/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.CategoryRatios;
import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class CategorySummary
extends CategoryRatios
implements DataIO {
    public static final int BYTESIZE = 16;
    public static final Comparator COUNT_ORDER = new CountOrder();
    private long num_real_objs;

    public CategorySummary() {
        this.num_real_objs = 0L;
    }

    public CategorySummary(float f, float f2, long l) {
        super(f, f2);
        this.num_real_objs = l;
    }

    public CategorySummary(CategorySummary categorySummary) {
        super(categorySummary);
        this.num_real_objs = categorySummary.num_real_objs;
    }

    public long getDrawableCount() {
        return this.num_real_objs;
    }

    public void addDrawableCount(long l) {
        this.num_real_objs += l;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeLong(this.num_real_objs);
    }

    public CategorySummary(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.num_real_objs = dataInput.readLong();
    }

    @Override
    public String toInfoBoxString(int n) {
        return super.toInfoBoxString(n) + ", count=" + this.num_real_objs;
    }

    @Override
    public String toString() {
        return super.toString() + ", count=" + this.num_real_objs;
    }

    private static class CountOrder
    implements Comparator {
        private CountOrder() {
        }

        public int compare(Object object, Object object2) {
            CategorySummary categorySummary = (CategorySummary)object;
            CategorySummary categorySummary2 = (CategorySummary)object2;
            long l = categorySummary.num_real_objs - categorySummary2.num_real_objs;
            return l < 0L ? -1 : (l == 0L ? 0 : 1);
        }
    }
}

