#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

setUp() {
	# Set a temporary directory to mess with real files
	TEST_TEMP_DIR=$(mktemp --directory)
	export TEST_TEMP_DIR
}

tearDown() {
	rm --force --recursive "$TEST_TEMP_DIR"
}

test_archives_path_base() {
	local PLAYIT_ARCHIVES_PATH_BASE

	PLAYIT_ARCHIVES_PATH_BASE='/home/jeux/alpha-centauri/archives/gog.com'
	archives_path_base=$(archives_path_base)
	assertEquals '/home/jeux/alpha-centauri/archives/gog.com' "$archives_path_base"
	unset PLAYIT_ARCHIVES_PATH_BASE

	# Falls back on $PWD if $PLAYIT_ARCHIVES_PATH_BASE is not set
	archives_path_base=$(archives_path_base)
	assertEquals "$PWD" "$archives_path_base"
}

test_archives_used_list() {
	local archives_list archives_list_expected PLAYIT_ARCHIVES_USED_LIST

	PLAYIT_ARCHIVES_USED_LIST='ARCHIVE_BASE_0
	ARCHIVE_REQUIRED_ENGINE
	ARCHIVE_OPTIONAL_ICONS'
	archives_list=$(archives_used_list)
	archives_list_expected='ARCHIVE_BASE_0
ARCHIVE_REQUIRED_ENGINE
ARCHIVE_OPTIONAL_ICONS'
	assertEquals "$archives_list_expected" "$archives_list"
	unset PLAYIT_ARCHIVES_USED_LIST

	# The list can be empty
	archives_list=$(archives_used_list)
	assertNull "$archives_list"
}

test_archives_used_add() {
	local archives_list archives_list_expected PLAYIT_ARCHIVES_USED_LIST

	archives_used_add 'ARCHIVE_BASE_0'
	archives_list=$(archives_used_list)
	assertEquals 'ARCHIVE_BASE_0' "$archives_list"

	archives_used_add 'ARCHIVE_REQUIRED_ENGINE'
	archives_list=$(archives_used_list)
	archives_list_expected='ARCHIVE_BASE_0
ARCHIVE_REQUIRED_ENGINE'
	assertEquals "$archives_list_expected" "$archives_list"
}

test_archives_list() {
	local ARCHIVE_BASE_0 ARCHIVE_BASE_1 ARCHIVE_NOT_EXPECTED_FORMAT archives_list_expected
	ARCHIVE_BASE_0='some_game_archive.tar.gz'
	ARCHIVE_BASE_1='some_other_game_archive.tar.gz'
	ARCHIVE_BASE_OTHER_0='yet_another_game_archive.tar.gz'
	ARCHIVE_NOT_EXPECTED_FORMAT='some_game_archive_that_should_not_be_included.tar.gz'
	archives_list_expected='ARCHIVE_BASE_1
ARCHIVE_BASE_0
ARCHIVE_BASE_OTHER_0'
	assertEquals "$archives_list_expected" "$(archives_list)"
}
