/* Bindings of osmesa.slb
 * Compile this module and link it with the application client
 */

#include <gem.h>
#include <stdlib.h>
#include <mint/slb.h>
#define NFOSMESA_NO_MANGLE
#include <slb/osmesa.h>
#include <mintbind.h>

#ifndef TRUE
# define TRUE 1
# define FALSE 0
#endif

#ifdef __PUREC__
#pragma warn -stv
#endif

struct _gl_osmesa gl;
static SLB_HANDLE gl_slb;
static SLB_EXEC gl_exec;
static struct gl_public *gl_pub;

/*
 * The "nwords" argument should actually only be a "short".
 * MagiC will expect it that way, with the actual arguments
 * following.
 * However, a "short" in the actual function definition
 * will be treated as promoted to int.
 * So we pass a long instead, with the upper half
 * set to 1 + nwords to account for the extra space.
 * This also has the benefit of keeping the stack longword aligned.
 */
#undef SLB_NWORDS
#define SLB_NWORDS(_nwords) ((((long)(_nwords) + 1l) << 16) | (long)(_nwords))
#undef SLB_NARGS
#define SLB_NARGS(_nargs) SLB_NWORDS(_nargs * 2)


#undef glClearDepth
#undef glFrustum
#undef glOrtho
#undef gluLookAt

static const GLubyte * APIENTRY exec_glGetString(GLenum name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (const GLubyte *)(*exec)(gl_slb, 1 /* NFOSMESA_LENGLGETSTRING */, SLB_NARGS(2), gl_pub, &name);
}

static OSMesaContext APIENTRY exec_OSMesaCreateContext(GLenum format, OSMesaContext sharelist)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sharelist;
	return (OSMesaContext)(*exec)(gl_slb, 3 /* NFOSMESA_OSMESACREATECONTEXT */, SLB_NARGS(2), gl_pub, &format);
}

static OSMesaContext APIENTRY exec_OSMesaCreateContextExt(GLenum format, GLint depthBits, GLint stencilBits, GLint accumBits, OSMesaContext sharelist)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)depthBits;
	(void)stencilBits;
	(void)accumBits;
	(void)sharelist;
	return (OSMesaContext)(*exec)(gl_slb, 4 /* NFOSMESA_OSMESACREATECONTEXTEXT */, SLB_NARGS(2), gl_pub, &format);
}

static void APIENTRY exec_OSMesaDestroyContext(OSMesaContext ctx)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 5 /* NFOSMESA_OSMESADESTROYCONTEXT */, SLB_NARGS(2), gl_pub, &ctx);
}

static GLboolean APIENTRY exec_OSMesaMakeCurrent(OSMesaContext ctx, void *buffer, GLenum type, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)type;
	(void)width;
	(void)height;
	return (GLboolean)(*exec)(gl_slb, 6 /* NFOSMESA_OSMESAMAKECURRENT */, SLB_NARGS(2), gl_pub, &ctx);
}

static OSMesaContext APIENTRY exec_OSMesaGetCurrentContext(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (OSMesaContext)(*exec)(gl_slb, 7 /* NFOSMESA_OSMESAGETCURRENTCONTEXT */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_OSMesaPixelStore(GLint pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 8 /* NFOSMESA_OSMESAPIXELSTORE */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_OSMesaGetIntegerv(GLint pname, GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 9 /* NFOSMESA_OSMESAGETINTEGERV */, SLB_NARGS(2), gl_pub, &pname);
}

static GLboolean APIENTRY exec_OSMesaGetDepthBuffer(OSMesaContext c, GLint *width, GLint *height, GLint *bytesPerValue, void * *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)width;
	(void)height;
	(void)bytesPerValue;
	(void)buffer;
	return (GLboolean)(*exec)(gl_slb, 10 /* NFOSMESA_OSMESAGETDEPTHBUFFER */, SLB_NARGS(2), gl_pub, &c);
}

static GLboolean APIENTRY exec_OSMesaGetColorBuffer(OSMesaContext c, GLint *width, GLint *height, GLint *format, void * *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)width;
	(void)height;
	(void)format;
	(void)buffer;
	return (GLboolean)(*exec)(gl_slb, 11 /* NFOSMESA_OSMESAGETCOLORBUFFER */, SLB_NARGS(2), gl_pub, &c);
}

static OSMESAproc APIENTRY exec_OSMesaGetProcAddress(const char *funcName)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (OSMESAproc)(*exec)(gl_slb, 12 /* NFOSMESA_OSMESAGETPROCADDRESS */, SLB_NARGS(2), gl_pub, &funcName);
}

static void APIENTRY exec_glClearIndex(GLfloat c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 13 /* NFOSMESA_GLCLEARINDEX */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 14 /* NFOSMESA_GLCLEARCOLOR */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glClear(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 15 /* NFOSMESA_GLCLEAR */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glIndexMask(GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 16 /* NFOSMESA_GLINDEXMASK */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glColorMask(GLboolean32 red, GLboolean32 green, GLboolean32 blue, GLboolean32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 17 /* NFOSMESA_GLCOLORMASK */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glAlphaFunc(GLenum func, GLclampf ref)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ref;
	(*exec)(gl_slb, 18 /* NFOSMESA_GLALPHAFUNC */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glBlendFunc(GLenum sfactor, GLenum dfactor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dfactor;
	(*exec)(gl_slb, 19 /* NFOSMESA_GLBLENDFUNC */, SLB_NARGS(2), gl_pub, &sfactor);
}

static void APIENTRY exec_glLogicOp(GLenum opcode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 20 /* NFOSMESA_GLLOGICOP */, SLB_NARGS(2), gl_pub, &opcode);
}

static void APIENTRY exec_glCullFace(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 21 /* NFOSMESA_GLCULLFACE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glFrontFace(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 22 /* NFOSMESA_GLFRONTFACE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glPointSize(GLfloat size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 23 /* NFOSMESA_GLPOINTSIZE */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glLineWidth(GLfloat width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 24 /* NFOSMESA_GLLINEWIDTH */, SLB_NARGS(2), gl_pub, &width);
}

static void APIENTRY exec_glLineStipple(GLint factor, GLushort32 pattern)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pattern;
	(*exec)(gl_slb, 25 /* NFOSMESA_GLLINESTIPPLE */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glPolygonMode(GLenum face, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 26 /* NFOSMESA_GLPOLYGONMODE */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glPolygonOffset(GLfloat factor, GLfloat units)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)units;
	(*exec)(gl_slb, 27 /* NFOSMESA_GLPOLYGONOFFSET */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glPolygonStipple(const GLubyte *mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 28 /* NFOSMESA_GLPOLYGONSTIPPLE */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glGetPolygonStipple(GLubyte *mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 29 /* NFOSMESA_GLGETPOLYGONSTIPPLE */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glEdgeFlag(GLboolean32 flag)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 30 /* NFOSMESA_GLEDGEFLAG */, SLB_NARGS(2), gl_pub, &flag);
}

static void APIENTRY exec_glEdgeFlagv(const GLboolean *flag)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 31 /* NFOSMESA_GLEDGEFLAGV */, SLB_NARGS(2), gl_pub, &flag);
}

static void APIENTRY exec_glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 32 /* NFOSMESA_GLSCISSOR */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glClipPlane(GLenum plane, const GLdouble *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equation;
	(*exec)(gl_slb, 33 /* NFOSMESA_GLCLIPPLANE */, SLB_NARGS(2), gl_pub, &plane);
}

static void APIENTRY exec_glGetClipPlane(GLenum plane, GLdouble *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equation;
	(*exec)(gl_slb, 34 /* NFOSMESA_GLGETCLIPPLANE */, SLB_NARGS(2), gl_pub, &plane);
}

static void APIENTRY exec_glDrawBuffer(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 35 /* NFOSMESA_GLDRAWBUFFER */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glReadBuffer(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 36 /* NFOSMESA_GLREADBUFFER */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glEnable(GLenum cap)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 37 /* NFOSMESA_GLENABLE */, SLB_NARGS(2), gl_pub, &cap);
}

static void APIENTRY exec_glDisable(GLenum cap)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 38 /* NFOSMESA_GLDISABLE */, SLB_NARGS(2), gl_pub, &cap);
}

static GLboolean APIENTRY exec_glIsEnabled(GLenum cap)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 39 /* NFOSMESA_GLISENABLED */, SLB_NARGS(2), gl_pub, &cap);
}

static void APIENTRY exec_glEnableClientState(GLenum array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 40 /* NFOSMESA_GLENABLECLIENTSTATE */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glDisableClientState(GLenum array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 41 /* NFOSMESA_GLDISABLECLIENTSTATE */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glGetBooleanv(GLenum pname, GLboolean *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 42 /* NFOSMESA_GLGETBOOLEANV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetDoublev(GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 43 /* NFOSMESA_GLGETDOUBLEV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetFloatv(GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 44 /* NFOSMESA_GLGETFLOATV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetIntegerv(GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 45 /* NFOSMESA_GLGETINTEGERV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPushAttrib(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 46 /* NFOSMESA_GLPUSHATTRIB */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glPopAttrib(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 47 /* NFOSMESA_GLPOPATTRIB */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPushClientAttrib(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 48 /* NFOSMESA_GLPUSHCLIENTATTRIB */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glPopClientAttrib(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 49 /* NFOSMESA_GLPOPCLIENTATTRIB */, SLB_NARGS(2), gl_pub, NULL);
}

static GLint APIENTRY exec_glRenderMode(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLint)(*exec)(gl_slb, 50 /* NFOSMESA_GLRENDERMODE */, SLB_NARGS(2), gl_pub, &mode);
}

static GLenum APIENTRY exec_glGetError(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLenum)(*exec)(gl_slb, 51 /* NFOSMESA_GLGETERROR */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glFinish(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 52 /* NFOSMESA_GLFINISH */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glFlush(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 53 /* NFOSMESA_GLFLUSH */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glHint(GLenum target, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 54 /* NFOSMESA_GLHINT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glClearDepth(GLclampd depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 55 /* NFOSMESA_GLCLEARDEPTH */, SLB_NARGS(2), gl_pub, &depth);
}

static void APIENTRY exec_glDepthFunc(GLenum func)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 56 /* NFOSMESA_GLDEPTHFUNC */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glDepthMask(GLboolean32 flag)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 57 /* NFOSMESA_GLDEPTHMASK */, SLB_NARGS(2), gl_pub, &flag);
}

static void APIENTRY exec_glDepthRange(GLclampd zNear, GLclampd zFar)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)zFar;
	(*exec)(gl_slb, 58 /* NFOSMESA_GLDEPTHRANGE */, SLB_NARGS(2), gl_pub, &zNear);
}

static void APIENTRY exec_glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 59 /* NFOSMESA_GLCLEARACCUM */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glAccum(GLenum op, GLfloat value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 60 /* NFOSMESA_GLACCUM */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glMatrixMode(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 61 /* NFOSMESA_GLMATRIXMODE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)right;
	(void)bottom;
	(void)top;
	(void)zNear;
	(void)zFar;
	(*exec)(gl_slb, 62 /* NFOSMESA_GLORTHO */, SLB_NARGS(2), gl_pub, &left);
}

static void APIENTRY exec_glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)right;
	(void)bottom;
	(void)top;
	(void)zNear;
	(void)zFar;
	(*exec)(gl_slb, 63 /* NFOSMESA_GLFRUSTUM */, SLB_NARGS(2), gl_pub, &left);
}

static void APIENTRY exec_glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 64 /* NFOSMESA_GLVIEWPORT */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glPushMatrix(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 65 /* NFOSMESA_GLPUSHMATRIX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPopMatrix(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 66 /* NFOSMESA_GLPOPMATRIX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glLoadIdentity(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 67 /* NFOSMESA_GLLOADIDENTITY */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glLoadMatrixd(const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 68 /* NFOSMESA_GLLOADMATRIXD */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glLoadMatrixf(const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 69 /* NFOSMESA_GLLOADMATRIXF */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultMatrixd(const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 70 /* NFOSMESA_GLMULTMATRIXD */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultMatrixf(const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 71 /* NFOSMESA_GLMULTMATRIXF */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 72 /* NFOSMESA_GLROTATED */, SLB_NARGS(2), gl_pub, &angle);
}

static void APIENTRY exec_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 73 /* NFOSMESA_GLROTATEF */, SLB_NARGS(2), gl_pub, &angle);
}

static void APIENTRY exec_glScaled(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 74 /* NFOSMESA_GLSCALED */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glScalef(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 75 /* NFOSMESA_GLSCALEF */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glTranslated(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 76 /* NFOSMESA_GLTRANSLATED */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glTranslatef(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 77 /* NFOSMESA_GLTRANSLATEF */, SLB_NARGS(2), gl_pub, &x);
}

static GLboolean APIENTRY exec_glIsList(GLuint list)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 78 /* NFOSMESA_GLISLIST */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glDeleteLists(GLuint list, GLsizei range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)range;
	(*exec)(gl_slb, 79 /* NFOSMESA_GLDELETELISTS */, SLB_NARGS(2), gl_pub, &list);
}

static GLuint APIENTRY exec_glGenLists(GLsizei range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 80 /* NFOSMESA_GLGENLISTS */, SLB_NARGS(2), gl_pub, &range);
}

static void APIENTRY exec_glNewList(GLuint list, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 81 /* NFOSMESA_GLNEWLIST */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glEndList(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 82 /* NFOSMESA_GLENDLIST */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glCallList(GLuint list)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 83 /* NFOSMESA_GLCALLLIST */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glCallLists(GLsizei n, GLenum type, const GLvoid *lists)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)lists;
	(*exec)(gl_slb, 84 /* NFOSMESA_GLCALLLISTS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glListBase(GLuint base)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 85 /* NFOSMESA_GLLISTBASE */, SLB_NARGS(2), gl_pub, &base);
}

static void APIENTRY exec_glBegin(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 86 /* NFOSMESA_GLBEGIN */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glEnd(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 87 /* NFOSMESA_GLEND */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glVertex2d(GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 88 /* NFOSMESA_GLVERTEX2D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2f(GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 89 /* NFOSMESA_GLVERTEX2F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2i(GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 90 /* NFOSMESA_GLVERTEX2I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2s(GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 91 /* NFOSMESA_GLVERTEX2S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3d(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 92 /* NFOSMESA_GLVERTEX3D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3f(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 93 /* NFOSMESA_GLVERTEX3F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3i(GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 94 /* NFOSMESA_GLVERTEX3I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3s(GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 95 /* NFOSMESA_GLVERTEX3S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 96 /* NFOSMESA_GLVERTEX4D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 97 /* NFOSMESA_GLVERTEX4F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4i(GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 98 /* NFOSMESA_GLVERTEX4I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4s(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 99 /* NFOSMESA_GLVERTEX4S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 100 /* NFOSMESA_GLVERTEX2DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex2fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 101 /* NFOSMESA_GLVERTEX2FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex2iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 102 /* NFOSMESA_GLVERTEX2IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex2sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 103 /* NFOSMESA_GLVERTEX2SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 104 /* NFOSMESA_GLVERTEX3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 105 /* NFOSMESA_GLVERTEX3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 106 /* NFOSMESA_GLVERTEX3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 107 /* NFOSMESA_GLVERTEX3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex4dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 108 /* NFOSMESA_GLVERTEX4DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex4fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 109 /* NFOSMESA_GLVERTEX4FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex4iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 110 /* NFOSMESA_GLVERTEX4IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex4sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 111 /* NFOSMESA_GLVERTEX4SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glNormal3b(GLbyte32 nx, GLbyte32 ny, GLbyte32 nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 112 /* NFOSMESA_GLNORMAL3B */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 113 /* NFOSMESA_GLNORMAL3D */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 114 /* NFOSMESA_GLNORMAL3F */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3i(GLint nx, GLint ny, GLint nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 115 /* NFOSMESA_GLNORMAL3I */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3s(GLshort32 nx, GLshort32 ny, GLshort32 nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 116 /* NFOSMESA_GLNORMAL3S */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3bv(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 117 /* NFOSMESA_GLNORMAL3BV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glNormal3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 118 /* NFOSMESA_GLNORMAL3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glNormal3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 119 /* NFOSMESA_GLNORMAL3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glNormal3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 120 /* NFOSMESA_GLNORMAL3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glNormal3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 121 /* NFOSMESA_GLNORMAL3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glIndexd(GLdouble c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 122 /* NFOSMESA_GLINDEXD */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexf(GLfloat c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 123 /* NFOSMESA_GLINDEXF */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexi(GLint c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 124 /* NFOSMESA_GLINDEXI */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexs(GLshort32 c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 125 /* NFOSMESA_GLINDEXS */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexub(GLubyte32 c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 126 /* NFOSMESA_GLINDEXUB */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexdv(const GLdouble *c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 127 /* NFOSMESA_GLINDEXDV */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexfv(const GLfloat *c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 128 /* NFOSMESA_GLINDEXFV */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexiv(const GLint *c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 129 /* NFOSMESA_GLINDEXIV */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexsv(const GLshort *c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 130 /* NFOSMESA_GLINDEXSV */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glIndexubv(const GLubyte *c)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 131 /* NFOSMESA_GLINDEXUBV */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glColor3b(GLbyte32 red, GLbyte32 green, GLbyte32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 132 /* NFOSMESA_GLCOLOR3B */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 133 /* NFOSMESA_GLCOLOR3D */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 134 /* NFOSMESA_GLCOLOR3F */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3i(GLint red, GLint green, GLint blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 135 /* NFOSMESA_GLCOLOR3I */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3s(GLshort32 red, GLshort32 green, GLshort32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 136 /* NFOSMESA_GLCOLOR3S */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3ub(GLubyte32 red, GLubyte32 green, GLubyte32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 137 /* NFOSMESA_GLCOLOR3UB */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3ui(GLuint red, GLuint green, GLuint blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 138 /* NFOSMESA_GLCOLOR3UI */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3us(GLushort32 red, GLushort32 green, GLushort32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 139 /* NFOSMESA_GLCOLOR3US */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4b(GLbyte32 red, GLbyte32 green, GLbyte32 blue, GLbyte32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 140 /* NFOSMESA_GLCOLOR4B */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 141 /* NFOSMESA_GLCOLOR4D */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 142 /* NFOSMESA_GLCOLOR4F */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4i(GLint red, GLint green, GLint blue, GLint alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 143 /* NFOSMESA_GLCOLOR4I */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4s(GLshort32 red, GLshort32 green, GLshort32 blue, GLshort32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 144 /* NFOSMESA_GLCOLOR4S */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4ub(GLubyte32 red, GLubyte32 green, GLubyte32 blue, GLubyte32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 145 /* NFOSMESA_GLCOLOR4UB */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 146 /* NFOSMESA_GLCOLOR4UI */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4us(GLushort32 red, GLushort32 green, GLushort32 blue, GLushort32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 147 /* NFOSMESA_GLCOLOR4US */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3bv(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 148 /* NFOSMESA_GLCOLOR3BV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 149 /* NFOSMESA_GLCOLOR3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 150 /* NFOSMESA_GLCOLOR3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 151 /* NFOSMESA_GLCOLOR3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 152 /* NFOSMESA_GLCOLOR3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3ubv(const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 153 /* NFOSMESA_GLCOLOR3UBV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3uiv(const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 154 /* NFOSMESA_GLCOLOR3UIV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3usv(const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 155 /* NFOSMESA_GLCOLOR3USV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4bv(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 156 /* NFOSMESA_GLCOLOR4BV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 157 /* NFOSMESA_GLCOLOR4DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 158 /* NFOSMESA_GLCOLOR4FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 159 /* NFOSMESA_GLCOLOR4IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 160 /* NFOSMESA_GLCOLOR4SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4ubv(const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 161 /* NFOSMESA_GLCOLOR4UBV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4uiv(const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 162 /* NFOSMESA_GLCOLOR4UIV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4usv(const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 163 /* NFOSMESA_GLCOLOR4USV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord1d(GLdouble s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 164 /* NFOSMESA_GLTEXCOORD1D */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1f(GLfloat s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 165 /* NFOSMESA_GLTEXCOORD1F */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1i(GLint s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 166 /* NFOSMESA_GLTEXCOORD1I */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1s(GLshort32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 167 /* NFOSMESA_GLTEXCOORD1S */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2d(GLdouble s, GLdouble t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 168 /* NFOSMESA_GLTEXCOORD2D */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2f(GLfloat s, GLfloat t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 169 /* NFOSMESA_GLTEXCOORD2F */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2i(GLint s, GLint t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 170 /* NFOSMESA_GLTEXCOORD2I */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2s(GLshort32 s, GLshort32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 171 /* NFOSMESA_GLTEXCOORD2S */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 172 /* NFOSMESA_GLTEXCOORD3D */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 173 /* NFOSMESA_GLTEXCOORD3F */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3i(GLint s, GLint t, GLint r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 174 /* NFOSMESA_GLTEXCOORD3I */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3s(GLshort32 s, GLshort32 t, GLshort32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 175 /* NFOSMESA_GLTEXCOORD3S */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 176 /* NFOSMESA_GLTEXCOORD4D */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 177 /* NFOSMESA_GLTEXCOORD4F */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4i(GLint s, GLint t, GLint r, GLint q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 178 /* NFOSMESA_GLTEXCOORD4I */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4s(GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 179 /* NFOSMESA_GLTEXCOORD4S */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 180 /* NFOSMESA_GLTEXCOORD1DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord1fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 181 /* NFOSMESA_GLTEXCOORD1FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord1iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 182 /* NFOSMESA_GLTEXCOORD1IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord1sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 183 /* NFOSMESA_GLTEXCOORD1SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord2dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 184 /* NFOSMESA_GLTEXCOORD2DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord2fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 185 /* NFOSMESA_GLTEXCOORD2FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord2iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 186 /* NFOSMESA_GLTEXCOORD2IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord2sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 187 /* NFOSMESA_GLTEXCOORD2SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 188 /* NFOSMESA_GLTEXCOORD3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 189 /* NFOSMESA_GLTEXCOORD3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 190 /* NFOSMESA_GLTEXCOORD3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 191 /* NFOSMESA_GLTEXCOORD3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord4dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 192 /* NFOSMESA_GLTEXCOORD4DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord4fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 193 /* NFOSMESA_GLTEXCOORD4FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord4iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 194 /* NFOSMESA_GLTEXCOORD4IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord4sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 195 /* NFOSMESA_GLTEXCOORD4SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos2d(GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 196 /* NFOSMESA_GLRASTERPOS2D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos2f(GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 197 /* NFOSMESA_GLRASTERPOS2F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos2i(GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 198 /* NFOSMESA_GLRASTERPOS2I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos2s(GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 199 /* NFOSMESA_GLRASTERPOS2S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 200 /* NFOSMESA_GLRASTERPOS3D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 201 /* NFOSMESA_GLRASTERPOS3F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos3i(GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 202 /* NFOSMESA_GLRASTERPOS3I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos3s(GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 203 /* NFOSMESA_GLRASTERPOS3S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 204 /* NFOSMESA_GLRASTERPOS4D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 205 /* NFOSMESA_GLRASTERPOS4F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 206 /* NFOSMESA_GLRASTERPOS4I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos4s(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 207 /* NFOSMESA_GLRASTERPOS4S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos2dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 208 /* NFOSMESA_GLRASTERPOS2DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos2fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 209 /* NFOSMESA_GLRASTERPOS2FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos2iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 210 /* NFOSMESA_GLRASTERPOS2IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos2sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 211 /* NFOSMESA_GLRASTERPOS2SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 212 /* NFOSMESA_GLRASTERPOS3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 213 /* NFOSMESA_GLRASTERPOS3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 214 /* NFOSMESA_GLRASTERPOS3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 215 /* NFOSMESA_GLRASTERPOS3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos4dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 216 /* NFOSMESA_GLRASTERPOS4DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos4fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 217 /* NFOSMESA_GLRASTERPOS4FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos4iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 218 /* NFOSMESA_GLRASTERPOS4IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRasterPos4sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 219 /* NFOSMESA_GLRASTERPOS4SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y1;
	(void)x2;
	(void)y2;
	(*exec)(gl_slb, 220 /* NFOSMESA_GLRECTD */, SLB_NARGS(2), gl_pub, &x1);
}

static void APIENTRY exec_glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y1;
	(void)x2;
	(void)y2;
	(*exec)(gl_slb, 221 /* NFOSMESA_GLRECTF */, SLB_NARGS(2), gl_pub, &x1);
}

static void APIENTRY exec_glRecti(GLint x1, GLint y1, GLint x2, GLint y2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y1;
	(void)x2;
	(void)y2;
	(*exec)(gl_slb, 222 /* NFOSMESA_GLRECTI */, SLB_NARGS(2), gl_pub, &x1);
}

static void APIENTRY exec_glRects(GLshort32 x1, GLshort32 y1, GLshort32 x2, GLshort32 y2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y1;
	(void)x2;
	(void)y2;
	(*exec)(gl_slb, 223 /* NFOSMESA_GLRECTS */, SLB_NARGS(2), gl_pub, &x1);
}

static void APIENTRY exec_glRectdv(const GLdouble *v1, const GLdouble *v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v2;
	(*exec)(gl_slb, 224 /* NFOSMESA_GLRECTDV */, SLB_NARGS(2), gl_pub, &v1);
}

static void APIENTRY exec_glRectfv(const GLfloat *v1, const GLfloat *v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v2;
	(*exec)(gl_slb, 225 /* NFOSMESA_GLRECTFV */, SLB_NARGS(2), gl_pub, &v1);
}

static void APIENTRY exec_glRectiv(const GLint *v1, const GLint *v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v2;
	(*exec)(gl_slb, 226 /* NFOSMESA_GLRECTIV */, SLB_NARGS(2), gl_pub, &v1);
}

static void APIENTRY exec_glRectsv(const GLshort *v1, const GLshort *v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v2;
	(*exec)(gl_slb, 227 /* NFOSMESA_GLRECTSV */, SLB_NARGS(2), gl_pub, &v1);
}

static void APIENTRY exec_glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 228 /* NFOSMESA_GLVERTEXPOINTER */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 229 /* NFOSMESA_GLNORMALPOINTER */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 230 /* NFOSMESA_GLCOLORPOINTER */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glIndexPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 231 /* NFOSMESA_GLINDEXPOINTER */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 232 /* NFOSMESA_GLTEXCOORDPOINTER */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glEdgeFlagPointer(GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 233 /* NFOSMESA_GLEDGEFLAGPOINTER */, SLB_NARGS(2), gl_pub, &stride);
}

static void APIENTRY exec_glGetPointerv(GLenum pname, GLvoid* *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 234 /* NFOSMESA_GLGETPOINTERV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glArrayElement(GLint i)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 235 /* NFOSMESA_GLARRAYELEMENT */, SLB_NARGS(2), gl_pub, &i);
}

static void APIENTRY exec_glDrawArrays(GLenum mode, GLint first, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(*exec)(gl_slb, 236 /* NFOSMESA_GLDRAWARRAYS */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(*exec)(gl_slb, 237 /* NFOSMESA_GLDRAWELEMENTS */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 238 /* NFOSMESA_GLINTERLEAVEDARRAYS */, SLB_NARGS(2), gl_pub, &format);
}

static void APIENTRY exec_glShadeModel(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 239 /* NFOSMESA_GLSHADEMODEL */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glLightf(GLenum light, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 240 /* NFOSMESA_GLLIGHTF */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glLighti(GLenum light, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 241 /* NFOSMESA_GLLIGHTI */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glLightfv(GLenum light, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 242 /* NFOSMESA_GLLIGHTFV */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glLightiv(GLenum light, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 243 /* NFOSMESA_GLLIGHTIV */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glGetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 244 /* NFOSMESA_GLGETLIGHTFV */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glGetLightiv(GLenum light, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 245 /* NFOSMESA_GLGETLIGHTIV */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glLightModelf(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 246 /* NFOSMESA_GLLIGHTMODELF */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glLightModeli(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 247 /* NFOSMESA_GLLIGHTMODELI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glLightModelfv(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 248 /* NFOSMESA_GLLIGHTMODELFV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glLightModeliv(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 249 /* NFOSMESA_GLLIGHTMODELIV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glMaterialf(GLenum face, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 250 /* NFOSMESA_GLMATERIALF */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glMateriali(GLenum face, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 251 /* NFOSMESA_GLMATERIALI */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glMaterialfv(GLenum face, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 252 /* NFOSMESA_GLMATERIALFV */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glMaterialiv(GLenum face, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 253 /* NFOSMESA_GLMATERIALIV */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 254 /* NFOSMESA_GLGETMATERIALFV */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glGetMaterialiv(GLenum face, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 255 /* NFOSMESA_GLGETMATERIALIV */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glColorMaterial(GLenum face, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 256 /* NFOSMESA_GLCOLORMATERIAL */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glPixelZoom(GLfloat xfactor, GLfloat yfactor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)yfactor;
	(*exec)(gl_slb, 257 /* NFOSMESA_GLPIXELZOOM */, SLB_NARGS(2), gl_pub, &xfactor);
}

static void APIENTRY exec_glPixelStoref(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 258 /* NFOSMESA_GLPIXELSTOREF */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelStorei(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 259 /* NFOSMESA_GLPIXELSTOREI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelTransferf(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 260 /* NFOSMESA_GLPIXELTRANSFERF */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelTransferi(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 261 /* NFOSMESA_GLPIXELTRANSFERI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mapsize;
	(void)values;
	(*exec)(gl_slb, 262 /* NFOSMESA_GLPIXELMAPFV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mapsize;
	(void)values;
	(*exec)(gl_slb, 263 /* NFOSMESA_GLPIXELMAPUIV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mapsize;
	(void)values;
	(*exec)(gl_slb, 264 /* NFOSMESA_GLPIXELMAPUSV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetPixelMapfv(GLenum map, GLfloat *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)values;
	(*exec)(gl_slb, 265 /* NFOSMESA_GLGETPIXELMAPFV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetPixelMapuiv(GLenum map, GLuint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)values;
	(*exec)(gl_slb, 266 /* NFOSMESA_GLGETPIXELMAPUIV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetPixelMapusv(GLenum map, GLushort *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)values;
	(*exec)(gl_slb, 267 /* NFOSMESA_GLGETPIXELMAPUSV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)height;
	(void)xorig;
	(void)yorig;
	(void)xmove;
	(void)ymove;
	(void)bitmap;
	(*exec)(gl_slb, 268 /* NFOSMESA_GLBITMAP */, SLB_NARGS(2), gl_pub, &width);
}

static void APIENTRY exec_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 269 /* NFOSMESA_GLREADPIXELS */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)height;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 270 /* NFOSMESA_GLDRAWPIXELS */, SLB_NARGS(2), gl_pub, &width);
}

static void APIENTRY exec_glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)width;
	(void)height;
	(void)type;
	(*exec)(gl_slb, 271 /* NFOSMESA_GLCOPYPIXELS */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glStencilFunc(GLenum func, GLint ref, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ref;
	(void)mask;
	(*exec)(gl_slb, 272 /* NFOSMESA_GLSTENCILFUNC */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glStencilMask(GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 273 /* NFOSMESA_GLSTENCILMASK */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)zfail;
	(void)zpass;
	(*exec)(gl_slb, 274 /* NFOSMESA_GLSTENCILOP */, SLB_NARGS(2), gl_pub, &fail);
}

static void APIENTRY exec_glClearStencil(GLint s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 275 /* NFOSMESA_GLCLEARSTENCIL */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexGend(GLenum coord, GLenum pname, GLdouble param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 276 /* NFOSMESA_GLTEXGEND */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexGenf(GLenum coord, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 277 /* NFOSMESA_GLTEXGENF */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexGeni(GLenum coord, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 278 /* NFOSMESA_GLTEXGENI */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexGendv(GLenum coord, GLenum pname, const GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 279 /* NFOSMESA_GLTEXGENDV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 280 /* NFOSMESA_GLTEXGENFV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexGeniv(GLenum coord, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 281 /* NFOSMESA_GLTEXGENIV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 282 /* NFOSMESA_GLGETTEXGENDV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 283 /* NFOSMESA_GLGETTEXGENFV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glGetTexGeniv(GLenum coord, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 284 /* NFOSMESA_GLGETTEXGENIV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexEnvf(GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 285 /* NFOSMESA_GLTEXENVF */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexEnvi(GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 286 /* NFOSMESA_GLTEXENVI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 287 /* NFOSMESA_GLTEXENVFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexEnviv(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 288 /* NFOSMESA_GLTEXENVIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 289 /* NFOSMESA_GLGETTEXENVFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 290 /* NFOSMESA_GLGETTEXENVIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterf(GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 291 /* NFOSMESA_GLTEXPARAMETERF */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameteri(GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 292 /* NFOSMESA_GLTEXPARAMETERI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 293 /* NFOSMESA_GLTEXPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 294 /* NFOSMESA_GLTEXPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 295 /* NFOSMESA_GLGETTEXPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 296 /* NFOSMESA_GLGETTEXPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 297 /* NFOSMESA_GLGETTEXLEVELPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 298 /* NFOSMESA_GLGETTEXLEVELPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 299 /* NFOSMESA_GLTEXIMAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 300 /* NFOSMESA_GLTEXIMAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 301 /* NFOSMESA_GLGETTEXIMAGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGenTextures(GLsizei n, GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(*exec)(gl_slb, 302 /* NFOSMESA_GLGENTEXTURES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteTextures(GLsizei n, const GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(*exec)(gl_slb, 303 /* NFOSMESA_GLDELETETEXTURES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glBindTexture(GLenum target, GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)texture;
	(*exec)(gl_slb, 304 /* NFOSMESA_GLBINDTEXTURE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPrioritizeTextures(GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(void)priorities;
	(*exec)(gl_slb, 305 /* NFOSMESA_GLPRIORITIZETEXTURES */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glAreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(void)residences;
	return (GLboolean)(*exec)(gl_slb, 306 /* NFOSMESA_GLARETEXTURESRESIDENT */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsTexture(GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 307 /* NFOSMESA_GLISTEXTURE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 308 /* NFOSMESA_GLTEXSUBIMAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 309 /* NFOSMESA_GLTEXSUBIMAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)border;
	(*exec)(gl_slb, 310 /* NFOSMESA_GLCOPYTEXIMAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(void)border;
	(*exec)(gl_slb, 311 /* NFOSMESA_GLCOPYTEXIMAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 312 /* NFOSMESA_GLCOPYTEXSUBIMAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 313 /* NFOSMESA_GLCOPYTEXSUBIMAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)stride;
	(void)order;
	(void)points;
	(*exec)(gl_slb, 314 /* NFOSMESA_GLMAP1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)stride;
	(void)order;
	(void)points;
	(*exec)(gl_slb, 315 /* NFOSMESA_GLMAP1F */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)points;
	(*exec)(gl_slb, 316 /* NFOSMESA_GLMAP2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)points;
	(*exec)(gl_slb, 317 /* NFOSMESA_GLMAP2F */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapdv(GLenum target, GLenum query, GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)v;
	(*exec)(gl_slb, 318 /* NFOSMESA_GLGETMAPDV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapfv(GLenum target, GLenum query, GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)v;
	(*exec)(gl_slb, 319 /* NFOSMESA_GLGETMAPFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapiv(GLenum target, GLenum query, GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)v;
	(*exec)(gl_slb, 320 /* NFOSMESA_GLGETMAPIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEvalCoord1d(GLdouble u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 321 /* NFOSMESA_GLEVALCOORD1D */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord1f(GLfloat u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 322 /* NFOSMESA_GLEVALCOORD1F */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord1dv(const GLdouble *u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 323 /* NFOSMESA_GLEVALCOORD1DV */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord1fv(const GLfloat *u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 324 /* NFOSMESA_GLEVALCOORD1FV */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord2d(GLdouble u, GLdouble v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 325 /* NFOSMESA_GLEVALCOORD2D */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord2f(GLfloat u, GLfloat v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 326 /* NFOSMESA_GLEVALCOORD2F */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord2dv(const GLdouble *u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 327 /* NFOSMESA_GLEVALCOORD2DV */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord2fv(const GLfloat *u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 328 /* NFOSMESA_GLEVALCOORD2FV */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glMapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(*exec)(gl_slb, 329 /* NFOSMESA_GLMAPGRID1D */, SLB_NARGS(2), gl_pub, &un);
}

static void APIENTRY exec_glMapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(*exec)(gl_slb, 330 /* NFOSMESA_GLMAPGRID1F */, SLB_NARGS(2), gl_pub, &un);
}

static void APIENTRY exec_glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)vn;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 331 /* NFOSMESA_GLMAPGRID2D */, SLB_NARGS(2), gl_pub, &un);
}

static void APIENTRY exec_glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)vn;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 332 /* NFOSMESA_GLMAPGRID2F */, SLB_NARGS(2), gl_pub, &un);
}

static void APIENTRY exec_glEvalPoint1(GLint i)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 333 /* NFOSMESA_GLEVALPOINT1 */, SLB_NARGS(2), gl_pub, &i);
}

static void APIENTRY exec_glEvalPoint2(GLint i, GLint j)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)j;
	(*exec)(gl_slb, 334 /* NFOSMESA_GLEVALPOINT2 */, SLB_NARGS(2), gl_pub, &i);
}

static void APIENTRY exec_glEvalMesh1(GLenum mode, GLint i1, GLint i2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)i1;
	(void)i2;
	(*exec)(gl_slb, 335 /* NFOSMESA_GLEVALMESH1 */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)i1;
	(void)i2;
	(void)j1;
	(void)j2;
	(*exec)(gl_slb, 336 /* NFOSMESA_GLEVALMESH2 */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glFogf(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 337 /* NFOSMESA_GLFOGF */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFogi(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 338 /* NFOSMESA_GLFOGI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFogfv(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 339 /* NFOSMESA_GLFOGFV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFogiv(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 340 /* NFOSMESA_GLFOGIV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)buffer;
	(*exec)(gl_slb, 341 /* NFOSMESA_GLFEEDBACKBUFFER */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glPassThrough(GLfloat token)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 342 /* NFOSMESA_GLPASSTHROUGH */, SLB_NARGS(2), gl_pub, &token);
}

static void APIENTRY exec_glSelectBuffer(GLsizei size, GLuint *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(*exec)(gl_slb, 343 /* NFOSMESA_GLSELECTBUFFER */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glInitNames(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 344 /* NFOSMESA_GLINITNAMES */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glLoadName(GLuint name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 345 /* NFOSMESA_GLLOADNAME */, SLB_NARGS(2), gl_pub, &name);
}

static void APIENTRY exec_glPushName(GLuint name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 346 /* NFOSMESA_GLPUSHNAME */, SLB_NARGS(2), gl_pub, &name);
}

static void APIENTRY exec_glPopName(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 347 /* NFOSMESA_GLPOPNAME */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEnableTraceMESA(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 348 /* NFOSMESA_GLENABLETRACEMESA */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glDisableTraceMESA(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 349 /* NFOSMESA_GLDISABLETRACEMESA */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glNewTraceMESA(GLbitfield mask, const GLubyte *traceName)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)traceName;
	(*exec)(gl_slb, 350 /* NFOSMESA_GLNEWTRACEMESA */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glEndTraceMESA(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 351 /* NFOSMESA_GLENDTRACEMESA */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glTraceAssertAttribMESA(GLbitfield attribMask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 352 /* NFOSMESA_GLTRACEASSERTATTRIBMESA */, SLB_NARGS(2), gl_pub, &attribMask);
}

static void APIENTRY exec_glTraceCommentMESA(const GLubyte *comment)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 353 /* NFOSMESA_GLTRACECOMMENTMESA */, SLB_NARGS(2), gl_pub, &comment);
}

static void APIENTRY exec_glTraceTextureMESA(GLuint name, const GLubyte *comment)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)comment;
	(*exec)(gl_slb, 354 /* NFOSMESA_GLTRACETEXTUREMESA */, SLB_NARGS(2), gl_pub, &name);
}

static void APIENTRY exec_glTraceListMESA(GLuint name, const GLubyte *comment)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)comment;
	(*exec)(gl_slb, 355 /* NFOSMESA_GLTRACELISTMESA */, SLB_NARGS(2), gl_pub, &name);
}

static void APIENTRY exec_glTracePointerMESA(GLvoid *pointer, const GLubyte *comment)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)comment;
	(*exec)(gl_slb, 356 /* NFOSMESA_GLTRACEPOINTERMESA */, SLB_NARGS(2), gl_pub, &pointer);
}

static void APIENTRY exec_glTracePointerRangeMESA(const GLvoid *first, const GLvoid *last, const GLubyte *comment)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)last;
	(void)comment;
	(*exec)(gl_slb, 357 /* NFOSMESA_GLTRACEPOINTERRANGEMESA */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glBlendEquationSeparateATI(GLenum equationRGB, GLenum equationAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equationAlpha;
	(*exec)(gl_slb, 358 /* NFOSMESA_GLBLENDEQUATIONSEPARATEATI */, SLB_NARGS(2), gl_pub, &equationRGB);
}

static void APIENTRY exec_glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 359 /* NFOSMESA_GLBLENDCOLOR */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glBlendEquation(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 360 /* NFOSMESA_GLBLENDEQUATION */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)end;
	(void)count;
	(void)type;
	(void)indices;
	(*exec)(gl_slb, 361 /* NFOSMESA_GLDRAWRANGEELEMENTS */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)format;
	(void)type;
	(void)table;
	(*exec)(gl_slb, 362 /* NFOSMESA_GLCOLORTABLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 363 /* NFOSMESA_GLCOLORTABLEPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 364 /* NFOSMESA_GLCOLORTABLEPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 365 /* NFOSMESA_GLCOPYCOLORTABLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTable(GLenum target, GLenum format, GLenum type, void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)table;
	(*exec)(gl_slb, 366 /* NFOSMESA_GLGETCOLORTABLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 367 /* NFOSMESA_GLGETCOLORTABLEPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 368 /* NFOSMESA_GLGETCOLORTABLEPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)count;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 369 /* NFOSMESA_GLCOLORSUBTABLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 370 /* NFOSMESA_GLCOPYCOLORSUBTABLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)format;
	(void)type;
	(void)image;
	(*exec)(gl_slb, 371 /* NFOSMESA_GLCONVOLUTIONFILTER1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)image;
	(*exec)(gl_slb, 372 /* NFOSMESA_GLCONVOLUTIONFILTER2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 373 /* NFOSMESA_GLCONVOLUTIONPARAMETERF */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 374 /* NFOSMESA_GLCONVOLUTIONPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameteri(GLenum target, GLenum pname, GLint params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 375 /* NFOSMESA_GLCONVOLUTIONPARAMETERI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameteriv(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 376 /* NFOSMESA_GLCONVOLUTIONPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 377 /* NFOSMESA_GLCOPYCONVOLUTIONFILTER1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 378 /* NFOSMESA_GLCOPYCONVOLUTIONFILTER2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)image;
	(*exec)(gl_slb, 379 /* NFOSMESA_GLGETCONVOLUTIONFILTER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 380 /* NFOSMESA_GLGETCONVOLUTIONPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 381 /* NFOSMESA_GLGETCONVOLUTIONPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetSeparableFilter(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)row;
	(void)column;
	(void)span;
	(*exec)(gl_slb, 382 /* NFOSMESA_GLGETSEPARABLEFILTER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)row;
	(void)column;
	(*exec)(gl_slb, 383 /* NFOSMESA_GLSEPARABLEFILTER2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetHistogram(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)values;
	(*exec)(gl_slb, 384 /* NFOSMESA_GLGETHISTOGRAM */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 385 /* NFOSMESA_GLGETHISTOGRAMPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetHistogramParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 386 /* NFOSMESA_GLGETHISTOGRAMPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMinmax(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)values;
	(*exec)(gl_slb, 387 /* NFOSMESA_GLGETMINMAX */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 388 /* NFOSMESA_GLGETMINMAXPARAMETERFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 389 /* NFOSMESA_GLGETMINMAXPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean32 sink)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)width;
	(void)internalformat;
	(void)sink;
	(*exec)(gl_slb, 390 /* NFOSMESA_GLHISTOGRAM */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMinmax(GLenum target, GLenum internalformat, GLboolean32 sink)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)sink;
	(*exec)(gl_slb, 391 /* NFOSMESA_GLMINMAX */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glResetHistogram(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 392 /* NFOSMESA_GLRESETHISTOGRAM */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glResetMinmax(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 393 /* NFOSMESA_GLRESETMINMAX */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 394 /* NFOSMESA_GLTEXIMAGE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 395 /* NFOSMESA_GLTEXSUBIMAGE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 396 /* NFOSMESA_GLCOPYTEXSUBIMAGE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glActiveTexture(GLenum texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 397 /* NFOSMESA_GLACTIVETEXTURE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glClientActiveTexture(GLenum texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 398 /* NFOSMESA_GLCLIENTACTIVETEXTURE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord1d(GLenum target, GLdouble s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 399 /* NFOSMESA_GLMULTITEXCOORD1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1dv(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 400 /* NFOSMESA_GLMULTITEXCOORD1DV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1f(GLenum target, GLfloat s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 401 /* NFOSMESA_GLMULTITEXCOORD1F */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1fv(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 402 /* NFOSMESA_GLMULTITEXCOORD1FV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1i(GLenum target, GLint s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 403 /* NFOSMESA_GLMULTITEXCOORD1I */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1iv(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 404 /* NFOSMESA_GLMULTITEXCOORD1IV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1s(GLenum target, GLshort32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 405 /* NFOSMESA_GLMULTITEXCOORD1S */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1sv(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 406 /* NFOSMESA_GLMULTITEXCOORD1SV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 407 /* NFOSMESA_GLMULTITEXCOORD2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2dv(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 408 /* NFOSMESA_GLMULTITEXCOORD2DV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 409 /* NFOSMESA_GLMULTITEXCOORD2F */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2fv(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 410 /* NFOSMESA_GLMULTITEXCOORD2FV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2i(GLenum target, GLint s, GLint t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 411 /* NFOSMESA_GLMULTITEXCOORD2I */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2iv(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 412 /* NFOSMESA_GLMULTITEXCOORD2IV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2s(GLenum target, GLshort32 s, GLshort32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 413 /* NFOSMESA_GLMULTITEXCOORD2S */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2sv(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 414 /* NFOSMESA_GLMULTITEXCOORD2SV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 415 /* NFOSMESA_GLMULTITEXCOORD3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3dv(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 416 /* NFOSMESA_GLMULTITEXCOORD3DV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 417 /* NFOSMESA_GLMULTITEXCOORD3F */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3fv(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 418 /* NFOSMESA_GLMULTITEXCOORD3FV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 419 /* NFOSMESA_GLMULTITEXCOORD3I */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3iv(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 420 /* NFOSMESA_GLMULTITEXCOORD3IV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3s(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 421 /* NFOSMESA_GLMULTITEXCOORD3S */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3sv(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 422 /* NFOSMESA_GLMULTITEXCOORD3SV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 423 /* NFOSMESA_GLMULTITEXCOORD4D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4dv(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 424 /* NFOSMESA_GLMULTITEXCOORD4DV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 425 /* NFOSMESA_GLMULTITEXCOORD4F */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4fv(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 426 /* NFOSMESA_GLMULTITEXCOORD4FV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 427 /* NFOSMESA_GLMULTITEXCOORD4I */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4iv(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 428 /* NFOSMESA_GLMULTITEXCOORD4IV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4s(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 429 /* NFOSMESA_GLMULTITEXCOORD4S */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4sv(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 430 /* NFOSMESA_GLMULTITEXCOORD4SV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glLoadTransposeMatrixf(const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 431 /* NFOSMESA_GLLOADTRANSPOSEMATRIXF */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glLoadTransposeMatrixd(const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 432 /* NFOSMESA_GLLOADTRANSPOSEMATRIXD */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultTransposeMatrixf(const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 433 /* NFOSMESA_GLMULTTRANSPOSEMATRIXF */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultTransposeMatrixd(const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 434 /* NFOSMESA_GLMULTTRANSPOSEMATRIXD */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glSampleCoverage(GLfloat value, GLboolean32 invert)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)invert;
	(*exec)(gl_slb, 435 /* NFOSMESA_GLSAMPLECOVERAGE */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 436 /* NFOSMESA_GLCOMPRESSEDTEXIMAGE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 437 /* NFOSMESA_GLCOMPRESSEDTEXIMAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 438 /* NFOSMESA_GLCOMPRESSEDTEXIMAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 439 /* NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 440 /* NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 441 /* NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetCompressedTexImage(GLenum target, GLint level, void *img)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)img;
	(*exec)(gl_slb, 442 /* NFOSMESA_GLGETCOMPRESSEDTEXIMAGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dfactorRGB;
	(void)sfactorAlpha;
	(void)dfactorAlpha;
	(*exec)(gl_slb, 443 /* NFOSMESA_GLBLENDFUNCSEPARATE */, SLB_NARGS(2), gl_pub, &sfactorRGB);
}

static void APIENTRY exec_glFogCoordf(GLfloat coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 444 /* NFOSMESA_GLFOGCOORDF */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoordfv(const GLfloat *coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 445 /* NFOSMESA_GLFOGCOORDFV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoordd(GLdouble coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 446 /* NFOSMESA_GLFOGCOORDD */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoorddv(const GLdouble *coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 447 /* NFOSMESA_GLFOGCOORDDV */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoordPointer(GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 448 /* NFOSMESA_GLFOGCOORDPOINTER */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)drawcount;
	(*exec)(gl_slb, 449 /* NFOSMESA_GLMULTIDRAWARRAYS */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei drawcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)drawcount;
	(*exec)(gl_slb, 450 /* NFOSMESA_GLMULTIDRAWELEMENTS */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glPointParameterf(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 451 /* NFOSMESA_GLPOINTPARAMETERF */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterfv(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 452 /* NFOSMESA_GLPOINTPARAMETERFV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameteri(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 453 /* NFOSMESA_GLPOINTPARAMETERI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameteriv(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 454 /* NFOSMESA_GLPOINTPARAMETERIV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glSecondaryColor3b(GLbyte32 red, GLbyte32 green, GLbyte32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 455 /* NFOSMESA_GLSECONDARYCOLOR3B */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3bv(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 456 /* NFOSMESA_GLSECONDARYCOLOR3BV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 457 /* NFOSMESA_GLSECONDARYCOLOR3D */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 458 /* NFOSMESA_GLSECONDARYCOLOR3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 459 /* NFOSMESA_GLSECONDARYCOLOR3F */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 460 /* NFOSMESA_GLSECONDARYCOLOR3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3i(GLint red, GLint green, GLint blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 461 /* NFOSMESA_GLSECONDARYCOLOR3I */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 462 /* NFOSMESA_GLSECONDARYCOLOR3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3s(GLshort32 red, GLshort32 green, GLshort32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 463 /* NFOSMESA_GLSECONDARYCOLOR3S */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 464 /* NFOSMESA_GLSECONDARYCOLOR3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3ub(GLubyte32 red, GLubyte32 green, GLubyte32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 465 /* NFOSMESA_GLSECONDARYCOLOR3UB */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3ubv(const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 466 /* NFOSMESA_GLSECONDARYCOLOR3UBV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 467 /* NFOSMESA_GLSECONDARYCOLOR3UI */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3uiv(const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 468 /* NFOSMESA_GLSECONDARYCOLOR3UIV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3us(GLushort32 red, GLushort32 green, GLushort32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 469 /* NFOSMESA_GLSECONDARYCOLOR3US */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3usv(const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 470 /* NFOSMESA_GLSECONDARYCOLOR3USV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 471 /* NFOSMESA_GLSECONDARYCOLORPOINTER */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWindowPos2d(GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 472 /* NFOSMESA_GLWINDOWPOS2D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 473 /* NFOSMESA_GLWINDOWPOS2DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2f(GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 474 /* NFOSMESA_GLWINDOWPOS2F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 475 /* NFOSMESA_GLWINDOWPOS2FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2i(GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 476 /* NFOSMESA_GLWINDOWPOS2I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 477 /* NFOSMESA_GLWINDOWPOS2IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2s(GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 478 /* NFOSMESA_GLWINDOWPOS2S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 479 /* NFOSMESA_GLWINDOWPOS2SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3d(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 480 /* NFOSMESA_GLWINDOWPOS3D */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3dv(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 481 /* NFOSMESA_GLWINDOWPOS3DV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3f(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 482 /* NFOSMESA_GLWINDOWPOS3F */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3fv(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 483 /* NFOSMESA_GLWINDOWPOS3FV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3i(GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 484 /* NFOSMESA_GLWINDOWPOS3I */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3iv(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 485 /* NFOSMESA_GLWINDOWPOS3IV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3s(GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 486 /* NFOSMESA_GLWINDOWPOS3S */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3sv(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 487 /* NFOSMESA_GLWINDOWPOS3SV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glGenQueries(GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 488 /* NFOSMESA_GLGENQUERIES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteQueries(GLsizei n, const GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 489 /* NFOSMESA_GLDELETEQUERIES */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsQuery(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 490 /* NFOSMESA_GLISQUERY */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginQuery(GLenum target, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 491 /* NFOSMESA_GLBEGINQUERY */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEndQuery(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 492 /* NFOSMESA_GLENDQUERY */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetQueryiv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 493 /* NFOSMESA_GLGETQUERYIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 494 /* NFOSMESA_GLGETQUERYOBJECTIV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 495 /* NFOSMESA_GLGETQUERYOBJECTUIV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBindBuffer(GLenum target, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(*exec)(gl_slb, 496 /* NFOSMESA_GLBINDBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeleteBuffers(GLsizei n, const GLuint *buffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffers;
	(*exec)(gl_slb, 497 /* NFOSMESA_GLDELETEBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenBuffers(GLsizei n, GLuint *buffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffers;
	(*exec)(gl_slb, 498 /* NFOSMESA_GLGENBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsBuffer(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 499 /* NFOSMESA_GLISBUFFER */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glBufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)data;
	(void)usage;
	(*exec)(gl_slb, 500 /* NFOSMESA_GLBUFFERDATA */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 501 /* NFOSMESA_GLBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 502 /* NFOSMESA_GLGETBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &target);
}

static void * APIENTRY exec_glMapBuffer(GLenum target, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	return (void *)(*exec)(gl_slb, 503 /* NFOSMESA_GLMAPBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static GLboolean APIENTRY exec_glUnmapBuffer(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 504 /* NFOSMESA_GLUNMAPBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 505 /* NFOSMESA_GLGETBUFFERPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferPointerv(GLenum target, GLenum pname, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 506 /* NFOSMESA_GLGETBUFFERPOINTERV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glActiveTextureARB(GLenum texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 507 /* NFOSMESA_GLACTIVETEXTUREARB */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glClientActiveTextureARB(GLenum texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 508 /* NFOSMESA_GLCLIENTACTIVETEXTUREARB */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord1dARB(GLenum target, GLdouble s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 509 /* NFOSMESA_GLMULTITEXCOORD1DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1dvARB(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 510 /* NFOSMESA_GLMULTITEXCOORD1DVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1fARB(GLenum target, GLfloat s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 511 /* NFOSMESA_GLMULTITEXCOORD1FARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1fvARB(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 512 /* NFOSMESA_GLMULTITEXCOORD1FVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1iARB(GLenum target, GLint s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 513 /* NFOSMESA_GLMULTITEXCOORD1IARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1ivARB(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 514 /* NFOSMESA_GLMULTITEXCOORD1IVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1sARB(GLenum target, GLshort32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 515 /* NFOSMESA_GLMULTITEXCOORD1SARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1svARB(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 516 /* NFOSMESA_GLMULTITEXCOORD1SVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2dARB(GLenum target, GLdouble s, GLdouble t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 517 /* NFOSMESA_GLMULTITEXCOORD2DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2dvARB(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 518 /* NFOSMESA_GLMULTITEXCOORD2DVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 519 /* NFOSMESA_GLMULTITEXCOORD2FARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2fvARB(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 520 /* NFOSMESA_GLMULTITEXCOORD2FVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2iARB(GLenum target, GLint s, GLint t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 521 /* NFOSMESA_GLMULTITEXCOORD2IARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2ivARB(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 522 /* NFOSMESA_GLMULTITEXCOORD2IVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2sARB(GLenum target, GLshort32 s, GLshort32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 523 /* NFOSMESA_GLMULTITEXCOORD2SARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2svARB(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 524 /* NFOSMESA_GLMULTITEXCOORD2SVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 525 /* NFOSMESA_GLMULTITEXCOORD3DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3dvARB(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 526 /* NFOSMESA_GLMULTITEXCOORD3DVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 527 /* NFOSMESA_GLMULTITEXCOORD3FARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3fvARB(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 528 /* NFOSMESA_GLMULTITEXCOORD3FVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3iARB(GLenum target, GLint s, GLint t, GLint r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 529 /* NFOSMESA_GLMULTITEXCOORD3IARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3ivARB(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 530 /* NFOSMESA_GLMULTITEXCOORD3IVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3sARB(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 531 /* NFOSMESA_GLMULTITEXCOORD3SARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3svARB(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 532 /* NFOSMESA_GLMULTITEXCOORD3SVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4dARB(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 533 /* NFOSMESA_GLMULTITEXCOORD4DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4dvARB(GLenum target, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 534 /* NFOSMESA_GLMULTITEXCOORD4DVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 535 /* NFOSMESA_GLMULTITEXCOORD4FARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4fvARB(GLenum target, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 536 /* NFOSMESA_GLMULTITEXCOORD4FVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4iARB(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 537 /* NFOSMESA_GLMULTITEXCOORD4IARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4ivARB(GLenum target, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 538 /* NFOSMESA_GLMULTITEXCOORD4IVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4sARB(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 539 /* NFOSMESA_GLMULTITEXCOORD4SARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4svARB(GLenum target, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 540 /* NFOSMESA_GLMULTITEXCOORD4SVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glLoadTransposeMatrixfARB(const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 541 /* NFOSMESA_GLLOADTRANSPOSEMATRIXFARB */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glLoadTransposeMatrixdARB(const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 542 /* NFOSMESA_GLLOADTRANSPOSEMATRIXDARB */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultTransposeMatrixfARB(const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 543 /* NFOSMESA_GLMULTTRANSPOSEMATRIXFARB */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultTransposeMatrixdARB(const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 544 /* NFOSMESA_GLMULTTRANSPOSEMATRIXDARB */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glSampleCoverageARB(GLfloat value, GLboolean32 invert)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)invert;
	(*exec)(gl_slb, 545 /* NFOSMESA_GLSAMPLECOVERAGEARB */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glCompressedTexImage3DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 546 /* NFOSMESA_GLCOMPRESSEDTEXIMAGE3DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexImage2DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 547 /* NFOSMESA_GLCOMPRESSEDTEXIMAGE2DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexImage1DARB(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 548 /* NFOSMESA_GLCOMPRESSEDTEXIMAGE1DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexSubImage3DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 549 /* NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE3DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 550 /* NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE2DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCompressedTexSubImage1DARB(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 551 /* NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE1DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetCompressedTexImageARB(GLenum target, GLint level, void *img)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)img;
	(*exec)(gl_slb, 552 /* NFOSMESA_GLGETCOMPRESSEDTEXIMAGEARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPointParameterfARB(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 553 /* NFOSMESA_GLPOINTPARAMETERFARB */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterfvARB(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 554 /* NFOSMESA_GLPOINTPARAMETERFVARB */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glWeightbvARB(GLint size, const GLbyte *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 555 /* NFOSMESA_GLWEIGHTBVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightsvARB(GLint size, const GLshort *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 556 /* NFOSMESA_GLWEIGHTSVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightivARB(GLint size, const GLint *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 557 /* NFOSMESA_GLWEIGHTIVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightfvARB(GLint size, const GLfloat *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 558 /* NFOSMESA_GLWEIGHTFVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightdvARB(GLint size, const GLdouble *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 559 /* NFOSMESA_GLWEIGHTDVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightubvARB(GLint size, const GLubyte *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 560 /* NFOSMESA_GLWEIGHTUBVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightusvARB(GLint size, const GLushort *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 561 /* NFOSMESA_GLWEIGHTUSVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightuivARB(GLint size, const GLuint *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)weights;
	(*exec)(gl_slb, 562 /* NFOSMESA_GLWEIGHTUIVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWeightPointerARB(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 563 /* NFOSMESA_GLWEIGHTPOINTERARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glVertexBlendARB(GLint count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 564 /* NFOSMESA_GLVERTEXBLENDARB */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glCurrentPaletteMatrixARB(GLint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 565 /* NFOSMESA_GLCURRENTPALETTEMATRIXARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glMatrixIndexubvARB(GLint size, const GLubyte *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indices;
	(*exec)(gl_slb, 566 /* NFOSMESA_GLMATRIXINDEXUBVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glMatrixIndexusvARB(GLint size, const GLushort *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indices;
	(*exec)(gl_slb, 567 /* NFOSMESA_GLMATRIXINDEXUSVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glMatrixIndexuivARB(GLint size, const GLuint *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indices;
	(*exec)(gl_slb, 568 /* NFOSMESA_GLMATRIXINDEXUIVARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 569 /* NFOSMESA_GLMATRIXINDEXPOINTERARB */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glWindowPos2dARB(GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 570 /* NFOSMESA_GLWINDOWPOS2DARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2dvARB(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 571 /* NFOSMESA_GLWINDOWPOS2DVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2fARB(GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 572 /* NFOSMESA_GLWINDOWPOS2FARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2fvARB(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 573 /* NFOSMESA_GLWINDOWPOS2FVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2iARB(GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 574 /* NFOSMESA_GLWINDOWPOS2IARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2ivARB(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 575 /* NFOSMESA_GLWINDOWPOS2IVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2sARB(GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 576 /* NFOSMESA_GLWINDOWPOS2SARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2svARB(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 577 /* NFOSMESA_GLWINDOWPOS2SVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3dARB(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 578 /* NFOSMESA_GLWINDOWPOS3DARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3dvARB(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 579 /* NFOSMESA_GLWINDOWPOS3DVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3fARB(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 580 /* NFOSMESA_GLWINDOWPOS3FARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3fvARB(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 581 /* NFOSMESA_GLWINDOWPOS3FVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3iARB(GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 582 /* NFOSMESA_GLWINDOWPOS3IARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3ivARB(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 583 /* NFOSMESA_GLWINDOWPOS3IVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3sARB(GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 584 /* NFOSMESA_GLWINDOWPOS3SARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3svARB(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 585 /* NFOSMESA_GLWINDOWPOS3SVARB */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertexAttrib1dARB(GLuint index, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 586 /* NFOSMESA_GLVERTEXATTRIB1DARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1dvARB(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 587 /* NFOSMESA_GLVERTEXATTRIB1DVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1fARB(GLuint index, GLfloat x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 588 /* NFOSMESA_GLVERTEXATTRIB1FARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1fvARB(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 589 /* NFOSMESA_GLVERTEXATTRIB1FVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1sARB(GLuint index, GLshort32 x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 590 /* NFOSMESA_GLVERTEXATTRIB1SARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1svARB(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 591 /* NFOSMESA_GLVERTEXATTRIB1SVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2dARB(GLuint index, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 592 /* NFOSMESA_GLVERTEXATTRIB2DARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2dvARB(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 593 /* NFOSMESA_GLVERTEXATTRIB2DVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 594 /* NFOSMESA_GLVERTEXATTRIB2FARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2fvARB(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 595 /* NFOSMESA_GLVERTEXATTRIB2FVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2sARB(GLuint index, GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 596 /* NFOSMESA_GLVERTEXATTRIB2SARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2svARB(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 597 /* NFOSMESA_GLVERTEXATTRIB2SVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 598 /* NFOSMESA_GLVERTEXATTRIB3DARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3dvARB(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 599 /* NFOSMESA_GLVERTEXATTRIB3DVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 600 /* NFOSMESA_GLVERTEXATTRIB3FARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3fvARB(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 601 /* NFOSMESA_GLVERTEXATTRIB3FVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3sARB(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 602 /* NFOSMESA_GLVERTEXATTRIB3SARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3svARB(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 603 /* NFOSMESA_GLVERTEXATTRIB3SVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NbvARB(GLuint index, const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 604 /* NFOSMESA_GLVERTEXATTRIB4NBVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NivARB(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 605 /* NFOSMESA_GLVERTEXATTRIB4NIVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NsvARB(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 606 /* NFOSMESA_GLVERTEXATTRIB4NSVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NubARB(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 607 /* NFOSMESA_GLVERTEXATTRIB4NUBARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NubvARB(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 608 /* NFOSMESA_GLVERTEXATTRIB4NUBVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NuivARB(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 609 /* NFOSMESA_GLVERTEXATTRIB4NUIVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4NusvARB(GLuint index, const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 610 /* NFOSMESA_GLVERTEXATTRIB4NUSVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4bvARB(GLuint index, const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 611 /* NFOSMESA_GLVERTEXATTRIB4BVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4dARB(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 612 /* NFOSMESA_GLVERTEXATTRIB4DARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4dvARB(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 613 /* NFOSMESA_GLVERTEXATTRIB4DVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 614 /* NFOSMESA_GLVERTEXATTRIB4FARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4fvARB(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 615 /* NFOSMESA_GLVERTEXATTRIB4FVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4ivARB(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 616 /* NFOSMESA_GLVERTEXATTRIB4IVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4sARB(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 617 /* NFOSMESA_GLVERTEXATTRIB4SARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4svARB(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 618 /* NFOSMESA_GLVERTEXATTRIB4SVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4ubvARB(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 619 /* NFOSMESA_GLVERTEXATTRIB4UBVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4uivARB(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 620 /* NFOSMESA_GLVERTEXATTRIB4UIVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4usvARB(GLuint index, const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 621 /* NFOSMESA_GLVERTEXATTRIB4USVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribPointerARB(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)normalized;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 622 /* NFOSMESA_GLVERTEXATTRIBPOINTERARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glEnableVertexAttribArrayARB(GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 623 /* NFOSMESA_GLENABLEVERTEXATTRIBARRAYARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glDisableVertexAttribArrayARB(GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 624 /* NFOSMESA_GLDISABLEVERTEXATTRIBARRAYARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glProgramStringARB(GLenum target, GLenum format, GLsizei len, const void *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)len;
	(void)string;
	(*exec)(gl_slb, 625 /* NFOSMESA_GLPROGRAMSTRINGARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindProgramARB(GLenum target, GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)program;
	(*exec)(gl_slb, 626 /* NFOSMESA_GLBINDPROGRAMARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeleteProgramsARB(GLsizei n, const GLuint *programs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programs;
	(*exec)(gl_slb, 627 /* NFOSMESA_GLDELETEPROGRAMSARB */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenProgramsARB(GLsizei n, GLuint *programs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programs;
	(*exec)(gl_slb, 628 /* NFOSMESA_GLGENPROGRAMSARB */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 629 /* NFOSMESA_GLPROGRAMENVPARAMETER4DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 630 /* NFOSMESA_GLPROGRAMENVPARAMETER4DVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 631 /* NFOSMESA_GLPROGRAMENVPARAMETER4FARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 632 /* NFOSMESA_GLPROGRAMENVPARAMETER4FVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 633 /* NFOSMESA_GLPROGRAMLOCALPARAMETER4DARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 634 /* NFOSMESA_GLPROGRAMLOCALPARAMETER4DVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 635 /* NFOSMESA_GLPROGRAMLOCALPARAMETER4FARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 636 /* NFOSMESA_GLPROGRAMLOCALPARAMETER4FVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 637 /* NFOSMESA_GLGETPROGRAMENVPARAMETERDVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 638 /* NFOSMESA_GLGETPROGRAMENVPARAMETERFVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 639 /* NFOSMESA_GLGETPROGRAMLOCALPARAMETERDVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 640 /* NFOSMESA_GLGETPROGRAMLOCALPARAMETERFVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramivARB(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 641 /* NFOSMESA_GLGETPROGRAMIVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramStringARB(GLenum target, GLenum pname, void *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)string;
	(*exec)(gl_slb, 642 /* NFOSMESA_GLGETPROGRAMSTRINGARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetVertexAttribdvARB(GLuint index, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 643 /* NFOSMESA_GLGETVERTEXATTRIBDVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribfvARB(GLuint index, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 644 /* NFOSMESA_GLGETVERTEXATTRIBFVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribivARB(GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 645 /* NFOSMESA_GLGETVERTEXATTRIBIVARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribPointervARB(GLuint index, GLenum pname, void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)pointer;
	(*exec)(gl_slb, 646 /* NFOSMESA_GLGETVERTEXATTRIBPOINTERVARB */, SLB_NARGS(2), gl_pub, &index);
}

static GLboolean APIENTRY exec_glIsProgramARB(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 647 /* NFOSMESA_GLISPROGRAMARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glBindBufferARB(GLenum target, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(*exec)(gl_slb, 648 /* NFOSMESA_GLBINDBUFFERARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeleteBuffersARB(GLsizei n, const GLuint *buffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffers;
	(*exec)(gl_slb, 649 /* NFOSMESA_GLDELETEBUFFERSARB */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenBuffersARB(GLsizei n, GLuint *buffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffers;
	(*exec)(gl_slb, 650 /* NFOSMESA_GLGENBUFFERSARB */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsBufferARB(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 651 /* NFOSMESA_GLISBUFFERARB */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glBufferDataARB(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)data;
	(void)usage;
	(*exec)(gl_slb, 652 /* NFOSMESA_GLBUFFERDATAARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 653 /* NFOSMESA_GLBUFFERSUBDATAARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferSubDataARB(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 654 /* NFOSMESA_GLGETBUFFERSUBDATAARB */, SLB_NARGS(2), gl_pub, &target);
}

static void * APIENTRY exec_glMapBufferARB(GLenum target, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	return (void *)(*exec)(gl_slb, 655 /* NFOSMESA_GLMAPBUFFERARB */, SLB_NARGS(2), gl_pub, &target);
}

static GLboolean APIENTRY exec_glUnmapBufferARB(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 656 /* NFOSMESA_GLUNMAPBUFFERARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferParameterivARB(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 657 /* NFOSMESA_GLGETBUFFERPARAMETERIVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferPointervARB(GLenum target, GLenum pname, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 658 /* NFOSMESA_GLGETBUFFERPOINTERVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGenQueriesARB(GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 659 /* NFOSMESA_GLGENQUERIESARB */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteQueriesARB(GLsizei n, const GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 660 /* NFOSMESA_GLDELETEQUERIESARB */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsQueryARB(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 661 /* NFOSMESA_GLISQUERYARB */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginQueryARB(GLenum target, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 662 /* NFOSMESA_GLBEGINQUERYARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEndQueryARB(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 663 /* NFOSMESA_GLENDQUERYARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetQueryivARB(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 664 /* NFOSMESA_GLGETQUERYIVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetQueryObjectivARB(GLuint id, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 665 /* NFOSMESA_GLGETQUERYOBJECTIVARB */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryObjectuivARB(GLuint id, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 666 /* NFOSMESA_GLGETQUERYOBJECTUIVARB */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glDeleteObjectARB(GLhandleARB obj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 667 /* NFOSMESA_GLDELETEOBJECTARB */, SLB_NARGS(2), gl_pub, &obj);
}

static GLhandleARB APIENTRY exec_glGetHandleARB(GLenum pname)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLhandleARB)(*exec)(gl_slb, 668 /* NFOSMESA_GLGETHANDLEARB */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glDetachObjectARB(GLhandleARB containerObj, GLhandleARB attachedObj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachedObj;
	(*exec)(gl_slb, 669 /* NFOSMESA_GLDETACHOBJECTARB */, SLB_NARGS(2), gl_pub, &containerObj);
}

static GLhandleARB APIENTRY exec_glCreateShaderObjectARB(GLenum shaderType)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLhandleARB)(*exec)(gl_slb, 670 /* NFOSMESA_GLCREATESHADEROBJECTARB */, SLB_NARGS(2), gl_pub, &shaderType);
}

static void APIENTRY exec_glShaderSourceARB(GLhandleARB shaderObj, GLsizei count, const GLcharARB * *string, const GLint *length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)string;
	(void)length;
	(*exec)(gl_slb, 671 /* NFOSMESA_GLSHADERSOURCEARB */, SLB_NARGS(2), gl_pub, &shaderObj);
}

static void APIENTRY exec_glCompileShaderARB(GLhandleARB shaderObj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 672 /* NFOSMESA_GLCOMPILESHADERARB */, SLB_NARGS(2), gl_pub, &shaderObj);
}

static GLhandleARB APIENTRY exec_glCreateProgramObjectARB(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLhandleARB)(*exec)(gl_slb, 673 /* NFOSMESA_GLCREATEPROGRAMOBJECTARB */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glAttachObjectARB(GLhandleARB containerObj, GLhandleARB obj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)obj;
	(*exec)(gl_slb, 674 /* NFOSMESA_GLATTACHOBJECTARB */, SLB_NARGS(2), gl_pub, &containerObj);
}

static void APIENTRY exec_glLinkProgramARB(GLhandleARB programObj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 675 /* NFOSMESA_GLLINKPROGRAMARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glUseProgramObjectARB(GLhandleARB programObj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 676 /* NFOSMESA_GLUSEPROGRAMOBJECTARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glValidateProgramARB(GLhandleARB programObj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 677 /* NFOSMESA_GLVALIDATEPROGRAMARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glUniform1fARB(GLint location, GLfloat v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(*exec)(gl_slb, 678 /* NFOSMESA_GLUNIFORM1FARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2fARB(GLint location, GLfloat v0, GLfloat v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 679 /* NFOSMESA_GLUNIFORM2FARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 680 /* NFOSMESA_GLUNIFORM3FARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 681 /* NFOSMESA_GLUNIFORM4FARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1iARB(GLint location, GLint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(*exec)(gl_slb, 682 /* NFOSMESA_GLUNIFORM1IARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2iARB(GLint location, GLint v0, GLint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 683 /* NFOSMESA_GLUNIFORM2IARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3iARB(GLint location, GLint v0, GLint v1, GLint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 684 /* NFOSMESA_GLUNIFORM3IARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 685 /* NFOSMESA_GLUNIFORM4IARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1fvARB(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 686 /* NFOSMESA_GLUNIFORM1FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2fvARB(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 687 /* NFOSMESA_GLUNIFORM2FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3fvARB(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 688 /* NFOSMESA_GLUNIFORM3FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4fvARB(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 689 /* NFOSMESA_GLUNIFORM4FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1ivARB(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 690 /* NFOSMESA_GLUNIFORM1IVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2ivARB(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 691 /* NFOSMESA_GLUNIFORM2IVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3ivARB(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 692 /* NFOSMESA_GLUNIFORM3IVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4ivARB(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 693 /* NFOSMESA_GLUNIFORM4IVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2fvARB(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 694 /* NFOSMESA_GLUNIFORMMATRIX2FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3fvARB(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 695 /* NFOSMESA_GLUNIFORMMATRIX3FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4fvARB(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 696 /* NFOSMESA_GLUNIFORMMATRIX4FVARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glGetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 697 /* NFOSMESA_GLGETOBJECTPARAMETERFVARB */, SLB_NARGS(2), gl_pub, &obj);
}

static void APIENTRY exec_glGetObjectParameterivARB(GLhandleARB obj, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 698 /* NFOSMESA_GLGETOBJECTPARAMETERIVARB */, SLB_NARGS(2), gl_pub, &obj);
}

static void APIENTRY exec_glGetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)maxLength;
	(void)length;
	(void)infoLog;
	(*exec)(gl_slb, 699 /* NFOSMESA_GLGETINFOLOGARB */, SLB_NARGS(2), gl_pub, &obj);
}

static void APIENTRY exec_glGetAttachedObjectsARB(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)maxCount;
	(void)count;
	(void)obj;
	(*exec)(gl_slb, 700 /* NFOSMESA_GLGETATTACHEDOBJECTSARB */, SLB_NARGS(2), gl_pub, &containerObj);
}

static GLint APIENTRY exec_glGetUniformLocationARB(GLhandleARB programObj, const GLcharARB *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 701 /* NFOSMESA_GLGETUNIFORMLOCATIONARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glGetActiveUniformARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)maxLength;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 702 /* NFOSMESA_GLGETACTIVEUNIFORMARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glGetUniformfvARB(GLhandleARB programObj, GLint location, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 703 /* NFOSMESA_GLGETUNIFORMFVARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glGetUniformivARB(GLhandleARB programObj, GLint location, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 704 /* NFOSMESA_GLGETUNIFORMIVARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glGetShaderSourceARB(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)maxLength;
	(void)length;
	(void)source;
	(*exec)(gl_slb, 705 /* NFOSMESA_GLGETSHADERSOURCEARB */, SLB_NARGS(2), gl_pub, &obj);
}

static void APIENTRY exec_glBindAttribLocationARB(GLhandleARB programObj, GLuint index, const GLcharARB *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)name;
	(*exec)(gl_slb, 706 /* NFOSMESA_GLBINDATTRIBLOCATIONARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glGetActiveAttribARB(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)maxLength;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 707 /* NFOSMESA_GLGETACTIVEATTRIBARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static GLint APIENTRY exec_glGetAttribLocationARB(GLhandleARB programObj, const GLcharARB *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 708 /* NFOSMESA_GLGETATTRIBLOCATIONARB */, SLB_NARGS(2), gl_pub, &programObj);
}

static void APIENTRY exec_glDrawBuffersARB(GLsizei n, const GLenum *bufs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufs;
	(*exec)(gl_slb, 709 /* NFOSMESA_GLDRAWBUFFERSARB */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glBlendColorEXT(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 710 /* NFOSMESA_GLBLENDCOLOREXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glPolygonOffsetEXT(GLfloat factor, GLfloat bias)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bias;
	(*exec)(gl_slb, 711 /* NFOSMESA_GLPOLYGONOFFSETEXT */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glTexImage3DEXT(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 712 /* NFOSMESA_GLTEXIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 713 /* NFOSMESA_GLTEXSUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexFilterFuncSGIS(GLenum target, GLenum filter, GLfloat *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)filter;
	(void)weights;
	(*exec)(gl_slb, 714 /* NFOSMESA_GLGETTEXFILTERFUNCSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexFilterFuncSGIS(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)filter;
	(void)n;
	(void)weights;
	(*exec)(gl_slb, 715 /* NFOSMESA_GLTEXFILTERFUNCSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 716 /* NFOSMESA_GLTEXSUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 717 /* NFOSMESA_GLTEXSUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexImage1DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)border;
	(*exec)(gl_slb, 718 /* NFOSMESA_GLCOPYTEXIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexImage2DEXT(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(void)border;
	(*exec)(gl_slb, 719 /* NFOSMESA_GLCOPYTEXIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexSubImage1DEXT(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 720 /* NFOSMESA_GLCOPYTEXSUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexSubImage2DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 721 /* NFOSMESA_GLCOPYTEXSUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyTexSubImage3DEXT(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 722 /* NFOSMESA_GLCOPYTEXSUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetHistogramEXT(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)values;
	(*exec)(gl_slb, 723 /* NFOSMESA_GLGETHISTOGRAMEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetHistogramParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 724 /* NFOSMESA_GLGETHISTOGRAMPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetHistogramParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 725 /* NFOSMESA_GLGETHISTOGRAMPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMinmaxEXT(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)values;
	(*exec)(gl_slb, 726 /* NFOSMESA_GLGETMINMAXEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMinmaxParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 727 /* NFOSMESA_GLGETMINMAXPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMinmaxParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 728 /* NFOSMESA_GLGETMINMAXPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glHistogramEXT(GLenum target, GLsizei width, GLenum internalformat, GLboolean32 sink)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)width;
	(void)internalformat;
	(void)sink;
	(*exec)(gl_slb, 729 /* NFOSMESA_GLHISTOGRAMEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMinmaxEXT(GLenum target, GLenum internalformat, GLboolean32 sink)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)sink;
	(*exec)(gl_slb, 730 /* NFOSMESA_GLMINMAXEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glResetHistogramEXT(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 731 /* NFOSMESA_GLRESETHISTOGRAMEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glResetMinmaxEXT(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 732 /* NFOSMESA_GLRESETMINMAXEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)format;
	(void)type;
	(void)image;
	(*exec)(gl_slb, 733 /* NFOSMESA_GLCONVOLUTIONFILTER1DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)image;
	(*exec)(gl_slb, 734 /* NFOSMESA_GLCONVOLUTIONFILTER2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameterfEXT(GLenum target, GLenum pname, GLfloat params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 735 /* NFOSMESA_GLCONVOLUTIONPARAMETERFEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameterfvEXT(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 736 /* NFOSMESA_GLCONVOLUTIONPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameteriEXT(GLenum target, GLenum pname, GLint params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 737 /* NFOSMESA_GLCONVOLUTIONPARAMETERIEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameterivEXT(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 738 /* NFOSMESA_GLCONVOLUTIONPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyConvolutionFilter1DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 739 /* NFOSMESA_GLCOPYCONVOLUTIONFILTER1DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyConvolutionFilter2DEXT(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 740 /* NFOSMESA_GLCOPYCONVOLUTIONFILTER2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetConvolutionFilterEXT(GLenum target, GLenum format, GLenum type, void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)image;
	(*exec)(gl_slb, 741 /* NFOSMESA_GLGETCONVOLUTIONFILTEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetConvolutionParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 742 /* NFOSMESA_GLGETCONVOLUTIONPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetConvolutionParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 743 /* NFOSMESA_GLGETCONVOLUTIONPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetSeparableFilterEXT(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)row;
	(void)column;
	(void)span;
	(*exec)(gl_slb, 744 /* NFOSMESA_GLGETSEPARABLEFILTEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glSeparableFilter2DEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)row;
	(void)column;
	(*exec)(gl_slb, 745 /* NFOSMESA_GLSEPARABLEFILTER2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorTableSGI(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)format;
	(void)type;
	(void)table;
	(*exec)(gl_slb, 746 /* NFOSMESA_GLCOLORTABLESGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorTableParameterfvSGI(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 747 /* NFOSMESA_GLCOLORTABLEPARAMETERFVSGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorTableParameterivSGI(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 748 /* NFOSMESA_GLCOLORTABLEPARAMETERIVSGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyColorTableSGI(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 749 /* NFOSMESA_GLCOPYCOLORTABLESGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableSGI(GLenum target, GLenum format, GLenum type, void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)table;
	(*exec)(gl_slb, 750 /* NFOSMESA_GLGETCOLORTABLESGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableParameterfvSGI(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 751 /* NFOSMESA_GLGETCOLORTABLEPARAMETERFVSGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableParameterivSGI(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 752 /* NFOSMESA_GLGETCOLORTABLEPARAMETERIVSGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPixelTexGenSGIX(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 753 /* NFOSMESA_GLPIXELTEXGENSGIX */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glPixelTexGenParameteriSGIS(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 754 /* NFOSMESA_GLPIXELTEXGENPARAMETERISGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelTexGenParameterivSGIS(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 755 /* NFOSMESA_GLPIXELTEXGENPARAMETERIVSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelTexGenParameterfSGIS(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 756 /* NFOSMESA_GLPIXELTEXGENPARAMETERFSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelTexGenParameterfvSGIS(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 757 /* NFOSMESA_GLPIXELTEXGENPARAMETERFVSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetPixelTexGenParameterivSGIS(GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 758 /* NFOSMESA_GLGETPIXELTEXGENPARAMETERIVSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetPixelTexGenParameterfvSGIS(GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 759 /* NFOSMESA_GLGETPIXELTEXGENPARAMETERFVSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glTexImage4DSGIS(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)size4d;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 760 /* NFOSMESA_GLTEXIMAGE4DSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexSubImage4DSGIS(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)woffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)size4d;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 761 /* NFOSMESA_GLTEXSUBIMAGE4DSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static GLboolean APIENTRY exec_glAreTexturesResidentEXT(GLsizei n, const GLuint *textures, GLboolean *residences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(void)residences;
	return (GLboolean)(*exec)(gl_slb, 762 /* NFOSMESA_GLARETEXTURESRESIDENTEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glBindTextureEXT(GLenum target, GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)texture;
	(*exec)(gl_slb, 763 /* NFOSMESA_GLBINDTEXTUREEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeleteTexturesEXT(GLsizei n, const GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(*exec)(gl_slb, 764 /* NFOSMESA_GLDELETETEXTURESEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenTexturesEXT(GLsizei n, GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(*exec)(gl_slb, 765 /* NFOSMESA_GLGENTEXTURESEXT */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsTextureEXT(GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 766 /* NFOSMESA_GLISTEXTUREEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glPrioritizeTexturesEXT(GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(void)priorities;
	(*exec)(gl_slb, 767 /* NFOSMESA_GLPRIORITIZETEXTURESEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDetailTexFuncSGIS(GLenum target, GLsizei n, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)points;
	(*exec)(gl_slb, 768 /* NFOSMESA_GLDETAILTEXFUNCSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetDetailTexFuncSGIS(GLenum target, GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)points;
	(*exec)(gl_slb, 769 /* NFOSMESA_GLGETDETAILTEXFUNCSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glSharpenTexFuncSGIS(GLenum target, GLsizei n, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)points;
	(*exec)(gl_slb, 770 /* NFOSMESA_GLSHARPENTEXFUNCSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetSharpenTexFuncSGIS(GLenum target, GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)points;
	(*exec)(gl_slb, 771 /* NFOSMESA_GLGETSHARPENTEXFUNCSGIS */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glSampleMaskSGIS(GLclampf value, GLboolean32 invert)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)invert;
	(*exec)(gl_slb, 772 /* NFOSMESA_GLSAMPLEMASKSGIS */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glSamplePatternSGIS(GLenum pattern)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 773 /* NFOSMESA_GLSAMPLEPATTERNSGIS */, SLB_NARGS(2), gl_pub, &pattern);
}

static void APIENTRY exec_glArrayElementEXT(GLint i)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 774 /* NFOSMESA_GLARRAYELEMENTEXT */, SLB_NARGS(2), gl_pub, &i);
}

static void APIENTRY exec_glColorPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)count;
	(void)pointer;
	(*exec)(gl_slb, 775 /* NFOSMESA_GLCOLORPOINTEREXT */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glDrawArraysEXT(GLenum mode, GLint first, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(*exec)(gl_slb, 776 /* NFOSMESA_GLDRAWARRAYSEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glEdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)pointer;
	(*exec)(gl_slb, 777 /* NFOSMESA_GLEDGEFLAGPOINTEREXT */, SLB_NARGS(2), gl_pub, &stride);
}

static void APIENTRY exec_glGetPointervEXT(GLenum pname, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 778 /* NFOSMESA_GLGETPOINTERVEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glIndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)count;
	(void)pointer;
	(*exec)(gl_slb, 779 /* NFOSMESA_GLINDEXPOINTEREXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glNormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)count;
	(void)pointer;
	(*exec)(gl_slb, 780 /* NFOSMESA_GLNORMALPOINTEREXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)count;
	(void)pointer;
	(*exec)(gl_slb, 781 /* NFOSMESA_GLTEXCOORDPOINTEREXT */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glVertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)count;
	(void)pointer;
	(*exec)(gl_slb, 782 /* NFOSMESA_GLVERTEXPOINTEREXT */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glBlendEquationEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 783 /* NFOSMESA_GLBLENDEQUATIONEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glSpriteParameterfSGIX(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 784 /* NFOSMESA_GLSPRITEPARAMETERFSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glSpriteParameterfvSGIX(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 785 /* NFOSMESA_GLSPRITEPARAMETERFVSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glSpriteParameteriSGIX(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 786 /* NFOSMESA_GLSPRITEPARAMETERISGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glSpriteParameterivSGIX(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 787 /* NFOSMESA_GLSPRITEPARAMETERIVSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterfEXT(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 788 /* NFOSMESA_GLPOINTPARAMETERFEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterfvEXT(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 789 /* NFOSMESA_GLPOINTPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterfSGIS(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 790 /* NFOSMESA_GLPOINTPARAMETERFSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterfvSGIS(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 791 /* NFOSMESA_GLPOINTPARAMETERFVSGIS */, SLB_NARGS(2), gl_pub, &pname);
}

static GLint APIENTRY exec_glGetInstrumentsSGIX(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLint)(*exec)(gl_slb, 792 /* NFOSMESA_GLGETINSTRUMENTSSGIX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glInstrumentsBufferSGIX(GLsizei size, GLint *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(*exec)(gl_slb, 793 /* NFOSMESA_GLINSTRUMENTSBUFFERSGIX */, SLB_NARGS(2), gl_pub, &size);
}

static GLint APIENTRY exec_glPollInstrumentsSGIX(GLint *marker_p)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLint)(*exec)(gl_slb, 794 /* NFOSMESA_GLPOLLINSTRUMENTSSGIX */, SLB_NARGS(2), gl_pub, &marker_p);
}

static void APIENTRY exec_glReadInstrumentsSGIX(GLint marker)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 795 /* NFOSMESA_GLREADINSTRUMENTSSGIX */, SLB_NARGS(2), gl_pub, &marker);
}

static void APIENTRY exec_glStartInstrumentsSGIX(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 796 /* NFOSMESA_GLSTARTINSTRUMENTSSGIX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glStopInstrumentsSGIX(GLint marker)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 797 /* NFOSMESA_GLSTOPINSTRUMENTSSGIX */, SLB_NARGS(2), gl_pub, &marker);
}

static void APIENTRY exec_glFrameZoomSGIX(GLint factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 798 /* NFOSMESA_GLFRAMEZOOMSGIX */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glTagSampleBufferSGIX(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 799 /* NFOSMESA_GLTAGSAMPLEBUFFERSGIX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glDeformationMap3dSGIX(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)w1;
	(void)w2;
	(void)wstride;
	(void)worder;
	(void)points;
	(*exec)(gl_slb, 800 /* NFOSMESA_GLDEFORMATIONMAP3DSGIX */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeformationMap3fSGIX(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)w1;
	(void)w2;
	(void)wstride;
	(void)worder;
	(void)points;
	(*exec)(gl_slb, 801 /* NFOSMESA_GLDEFORMATIONMAP3FSGIX */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeformSGIX(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 802 /* NFOSMESA_GLDEFORMSGIX */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glLoadIdentityDeformationMapSGIX(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 803 /* NFOSMESA_GLLOADIDENTITYDEFORMATIONMAPSGIX */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glReferencePlaneSGIX(const GLdouble *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 804 /* NFOSMESA_GLREFERENCEPLANESGIX */, SLB_NARGS(2), gl_pub, &equation);
}

static void APIENTRY exec_glFlushRasterSGIX(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 805 /* NFOSMESA_GLFLUSHRASTERSGIX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glFogFuncSGIS(GLsizei n, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)points;
	(*exec)(gl_slb, 806 /* NFOSMESA_GLFOGFUNCSGIS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGetFogFuncSGIS(GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 807 /* NFOSMESA_GLGETFOGFUNCSGIS */, SLB_NARGS(2), gl_pub, &points);
}

static void APIENTRY exec_glImageTransformParameteriHP(GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 808 /* NFOSMESA_GLIMAGETRANSFORMPARAMETERIHP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glImageTransformParameterfHP(GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 809 /* NFOSMESA_GLIMAGETRANSFORMPARAMETERFHP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glImageTransformParameterivHP(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 810 /* NFOSMESA_GLIMAGETRANSFORMPARAMETERIVHP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glImageTransformParameterfvHP(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 811 /* NFOSMESA_GLIMAGETRANSFORMPARAMETERFVHP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetImageTransformParameterivHP(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 812 /* NFOSMESA_GLGETIMAGETRANSFORMPARAMETERIVHP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetImageTransformParameterfvHP(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 813 /* NFOSMESA_GLGETIMAGETRANSFORMPARAMETERFVHP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorSubTableEXT(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)count;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 814 /* NFOSMESA_GLCOLORSUBTABLEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyColorSubTableEXT(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 815 /* NFOSMESA_GLCOPYCOLORSUBTABLEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glHintPGI(GLenum target, GLint mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 816 /* NFOSMESA_GLHINTPGI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glColorTableEXT(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalFormat;
	(void)width;
	(void)format;
	(void)type;
	(void)table;
	(*exec)(gl_slb, 817 /* NFOSMESA_GLCOLORTABLEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableEXT(GLenum target, GLenum format, GLenum type, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 818 /* NFOSMESA_GLGETCOLORTABLEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 819 /* NFOSMESA_GLGETCOLORTABLEPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetColorTableParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 820 /* NFOSMESA_GLGETCOLORTABLEPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetListParameterfvSGIX(GLuint list, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 821 /* NFOSMESA_GLGETLISTPARAMETERFVSGIX */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glGetListParameterivSGIX(GLuint list, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 822 /* NFOSMESA_GLGETLISTPARAMETERIVSGIX */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glListParameterfSGIX(GLuint list, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 823 /* NFOSMESA_GLLISTPARAMETERFSGIX */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glListParameterfvSGIX(GLuint list, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 824 /* NFOSMESA_GLLISTPARAMETERFVSGIX */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glListParameteriSGIX(GLuint list, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 825 /* NFOSMESA_GLLISTPARAMETERISGIX */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glListParameterivSGIX(GLuint list, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 826 /* NFOSMESA_GLLISTPARAMETERIVSGIX */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glIndexMaterialEXT(GLenum face, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 827 /* NFOSMESA_GLINDEXMATERIALEXT */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glIndexFuncEXT(GLenum func, GLclampf ref)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ref;
	(*exec)(gl_slb, 828 /* NFOSMESA_GLINDEXFUNCEXT */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glLockArraysEXT(GLint first, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(*exec)(gl_slb, 829 /* NFOSMESA_GLLOCKARRAYSEXT */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glUnlockArraysEXT(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 830 /* NFOSMESA_GLUNLOCKARRAYSEXT */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glCullParameterdvEXT(GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 831 /* NFOSMESA_GLCULLPARAMETERDVEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glCullParameterfvEXT(GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 832 /* NFOSMESA_GLCULLPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFragmentColorMaterialSGIX(GLenum face, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 833 /* NFOSMESA_GLFRAGMENTCOLORMATERIALSGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glFragmentLightfSGIX(GLenum light, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 834 /* NFOSMESA_GLFRAGMENTLIGHTFSGIX */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glFragmentLightfvSGIX(GLenum light, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 835 /* NFOSMESA_GLFRAGMENTLIGHTFVSGIX */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glFragmentLightiSGIX(GLenum light, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 836 /* NFOSMESA_GLFRAGMENTLIGHTISGIX */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glFragmentLightivSGIX(GLenum light, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 837 /* NFOSMESA_GLFRAGMENTLIGHTIVSGIX */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glFragmentLightModelfSGIX(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 838 /* NFOSMESA_GLFRAGMENTLIGHTMODELFSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFragmentLightModelfvSGIX(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 839 /* NFOSMESA_GLFRAGMENTLIGHTMODELFVSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFragmentLightModeliSGIX(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 840 /* NFOSMESA_GLFRAGMENTLIGHTMODELISGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFragmentLightModelivSGIX(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 841 /* NFOSMESA_GLFRAGMENTLIGHTMODELIVSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFragmentMaterialfSGIX(GLenum face, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 842 /* NFOSMESA_GLFRAGMENTMATERIALFSGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glFragmentMaterialfvSGIX(GLenum face, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 843 /* NFOSMESA_GLFRAGMENTMATERIALFVSGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glFragmentMaterialiSGIX(GLenum face, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 844 /* NFOSMESA_GLFRAGMENTMATERIALISGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glFragmentMaterialivSGIX(GLenum face, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 845 /* NFOSMESA_GLFRAGMENTMATERIALIVSGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glGetFragmentLightfvSGIX(GLenum light, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 846 /* NFOSMESA_GLGETFRAGMENTLIGHTFVSGIX */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glGetFragmentLightivSGIX(GLenum light, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 847 /* NFOSMESA_GLGETFRAGMENTLIGHTIVSGIX */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glGetFragmentMaterialfvSGIX(GLenum face, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 848 /* NFOSMESA_GLGETFRAGMENTMATERIALFVSGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glGetFragmentMaterialivSGIX(GLenum face, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 849 /* NFOSMESA_GLGETFRAGMENTMATERIALIVSGIX */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glLightEnviSGIX(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 850 /* NFOSMESA_GLLIGHTENVISGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glDrawRangeElementsEXT(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)end;
	(void)count;
	(void)type;
	(void)indices;
	(*exec)(gl_slb, 851 /* NFOSMESA_GLDRAWRANGEELEMENTSEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glApplyTextureEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 852 /* NFOSMESA_GLAPPLYTEXTUREEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glTextureLightEXT(GLenum pname)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 853 /* NFOSMESA_GLTEXTURELIGHTEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glTextureMaterialEXT(GLenum face, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 854 /* NFOSMESA_GLTEXTUREMATERIALEXT */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glAsyncMarkerSGIX(GLuint marker)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 855 /* NFOSMESA_GLASYNCMARKERSGIX */, SLB_NARGS(2), gl_pub, &marker);
}

static GLint APIENTRY exec_glFinishAsyncSGIX(GLuint *markerp)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLint)(*exec)(gl_slb, 856 /* NFOSMESA_GLFINISHASYNCSGIX */, SLB_NARGS(2), gl_pub, &markerp);
}

static GLint APIENTRY exec_glPollAsyncSGIX(GLuint *markerp)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLint)(*exec)(gl_slb, 857 /* NFOSMESA_GLPOLLASYNCSGIX */, SLB_NARGS(2), gl_pub, &markerp);
}

static GLuint APIENTRY exec_glGenAsyncMarkersSGIX(GLsizei range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 858 /* NFOSMESA_GLGENASYNCMARKERSSGIX */, SLB_NARGS(2), gl_pub, &range);
}

static void APIENTRY exec_glDeleteAsyncMarkersSGIX(GLuint marker, GLsizei range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)range;
	(*exec)(gl_slb, 859 /* NFOSMESA_GLDELETEASYNCMARKERSSGIX */, SLB_NARGS(2), gl_pub, &marker);
}

static GLboolean APIENTRY exec_glIsAsyncMarkerSGIX(GLuint marker)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 860 /* NFOSMESA_GLISASYNCMARKERSGIX */, SLB_NARGS(2), gl_pub, &marker);
}

static void APIENTRY exec_glVertexPointervINTEL(GLint size, GLenum type, const void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)pointer;
	(*exec)(gl_slb, 861 /* NFOSMESA_GLVERTEXPOINTERVINTEL */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glNormalPointervINTEL(GLenum type, const void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 862 /* NFOSMESA_GLNORMALPOINTERVINTEL */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glColorPointervINTEL(GLint size, GLenum type, const void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)pointer;
	(*exec)(gl_slb, 863 /* NFOSMESA_GLCOLORPOINTERVINTEL */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glTexCoordPointervINTEL(GLint size, GLenum type, const void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)pointer;
	(*exec)(gl_slb, 864 /* NFOSMESA_GLTEXCOORDPOINTERVINTEL */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glPixelTransformParameteriEXT(GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 865 /* NFOSMESA_GLPIXELTRANSFORMPARAMETERIEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPixelTransformParameterfEXT(GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 866 /* NFOSMESA_GLPIXELTRANSFORMPARAMETERFEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPixelTransformParameterivEXT(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 867 /* NFOSMESA_GLPIXELTRANSFORMPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPixelTransformParameterfvEXT(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 868 /* NFOSMESA_GLPIXELTRANSFORMPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glSecondaryColor3bEXT(GLbyte32 red, GLbyte32 green, GLbyte32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 869 /* NFOSMESA_GLSECONDARYCOLOR3BEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3bvEXT(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 870 /* NFOSMESA_GLSECONDARYCOLOR3BVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3dEXT(GLdouble red, GLdouble green, GLdouble blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 871 /* NFOSMESA_GLSECONDARYCOLOR3DEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3dvEXT(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 872 /* NFOSMESA_GLSECONDARYCOLOR3DVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 873 /* NFOSMESA_GLSECONDARYCOLOR3FEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3fvEXT(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 874 /* NFOSMESA_GLSECONDARYCOLOR3FVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3iEXT(GLint red, GLint green, GLint blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 875 /* NFOSMESA_GLSECONDARYCOLOR3IEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3ivEXT(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 876 /* NFOSMESA_GLSECONDARYCOLOR3IVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3sEXT(GLshort32 red, GLshort32 green, GLshort32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 877 /* NFOSMESA_GLSECONDARYCOLOR3SEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3svEXT(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 878 /* NFOSMESA_GLSECONDARYCOLOR3SVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3ubEXT(GLubyte32 red, GLubyte32 green, GLubyte32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 879 /* NFOSMESA_GLSECONDARYCOLOR3UBEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3ubvEXT(const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 880 /* NFOSMESA_GLSECONDARYCOLOR3UBVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3uiEXT(GLuint red, GLuint green, GLuint blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 881 /* NFOSMESA_GLSECONDARYCOLOR3UIEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3uivEXT(const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 882 /* NFOSMESA_GLSECONDARYCOLOR3UIVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColor3usEXT(GLushort32 red, GLushort32 green, GLushort32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 883 /* NFOSMESA_GLSECONDARYCOLOR3USEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3usvEXT(const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 884 /* NFOSMESA_GLSECONDARYCOLOR3USVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glSecondaryColorPointerEXT(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 885 /* NFOSMESA_GLSECONDARYCOLORPOINTEREXT */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glTextureNormalEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 886 /* NFOSMESA_GLTEXTURENORMALEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawArraysEXT(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)primcount;
	(*exec)(gl_slb, 887 /* NFOSMESA_GLMULTIDRAWARRAYSEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)primcount;
	(*exec)(gl_slb, 888 /* NFOSMESA_GLMULTIDRAWELEMENTSEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glFogCoordfEXT(GLfloat coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 889 /* NFOSMESA_GLFOGCOORDFEXT */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoordfvEXT(const GLfloat *coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 890 /* NFOSMESA_GLFOGCOORDFVEXT */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoorddEXT(GLdouble coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 891 /* NFOSMESA_GLFOGCOORDDEXT */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoorddvEXT(const GLdouble *coord)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 892 /* NFOSMESA_GLFOGCOORDDVEXT */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glFogCoordPointerEXT(GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 893 /* NFOSMESA_GLFOGCOORDPOINTEREXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTangent3bEXT(GLbyte32 tx, GLbyte32 ty, GLbyte32 tz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ty;
	(void)tz;
	(*exec)(gl_slb, 894 /* NFOSMESA_GLTANGENT3BEXT */, SLB_NARGS(2), gl_pub, &tx);
}

static void APIENTRY exec_glTangent3bvEXT(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 895 /* NFOSMESA_GLTANGENT3BVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTangent3dEXT(GLdouble tx, GLdouble ty, GLdouble tz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ty;
	(void)tz;
	(*exec)(gl_slb, 896 /* NFOSMESA_GLTANGENT3DEXT */, SLB_NARGS(2), gl_pub, &tx);
}

static void APIENTRY exec_glTangent3dvEXT(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 897 /* NFOSMESA_GLTANGENT3DVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTangent3fEXT(GLfloat tx, GLfloat ty, GLfloat tz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ty;
	(void)tz;
	(*exec)(gl_slb, 898 /* NFOSMESA_GLTANGENT3FEXT */, SLB_NARGS(2), gl_pub, &tx);
}

static void APIENTRY exec_glTangent3fvEXT(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 899 /* NFOSMESA_GLTANGENT3FVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTangent3iEXT(GLint tx, GLint ty, GLint tz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ty;
	(void)tz;
	(*exec)(gl_slb, 900 /* NFOSMESA_GLTANGENT3IEXT */, SLB_NARGS(2), gl_pub, &tx);
}

static void APIENTRY exec_glTangent3ivEXT(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 901 /* NFOSMESA_GLTANGENT3IVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTangent3sEXT(GLshort32 tx, GLshort32 ty, GLshort32 tz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ty;
	(void)tz;
	(*exec)(gl_slb, 902 /* NFOSMESA_GLTANGENT3SEXT */, SLB_NARGS(2), gl_pub, &tx);
}

static void APIENTRY exec_glTangent3svEXT(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 903 /* NFOSMESA_GLTANGENT3SVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glBinormal3bEXT(GLbyte32 bx, GLbyte32 by, GLbyte32 bz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)by;
	(void)bz;
	(*exec)(gl_slb, 904 /* NFOSMESA_GLBINORMAL3BEXT */, SLB_NARGS(2), gl_pub, &bx);
}

static void APIENTRY exec_glBinormal3bvEXT(const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 905 /* NFOSMESA_GLBINORMAL3BVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glBinormal3dEXT(GLdouble bx, GLdouble by, GLdouble bz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)by;
	(void)bz;
	(*exec)(gl_slb, 906 /* NFOSMESA_GLBINORMAL3DEXT */, SLB_NARGS(2), gl_pub, &bx);
}

static void APIENTRY exec_glBinormal3dvEXT(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 907 /* NFOSMESA_GLBINORMAL3DVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glBinormal3fEXT(GLfloat bx, GLfloat by, GLfloat bz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)by;
	(void)bz;
	(*exec)(gl_slb, 908 /* NFOSMESA_GLBINORMAL3FEXT */, SLB_NARGS(2), gl_pub, &bx);
}

static void APIENTRY exec_glBinormal3fvEXT(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 909 /* NFOSMESA_GLBINORMAL3FVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glBinormal3iEXT(GLint bx, GLint by, GLint bz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)by;
	(void)bz;
	(*exec)(gl_slb, 910 /* NFOSMESA_GLBINORMAL3IEXT */, SLB_NARGS(2), gl_pub, &bx);
}

static void APIENTRY exec_glBinormal3ivEXT(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 911 /* NFOSMESA_GLBINORMAL3IVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glBinormal3sEXT(GLshort32 bx, GLshort32 by, GLshort32 bz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)by;
	(void)bz;
	(*exec)(gl_slb, 912 /* NFOSMESA_GLBINORMAL3SEXT */, SLB_NARGS(2), gl_pub, &bx);
}

static void APIENTRY exec_glBinormal3svEXT(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 913 /* NFOSMESA_GLBINORMAL3SVEXT */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTangentPointerEXT(GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 914 /* NFOSMESA_GLTANGENTPOINTEREXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glBinormalPointerEXT(GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 915 /* NFOSMESA_GLBINORMALPOINTEREXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glFinishTextureSUNX(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 916 /* NFOSMESA_GLFINISHTEXTURESUNX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glGlobalAlphaFactorbSUN(GLbyte32 factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 917 /* NFOSMESA_GLGLOBALALPHAFACTORBSUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactorsSUN(GLshort32 factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 918 /* NFOSMESA_GLGLOBALALPHAFACTORSSUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactoriSUN(GLint factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 919 /* NFOSMESA_GLGLOBALALPHAFACTORISUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactorfSUN(GLfloat factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 920 /* NFOSMESA_GLGLOBALALPHAFACTORFSUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactordSUN(GLdouble factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 921 /* NFOSMESA_GLGLOBALALPHAFACTORDSUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactorubSUN(GLubyte32 factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 922 /* NFOSMESA_GLGLOBALALPHAFACTORUBSUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactorusSUN(GLushort32 factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 923 /* NFOSMESA_GLGLOBALALPHAFACTORUSSUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glGlobalAlphaFactoruiSUN(GLuint factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 924 /* NFOSMESA_GLGLOBALALPHAFACTORUISUN */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glReplacementCodeuiSUN(GLuint code)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 925 /* NFOSMESA_GLREPLACEMENTCODEUISUN */, SLB_NARGS(2), gl_pub, &code);
}

static void APIENTRY exec_glReplacementCodeusSUN(GLushort32 code)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 926 /* NFOSMESA_GLREPLACEMENTCODEUSSUN */, SLB_NARGS(2), gl_pub, &code);
}

static void APIENTRY exec_glReplacementCodeubSUN(GLubyte32 code)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 927 /* NFOSMESA_GLREPLACEMENTCODEUBSUN */, SLB_NARGS(2), gl_pub, &code);
}

static void APIENTRY exec_glReplacementCodeuivSUN(const GLuint *code)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 928 /* NFOSMESA_GLREPLACEMENTCODEUIVSUN */, SLB_NARGS(2), gl_pub, &code);
}

static void APIENTRY exec_glReplacementCodeusvSUN(const GLushort *code)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 929 /* NFOSMESA_GLREPLACEMENTCODEUSVSUN */, SLB_NARGS(2), gl_pub, &code);
}

static void APIENTRY exec_glReplacementCodeubvSUN(const GLubyte *code)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 930 /* NFOSMESA_GLREPLACEMENTCODEUBVSUN */, SLB_NARGS(2), gl_pub, &code);
}

static void APIENTRY exec_glReplacementCodePointerSUN(GLenum type, GLsizei stride, const void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 931 /* NFOSMESA_GLREPLACEMENTCODEPOINTERSUN */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glColor4ubVertex2fSUN(GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)g;
	(void)b;
	(void)a;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 932 /* NFOSMESA_GLCOLOR4UBVERTEX2FSUN */, SLB_NARGS(2), gl_pub, &r);
}

static void APIENTRY exec_glColor4ubVertex2fvSUN(const GLubyte *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 933 /* NFOSMESA_GLCOLOR4UBVERTEX2FVSUN */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glColor4ubVertex3fSUN(GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)g;
	(void)b;
	(void)a;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 934 /* NFOSMESA_GLCOLOR4UBVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &r);
}

static void APIENTRY exec_glColor4ubVertex3fvSUN(const GLubyte *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 935 /* NFOSMESA_GLCOLOR4UBVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glColor3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)g;
	(void)b;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 936 /* NFOSMESA_GLCOLOR3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &r);
}

static void APIENTRY exec_glColor3fVertex3fvSUN(const GLfloat *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 937 /* NFOSMESA_GLCOLOR3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glNormal3fVertex3fSUN(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 938 /* NFOSMESA_GLNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3fVertex3fvSUN(const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 939 /* NFOSMESA_GLNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glColor4fNormal3fVertex3fSUN(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)g;
	(void)b;
	(void)a;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 940 /* NFOSMESA_GLCOLOR4FNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &r);
}

static void APIENTRY exec_glColor4fNormal3fVertex3fvSUN(const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 941 /* NFOSMESA_GLCOLOR4FNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &c);
}

static void APIENTRY exec_glTexCoord2fVertex3fSUN(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 942 /* NFOSMESA_GLTEXCOORD2FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2fVertex3fvSUN(const GLfloat *tc, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 943 /* NFOSMESA_GLTEXCOORD2FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glTexCoord4fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)p;
	(void)q;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 944 /* NFOSMESA_GLTEXCOORD4FVERTEX4FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4fVertex4fvSUN(const GLfloat *tc, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 945 /* NFOSMESA_GLTEXCOORD4FVERTEX4FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glTexCoord2fColor4ubVertex3fSUN(GLfloat s, GLfloat t, GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 946 /* NFOSMESA_GLTEXCOORD2FCOLOR4UBVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2fColor4ubVertex3fvSUN(const GLfloat *tc, const GLubyte *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)v;
	(*exec)(gl_slb, 947 /* NFOSMESA_GLTEXCOORD2FCOLOR4UBVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glTexCoord2fColor3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)g;
	(void)b;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 948 /* NFOSMESA_GLTEXCOORD2FCOLOR3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2fColor3fVertex3fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)v;
	(*exec)(gl_slb, 949 /* NFOSMESA_GLTEXCOORD2FCOLOR3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glTexCoord2fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 950 /* NFOSMESA_GLTEXCOORD2FNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2fNormal3fVertex3fvSUN(const GLfloat *tc, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 951 /* NFOSMESA_GLTEXCOORD2FNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glTexCoord2fColor4fNormal3fVertex3fSUN(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 952 /* NFOSMESA_GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2fColor4fNormal3fVertex3fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 953 /* NFOSMESA_GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glTexCoord4fColor4fNormal3fVertex4fSUN(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)p;
	(void)q;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 954 /* NFOSMESA_GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4fColor4fNormal3fVertex4fvSUN(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 955 /* NFOSMESA_GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN */, SLB_NARGS(2), gl_pub, &tc);
}

static void APIENTRY exec_glReplacementCodeuiVertex3fSUN(GLuint rc, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 956 /* NFOSMESA_GLREPLACEMENTCODEUIVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiVertex3fvSUN(const GLuint *rc, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 957 /* NFOSMESA_GLREPLACEMENTCODEUIVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiColor4ubVertex3fSUN(GLuint rc, GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 958 /* NFOSMESA_GLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiColor4ubVertex3fvSUN(const GLuint *rc, const GLubyte *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)v;
	(*exec)(gl_slb, 959 /* NFOSMESA_GLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiColor3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)g;
	(void)b;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 960 /* NFOSMESA_GLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiColor3fVertex3fvSUN(const GLuint *rc, const GLfloat *c, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)v;
	(*exec)(gl_slb, 961 /* NFOSMESA_GLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiNormal3fVertex3fSUN(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 962 /* NFOSMESA_GLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 963 /* NFOSMESA_GLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 964 /* NFOSMESA_GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiColor4fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)c;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 965 /* NFOSMESA_GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiTexCoord2fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 966 /* NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiTexCoord2fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)tc;
	(void)v;
	(*exec)(gl_slb, 967 /* NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 968 /* NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)tc;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 969 /* NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(void)nx;
	(void)ny;
	(void)nz;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 970 /* NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)tc;
	(void)c;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 971 /* NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN */, SLB_NARGS(2), gl_pub, &rc);
}

static void APIENTRY exec_glBlendFuncSeparateEXT(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dfactorRGB;
	(void)sfactorAlpha;
	(void)dfactorAlpha;
	(*exec)(gl_slb, 972 /* NFOSMESA_GLBLENDFUNCSEPARATEEXT */, SLB_NARGS(2), gl_pub, &sfactorRGB);
}

static void APIENTRY exec_glBlendFuncSeparateINGR(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dfactorRGB;
	(void)sfactorAlpha;
	(void)dfactorAlpha;
	(*exec)(gl_slb, 973 /* NFOSMESA_GLBLENDFUNCSEPARATEINGR */, SLB_NARGS(2), gl_pub, &sfactorRGB);
}

static void APIENTRY exec_glVertexWeightfEXT(GLfloat weight)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 974 /* NFOSMESA_GLVERTEXWEIGHTFEXT */, SLB_NARGS(2), gl_pub, &weight);
}

static void APIENTRY exec_glVertexWeightfvEXT(const GLfloat *weight)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 975 /* NFOSMESA_GLVERTEXWEIGHTFVEXT */, SLB_NARGS(2), gl_pub, &weight);
}

static void APIENTRY exec_glVertexWeightPointerEXT(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 976 /* NFOSMESA_GLVERTEXWEIGHTPOINTEREXT */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glFlushVertexArrayRangeNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 977 /* NFOSMESA_GLFLUSHVERTEXARRAYRANGENV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glVertexArrayRangeNV(GLsizei length, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 978 /* NFOSMESA_GLVERTEXARRAYRANGENV */, SLB_NARGS(2), gl_pub, &length);
}

static void APIENTRY exec_glCombinerParameterfvNV(GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 979 /* NFOSMESA_GLCOMBINERPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glCombinerParameterfNV(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 980 /* NFOSMESA_GLCOMBINERPARAMETERFNV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glCombinerParameterivNV(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 981 /* NFOSMESA_GLCOMBINERPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glCombinerParameteriNV(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 982 /* NFOSMESA_GLCOMBINERPARAMETERINV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glCombinerInputNV(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)portion;
	(void)variable;
	(void)input;
	(void)mapping;
	(void)componentUsage;
	(*exec)(gl_slb, 983 /* NFOSMESA_GLCOMBINERINPUTNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glCombinerOutputNV(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean32 abDotProduct, GLboolean32 cdDotProduct, GLboolean32 muxSum)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)portion;
	(void)abOutput;
	(void)cdOutput;
	(void)sumOutput;
	(void)scale;
	(void)bias;
	(void)abDotProduct;
	(void)cdDotProduct;
	(void)muxSum;
	(*exec)(gl_slb, 984 /* NFOSMESA_GLCOMBINEROUTPUTNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glFinalCombinerInputNV(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)input;
	(void)mapping;
	(void)componentUsage;
	(*exec)(gl_slb, 985 /* NFOSMESA_GLFINALCOMBINERINPUTNV */, SLB_NARGS(2), gl_pub, &variable);
}

static void APIENTRY exec_glGetCombinerInputParameterfvNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)portion;
	(void)variable;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 986 /* NFOSMESA_GLGETCOMBINERINPUTPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glGetCombinerInputParameterivNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)portion;
	(void)variable;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 987 /* NFOSMESA_GLGETCOMBINERINPUTPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glGetCombinerOutputParameterfvNV(GLenum stage, GLenum portion, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)portion;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 988 /* NFOSMESA_GLGETCOMBINEROUTPUTPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glGetCombinerOutputParameterivNV(GLenum stage, GLenum portion, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)portion;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 989 /* NFOSMESA_GLGETCOMBINEROUTPUTPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glGetFinalCombinerInputParameterfvNV(GLenum variable, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 990 /* NFOSMESA_GLGETFINALCOMBINERINPUTPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &variable);
}

static void APIENTRY exec_glGetFinalCombinerInputParameterivNV(GLenum variable, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 991 /* NFOSMESA_GLGETFINALCOMBINERINPUTPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &variable);
}

static void APIENTRY exec_glResizeBuffersMESA(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 992 /* NFOSMESA_GLRESIZEBUFFERSMESA */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glWindowPos2dMESA(GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 993 /* NFOSMESA_GLWINDOWPOS2DMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2dvMESA(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 994 /* NFOSMESA_GLWINDOWPOS2DVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2fMESA(GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 995 /* NFOSMESA_GLWINDOWPOS2FMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2fvMESA(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 996 /* NFOSMESA_GLWINDOWPOS2FVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2iMESA(GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 997 /* NFOSMESA_GLWINDOWPOS2IMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2ivMESA(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 998 /* NFOSMESA_GLWINDOWPOS2IVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos2sMESA(GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 999 /* NFOSMESA_GLWINDOWPOS2SMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos2svMESA(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1000 /* NFOSMESA_GLWINDOWPOS2SVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3dMESA(GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1001 /* NFOSMESA_GLWINDOWPOS3DMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3dvMESA(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1002 /* NFOSMESA_GLWINDOWPOS3DVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3fMESA(GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1003 /* NFOSMESA_GLWINDOWPOS3FMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3fvMESA(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1004 /* NFOSMESA_GLWINDOWPOS3FVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3iMESA(GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1005 /* NFOSMESA_GLWINDOWPOS3IMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3ivMESA(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1006 /* NFOSMESA_GLWINDOWPOS3IVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos3sMESA(GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1007 /* NFOSMESA_GLWINDOWPOS3SMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos3svMESA(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1008 /* NFOSMESA_GLWINDOWPOS3SVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos4dMESA(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1009 /* NFOSMESA_GLWINDOWPOS4DMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos4dvMESA(const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1010 /* NFOSMESA_GLWINDOWPOS4DVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos4fMESA(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1011 /* NFOSMESA_GLWINDOWPOS4FMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos4fvMESA(const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1012 /* NFOSMESA_GLWINDOWPOS4FVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos4iMESA(GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1013 /* NFOSMESA_GLWINDOWPOS4IMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos4ivMESA(const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1014 /* NFOSMESA_GLWINDOWPOS4IVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glWindowPos4sMESA(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1015 /* NFOSMESA_GLWINDOWPOS4SMESA */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glWindowPos4svMESA(const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1016 /* NFOSMESA_GLWINDOWPOS4SVMESA */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glMultiModeDrawArraysIBM(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)primcount;
	(void)modestride;
	(*exec)(gl_slb, 1017 /* NFOSMESA_GLMULTIMODEDRAWARRAYSIBM */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiModeDrawElementsIBM(const GLenum *mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei primcount, GLint modestride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)primcount;
	(void)modestride;
	(*exec)(gl_slb, 1018 /* NFOSMESA_GLMULTIMODEDRAWELEMENTSIBM */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glColorPointerListIBM(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1019 /* NFOSMESA_GLCOLORPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glSecondaryColorPointerListIBM(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1020 /* NFOSMESA_GLSECONDARYCOLORPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glEdgeFlagPointerListIBM(GLint stride, const GLboolean * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1021 /* NFOSMESA_GLEDGEFLAGPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &stride);
}

static void APIENTRY exec_glFogCoordPointerListIBM(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1022 /* NFOSMESA_GLFOGCOORDPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glIndexPointerListIBM(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1023 /* NFOSMESA_GLINDEXPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glNormalPointerListIBM(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1024 /* NFOSMESA_GLNORMALPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordPointerListIBM(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1025 /* NFOSMESA_GLTEXCOORDPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glVertexPointerListIBM(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)pointer;
	(void)ptrstride;
	(*exec)(gl_slb, 1026 /* NFOSMESA_GLVERTEXPOINTERLISTIBM */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glTbufferMask3DFX(GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1027 /* NFOSMESA_GLTBUFFERMASK3DFX */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glSampleMaskEXT(GLclampf value, GLboolean32 invert)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)invert;
	(*exec)(gl_slb, 1028 /* NFOSMESA_GLSAMPLEMASKEXT */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glSamplePatternEXT(GLenum pattern)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1029 /* NFOSMESA_GLSAMPLEPATTERNEXT */, SLB_NARGS(2), gl_pub, &pattern);
}

static void APIENTRY exec_glTextureColorMaskSGIS(GLboolean32 red, GLboolean32 green, GLboolean32 blue, GLboolean32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1030 /* NFOSMESA_GLTEXTURECOLORMASKSGIS */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glIglooInterfaceSGIX(GLenum pname, const void *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 1031 /* NFOSMESA_GLIGLOOINTERFACESGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glDeleteFencesNV(GLsizei n, const GLuint *fences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fences;
	(*exec)(gl_slb, 1032 /* NFOSMESA_GLDELETEFENCESNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenFencesNV(GLsizei n, GLuint *fences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fences;
	(*exec)(gl_slb, 1033 /* NFOSMESA_GLGENFENCESNV */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsFenceNV(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1034 /* NFOSMESA_GLISFENCENV */, SLB_NARGS(2), gl_pub, &fence);
}

static GLboolean APIENTRY exec_glTestFenceNV(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1035 /* NFOSMESA_GLTESTFENCENV */, SLB_NARGS(2), gl_pub, &fence);
}

static void APIENTRY exec_glGetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1036 /* NFOSMESA_GLGETFENCEIVNV */, SLB_NARGS(2), gl_pub, &fence);
}

static void APIENTRY exec_glFinishFenceNV(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1037 /* NFOSMESA_GLFINISHFENCENV */, SLB_NARGS(2), gl_pub, &fence);
}

static void APIENTRY exec_glSetFenceNV(GLuint fence, GLenum condition)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)condition;
	(*exec)(gl_slb, 1038 /* NFOSMESA_GLSETFENCENV */, SLB_NARGS(2), gl_pub, &fence);
}

static void APIENTRY exec_glMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean32 packed, const void *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)type;
	(void)ustride;
	(void)vstride;
	(void)uorder;
	(void)vorder;
	(void)packed;
	(void)points;
	(*exec)(gl_slb, 1039 /* NFOSMESA_GLMAPCONTROLPOINTSNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMapParameterivNV(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1040 /* NFOSMESA_GLMAPPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMapParameterfvNV(GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1041 /* NFOSMESA_GLMAPPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean32 packed, void *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)type;
	(void)ustride;
	(void)vstride;
	(void)packed;
	(void)points;
	(*exec)(gl_slb, 1042 /* NFOSMESA_GLGETMAPCONTROLPOINTSNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapParameterivNV(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1043 /* NFOSMESA_GLGETMAPPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapParameterfvNV(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1044 /* NFOSMESA_GLGETMAPPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapAttribParameterivNV(GLenum target, GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1045 /* NFOSMESA_GLGETMAPATTRIBPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMapAttribParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1046 /* NFOSMESA_GLGETMAPATTRIBPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEvalMapsNV(GLenum target, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1047 /* NFOSMESA_GLEVALMAPSNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCombinerStageParameterfvNV(GLenum stage, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1048 /* NFOSMESA_GLCOMBINERSTAGEPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &stage);
}

static void APIENTRY exec_glGetCombinerStageParameterfvNV(GLenum stage, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1049 /* NFOSMESA_GLGETCOMBINERSTAGEPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &stage);
}

static GLboolean APIENTRY exec_glAreProgramsResidentNV(GLsizei n, const GLuint *programs, GLboolean *residences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programs;
	(void)residences;
	return (GLboolean)(*exec)(gl_slb, 1050 /* NFOSMESA_GLAREPROGRAMSRESIDENTNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glBindProgramNV(GLenum target, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 1051 /* NFOSMESA_GLBINDPROGRAMNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDeleteProgramsNV(GLsizei n, const GLuint *programs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programs;
	(*exec)(gl_slb, 1052 /* NFOSMESA_GLDELETEPROGRAMSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glExecuteProgramNV(GLenum target, GLuint id, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)params;
	(*exec)(gl_slb, 1053 /* NFOSMESA_GLEXECUTEPROGRAMNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGenProgramsNV(GLsizei n, GLuint *programs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programs;
	(*exec)(gl_slb, 1054 /* NFOSMESA_GLGENPROGRAMSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGetProgramParameterdvNV(GLenum target, GLuint index, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1055 /* NFOSMESA_GLGETPROGRAMPARAMETERDVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1056 /* NFOSMESA_GLGETPROGRAMPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramivNV(GLuint id, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1057 /* NFOSMESA_GLGETPROGRAMIVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetProgramStringNV(GLuint id, GLenum pname, GLubyte *program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)program;
	(*exec)(gl_slb, 1058 /* NFOSMESA_GLGETPROGRAMSTRINGNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetTrackMatrixivNV(GLenum target, GLuint address, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)address;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1059 /* NFOSMESA_GLGETTRACKMATRIXIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetVertexAttribdvNV(GLuint index, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1060 /* NFOSMESA_GLGETVERTEXATTRIBDVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribfvNV(GLuint index, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1061 /* NFOSMESA_GLGETVERTEXATTRIBFVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribivNV(GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1062 /* NFOSMESA_GLGETVERTEXATTRIBIVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribPointervNV(GLuint index, GLenum pname, void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)pointer;
	(*exec)(gl_slb, 1063 /* NFOSMESA_GLGETVERTEXATTRIBPOINTERVNV */, SLB_NARGS(2), gl_pub, &index);
}

static GLboolean APIENTRY exec_glIsProgramNV(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1064 /* NFOSMESA_GLISPROGRAMNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glLoadProgramNV(GLenum target, GLuint id, GLsizei len, const GLubyte *program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)len;
	(void)program;
	(*exec)(gl_slb, 1065 /* NFOSMESA_GLLOADPROGRAMNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameter4dNV(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1066 /* NFOSMESA_GLPROGRAMPARAMETER4DNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameter4dvNV(GLenum target, GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)v;
	(*exec)(gl_slb, 1067 /* NFOSMESA_GLPROGRAMPARAMETER4DVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameter4fNV(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1068 /* NFOSMESA_GLPROGRAMPARAMETER4FNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameter4fvNV(GLenum target, GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)v;
	(*exec)(gl_slb, 1069 /* NFOSMESA_GLPROGRAMPARAMETER4FVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameters4dvNV(GLenum target, GLuint index, GLsizei count, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1070 /* NFOSMESA_GLPROGRAMPARAMETERS4DVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameters4fvNV(GLenum target, GLuint index, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1071 /* NFOSMESA_GLPROGRAMPARAMETERS4FVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glRequestResidentProgramsNV(GLsizei n, const GLuint *programs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programs;
	(*exec)(gl_slb, 1072 /* NFOSMESA_GLREQUESTRESIDENTPROGRAMSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glTrackMatrixNV(GLenum target, GLuint address, GLenum matrix, GLenum transform)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)address;
	(void)matrix;
	(void)transform;
	(*exec)(gl_slb, 1073 /* NFOSMESA_GLTRACKMATRIXNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glVertexAttribPointerNV(GLuint index, GLint fsize, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fsize;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 1074 /* NFOSMESA_GLVERTEXATTRIBPOINTERNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1dNV(GLuint index, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1075 /* NFOSMESA_GLVERTEXATTRIB1DNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1dvNV(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1076 /* NFOSMESA_GLVERTEXATTRIB1DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1fNV(GLuint index, GLfloat x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1077 /* NFOSMESA_GLVERTEXATTRIB1FNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1fvNV(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1078 /* NFOSMESA_GLVERTEXATTRIB1FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1sNV(GLuint index, GLshort32 x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1079 /* NFOSMESA_GLVERTEXATTRIB1SNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1svNV(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1080 /* NFOSMESA_GLVERTEXATTRIB1SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1081 /* NFOSMESA_GLVERTEXATTRIB2DNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2dvNV(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1082 /* NFOSMESA_GLVERTEXATTRIB2DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1083 /* NFOSMESA_GLVERTEXATTRIB2FNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2fvNV(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1084 /* NFOSMESA_GLVERTEXATTRIB2FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2sNV(GLuint index, GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1085 /* NFOSMESA_GLVERTEXATTRIB2SNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2svNV(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1086 /* NFOSMESA_GLVERTEXATTRIB2SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1087 /* NFOSMESA_GLVERTEXATTRIB3DNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3dvNV(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1088 /* NFOSMESA_GLVERTEXATTRIB3DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1089 /* NFOSMESA_GLVERTEXATTRIB3FNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3fvNV(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1090 /* NFOSMESA_GLVERTEXATTRIB3FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3sNV(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1091 /* NFOSMESA_GLVERTEXATTRIB3SNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3svNV(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1092 /* NFOSMESA_GLVERTEXATTRIB3SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1093 /* NFOSMESA_GLVERTEXATTRIB4DNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4dvNV(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1094 /* NFOSMESA_GLVERTEXATTRIB4DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1095 /* NFOSMESA_GLVERTEXATTRIB4FNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4fvNV(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1096 /* NFOSMESA_GLVERTEXATTRIB4FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4sNV(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1097 /* NFOSMESA_GLVERTEXATTRIB4SNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4svNV(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1098 /* NFOSMESA_GLVERTEXATTRIB4SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4ubNV(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1099 /* NFOSMESA_GLVERTEXATTRIB4UBNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4ubvNV(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1100 /* NFOSMESA_GLVERTEXATTRIB4UBVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs1dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1101 /* NFOSMESA_GLVERTEXATTRIBS1DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs1fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1102 /* NFOSMESA_GLVERTEXATTRIBS1FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs1svNV(GLuint index, GLsizei count, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1103 /* NFOSMESA_GLVERTEXATTRIBS1SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs2dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1104 /* NFOSMESA_GLVERTEXATTRIBS2DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs2fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1105 /* NFOSMESA_GLVERTEXATTRIBS2FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs2svNV(GLuint index, GLsizei count, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1106 /* NFOSMESA_GLVERTEXATTRIBS2SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs3dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1107 /* NFOSMESA_GLVERTEXATTRIBS3DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs3fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1108 /* NFOSMESA_GLVERTEXATTRIBS3FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs3svNV(GLuint index, GLsizei count, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1109 /* NFOSMESA_GLVERTEXATTRIBS3SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs4dvNV(GLuint index, GLsizei count, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1110 /* NFOSMESA_GLVERTEXATTRIBS4DVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs4fvNV(GLuint index, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1111 /* NFOSMESA_GLVERTEXATTRIBS4FVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs4svNV(GLuint index, GLsizei count, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1112 /* NFOSMESA_GLVERTEXATTRIBS4SVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs4ubvNV(GLuint index, GLsizei count, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1113 /* NFOSMESA_GLVERTEXATTRIBS4UBVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glTexBumpParameterivATI(GLenum pname, const GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1114 /* NFOSMESA_GLTEXBUMPPARAMETERIVATI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glTexBumpParameterfvATI(GLenum pname, const GLfloat *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1115 /* NFOSMESA_GLTEXBUMPPARAMETERFVATI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetTexBumpParameterivATI(GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1116 /* NFOSMESA_GLGETTEXBUMPPARAMETERIVATI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetTexBumpParameterfvATI(GLenum pname, GLfloat *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1117 /* NFOSMESA_GLGETTEXBUMPPARAMETERFVATI */, SLB_NARGS(2), gl_pub, &pname);
}

static GLuint APIENTRY exec_glGenFragmentShadersATI(GLuint range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 1118 /* NFOSMESA_GLGENFRAGMENTSHADERSATI */, SLB_NARGS(2), gl_pub, &range);
}

static void APIENTRY exec_glBindFragmentShaderATI(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1119 /* NFOSMESA_GLBINDFRAGMENTSHADERATI */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glDeleteFragmentShaderATI(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1120 /* NFOSMESA_GLDELETEFRAGMENTSHADERATI */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginFragmentShaderATI(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1121 /* NFOSMESA_GLBEGINFRAGMENTSHADERATI */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndFragmentShaderATI(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1122 /* NFOSMESA_GLENDFRAGMENTSHADERATI */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPassTexCoordATI(GLuint dst, GLuint coord, GLenum swizzle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)swizzle;
	(*exec)(gl_slb, 1123 /* NFOSMESA_GLPASSTEXCOORDATI */, SLB_NARGS(2), gl_pub, &dst);
}

static void APIENTRY exec_glSampleMapATI(GLuint dst, GLuint interp, GLenum swizzle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)interp;
	(void)swizzle;
	(*exec)(gl_slb, 1124 /* NFOSMESA_GLSAMPLEMAPATI */, SLB_NARGS(2), gl_pub, &dst);
}

static void APIENTRY exec_glColorFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dst;
	(void)dstMask;
	(void)dstMod;
	(void)arg1;
	(void)arg1Rep;
	(void)arg1Mod;
	(*exec)(gl_slb, 1125 /* NFOSMESA_GLCOLORFRAGMENTOP1ATI */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glColorFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dst;
	(void)dstMask;
	(void)dstMod;
	(void)arg1;
	(void)arg1Rep;
	(void)arg1Mod;
	(void)arg2;
	(void)arg2Rep;
	(void)arg2Mod;
	(*exec)(gl_slb, 1126 /* NFOSMESA_GLCOLORFRAGMENTOP2ATI */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glColorFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dst;
	(void)dstMask;
	(void)dstMod;
	(void)arg1;
	(void)arg1Rep;
	(void)arg1Mod;
	(void)arg2;
	(void)arg2Rep;
	(void)arg2Mod;
	(void)arg3;
	(void)arg3Rep;
	(void)arg3Mod;
	(*exec)(gl_slb, 1127 /* NFOSMESA_GLCOLORFRAGMENTOP3ATI */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glAlphaFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dst;
	(void)dstMod;
	(void)arg1;
	(void)arg1Rep;
	(void)arg1Mod;
	(*exec)(gl_slb, 1128 /* NFOSMESA_GLALPHAFRAGMENTOP1ATI */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glAlphaFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dst;
	(void)dstMod;
	(void)arg1;
	(void)arg1Rep;
	(void)arg1Mod;
	(void)arg2;
	(void)arg2Rep;
	(void)arg2Mod;
	(*exec)(gl_slb, 1129 /* NFOSMESA_GLALPHAFRAGMENTOP2ATI */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glAlphaFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dst;
	(void)dstMod;
	(void)arg1;
	(void)arg1Rep;
	(void)arg1Mod;
	(void)arg2;
	(void)arg2Rep;
	(void)arg2Mod;
	(void)arg3;
	(void)arg3Rep;
	(void)arg3Mod;
	(*exec)(gl_slb, 1130 /* NFOSMESA_GLALPHAFRAGMENTOP3ATI */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glSetFragmentShaderConstantATI(GLuint dst, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 1131 /* NFOSMESA_GLSETFRAGMENTSHADERCONSTANTATI */, SLB_NARGS(2), gl_pub, &dst);
}

static void APIENTRY exec_glPNTrianglesiATI(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1132 /* NFOSMESA_GLPNTRIANGLESIATI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPNTrianglesfATI(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1133 /* NFOSMESA_GLPNTRIANGLESFATI */, SLB_NARGS(2), gl_pub, &pname);
}

static GLuint APIENTRY exec_glNewObjectBufferATI(GLsizei size, const void *pointer, GLenum usage)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(void)usage;
	return (GLuint)(*exec)(gl_slb, 1134 /* NFOSMESA_GLNEWOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &size);
}

static GLboolean APIENTRY exec_glIsObjectBufferATI(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1135 /* NFOSMESA_GLISOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glUpdateObjectBufferATI(GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)pointer;
	(void)preserve;
	(*exec)(gl_slb, 1136 /* NFOSMESA_GLUPDATEOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetObjectBufferfvATI(GLuint buffer, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1137 /* NFOSMESA_GLGETOBJECTBUFFERFVATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetObjectBufferivATI(GLuint buffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1138 /* NFOSMESA_GLGETOBJECTBUFFERIVATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glFreeObjectBufferATI(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1139 /* NFOSMESA_GLFREEOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glArrayObjectATI(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(void)buffer;
	(void)offset;
	(*exec)(gl_slb, 1140 /* NFOSMESA_GLARRAYOBJECTATI */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glGetArrayObjectfvATI(GLenum array, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1141 /* NFOSMESA_GLGETARRAYOBJECTFVATI */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glGetArrayObjectivATI(GLenum array, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1142 /* NFOSMESA_GLGETARRAYOBJECTIVATI */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glVariantArrayObjectATI(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)buffer;
	(void)offset;
	(*exec)(gl_slb, 1143 /* NFOSMESA_GLVARIANTARRAYOBJECTATI */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetVariantArrayObjectfvATI(GLuint id, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1144 /* NFOSMESA_GLGETVARIANTARRAYOBJECTFVATI */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetVariantArrayObjectivATI(GLuint id, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1145 /* NFOSMESA_GLGETVARIANTARRAYOBJECTIVATI */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginVertexShaderEXT(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1146 /* NFOSMESA_GLBEGINVERTEXSHADEREXT */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndVertexShaderEXT(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1147 /* NFOSMESA_GLENDVERTEXSHADEREXT */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glBindVertexShaderEXT(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1148 /* NFOSMESA_GLBINDVERTEXSHADEREXT */, SLB_NARGS(2), gl_pub, &id);
}

static GLuint APIENTRY exec_glGenVertexShadersEXT(GLuint range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 1149 /* NFOSMESA_GLGENVERTEXSHADERSEXT */, SLB_NARGS(2), gl_pub, &range);
}

static void APIENTRY exec_glDeleteVertexShaderEXT(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1150 /* NFOSMESA_GLDELETEVERTEXSHADEREXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glShaderOp1EXT(GLenum op, GLuint res, GLuint arg1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)res;
	(void)arg1;
	(*exec)(gl_slb, 1151 /* NFOSMESA_GLSHADEROP1EXT */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glShaderOp2EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)res;
	(void)arg1;
	(void)arg2;
	(*exec)(gl_slb, 1152 /* NFOSMESA_GLSHADEROP2EXT */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glShaderOp3EXT(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)res;
	(void)arg1;
	(void)arg2;
	(void)arg3;
	(*exec)(gl_slb, 1153 /* NFOSMESA_GLSHADEROP3EXT */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glSwizzleEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)in;
	(void)outX;
	(void)outY;
	(void)outZ;
	(void)outW;
	(*exec)(gl_slb, 1154 /* NFOSMESA_GLSWIZZLEEXT */, SLB_NARGS(2), gl_pub, &res);
}

static void APIENTRY exec_glWriteMaskEXT(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)in;
	(void)outX;
	(void)outY;
	(void)outZ;
	(void)outW;
	(*exec)(gl_slb, 1155 /* NFOSMESA_GLWRITEMASKEXT */, SLB_NARGS(2), gl_pub, &res);
}

static void APIENTRY exec_glInsertComponentEXT(GLuint res, GLuint src, GLuint num)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)src;
	(void)num;
	(*exec)(gl_slb, 1156 /* NFOSMESA_GLINSERTCOMPONENTEXT */, SLB_NARGS(2), gl_pub, &res);
}

static void APIENTRY exec_glExtractComponentEXT(GLuint res, GLuint src, GLuint num)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)src;
	(void)num;
	(*exec)(gl_slb, 1157 /* NFOSMESA_GLEXTRACTCOMPONENTEXT */, SLB_NARGS(2), gl_pub, &res);
}

static GLuint APIENTRY exec_glGenSymbolsEXT(GLenum datatype, GLenum storagetype, GLenum range, GLuint components)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)storagetype;
	(void)range;
	(void)components;
	return (GLuint)(*exec)(gl_slb, 1158 /* NFOSMESA_GLGENSYMBOLSEXT */, SLB_NARGS(2), gl_pub, &datatype);
}

static void APIENTRY exec_glSetInvariantEXT(GLuint id, GLenum type, const void *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)addr;
	(*exec)(gl_slb, 1159 /* NFOSMESA_GLSETINVARIANTEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glSetLocalConstantEXT(GLuint id, GLenum type, const void *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)addr;
	(*exec)(gl_slb, 1160 /* NFOSMESA_GLSETLOCALCONSTANTEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantbvEXT(GLuint id, const GLbyte *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1161 /* NFOSMESA_GLVARIANTBVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantsvEXT(GLuint id, const GLshort *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1162 /* NFOSMESA_GLVARIANTSVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantivEXT(GLuint id, const GLint *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1163 /* NFOSMESA_GLVARIANTIVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantfvEXT(GLuint id, const GLfloat *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1164 /* NFOSMESA_GLVARIANTFVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantdvEXT(GLuint id, const GLdouble *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1165 /* NFOSMESA_GLVARIANTDVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantubvEXT(GLuint id, const GLubyte *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1166 /* NFOSMESA_GLVARIANTUBVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantusvEXT(GLuint id, const GLushort *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1167 /* NFOSMESA_GLVARIANTUSVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantuivEXT(GLuint id, const GLuint *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)addr;
	(*exec)(gl_slb, 1168 /* NFOSMESA_GLVARIANTUIVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVariantPointerEXT(GLuint id, GLenum type, GLuint stride, const void *addr)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(void)addr;
	(*exec)(gl_slb, 1169 /* NFOSMESA_GLVARIANTPOINTEREXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glEnableVariantClientStateEXT(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1170 /* NFOSMESA_GLENABLEVARIANTCLIENTSTATEEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glDisableVariantClientStateEXT(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1171 /* NFOSMESA_GLDISABLEVARIANTCLIENTSTATEEXT */, SLB_NARGS(2), gl_pub, &id);
}

static GLuint APIENTRY exec_glBindLightParameterEXT(GLenum light, GLenum value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	return (GLuint)(*exec)(gl_slb, 1172 /* NFOSMESA_GLBINDLIGHTPARAMETEREXT */, SLB_NARGS(2), gl_pub, &light);
}

static GLuint APIENTRY exec_glBindMaterialParameterEXT(GLenum face, GLenum value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	return (GLuint)(*exec)(gl_slb, 1173 /* NFOSMESA_GLBINDMATERIALPARAMETEREXT */, SLB_NARGS(2), gl_pub, &face);
}

static GLuint APIENTRY exec_glBindTexGenParameterEXT(GLenum unit, GLenum coord, GLenum value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)value;
	return (GLuint)(*exec)(gl_slb, 1174 /* NFOSMESA_GLBINDTEXGENPARAMETEREXT */, SLB_NARGS(2), gl_pub, &unit);
}

static GLuint APIENTRY exec_glBindTextureUnitParameterEXT(GLenum unit, GLenum value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	return (GLuint)(*exec)(gl_slb, 1175 /* NFOSMESA_GLBINDTEXTUREUNITPARAMETEREXT */, SLB_NARGS(2), gl_pub, &unit);
}

static GLuint APIENTRY exec_glBindParameterEXT(GLenum value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 1176 /* NFOSMESA_GLBINDPARAMETEREXT */, SLB_NARGS(2), gl_pub, &value);
}

static GLboolean APIENTRY exec_glIsVariantEnabledEXT(GLuint id, GLenum cap)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)cap;
	return (GLboolean)(*exec)(gl_slb, 1177 /* NFOSMESA_GLISVARIANTENABLEDEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetVariantBooleanvEXT(GLuint id, GLenum value, GLboolean *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1178 /* NFOSMESA_GLGETVARIANTBOOLEANVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetVariantIntegervEXT(GLuint id, GLenum value, GLint *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1179 /* NFOSMESA_GLGETVARIANTINTEGERVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetVariantFloatvEXT(GLuint id, GLenum value, GLfloat *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1180 /* NFOSMESA_GLGETVARIANTFLOATVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetVariantPointervEXT(GLuint id, GLenum value, void * *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1181 /* NFOSMESA_GLGETVARIANTPOINTERVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetInvariantBooleanvEXT(GLuint id, GLenum value, GLboolean *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1182 /* NFOSMESA_GLGETINVARIANTBOOLEANVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetInvariantIntegervEXT(GLuint id, GLenum value, GLint *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1183 /* NFOSMESA_GLGETINVARIANTINTEGERVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetInvariantFloatvEXT(GLuint id, GLenum value, GLfloat *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1184 /* NFOSMESA_GLGETINVARIANTFLOATVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetLocalConstantBooleanvEXT(GLuint id, GLenum value, GLboolean *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1185 /* NFOSMESA_GLGETLOCALCONSTANTBOOLEANVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetLocalConstantIntegervEXT(GLuint id, GLenum value, GLint *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1186 /* NFOSMESA_GLGETLOCALCONSTANTINTEGERVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetLocalConstantFloatvEXT(GLuint id, GLenum value, GLfloat *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(void)data;
	(*exec)(gl_slb, 1187 /* NFOSMESA_GLGETLOCALCONSTANTFLOATVEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVertexStream1sATI(GLenum stream, GLshort32 x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1188 /* NFOSMESA_GLVERTEXSTREAM1SATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1svATI(GLenum stream, const GLshort *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1189 /* NFOSMESA_GLVERTEXSTREAM1SVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1iATI(GLenum stream, GLint x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1190 /* NFOSMESA_GLVERTEXSTREAM1IATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1ivATI(GLenum stream, const GLint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1191 /* NFOSMESA_GLVERTEXSTREAM1IVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1fATI(GLenum stream, GLfloat x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1192 /* NFOSMESA_GLVERTEXSTREAM1FATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1fvATI(GLenum stream, const GLfloat *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1193 /* NFOSMESA_GLVERTEXSTREAM1FVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1dATI(GLenum stream, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1194 /* NFOSMESA_GLVERTEXSTREAM1DATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream1dvATI(GLenum stream, const GLdouble *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1195 /* NFOSMESA_GLVERTEXSTREAM1DVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2sATI(GLenum stream, GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1196 /* NFOSMESA_GLVERTEXSTREAM2SATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2svATI(GLenum stream, const GLshort *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1197 /* NFOSMESA_GLVERTEXSTREAM2SVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2iATI(GLenum stream, GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1198 /* NFOSMESA_GLVERTEXSTREAM2IATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2ivATI(GLenum stream, const GLint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1199 /* NFOSMESA_GLVERTEXSTREAM2IVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2fATI(GLenum stream, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1200 /* NFOSMESA_GLVERTEXSTREAM2FATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2fvATI(GLenum stream, const GLfloat *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1201 /* NFOSMESA_GLVERTEXSTREAM2FVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2dATI(GLenum stream, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1202 /* NFOSMESA_GLVERTEXSTREAM2DATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream2dvATI(GLenum stream, const GLdouble *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1203 /* NFOSMESA_GLVERTEXSTREAM2DVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3sATI(GLenum stream, GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1204 /* NFOSMESA_GLVERTEXSTREAM3SATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3svATI(GLenum stream, const GLshort *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1205 /* NFOSMESA_GLVERTEXSTREAM3SVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3iATI(GLenum stream, GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1206 /* NFOSMESA_GLVERTEXSTREAM3IATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3ivATI(GLenum stream, const GLint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1207 /* NFOSMESA_GLVERTEXSTREAM3IVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1208 /* NFOSMESA_GLVERTEXSTREAM3FATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3fvATI(GLenum stream, const GLfloat *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1209 /* NFOSMESA_GLVERTEXSTREAM3FVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1210 /* NFOSMESA_GLVERTEXSTREAM3DATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream3dvATI(GLenum stream, const GLdouble *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1211 /* NFOSMESA_GLVERTEXSTREAM3DVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4sATI(GLenum stream, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1212 /* NFOSMESA_GLVERTEXSTREAM4SATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4svATI(GLenum stream, const GLshort *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1213 /* NFOSMESA_GLVERTEXSTREAM4SVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4iATI(GLenum stream, GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1214 /* NFOSMESA_GLVERTEXSTREAM4IATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4ivATI(GLenum stream, const GLint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1215 /* NFOSMESA_GLVERTEXSTREAM4IVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4fATI(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1216 /* NFOSMESA_GLVERTEXSTREAM4FATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4fvATI(GLenum stream, const GLfloat *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1217 /* NFOSMESA_GLVERTEXSTREAM4FVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4dATI(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1218 /* NFOSMESA_GLVERTEXSTREAM4DATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexStream4dvATI(GLenum stream, const GLdouble *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1219 /* NFOSMESA_GLVERTEXSTREAM4DVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3bATI(GLenum stream, GLbyte32 nx, GLbyte32 ny, GLbyte32 nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nx;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 1220 /* NFOSMESA_GLNORMALSTREAM3BATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3bvATI(GLenum stream, const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1221 /* NFOSMESA_GLNORMALSTREAM3BVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3sATI(GLenum stream, GLshort32 nx, GLshort32 ny, GLshort32 nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nx;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 1222 /* NFOSMESA_GLNORMALSTREAM3SATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3svATI(GLenum stream, const GLshort *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1223 /* NFOSMESA_GLNORMALSTREAM3SVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3iATI(GLenum stream, GLint nx, GLint ny, GLint nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nx;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 1224 /* NFOSMESA_GLNORMALSTREAM3IATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3ivATI(GLenum stream, const GLint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1225 /* NFOSMESA_GLNORMALSTREAM3IVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3fATI(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nx;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 1226 /* NFOSMESA_GLNORMALSTREAM3FATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3fvATI(GLenum stream, const GLfloat *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1227 /* NFOSMESA_GLNORMALSTREAM3FVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3dATI(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nx;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 1228 /* NFOSMESA_GLNORMALSTREAM3DATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glNormalStream3dvATI(GLenum stream, const GLdouble *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1229 /* NFOSMESA_GLNORMALSTREAM3DVATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glClientActiveVertexStreamATI(GLenum stream)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1230 /* NFOSMESA_GLCLIENTACTIVEVERTEXSTREAMATI */, SLB_NARGS(2), gl_pub, &stream);
}

static void APIENTRY exec_glVertexBlendEnviATI(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1231 /* NFOSMESA_GLVERTEXBLENDENVIATI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glVertexBlendEnvfATI(GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1232 /* NFOSMESA_GLVERTEXBLENDENVFATI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glElementPointerATI(GLenum type, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 1233 /* NFOSMESA_GLELEMENTPOINTERATI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glDrawElementArrayATI(GLenum mode, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(*exec)(gl_slb, 1234 /* NFOSMESA_GLDRAWELEMENTARRAYATI */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawRangeElementArrayATI(GLenum mode, GLuint start, GLuint end, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)end;
	(void)count;
	(*exec)(gl_slb, 1235 /* NFOSMESA_GLDRAWRANGEELEMENTARRAYATI */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawMeshArraysSUN(GLenum mode, GLint first, GLsizei count, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)width;
	(*exec)(gl_slb, 1236 /* NFOSMESA_GLDRAWMESHARRAYSSUN */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glGenOcclusionQueriesNV(GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 1237 /* NFOSMESA_GLGENOCCLUSIONQUERIESNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteOcclusionQueriesNV(GLsizei n, const GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 1238 /* NFOSMESA_GLDELETEOCCLUSIONQUERIESNV */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsOcclusionQueryNV(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1239 /* NFOSMESA_GLISOCCLUSIONQUERYNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginOcclusionQueryNV(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1240 /* NFOSMESA_GLBEGINOCCLUSIONQUERYNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glEndOcclusionQueryNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1241 /* NFOSMESA_GLENDOCCLUSIONQUERYNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glGetOcclusionQueryivNV(GLuint id, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1242 /* NFOSMESA_GLGETOCCLUSIONQUERYIVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetOcclusionQueryuivNV(GLuint id, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1243 /* NFOSMESA_GLGETOCCLUSIONQUERYUIVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glPointParameteriNV(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1244 /* NFOSMESA_GLPOINTPARAMETERINV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointParameterivNV(GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 1245 /* NFOSMESA_GLPOINTPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glActiveStencilFaceEXT(GLenum face)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1246 /* NFOSMESA_GLACTIVESTENCILFACEEXT */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glElementPointerAPPLE(GLenum type, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 1247 /* NFOSMESA_GLELEMENTPOINTERAPPLE */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glDrawElementArrayAPPLE(GLenum mode, GLint first, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(*exec)(gl_slb, 1248 /* NFOSMESA_GLDRAWELEMENTARRAYAPPLE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)end;
	(void)first;
	(void)count;
	(*exec)(gl_slb, 1249 /* NFOSMESA_GLDRAWRANGEELEMENTARRAYAPPLE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementArrayAPPLE(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)primcount;
	(*exec)(gl_slb, 1250 /* NFOSMESA_GLMULTIDRAWELEMENTARRAYAPPLE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawRangeElementArrayAPPLE(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)end;
	(void)first;
	(void)count;
	(void)primcount;
	(*exec)(gl_slb, 1251 /* NFOSMESA_GLMULTIDRAWRANGEELEMENTARRAYAPPLE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glGenFencesAPPLE(GLsizei n, GLuint *fences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fences;
	(*exec)(gl_slb, 1252 /* NFOSMESA_GLGENFENCESAPPLE */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteFencesAPPLE(GLsizei n, const GLuint *fences)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fences;
	(*exec)(gl_slb, 1253 /* NFOSMESA_GLDELETEFENCESAPPLE */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glSetFenceAPPLE(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1254 /* NFOSMESA_GLSETFENCEAPPLE */, SLB_NARGS(2), gl_pub, &fence);
}

static GLboolean APIENTRY exec_glIsFenceAPPLE(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1255 /* NFOSMESA_GLISFENCEAPPLE */, SLB_NARGS(2), gl_pub, &fence);
}

static GLboolean APIENTRY exec_glTestFenceAPPLE(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1256 /* NFOSMESA_GLTESTFENCEAPPLE */, SLB_NARGS(2), gl_pub, &fence);
}

static void APIENTRY exec_glFinishFenceAPPLE(GLuint fence)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1257 /* NFOSMESA_GLFINISHFENCEAPPLE */, SLB_NARGS(2), gl_pub, &fence);
}

static GLboolean APIENTRY exec_glTestObjectAPPLE(GLenum object, GLuint name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLboolean)(*exec)(gl_slb, 1258 /* NFOSMESA_GLTESTOBJECTAPPLE */, SLB_NARGS(2), gl_pub, &object);
}

static void APIENTRY exec_glFinishObjectAPPLE(GLenum object, GLuint name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(*exec)(gl_slb, 1259 /* NFOSMESA_GLFINISHOBJECTAPPLE */, SLB_NARGS(2), gl_pub, &object);
}

static void APIENTRY exec_glBindVertexArrayAPPLE(GLuint array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1260 /* NFOSMESA_GLBINDVERTEXARRAYAPPLE */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glDeleteVertexArraysAPPLE(GLsizei n, const GLuint *arrays)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)arrays;
	(*exec)(gl_slb, 1261 /* NFOSMESA_GLDELETEVERTEXARRAYSAPPLE */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenVertexArraysAPPLE(GLsizei n, GLuint *arrays)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)arrays;
	(*exec)(gl_slb, 1262 /* NFOSMESA_GLGENVERTEXARRAYSAPPLE */, SLB_NARGS(2), gl_pub, &n);
}

static GLboolean APIENTRY exec_glIsVertexArrayAPPLE(GLuint array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1263 /* NFOSMESA_GLISVERTEXARRAYAPPLE */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glVertexArrayRangeAPPLE(GLsizei length, void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 1264 /* NFOSMESA_GLVERTEXARRAYRANGEAPPLE */, SLB_NARGS(2), gl_pub, &length);
}

static void APIENTRY exec_glFlushVertexArrayRangeAPPLE(GLsizei length, void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pointer;
	(*exec)(gl_slb, 1265 /* NFOSMESA_GLFLUSHVERTEXARRAYRANGEAPPLE */, SLB_NARGS(2), gl_pub, &length);
}

static void APIENTRY exec_glVertexArrayParameteriAPPLE(GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1266 /* NFOSMESA_GLVERTEXARRAYPARAMETERIAPPLE */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glDrawBuffersATI(GLsizei n, const GLenum *bufs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufs;
	(*exec)(gl_slb, 1267 /* NFOSMESA_GLDRAWBUFFERSATI */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glProgramNamedParameter4fNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1268 /* NFOSMESA_GLPROGRAMNAMEDPARAMETER4FNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glProgramNamedParameter4dNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1269 /* NFOSMESA_GLPROGRAMNAMEDPARAMETER4DNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glProgramNamedParameter4fvNV(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)v;
	(*exec)(gl_slb, 1270 /* NFOSMESA_GLPROGRAMNAMEDPARAMETER4FVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glProgramNamedParameter4dvNV(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)v;
	(*exec)(gl_slb, 1271 /* NFOSMESA_GLPROGRAMNAMEDPARAMETER4DVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetProgramNamedParameterfvNV(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)params;
	(*exec)(gl_slb, 1272 /* NFOSMESA_GLGETPROGRAMNAMEDPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetProgramNamedParameterdvNV(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)params;
	(*exec)(gl_slb, 1273 /* NFOSMESA_GLGETPROGRAMNAMEDPARAMETERDVNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glVertex2hNV(GLhalfNV32 x, GLhalfNV32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 1274 /* NFOSMESA_GLVERTEX2HNV */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1275 /* NFOSMESA_GLVERTEX2HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex3hNV(GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1276 /* NFOSMESA_GLVERTEX3HNV */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1277 /* NFOSMESA_GLVERTEX3HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertex4hNV(GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z, GLhalfNV32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1278 /* NFOSMESA_GLVERTEX4HNV */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1279 /* NFOSMESA_GLVERTEX4HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glNormal3hNV(GLhalfNV32 nx, GLhalfNV32 ny, GLhalfNV32 nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 1280 /* NFOSMESA_GLNORMAL3HNV */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1281 /* NFOSMESA_GLNORMAL3HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor3hNV(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 1282 /* NFOSMESA_GLCOLOR3HNV */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1283 /* NFOSMESA_GLCOLOR3HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glColor4hNV(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue, GLhalfNV32 alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1284 /* NFOSMESA_GLCOLOR4HNV */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1285 /* NFOSMESA_GLCOLOR4HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord1hNV(GLhalfNV32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1286 /* NFOSMESA_GLTEXCOORD1HNV */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1287 /* NFOSMESA_GLTEXCOORD1HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord2hNV(GLhalfNV32 s, GLhalfNV32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 1288 /* NFOSMESA_GLTEXCOORD2HNV */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1289 /* NFOSMESA_GLTEXCOORD2HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord3hNV(GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 1290 /* NFOSMESA_GLTEXCOORD3HNV */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1291 /* NFOSMESA_GLTEXCOORD3HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glTexCoord4hNV(GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r, GLhalfNV32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 1292 /* NFOSMESA_GLTEXCOORD4HNV */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1293 /* NFOSMESA_GLTEXCOORD4HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glMultiTexCoord1hNV(GLenum target, GLhalfNV32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 1294 /* NFOSMESA_GLMULTITEXCOORD1HNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord1hvNV(GLenum target, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1295 /* NFOSMESA_GLMULTITEXCOORD1HVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2hNV(GLenum target, GLhalfNV32 s, GLhalfNV32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 1296 /* NFOSMESA_GLMULTITEXCOORD2HNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord2hvNV(GLenum target, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1297 /* NFOSMESA_GLMULTITEXCOORD2HVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3hNV(GLenum target, GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 1298 /* NFOSMESA_GLMULTITEXCOORD3HNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord3hvNV(GLenum target, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1299 /* NFOSMESA_GLMULTITEXCOORD3HVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4hNV(GLenum target, GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r, GLhalfNV32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 1300 /* NFOSMESA_GLMULTITEXCOORD4HNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMultiTexCoord4hvNV(GLenum target, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1301 /* NFOSMESA_GLMULTITEXCOORD4HVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFogCoordhNV(GLhalfNV32 fog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1302 /* NFOSMESA_GLFOGCOORDHNV */, SLB_NARGS(2), gl_pub, &fog);
}

static void APIENTRY exec_glFogCoordhvNV(const GLhalfNV *fog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1303 /* NFOSMESA_GLFOGCOORDHVNV */, SLB_NARGS(2), gl_pub, &fog);
}

static void APIENTRY exec_glSecondaryColor3hNV(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 1304 /* NFOSMESA_GLSECONDARYCOLOR3HNV */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glSecondaryColor3hvNV(const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1305 /* NFOSMESA_GLSECONDARYCOLOR3HVNV */, SLB_NARGS(2), gl_pub, &v);
}

static void APIENTRY exec_glVertexWeighthNV(GLhalfNV32 weight)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1306 /* NFOSMESA_GLVERTEXWEIGHTHNV */, SLB_NARGS(2), gl_pub, &weight);
}

static void APIENTRY exec_glVertexWeighthvNV(const GLhalfNV *weight)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1307 /* NFOSMESA_GLVERTEXWEIGHTHVNV */, SLB_NARGS(2), gl_pub, &weight);
}

static void APIENTRY exec_glVertexAttrib1hNV(GLuint index, GLhalfNV32 x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 1308 /* NFOSMESA_GLVERTEXATTRIB1HNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1hvNV(GLuint index, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1309 /* NFOSMESA_GLVERTEXATTRIB1HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2hNV(GLuint index, GLhalfNV32 x, GLhalfNV32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 1310 /* NFOSMESA_GLVERTEXATTRIB2HNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2hvNV(GLuint index, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1311 /* NFOSMESA_GLVERTEXATTRIB2HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3hNV(GLuint index, GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 1312 /* NFOSMESA_GLVERTEXATTRIB3HNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3hvNV(GLuint index, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1313 /* NFOSMESA_GLVERTEXATTRIB3HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4hNV(GLuint index, GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z, GLhalfNV32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 1314 /* NFOSMESA_GLVERTEXATTRIB4HNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4hvNV(GLuint index, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1315 /* NFOSMESA_GLVERTEXATTRIB4HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs1hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 1316 /* NFOSMESA_GLVERTEXATTRIBS1HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs2hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 1317 /* NFOSMESA_GLVERTEXATTRIBS2HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs3hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 1318 /* NFOSMESA_GLVERTEXATTRIBS3HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribs4hvNV(GLuint index, GLsizei n, const GLhalfNV *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)v;
	(*exec)(gl_slb, 1319 /* NFOSMESA_GLVERTEXATTRIBS4HVNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glPixelDataRangeNV(GLenum target, GLsizei length, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)length;
	(void)pointer;
	(*exec)(gl_slb, 1320 /* NFOSMESA_GLPIXELDATARANGENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFlushPixelDataRangeNV(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1321 /* NFOSMESA_GLFLUSHPIXELDATARANGENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glPrimitiveRestartNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1322 /* NFOSMESA_GLPRIMITIVERESTARTNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPrimitiveRestartIndexNV(GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1323 /* NFOSMESA_GLPRIMITIVERESTARTINDEXNV */, SLB_NARGS(2), gl_pub, &index);
}

static void * APIENTRY exec_glMapObjectBufferATI(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (void *)(*exec)(gl_slb, 1324 /* NFOSMESA_GLMAPOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glUnmapObjectBufferATI(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1325 /* NFOSMESA_GLUNMAPOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glStencilOpSeparateATI(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sfail;
	(void)dpfail;
	(void)dppass;
	(*exec)(gl_slb, 1326 /* NFOSMESA_GLSTENCILOPSEPARATEATI */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glStencilFuncSeparateATI(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)backfunc;
	(void)ref;
	(void)mask;
	(*exec)(gl_slb, 1327 /* NFOSMESA_GLSTENCILFUNCSEPARATEATI */, SLB_NARGS(2), gl_pub, &frontfunc);
}

static void APIENTRY exec_glVertexAttribArrayObjectATI(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, GLuint buffer, GLuint offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)normalized;
	(void)stride;
	(void)buffer;
	(void)offset;
	(*exec)(gl_slb, 1328 /* NFOSMESA_GLVERTEXATTRIBARRAYOBJECTATI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribArrayObjectfvATI(GLuint index, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1329 /* NFOSMESA_GLGETVERTEXATTRIBARRAYOBJECTFVATI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribArrayObjectivATI(GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1330 /* NFOSMESA_GLGETVERTEXATTRIBARRAYOBJECTIVATI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glDepthBoundsEXT(GLclampd zmin, GLclampd zmax)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)zmax;
	(*exec)(gl_slb, 1331 /* NFOSMESA_GLDEPTHBOUNDSEXT */, SLB_NARGS(2), gl_pub, &zmin);
}

static void APIENTRY exec_glBlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)modeAlpha;
	(*exec)(gl_slb, 1332 /* NFOSMESA_GLBLENDEQUATIONSEPARATEEXT */, SLB_NARGS(2), gl_pub, &modeRGB);
}

static void APIENTRY exec_OSMesaColorClamp(GLboolean32 enable)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1333 /* NFOSMESA_OSMESACOLORCLAMP */, SLB_NARGS(2), gl_pub, &enable);
}

static void APIENTRY exec_OSMesaPostprocess(OSMesaContext osmesa, const char *filter, GLuint enable_value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)filter;
	(void)enable_value;
	(*exec)(gl_slb, 1334 /* NFOSMESA_OSMESAPOSTPROCESS */, SLB_NARGS(2), gl_pub, &osmesa);
}

static void * APIENTRY exec_OSMesaCreateLDG(GLenum format, GLenum type, GLint width, GLint height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)width;
	(void)height;
	return (void *)(*exec)(gl_slb, 1384 /*  */, SLB_NARGS(2), gl_pub, &format);
}

static void APIENTRY exec_OSMesaDestroyLDG(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1385 /*  */, SLB_NARGS(2), gl_pub, NULL);
}

static GLsizei APIENTRY exec_max_width(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLsizei)(*exec)(gl_slb, 1386 /*  */, SLB_NARGS(2), gl_pub, NULL);
}

static GLsizei APIENTRY exec_max_height(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLsizei)(*exec)(gl_slb, 1387 /*  */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_information(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1388 /*  */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_exception_error(void (CALLBACK *exception)(GLenum param) )
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1389 /*  */, SLB_NARGS(2), gl_pub, &exception);
}

static void APIENTRY exec_gluLookAtf(GLfloat eyeX, GLfloat eyeY, GLfloat eyeZ, GLfloat centerX, GLfloat centerY, GLfloat centerZ, GLfloat upX, GLfloat upY, GLfloat upZ)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)eyeY;
	(void)eyeZ;
	(void)centerX;
	(void)centerY;
	(void)centerZ;
	(void)upX;
	(void)upY;
	(void)upZ;
	(*exec)(gl_slb, 1390 /* NFOSMESA_GLULOOKATF */, SLB_NARGS(2), gl_pub, &eyeX);
}

static void APIENTRY exec_glFrustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near_val, GLfloat far_val)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)right;
	(void)bottom;
	(void)top;
	(void)near_val;
	(void)far_val;
	(*exec)(gl_slb, 1391 /* NFOSMESA_GLFRUSTUMF */, SLB_NARGS(2), gl_pub, &left);
}

static void APIENTRY exec_glOrthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near_val, GLfloat far_val)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)right;
	(void)bottom;
	(void)top;
	(void)near_val;
	(void)far_val;
	(*exec)(gl_slb, 1392 /* NFOSMESA_GLORTHOF */, SLB_NARGS(2), gl_pub, &left);
}

static void APIENTRY exec_swapbuffer(void *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1393 /* NFOSMESA_TINYGLSWAPBUFFER */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_gluLookAt(GLdouble eyeX, GLdouble eyeY, GLdouble eyeZ, GLdouble centerX, GLdouble centerY, GLdouble centerZ, GLdouble upX, GLdouble upY, GLdouble upZ)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)eyeY;
	(void)eyeZ;
	(void)centerX;
	(void)centerY;
	(void)centerZ;
	(void)upX;
	(void)upY;
	(void)upZ;
	(*exec)(gl_slb, 1394 /* NFOSMESA_GLULOOKAT */, SLB_NARGS(2), gl_pub, &eyeX);
}

static void APIENTRY exec_glAccumxOES(GLenum op, GLfixed value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 1400 /* NFOSMESA_GLACCUMXOES */, SLB_NARGS(2), gl_pub, &op);
}

static void APIENTRY exec_glActiveProgramEXT(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1401 /* NFOSMESA_GLACTIVEPROGRAMEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glActiveShaderProgram(GLuint pipeline, GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)program;
	(*exec)(gl_slb, 1402 /* NFOSMESA_GLACTIVESHADERPROGRAM */, SLB_NARGS(2), gl_pub, &pipeline);
}

static void APIENTRY exec_glActiveVaryingNV(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(*exec)(gl_slb, 1403 /* NFOSMESA_GLACTIVEVARYINGNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glAddSwapHintRectWIN(GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 1404 /* NFOSMESA_GLADDSWAPHINTRECTWIN */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glAlphaFuncxOES(GLenum func, GLfixed ref)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ref;
	(*exec)(gl_slb, 1405 /* NFOSMESA_GLALPHAFUNCXOES */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glAttachShader(GLuint program, GLuint shader)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shader;
	(*exec)(gl_slb, 1406 /* NFOSMESA_GLATTACHSHADER */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glBeginConditionalRender(GLuint id, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1407 /* NFOSMESA_GLBEGINCONDITIONALRENDER */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginConditionalRenderNV(GLuint id, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1408 /* NFOSMESA_GLBEGINCONDITIONALRENDERNV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginConditionalRenderNVX(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1409 /* NFOSMESA_GLBEGINCONDITIONALRENDERNVX */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glBeginPerfMonitorAMD(GLuint monitor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1410 /* NFOSMESA_GLBEGINPERFMONITORAMD */, SLB_NARGS(2), gl_pub, &monitor);
}

static void APIENTRY exec_glBeginPerfQueryINTEL(GLuint queryHandle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1411 /* NFOSMESA_GLBEGINPERFQUERYINTEL */, SLB_NARGS(2), gl_pub, &queryHandle);
}

static void APIENTRY exec_glBeginQueryIndexed(GLenum target, GLuint index, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)id;
	(*exec)(gl_slb, 1412 /* NFOSMESA_GLBEGINQUERYINDEXED */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBeginTransformFeedback(GLenum primitiveMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1413 /* NFOSMESA_GLBEGINTRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, &primitiveMode);
}

static void APIENTRY exec_glBeginTransformFeedbackEXT(GLenum primitiveMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1414 /* NFOSMESA_GLBEGINTRANSFORMFEEDBACKEXT */, SLB_NARGS(2), gl_pub, &primitiveMode);
}

static void APIENTRY exec_glBeginTransformFeedbackNV(GLenum primitiveMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1415 /* NFOSMESA_GLBEGINTRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, &primitiveMode);
}

static void APIENTRY exec_glBeginVideoCaptureNV(GLuint video_capture_slot)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1416 /* NFOSMESA_GLBEGINVIDEOCAPTURENV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glBindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)name;
	(*exec)(gl_slb, 1417 /* NFOSMESA_GLBINDATTRIBLOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glBindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(*exec)(gl_slb, 1418 /* NFOSMESA_GLBINDBUFFERBASE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferBaseEXT(GLenum target, GLuint index, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(*exec)(gl_slb, 1419 /* NFOSMESA_GLBINDBUFFERBASEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferBaseNV(GLenum target, GLuint index, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(*exec)(gl_slb, 1420 /* NFOSMESA_GLBINDBUFFERBASENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferOffsetEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(void)offset;
	(*exec)(gl_slb, 1421 /* NFOSMESA_GLBINDBUFFEROFFSETEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferOffsetNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(void)offset;
	(*exec)(gl_slb, 1422 /* NFOSMESA_GLBINDBUFFEROFFSETNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(void)offset;
	(void)size;
	(*exec)(gl_slb, 1423 /* NFOSMESA_GLBINDBUFFERRANGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferRangeEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(void)offset;
	(void)size;
	(*exec)(gl_slb, 1424 /* NFOSMESA_GLBINDBUFFERRANGEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBufferRangeNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)buffer;
	(void)offset;
	(void)size;
	(*exec)(gl_slb, 1425 /* NFOSMESA_GLBINDBUFFERRANGENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint *buffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)buffers;
	(*exec)(gl_slb, 1426 /* NFOSMESA_GLBINDBUFFERSBASE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindBuffersRange(GLenum target, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizeiptr *sizes)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)buffers;
	(void)offsets;
	(void)sizes;
	(*exec)(gl_slb, 1427 /* NFOSMESA_GLBINDBUFFERSRANGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindFragDataLocation(GLuint program, GLuint color, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(void)name;
	(*exec)(gl_slb, 1428 /* NFOSMESA_GLBINDFRAGDATALOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glBindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(void)name;
	(*exec)(gl_slb, 1429 /* NFOSMESA_GLBINDFRAGDATALOCATIONEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)colorNumber;
	(void)index;
	(void)name;
	(*exec)(gl_slb, 1430 /* NFOSMESA_GLBINDFRAGDATALOCATIONINDEXED */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glBindFramebuffer(GLenum target, GLuint framebuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffer;
	(*exec)(gl_slb, 1431 /* NFOSMESA_GLBINDFRAMEBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindFramebufferEXT(GLenum target, GLuint framebuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffer;
	(*exec)(gl_slb, 1432 /* NFOSMESA_GLBINDFRAMEBUFFEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum access, GLenum format)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)texture;
	(void)level;
	(void)layered;
	(void)layer;
	(void)access;
	(void)format;
	(*exec)(gl_slb, 1433 /* NFOSMESA_GLBINDIMAGETEXTURE */, SLB_NARGS(2), gl_pub, &unit);
}

static void APIENTRY exec_glBindImageTextureEXT(GLuint index, GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum access, GLint format)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)texture;
	(void)level;
	(void)layered;
	(void)layer;
	(void)access;
	(void)format;
	(*exec)(gl_slb, 1434 /* NFOSMESA_GLBINDIMAGETEXTUREEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glBindImageTextures(GLuint first, GLsizei count, const GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)textures;
	(*exec)(gl_slb, 1435 /* NFOSMESA_GLBINDIMAGETEXTURES */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glBindMultiTextureEXT(GLenum texunit, GLenum target, GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)texture;
	(*exec)(gl_slb, 1436 /* NFOSMESA_GLBINDMULTITEXTUREEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glBindProgramPipeline(GLuint pipeline)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1437 /* NFOSMESA_GLBINDPROGRAMPIPELINE */, SLB_NARGS(2), gl_pub, &pipeline);
}

static void APIENTRY exec_glBindRenderbuffer(GLenum target, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffer;
	(*exec)(gl_slb, 1438 /* NFOSMESA_GLBINDRENDERBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindRenderbufferEXT(GLenum target, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffer;
	(*exec)(gl_slb, 1439 /* NFOSMESA_GLBINDRENDERBUFFEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindSampler(GLuint unit, GLuint sampler)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sampler;
	(*exec)(gl_slb, 1440 /* NFOSMESA_GLBINDSAMPLER */, SLB_NARGS(2), gl_pub, &unit);
}

static void APIENTRY exec_glBindSamplers(GLuint first, GLsizei count, const GLuint *samplers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)samplers;
	(*exec)(gl_slb, 1441 /* NFOSMESA_GLBINDSAMPLERS */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glBindTextures(GLuint first, GLsizei count, const GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)textures;
	(*exec)(gl_slb, 1442 /* NFOSMESA_GLBINDTEXTURES */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glBindTransformFeedback(GLenum target, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 1443 /* NFOSMESA_GLBINDTRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindTransformFeedbackNV(GLenum target, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 1444 /* NFOSMESA_GLBINDTRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBindVertexArray(GLuint array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1445 /* NFOSMESA_GLBINDVERTEXARRAY */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glBindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)offset;
	(void)stride;
	(*exec)(gl_slb, 1446 /* NFOSMESA_GLBINDVERTEXBUFFER */, SLB_NARGS(2), gl_pub, &bindingindex);
}

static void APIENTRY exec_glBindVertexBuffers(GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)buffers;
	(void)offsets;
	(void)strides;
	(*exec)(gl_slb, 1447 /* NFOSMESA_GLBINDVERTEXBUFFERS */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glBindVideoCaptureStreamBufferNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)frame_region;
	(void)offset;
	(*exec)(gl_slb, 1448 /* NFOSMESA_GLBINDVIDEOCAPTURESTREAMBUFFERNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glBindVideoCaptureStreamTextureNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)frame_region;
	(void)target;
	(void)texture;
	(*exec)(gl_slb, 1449 /* NFOSMESA_GLBINDVIDEOCAPTURESTREAMTEXTURENV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glBitmapxOES(GLsizei width, GLsizei height, GLfixed xorig, GLfixed yorig, GLfixed xmove, GLfixed ymove, const GLubyte *bitmap)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)height;
	(void)xorig;
	(void)yorig;
	(void)xmove;
	(void)ymove;
	(void)bitmap;
	(*exec)(gl_slb, 1450 /* NFOSMESA_GLBITMAPXOES */, SLB_NARGS(2), gl_pub, &width);
}

static void APIENTRY exec_glBlendBarrierNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1451 /* NFOSMESA_GLBLENDBARRIERNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glBlendColorxOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1452 /* NFOSMESA_GLBLENDCOLORXOES */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glBlendEquationIndexedAMD(GLuint buf, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1453 /* NFOSMESA_GLBLENDEQUATIONINDEXEDAMD */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)modeAlpha;
	(*exec)(gl_slb, 1454 /* NFOSMESA_GLBLENDEQUATIONSEPARATE */, SLB_NARGS(2), gl_pub, &modeRGB);
}

static void APIENTRY exec_glBlendEquationSeparateIndexedAMD(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)modeRGB;
	(void)modeAlpha;
	(*exec)(gl_slb, 1455 /* NFOSMESA_GLBLENDEQUATIONSEPARATEINDEXEDAMD */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)modeRGB;
	(void)modeAlpha;
	(*exec)(gl_slb, 1456 /* NFOSMESA_GLBLENDEQUATIONSEPARATEI */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)modeRGB;
	(void)modeAlpha;
	(*exec)(gl_slb, 1457 /* NFOSMESA_GLBLENDEQUATIONSEPARATEIARB */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendEquationi(GLuint buf, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1458 /* NFOSMESA_GLBLENDEQUATIONI */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendEquationiARB(GLuint buf, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1459 /* NFOSMESA_GLBLENDEQUATIONIARB */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendFuncIndexedAMD(GLuint buf, GLenum src, GLenum dst)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)src;
	(void)dst;
	(*exec)(gl_slb, 1460 /* NFOSMESA_GLBLENDFUNCINDEXEDAMD */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendFuncSeparateIndexedAMD(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcRGB;
	(void)dstRGB;
	(void)srcAlpha;
	(void)dstAlpha;
	(*exec)(gl_slb, 1461 /* NFOSMESA_GLBLENDFUNCSEPARATEINDEXEDAMD */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcRGB;
	(void)dstRGB;
	(void)srcAlpha;
	(void)dstAlpha;
	(*exec)(gl_slb, 1462 /* NFOSMESA_GLBLENDFUNCSEPARATEI */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcRGB;
	(void)dstRGB;
	(void)srcAlpha;
	(void)dstAlpha;
	(*exec)(gl_slb, 1463 /* NFOSMESA_GLBLENDFUNCSEPARATEIARB */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendFunci(GLuint buf, GLenum src, GLenum dst)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)src;
	(void)dst;
	(*exec)(gl_slb, 1464 /* NFOSMESA_GLBLENDFUNCI */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendFunciARB(GLuint buf, GLenum src, GLenum dst)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)src;
	(void)dst;
	(*exec)(gl_slb, 1465 /* NFOSMESA_GLBLENDFUNCIARB */, SLB_NARGS(2), gl_pub, &buf);
}

static void APIENTRY exec_glBlendParameteriNV(GLenum pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 1466 /* NFOSMESA_GLBLENDPARAMETERINV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcY0;
	(void)srcX1;
	(void)srcY1;
	(void)dstX0;
	(void)dstY0;
	(void)dstX1;
	(void)dstY1;
	(void)mask;
	(void)filter;
	(*exec)(gl_slb, 1467 /* NFOSMESA_GLBLITFRAMEBUFFER */, SLB_NARGS(2), gl_pub, &srcX0);
}

static void APIENTRY exec_glBlitFramebufferEXT(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcY0;
	(void)srcX1;
	(void)srcY1;
	(void)dstX0;
	(void)dstY0;
	(void)dstX1;
	(void)dstY1;
	(void)mask;
	(void)filter;
	(*exec)(gl_slb, 1468 /* NFOSMESA_GLBLITFRAMEBUFFEREXT */, SLB_NARGS(2), gl_pub, &srcX0);
}

static void APIENTRY exec_glBufferAddressRangeNV(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)address;
	(void)length;
	(*exec)(gl_slb, 1469 /* NFOSMESA_GLBUFFERADDRESSRANGENV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glBufferParameteriAPPLE(GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1470 /* NFOSMESA_GLBUFFERPARAMETERIAPPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glBufferStorage(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)data;
	(void)flags;
	(*exec)(gl_slb, 1471 /* NFOSMESA_GLBUFFERSTORAGE */, SLB_NARGS(2), gl_pub, &target);
}

static GLenum APIENTRY exec_glCheckFramebufferStatus(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLenum)(*exec)(gl_slb, 1472 /* NFOSMESA_GLCHECKFRAMEBUFFERSTATUS */, SLB_NARGS(2), gl_pub, &target);
}

static GLenum APIENTRY exec_glCheckFramebufferStatusEXT(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLenum)(*exec)(gl_slb, 1473 /* NFOSMESA_GLCHECKFRAMEBUFFERSTATUSEXT */, SLB_NARGS(2), gl_pub, &target);
}

static GLenum APIENTRY exec_glCheckNamedFramebufferStatusEXT(GLuint framebuffer, GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	return (GLenum)(*exec)(gl_slb, 1474 /* NFOSMESA_GLCHECKNAMEDFRAMEBUFFERSTATUSEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glClampColor(GLenum target, GLenum clamp)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)clamp;
	(*exec)(gl_slb, 1475 /* NFOSMESA_GLCLAMPCOLOR */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glClampColorARB(GLenum target, GLenum clamp)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)clamp;
	(*exec)(gl_slb, 1476 /* NFOSMESA_GLCLAMPCOLORARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glClearAccumxOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1477 /* NFOSMESA_GLCLEARACCUMXOES */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 1478 /* NFOSMESA_GLCLEARBUFFERDATA */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)offset;
	(void)size;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 1479 /* NFOSMESA_GLCLEARBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)drawbuffer;
	(void)depth;
	(void)stencil;
	(*exec)(gl_slb, 1480 /* NFOSMESA_GLCLEARBUFFERFI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)drawbuffer;
	(void)value;
	(*exec)(gl_slb, 1481 /* NFOSMESA_GLCLEARBUFFERFV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)drawbuffer;
	(void)value;
	(*exec)(gl_slb, 1482 /* NFOSMESA_GLCLEARBUFFERIV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)drawbuffer;
	(void)value;
	(*exec)(gl_slb, 1483 /* NFOSMESA_GLCLEARBUFFERUIV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearColorIiEXT(GLint red, GLint green, GLint blue, GLint alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1484 /* NFOSMESA_GLCLEARCOLORIIEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glClearColorIuiEXT(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1485 /* NFOSMESA_GLCLEARCOLORIUIEXT */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glClearColorxOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1486 /* NFOSMESA_GLCLEARCOLORXOES */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glClearDebugLogMESA(GLhandleARB obj, GLenum logType, GLenum shaderType)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)logType;
	(void)shaderType;
	(*exec)(gl_slb, 1487 /* NFOSMESA_GLCLEARDEBUGLOGMESA */, SLB_NARGS(2), gl_pub, &obj);
}

static void APIENTRY exec_glClearDepthdNV(GLdouble depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1488 /* NFOSMESA_GLCLEARDEPTHDNV */, SLB_NARGS(2), gl_pub, &depth);
}

static void APIENTRY exec_glClearDepthf(GLfloat d)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1489 /* NFOSMESA_GLCLEARDEPTHF */, SLB_NARGS(2), gl_pub, &d);
}

static void APIENTRY exec_glClearDepthfOES(GLclampf depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1490 /* NFOSMESA_GLCLEARDEPTHFOES */, SLB_NARGS(2), gl_pub, &depth);
}

static void APIENTRY exec_glClearDepthxOES(GLfixed depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1491 /* NFOSMESA_GLCLEARDEPTHXOES */, SLB_NARGS(2), gl_pub, &depth);
}

static void APIENTRY exec_glClearNamedBufferDataEXT(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 1492 /* NFOSMESA_GLCLEARNAMEDBUFFERDATAEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearNamedBufferSubDataEXT(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)offset;
	(void)size;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 1493 /* NFOSMESA_GLCLEARNAMEDBUFFERSUBDATAEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 1494 /* NFOSMESA_GLCLEARTEXIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glClearTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 1495 /* NFOSMESA_GLCLEARTEXSUBIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glClientAttribDefaultEXT(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1496 /* NFOSMESA_GLCLIENTATTRIBDEFAULTEXT */, SLB_NARGS(2), gl_pub, &mask);
}

static GLenum APIENTRY exec_glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)flags;
	(void)timeout;
	return (GLenum)(*exec)(gl_slb, 1497 /* NFOSMESA_GLCLIENTWAITSYNC */, SLB_NARGS(2), gl_pub, &sync);
}

static void APIENTRY exec_glClipPlanefOES(GLenum plane, const GLfloat *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equation;
	(*exec)(gl_slb, 1498 /* NFOSMESA_GLCLIPPLANEFOES */, SLB_NARGS(2), gl_pub, &plane);
}

static void APIENTRY exec_glClipPlanexOES(GLenum plane, const GLfixed *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equation;
	(*exec)(gl_slb, 1499 /* NFOSMESA_GLCLIPPLANEXOES */, SLB_NARGS(2), gl_pub, &plane);
}

static void APIENTRY exec_glColor3xOES(GLfixed red, GLfixed green, GLfixed blue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(*exec)(gl_slb, 1500 /* NFOSMESA_GLCOLOR3XOES */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor3xvOES(const GLfixed *components)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1501 /* NFOSMESA_GLCOLOR3XVOES */, SLB_NARGS(2), gl_pub, &components);
}

static void APIENTRY exec_glColor4xOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)green;
	(void)blue;
	(void)alpha;
	(*exec)(gl_slb, 1502 /* NFOSMESA_GLCOLOR4XOES */, SLB_NARGS(2), gl_pub, &red);
}

static void APIENTRY exec_glColor4xvOES(const GLfixed *components)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1503 /* NFOSMESA_GLCOLOR4XVOES */, SLB_NARGS(2), gl_pub, &components);
}

static void APIENTRY exec_glColorFormatNV(GLint size, GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(*exec)(gl_slb, 1504 /* NFOSMESA_GLCOLORFORMATNV */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glColorMaskIndexedEXT(GLuint index, GLboolean32 r, GLboolean32 g, GLboolean32 b, GLboolean32 a)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(*exec)(gl_slb, 1505 /* NFOSMESA_GLCOLORMASKINDEXEDEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glColorMaski(GLuint index, GLboolean32 r, GLboolean32 g, GLboolean32 b, GLboolean32 a)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)g;
	(void)b;
	(void)a;
	(*exec)(gl_slb, 1506 /* NFOSMESA_GLCOLORMASKI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glColorP3ui(GLenum type, GLuint color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(*exec)(gl_slb, 1507 /* NFOSMESA_GLCOLORP3UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glColorP3uiv(GLenum type, const GLuint *color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(*exec)(gl_slb, 1508 /* NFOSMESA_GLCOLORP3UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glColorP4ui(GLenum type, GLuint color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(*exec)(gl_slb, 1509 /* NFOSMESA_GLCOLORP4UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glColorP4uiv(GLenum type, const GLuint *color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(*exec)(gl_slb, 1510 /* NFOSMESA_GLCOLORP4UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glCompileShader(GLuint shader)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1511 /* NFOSMESA_GLCOMPILESHADER */, SLB_NARGS(2), gl_pub, &shader);
}

static void APIENTRY exec_glCompileShaderIncludeARB(GLuint shader, GLsizei count, const GLchar *const *path, const GLint *length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)path;
	(void)length;
	(*exec)(gl_slb, 1512 /* NFOSMESA_GLCOMPILESHADERINCLUDEARB */, SLB_NARGS(2), gl_pub, &shader);
}

static void APIENTRY exec_glCompressedMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1513 /* NFOSMESA_GLCOMPRESSEDMULTITEXIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCompressedMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1514 /* NFOSMESA_GLCOMPRESSEDMULTITEXIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCompressedMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1515 /* NFOSMESA_GLCOMPRESSEDMULTITEXIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCompressedMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1516 /* NFOSMESA_GLCOMPRESSEDMULTITEXSUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCompressedMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1517 /* NFOSMESA_GLCOMPRESSEDMULTITEXSUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCompressedMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1518 /* NFOSMESA_GLCOMPRESSEDMULTITEXSUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCompressedTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1519 /* NFOSMESA_GLCOMPRESSEDTEXTUREIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1520 /* NFOSMESA_GLCOMPRESSEDTEXTUREIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1521 /* NFOSMESA_GLCOMPRESSEDTEXTUREIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1522 /* NFOSMESA_GLCOMPRESSEDTEXTURESUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1523 /* NFOSMESA_GLCOMPRESSEDTEXTURESUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)imageSize;
	(void)bits;
	(*exec)(gl_slb, 1524 /* NFOSMESA_GLCOMPRESSEDTEXTURESUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glConvolutionParameterxOES(GLenum target, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1525 /* NFOSMESA_GLCONVOLUTIONPARAMETERXOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glConvolutionParameterxvOES(GLenum target, GLenum pname, const GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1526 /* NFOSMESA_GLCONVOLUTIONPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)writeTarget;
	(void)readOffset;
	(void)writeOffset;
	(void)size;
	(*exec)(gl_slb, 1527 /* NFOSMESA_GLCOPYBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &readTarget);
}

static void APIENTRY exec_glCopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcTarget;
	(void)srcLevel;
	(void)srcX;
	(void)srcY;
	(void)srcZ;
	(void)dstName;
	(void)dstTarget;
	(void)dstLevel;
	(void)dstX;
	(void)dstY;
	(void)dstZ;
	(void)srcWidth;
	(void)srcHeight;
	(void)srcDepth;
	(*exec)(gl_slb, 1528 /* NFOSMESA_GLCOPYIMAGESUBDATA */, SLB_NARGS(2), gl_pub, &srcName);
}

static void APIENTRY exec_glCopyImageSubDataNV(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcTarget;
	(void)srcLevel;
	(void)srcX;
	(void)srcY;
	(void)srcZ;
	(void)dstName;
	(void)dstTarget;
	(void)dstLevel;
	(void)dstX;
	(void)dstY;
	(void)dstZ;
	(void)width;
	(void)height;
	(void)depth;
	(*exec)(gl_slb, 1529 /* NFOSMESA_GLCOPYIMAGESUBDATANV */, SLB_NARGS(2), gl_pub, &srcName);
}

static void APIENTRY exec_glCopyMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)border;
	(*exec)(gl_slb, 1530 /* NFOSMESA_GLCOPYMULTITEXIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCopyMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(void)border;
	(*exec)(gl_slb, 1531 /* NFOSMESA_GLCOPYMULTITEXIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCopyMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 1532 /* NFOSMESA_GLCOPYMULTITEXSUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCopyMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 1533 /* NFOSMESA_GLCOPYMULTITEXSUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCopyMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 1534 /* NFOSMESA_GLCOPYMULTITEXSUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glCopyPathNV(GLuint resultPath, GLuint srcPath)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcPath;
	(*exec)(gl_slb, 1535 /* NFOSMESA_GLCOPYPATHNV */, SLB_NARGS(2), gl_pub, &resultPath);
}

static void APIENTRY exec_glCopyTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)border;
	(*exec)(gl_slb, 1536 /* NFOSMESA_GLCOPYTEXTUREIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(void)border;
	(*exec)(gl_slb, 1537 /* NFOSMESA_GLCOPYTEXTUREIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 1538 /* NFOSMESA_GLCOPYTEXTURESUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 1539 /* NFOSMESA_GLCOPYTEXTURESUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 1540 /* NFOSMESA_GLCOPYTEXTURESUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCoverFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pathNameType;
	(void)paths;
	(void)pathBase;
	(void)coverMode;
	(void)transformType;
	(void)transformValues;
	(*exec)(gl_slb, 1541 /* NFOSMESA_GLCOVERFILLPATHINSTANCEDNV */, SLB_NARGS(2), gl_pub, &numPaths);
}

static void APIENTRY exec_glCoverFillPathNV(GLuint path, GLenum coverMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coverMode;
	(*exec)(gl_slb, 1542 /* NFOSMESA_GLCOVERFILLPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glCoverStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pathNameType;
	(void)paths;
	(void)pathBase;
	(void)coverMode;
	(void)transformType;
	(void)transformValues;
	(*exec)(gl_slb, 1543 /* NFOSMESA_GLCOVERSTROKEPATHINSTANCEDNV */, SLB_NARGS(2), gl_pub, &numPaths);
}

static void APIENTRY exec_glCoverStrokePathNV(GLuint path, GLenum coverMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coverMode;
	(*exec)(gl_slb, 1544 /* NFOSMESA_GLCOVERSTROKEPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static GLhandleARB APIENTRY exec_glCreateDebugObjectMESA(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLhandleARB)(*exec)(gl_slb, 1545 /* NFOSMESA_GLCREATEDEBUGOBJECTMESA */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glCreatePerfQueryINTEL(GLuint queryId, GLuint *queryHandle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)queryHandle;
	(*exec)(gl_slb, 1546 /* NFOSMESA_GLCREATEPERFQUERYINTEL */, SLB_NARGS(2), gl_pub, &queryId);
}

static GLuint APIENTRY exec_glCreateProgram(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 1547 /* NFOSMESA_GLCREATEPROGRAM */, SLB_NARGS(2), gl_pub, NULL);
}

static GLuint APIENTRY exec_glCreateShader(GLenum type)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 1548 /* NFOSMESA_GLCREATESHADER */, SLB_NARGS(2), gl_pub, &type);
}

static GLuint APIENTRY exec_glCreateShaderProgramEXT(GLenum type, const GLchar *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)string;
	return (GLuint)(*exec)(gl_slb, 1549 /* NFOSMESA_GLCREATESHADERPROGRAMEXT */, SLB_NARGS(2), gl_pub, &type);
}

static GLuint APIENTRY exec_glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const *strings)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)strings;
	return (GLuint)(*exec)(gl_slb, 1550 /* NFOSMESA_GLCREATESHADERPROGRAMV */, SLB_NARGS(2), gl_pub, &type);
}

static GLsync APIENTRY exec_glCreateSyncFromCLeventARB(struct _cl_context *context, struct _cl_event *event, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)event;
	(void)flags;
	return (GLsync)(*exec)(gl_slb, 1551 /* NFOSMESA_GLCREATESYNCFROMCLEVENTARB */, SLB_NARGS(2), gl_pub, &context);
}

static void APIENTRY exec_glDebugMessageCallback(GLDEBUGPROC callback, const void *userParam)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)userParam;
	(*exec)(gl_slb, 1552 /* NFOSMESA_GLDEBUGMESSAGECALLBACK */, SLB_NARGS(2), gl_pub, &callback);
}

static void APIENTRY exec_glDebugMessageCallbackAMD(GLDEBUGPROCAMD callback, void *userParam)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)userParam;
	(*exec)(gl_slb, 1553 /* NFOSMESA_GLDEBUGMESSAGECALLBACKAMD */, SLB_NARGS(2), gl_pub, &callback);
}

static void APIENTRY exec_glDebugMessageCallbackARB(GLDEBUGPROCARB callback, const void *userParam)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)userParam;
	(*exec)(gl_slb, 1554 /* NFOSMESA_GLDEBUGMESSAGECALLBACKARB */, SLB_NARGS(2), gl_pub, &callback);
}

static void APIENTRY exec_glDebugMessageControl(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)severity;
	(void)count;
	(void)ids;
	(void)enabled;
	(*exec)(gl_slb, 1555 /* NFOSMESA_GLDEBUGMESSAGECONTROL */, SLB_NARGS(2), gl_pub, &source);
}

static void APIENTRY exec_glDebugMessageControlARB(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)severity;
	(void)count;
	(void)ids;
	(void)enabled;
	(*exec)(gl_slb, 1556 /* NFOSMESA_GLDEBUGMESSAGECONTROLARB */, SLB_NARGS(2), gl_pub, &source);
}

static void APIENTRY exec_glDebugMessageEnableAMD(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)severity;
	(void)count;
	(void)ids;
	(void)enabled;
	(*exec)(gl_slb, 1557 /* NFOSMESA_GLDEBUGMESSAGEENABLEAMD */, SLB_NARGS(2), gl_pub, &category);
}

static void APIENTRY exec_glDebugMessageInsert(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)id;
	(void)severity;
	(void)length;
	(void)buf;
	(*exec)(gl_slb, 1558 /* NFOSMESA_GLDEBUGMESSAGEINSERT */, SLB_NARGS(2), gl_pub, &source);
}

static void APIENTRY exec_glDebugMessageInsertAMD(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)severity;
	(void)id;
	(void)length;
	(void)buf;
	(*exec)(gl_slb, 1559 /* NFOSMESA_GLDEBUGMESSAGEINSERTAMD */, SLB_NARGS(2), gl_pub, &category);
}

static void APIENTRY exec_glDebugMessageInsertARB(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)id;
	(void)severity;
	(void)length;
	(void)buf;
	(*exec)(gl_slb, 1560 /* NFOSMESA_GLDEBUGMESSAGEINSERTARB */, SLB_NARGS(2), gl_pub, &source);
}

static void APIENTRY exec_glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffers;
	(*exec)(gl_slb, 1561 /* NFOSMESA_GLDELETEFRAMEBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteFramebuffersEXT(GLsizei n, const GLuint *framebuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffers;
	(*exec)(gl_slb, 1562 /* NFOSMESA_GLDELETEFRAMEBUFFERSEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteNamedStringARB(GLint namelen, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(*exec)(gl_slb, 1563 /* NFOSMESA_GLDELETENAMEDSTRINGARB */, SLB_NARGS(2), gl_pub, &namelen);
}

static void APIENTRY exec_glDeleteNamesAMD(GLenum identifier, GLuint num, const GLuint *names)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)num;
	(void)names;
	(*exec)(gl_slb, 1564 /* NFOSMESA_GLDELETENAMESAMD */, SLB_NARGS(2), gl_pub, &identifier);
}

static void APIENTRY exec_glDeleteObjectBufferATI(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1565 /* NFOSMESA_GLDELETEOBJECTBUFFERATI */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glDeletePathsNV(GLuint path, GLsizei range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)range;
	(*exec)(gl_slb, 1566 /* NFOSMESA_GLDELETEPATHSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)monitors;
	(*exec)(gl_slb, 1567 /* NFOSMESA_GLDELETEPERFMONITORSAMD */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeletePerfQueryINTEL(GLuint queryHandle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1568 /* NFOSMESA_GLDELETEPERFQUERYINTEL */, SLB_NARGS(2), gl_pub, &queryHandle);
}

static void APIENTRY exec_glDeleteProgram(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1569 /* NFOSMESA_GLDELETEPROGRAM */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glDeleteProgramPipelines(GLsizei n, const GLuint *pipelines)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pipelines;
	(*exec)(gl_slb, 1570 /* NFOSMESA_GLDELETEPROGRAMPIPELINES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffers;
	(*exec)(gl_slb, 1571 /* NFOSMESA_GLDELETERENDERBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteRenderbuffersEXT(GLsizei n, const GLuint *renderbuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffers;
	(*exec)(gl_slb, 1572 /* NFOSMESA_GLDELETERENDERBUFFERSEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteSamplers(GLsizei count, const GLuint *samplers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samplers;
	(*exec)(gl_slb, 1573 /* NFOSMESA_GLDELETESAMPLERS */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glDeleteShader(GLuint shader)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1574 /* NFOSMESA_GLDELETESHADER */, SLB_NARGS(2), gl_pub, &shader);
}

static void APIENTRY exec_glDeleteSync(GLsync sync)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1575 /* NFOSMESA_GLDELETESYNC */, SLB_NARGS(2), gl_pub, &sync);
}

static void APIENTRY exec_glDeleteTransformFeedbacks(GLsizei n, const GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 1576 /* NFOSMESA_GLDELETETRANSFORMFEEDBACKS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteTransformFeedbacksNV(GLsizei n, const GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 1577 /* NFOSMESA_GLDELETETRANSFORMFEEDBACKSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)arrays;
	(*exec)(gl_slb, 1578 /* NFOSMESA_GLDELETEVERTEXARRAYS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDepthBoundsdNV(GLdouble zmin, GLdouble zmax)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)zmax;
	(*exec)(gl_slb, 1579 /* NFOSMESA_GLDEPTHBOUNDSDNV */, SLB_NARGS(2), gl_pub, &zmin);
}

static void APIENTRY exec_glDepthRangeArrayv(GLuint first, GLsizei count, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 1580 /* NFOSMESA_GLDEPTHRANGEARRAYV */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glDepthRangeIndexed(GLuint index, GLdouble n, GLdouble f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)f;
	(*exec)(gl_slb, 1581 /* NFOSMESA_GLDEPTHRANGEINDEXED */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glDepthRangedNV(GLdouble zNear, GLdouble zFar)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)zFar;
	(*exec)(gl_slb, 1582 /* NFOSMESA_GLDEPTHRANGEDNV */, SLB_NARGS(2), gl_pub, &zNear);
}

static void APIENTRY exec_glDepthRangef(GLfloat n, GLfloat f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)f;
	(*exec)(gl_slb, 1583 /* NFOSMESA_GLDEPTHRANGEF */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDepthRangefOES(GLclampf n, GLclampf f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)f;
	(*exec)(gl_slb, 1584 /* NFOSMESA_GLDEPTHRANGEFOES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDepthRangexOES(GLfixed n, GLfixed f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)f;
	(*exec)(gl_slb, 1585 /* NFOSMESA_GLDEPTHRANGEXOES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDetachShader(GLuint program, GLuint shader)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shader;
	(*exec)(gl_slb, 1586 /* NFOSMESA_GLDETACHSHADER */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glDisableClientStateIndexedEXT(GLenum array, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1587 /* NFOSMESA_GLDISABLECLIENTSTATEINDEXEDEXT */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glDisableClientStateiEXT(GLenum array, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1588 /* NFOSMESA_GLDISABLECLIENTSTATEIEXT */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glDisableIndexedEXT(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1589 /* NFOSMESA_GLDISABLEINDEXEDEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDisableVertexArrayAttribEXT(GLuint vaobj, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1590 /* NFOSMESA_GLDISABLEVERTEXARRAYATTRIBEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glDisableVertexArrayEXT(GLuint vaobj, GLenum array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)array;
	(*exec)(gl_slb, 1591 /* NFOSMESA_GLDISABLEVERTEXARRAYEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glDisableVertexAttribAPPLE(GLuint index, GLenum pname)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(*exec)(gl_slb, 1592 /* NFOSMESA_GLDISABLEVERTEXATTRIBAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glDisableVertexAttribArray(GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1593 /* NFOSMESA_GLDISABLEVERTEXATTRIBARRAY */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glDisablei(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1594 /* NFOSMESA_GLDISABLEI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)num_groups_y;
	(void)num_groups_z;
	(*exec)(gl_slb, 1595 /* NFOSMESA_GLDISPATCHCOMPUTE */, SLB_NARGS(2), gl_pub, &num_groups_x);
}

static void APIENTRY exec_glDispatchComputeGroupSizeARB(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)num_groups_y;
	(void)num_groups_z;
	(void)group_size_x;
	(void)group_size_y;
	(void)group_size_z;
	(*exec)(gl_slb, 1596 /* NFOSMESA_GLDISPATCHCOMPUTEGROUPSIZEARB */, SLB_NARGS(2), gl_pub, &num_groups_x);
}

static void APIENTRY exec_glDispatchComputeIndirect(GLintptr indirect)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1597 /* NFOSMESA_GLDISPATCHCOMPUTEINDIRECT */, SLB_NARGS(2), gl_pub, &indirect);
}

static void APIENTRY exec_glDrawArraysIndirect(GLenum mode, const void *indirect)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirect;
	(*exec)(gl_slb, 1598 /* NFOSMESA_GLDRAWARRAYSINDIRECT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)instancecount;
	(*exec)(gl_slb, 1599 /* NFOSMESA_GLDRAWARRAYSINSTANCED */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)primcount;
	(*exec)(gl_slb, 1600 /* NFOSMESA_GLDRAWARRAYSINSTANCEDARB */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)first;
	(void)count;
	(void)instancecount;
	(void)baseinstance;
	(*exec)(gl_slb, 1601 /* NFOSMESA_GLDRAWARRAYSINSTANCEDBASEINSTANCE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)count;
	(void)primcount;
	(*exec)(gl_slb, 1602 /* NFOSMESA_GLDRAWARRAYSINSTANCEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawBuffers(GLsizei n, const GLenum *bufs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufs;
	(*exec)(gl_slb, 1603 /* NFOSMESA_GLDRAWBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)basevertex;
	(*exec)(gl_slb, 1604 /* NFOSMESA_GLDRAWELEMENTSBASEVERTEX */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsIndirect(GLenum mode, GLenum type, const void *indirect)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)indirect;
	(*exec)(gl_slb, 1605 /* NFOSMESA_GLDRAWELEMENTSINDIRECT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)instancecount;
	(*exec)(gl_slb, 1606 /* NFOSMESA_GLDRAWELEMENTSINSTANCED */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)primcount;
	(*exec)(gl_slb, 1607 /* NFOSMESA_GLDRAWELEMENTSINSTANCEDARB */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)instancecount;
	(void)baseinstance;
	(*exec)(gl_slb, 1608 /* NFOSMESA_GLDRAWELEMENTSINSTANCEDBASEINSTANCE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)instancecount;
	(void)basevertex;
	(*exec)(gl_slb, 1609 /* NFOSMESA_GLDRAWELEMENTSINSTANCEDBASEVERTEX */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)instancecount;
	(void)basevertex;
	(void)baseinstance;
	(*exec)(gl_slb, 1610 /* NFOSMESA_GLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCE */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)primcount;
	(*exec)(gl_slb, 1611 /* NFOSMESA_GLDRAWELEMENTSINSTANCEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)end;
	(void)count;
	(void)type;
	(void)indices;
	(void)basevertex;
	(*exec)(gl_slb, 1612 /* NFOSMESA_GLDRAWRANGEELEMENTSBASEVERTEX */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawTextureNV(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sampler;
	(void)x0;
	(void)y0;
	(void)x1;
	(void)y1;
	(void)z;
	(void)s0;
	(void)t0;
	(void)s1;
	(void)t1;
	(*exec)(gl_slb, 1613 /* NFOSMESA_GLDRAWTEXTURENV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glDrawTransformFeedback(GLenum mode, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 1614 /* NFOSMESA_GLDRAWTRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei instancecount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)instancecount;
	(*exec)(gl_slb, 1615 /* NFOSMESA_GLDRAWTRANSFORMFEEDBACKINSTANCED */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawTransformFeedbackNV(GLenum mode, GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(*exec)(gl_slb, 1616 /* NFOSMESA_GLDRAWTRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)stream;
	(*exec)(gl_slb, 1617 /* NFOSMESA_GLDRAWTRANSFORMFEEDBACKSTREAM */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glDrawTransformFeedbackStreamInstanced(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)stream;
	(void)instancecount;
	(*exec)(gl_slb, 1618 /* NFOSMESA_GLDRAWTRANSFORMFEEDBACKSTREAMINSTANCED */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glEdgeFlagFormatNV(GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1619 /* NFOSMESA_GLEDGEFLAGFORMATNV */, SLB_NARGS(2), gl_pub, &stride);
}

static void APIENTRY exec_glEnableClientStateIndexedEXT(GLenum array, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1620 /* NFOSMESA_GLENABLECLIENTSTATEINDEXEDEXT */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glEnableClientStateiEXT(GLenum array, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1621 /* NFOSMESA_GLENABLECLIENTSTATEIEXT */, SLB_NARGS(2), gl_pub, &array);
}

static void APIENTRY exec_glEnableIndexedEXT(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1622 /* NFOSMESA_GLENABLEINDEXEDEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEnableVertexArrayAttribEXT(GLuint vaobj, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1623 /* NFOSMESA_GLENABLEVERTEXARRAYATTRIBEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glEnableVertexArrayEXT(GLuint vaobj, GLenum array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)array;
	(*exec)(gl_slb, 1624 /* NFOSMESA_GLENABLEVERTEXARRAYEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glEnableVertexAttribAPPLE(GLuint index, GLenum pname)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(*exec)(gl_slb, 1625 /* NFOSMESA_GLENABLEVERTEXATTRIBAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glEnableVertexAttribArray(GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1626 /* NFOSMESA_GLENABLEVERTEXATTRIBARRAY */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glEnablei(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1627 /* NFOSMESA_GLENABLEI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEndConditionalRender(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1628 /* NFOSMESA_GLENDCONDITIONALRENDER */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndConditionalRenderNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1629 /* NFOSMESA_GLENDCONDITIONALRENDERNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndConditionalRenderNVX(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1630 /* NFOSMESA_GLENDCONDITIONALRENDERNVX */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndPerfMonitorAMD(GLuint monitor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1631 /* NFOSMESA_GLENDPERFMONITORAMD */, SLB_NARGS(2), gl_pub, &monitor);
}

static void APIENTRY exec_glEndPerfQueryINTEL(GLuint queryHandle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1632 /* NFOSMESA_GLENDPERFQUERYINTEL */, SLB_NARGS(2), gl_pub, &queryHandle);
}

static void APIENTRY exec_glEndQueryIndexed(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 1633 /* NFOSMESA_GLENDQUERYINDEXED */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glEndTransformFeedback(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1634 /* NFOSMESA_GLENDTRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndTransformFeedbackEXT(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1635 /* NFOSMESA_GLENDTRANSFORMFEEDBACKEXT */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndTransformFeedbackNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1636 /* NFOSMESA_GLENDTRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glEndVideoCaptureNV(GLuint video_capture_slot)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1637 /* NFOSMESA_GLENDVIDEOCAPTURENV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glEvalCoord1xOES(GLfixed u)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1638 /* NFOSMESA_GLEVALCOORD1XOES */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord1xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1639 /* NFOSMESA_GLEVALCOORD1XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glEvalCoord2xOES(GLfixed u, GLfixed v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 1640 /* NFOSMESA_GLEVALCOORD2XOES */, SLB_NARGS(2), gl_pub, &u);
}

static void APIENTRY exec_glEvalCoord2xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1641 /* NFOSMESA_GLEVALCOORD2XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glFeedbackBufferxOES(GLsizei n, GLenum type, const GLfixed *buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)buffer;
	(*exec)(gl_slb, 1642 /* NFOSMESA_GLFEEDBACKBUFFERXOES */, SLB_NARGS(2), gl_pub, &n);
}

static GLsync APIENTRY exec_glFenceSync(GLenum condition, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)flags;
	return (GLsync)(*exec)(gl_slb, 1643 /* NFOSMESA_GLFENCESYNC */, SLB_NARGS(2), gl_pub, &condition);
}

static void APIENTRY exec_glFinishRenderAPPLE(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1644 /* NFOSMESA_GLFINISHRENDERAPPLE */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(*exec)(gl_slb, 1645 /* NFOSMESA_GLFLUSHMAPPEDBUFFERRANGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFlushMappedBufferRangeAPPLE(GLenum target, GLintptr offset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(*exec)(gl_slb, 1646 /* NFOSMESA_GLFLUSHMAPPEDBUFFERRANGEAPPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFlushMappedNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(*exec)(gl_slb, 1647 /* NFOSMESA_GLFLUSHMAPPEDNAMEDBUFFERRANGEEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glFlushRenderAPPLE(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1648 /* NFOSMESA_GLFLUSHRENDERAPPLE */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glFlushStaticDataIBM(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1649 /* NFOSMESA_GLFLUSHSTATICDATAIBM */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFogCoordFormatNV(GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(*exec)(gl_slb, 1650 /* NFOSMESA_GLFOGCOORDFORMATNV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glFogxOES(GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1651 /* NFOSMESA_GLFOGXOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFogxvOES(GLenum pname, const GLfixed *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1652 /* NFOSMESA_GLFOGXVOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glFrameTerminatorGREMEDY(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1653 /* NFOSMESA_GLFRAMETERMINATORGREMEDY */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glFramebufferDrawBufferEXT(GLuint framebuffer, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1654 /* NFOSMESA_GLFRAMEBUFFERDRAWBUFFEREXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glFramebufferDrawBuffersEXT(GLuint framebuffer, GLsizei n, const GLenum *bufs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)bufs;
	(*exec)(gl_slb, 1655 /* NFOSMESA_GLFRAMEBUFFERDRAWBUFFERSEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glFramebufferParameteri(GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1656 /* NFOSMESA_GLFRAMEBUFFERPARAMETERI */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferReadBufferEXT(GLuint framebuffer, GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mode;
	(*exec)(gl_slb, 1657 /* NFOSMESA_GLFRAMEBUFFERREADBUFFEREXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)renderbuffertarget;
	(void)renderbuffer;
	(*exec)(gl_slb, 1658 /* NFOSMESA_GLFRAMEBUFFERRENDERBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)renderbuffertarget;
	(void)renderbuffer;
	(*exec)(gl_slb, 1659 /* NFOSMESA_GLFRAMEBUFFERRENDERBUFFEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1660 /* NFOSMESA_GLFRAMEBUFFERTEXTURE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1661 /* NFOSMESA_GLFRAMEBUFFERTEXTURE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture1DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1662 /* NFOSMESA_GLFRAMEBUFFERTEXTURE1DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1663 /* NFOSMESA_GLFRAMEBUFFERTEXTURE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1664 /* NFOSMESA_GLFRAMEBUFFERTEXTURE2DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(void)zoffset;
	(*exec)(gl_slb, 1665 /* NFOSMESA_GLFRAMEBUFFERTEXTURE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTexture3DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(void)zoffset;
	(*exec)(gl_slb, 1666 /* NFOSMESA_GLFRAMEBUFFERTEXTURE3DEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureARB(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1667 /* NFOSMESA_GLFRAMEBUFFERTEXTUREARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 1668 /* NFOSMESA_GLFRAMEBUFFERTEXTUREEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)face;
	(*exec)(gl_slb, 1669 /* NFOSMESA_GLFRAMEBUFFERTEXTUREFACEARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureFaceEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)face;
	(*exec)(gl_slb, 1670 /* NFOSMESA_GLFRAMEBUFFERTEXTUREFACEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)layer;
	(*exec)(gl_slb, 1671 /* NFOSMESA_GLFRAMEBUFFERTEXTURELAYER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureLayerARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)layer;
	(*exec)(gl_slb, 1672 /* NFOSMESA_GLFRAMEBUFFERTEXTURELAYERARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureLayerEXT(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)layer;
	(*exec)(gl_slb, 1673 /* NFOSMESA_GLFRAMEBUFFERTEXTURELAYEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFrustumfOES(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)b;
	(void)t;
	(void)n;
	(void)f;
	(*exec)(gl_slb, 1674 /* NFOSMESA_GLFRUSTUMFOES */, SLB_NARGS(2), gl_pub, &l);
}

static void APIENTRY exec_glFrustumxOES(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)b;
	(void)t;
	(void)n;
	(void)f;
	(*exec)(gl_slb, 1675 /* NFOSMESA_GLFRUSTUMXOES */, SLB_NARGS(2), gl_pub, &l);
}

static void APIENTRY exec_glGenFramebuffers(GLsizei n, GLuint *framebuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffers;
	(*exec)(gl_slb, 1676 /* NFOSMESA_GLGENFRAMEBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenFramebuffersEXT(GLsizei n, GLuint *framebuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffers;
	(*exec)(gl_slb, 1677 /* NFOSMESA_GLGENFRAMEBUFFERSEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenNamesAMD(GLenum identifier, GLuint num, GLuint *names)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)num;
	(void)names;
	(*exec)(gl_slb, 1678 /* NFOSMESA_GLGENNAMESAMD */, SLB_NARGS(2), gl_pub, &identifier);
}

static GLuint APIENTRY exec_glGenPathsNV(GLsizei range)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLuint)(*exec)(gl_slb, 1679 /* NFOSMESA_GLGENPATHSNV */, SLB_NARGS(2), gl_pub, &range);
}

static void APIENTRY exec_glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)monitors;
	(*exec)(gl_slb, 1680 /* NFOSMESA_GLGENPERFMONITORSAMD */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenProgramPipelines(GLsizei n, GLuint *pipelines)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pipelines;
	(*exec)(gl_slb, 1681 /* NFOSMESA_GLGENPROGRAMPIPELINES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffers;
	(*exec)(gl_slb, 1682 /* NFOSMESA_GLGENRENDERBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenRenderbuffersEXT(GLsizei n, GLuint *renderbuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffers;
	(*exec)(gl_slb, 1683 /* NFOSMESA_GLGENRENDERBUFFERSEXT */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenSamplers(GLsizei count, GLuint *samplers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samplers;
	(*exec)(gl_slb, 1684 /* NFOSMESA_GLGENSAMPLERS */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glGenTransformFeedbacks(GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 1685 /* NFOSMESA_GLGENTRANSFORMFEEDBACKS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenTransformFeedbacksNV(GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 1686 /* NFOSMESA_GLGENTRANSFORMFEEDBACKSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenVertexArrays(GLsizei n, GLuint *arrays)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)arrays;
	(*exec)(gl_slb, 1687 /* NFOSMESA_GLGENVERTEXARRAYS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glGenerateMipmap(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1688 /* NFOSMESA_GLGENERATEMIPMAP */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGenerateMipmapEXT(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1689 /* NFOSMESA_GLGENERATEMIPMAPEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGenerateMultiTexMipmapEXT(GLenum texunit, GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(*exec)(gl_slb, 1690 /* NFOSMESA_GLGENERATEMULTITEXMIPMAPEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGenerateTextureMipmapEXT(GLuint texture, GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(*exec)(gl_slb, 1691 /* NFOSMESA_GLGENERATETEXTUREMIPMAPEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetActiveAtomicCounterBufferiv(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufferIndex;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1692 /* NFOSMESA_GLGETACTIVEATOMICCOUNTERBUFFERIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)bufSize;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 1693 /* NFOSMESA_GLGETACTIVEATTRIB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveSubroutineName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shadertype;
	(void)index;
	(void)bufsize;
	(void)length;
	(void)name;
	(*exec)(gl_slb, 1694 /* NFOSMESA_GLGETACTIVESUBROUTINENAME */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveSubroutineUniformName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shadertype;
	(void)index;
	(void)bufsize;
	(void)length;
	(void)name;
	(*exec)(gl_slb, 1695 /* NFOSMESA_GLGETACTIVESUBROUTINEUNIFORMNAME */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveSubroutineUniformiv(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shadertype;
	(void)index;
	(void)pname;
	(void)values;
	(*exec)(gl_slb, 1696 /* NFOSMESA_GLGETACTIVESUBROUTINEUNIFORMIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)bufSize;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 1697 /* NFOSMESA_GLGETACTIVEUNIFORM */, SLB_NARGS(2), gl_pub, &program);
}

static GLuint APIENTRY exec_glGetActiveUniformBlockIndex(GLuint program, const GLchar *uniformBlockName)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformBlockName;
	return (GLuint)(*exec)(gl_slb, 1698 /* NFOSMESA_GLGETACTIVEUNIFORMBLOCKINDEX */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformBlockIndex;
	(void)bufSize;
	(void)length;
	(void)uniformBlockName;
	(*exec)(gl_slb, 1699 /* NFOSMESA_GLGETACTIVEUNIFORMBLOCKNAME */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformBlockIndex;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1700 /* NFOSMESA_GLGETACTIVEUNIFORMBLOCKIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformIndex;
	(void)bufSize;
	(void)length;
	(void)uniformName;
	(*exec)(gl_slb, 1701 /* NFOSMESA_GLGETACTIVEUNIFORMNAME */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformCount;
	(void)uniformIndices;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1702 /* NFOSMESA_GLGETACTIVEUNIFORMSIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetActiveVaryingNV(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)bufSize;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 1703 /* NFOSMESA_GLGETACTIVEVARYINGNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)maxCount;
	(void)count;
	(void)shaders;
	(*exec)(gl_slb, 1704 /* NFOSMESA_GLGETATTACHEDSHADERS */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetAttribLocation(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1705 /* NFOSMESA_GLGETATTRIBLOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetBooleanIndexedvEXT(GLenum target, GLuint index, GLboolean *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1706 /* NFOSMESA_GLGETBOOLEANINDEXEDVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1707 /* NFOSMESA_GLGETBOOLEANI_V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1708 /* NFOSMESA_GLGETBUFFERPARAMETERI64V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetBufferParameterui64vNV(GLenum target, GLenum pname, GLuint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1709 /* NFOSMESA_GLGETBUFFERPARAMETERUI64VNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetClipPlanefOES(GLenum plane, GLfloat *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equation;
	(*exec)(gl_slb, 1710 /* NFOSMESA_GLGETCLIPPLANEFOES */, SLB_NARGS(2), gl_pub, &plane);
}

static void APIENTRY exec_glGetClipPlanexOES(GLenum plane, GLfixed *equation)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)equation;
	(*exec)(gl_slb, 1711 /* NFOSMESA_GLGETCLIPPLANEXOES */, SLB_NARGS(2), gl_pub, &plane);
}

static void APIENTRY exec_glGetCompressedMultiTexImageEXT(GLenum texunit, GLenum target, GLint lod, void *img)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)lod;
	(void)img;
	(*exec)(gl_slb, 1712 /* NFOSMESA_GLGETCOMPRESSEDMULTITEXIMAGEEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetCompressedTextureImageEXT(GLuint texture, GLenum target, GLint lod, void *img)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)lod;
	(void)img;
	(*exec)(gl_slb, 1713 /* NFOSMESA_GLGETCOMPRESSEDTEXTUREIMAGEEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetConvolutionParameterxvOES(GLenum target, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1714 /* NFOSMESA_GLGETCONVOLUTIONPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static GLsizei APIENTRY exec_glGetDebugLogLengthMESA(GLhandleARB obj, GLenum logType, GLenum shaderType)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)logType;
	(void)shaderType;
	return (GLsizei)(*exec)(gl_slb, 1715 /* NFOSMESA_GLGETDEBUGLOGLENGTHMESA */, SLB_NARGS(2), gl_pub, &obj);
}

static void APIENTRY exec_glGetDebugLogMESA(GLhandleARB obj, GLenum logType, GLenum shaderType, GLsizei maxLength, GLsizei *length, GLcharARB *debugLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)logType;
	(void)shaderType;
	(void)maxLength;
	(void)length;
	(void)debugLog;
	(*exec)(gl_slb, 1716 /* NFOSMESA_GLGETDEBUGLOGMESA */, SLB_NARGS(2), gl_pub, &obj);
}

static GLuint APIENTRY exec_glGetDebugMessageLog(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)sources;
	(void)types;
	(void)ids;
	(void)severities;
	(void)lengths;
	(void)messageLog;
	return (GLuint)(*exec)(gl_slb, 1717 /* NFOSMESA_GLGETDEBUGMESSAGELOG */, SLB_NARGS(2), gl_pub, &count);
}

static GLuint APIENTRY exec_glGetDebugMessageLogAMD(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufsize;
	(void)categories;
	(void)severities;
	(void)ids;
	(void)lengths;
	(void)message;
	return (GLuint)(*exec)(gl_slb, 1718 /* NFOSMESA_GLGETDEBUGMESSAGELOGAMD */, SLB_NARGS(2), gl_pub, &count);
}

static GLuint APIENTRY exec_glGetDebugMessageLogARB(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)sources;
	(void)types;
	(void)ids;
	(void)severities;
	(void)lengths;
	(void)messageLog;
	return (GLuint)(*exec)(gl_slb, 1719 /* NFOSMESA_GLGETDEBUGMESSAGELOGARB */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glGetDoubleIndexedvEXT(GLenum target, GLuint index, GLdouble *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1720 /* NFOSMESA_GLGETDOUBLEINDEXEDVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetDoublei_v(GLenum target, GLuint index, GLdouble *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1721 /* NFOSMESA_GLGETDOUBLEI_V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetDoublei_vEXT(GLenum pname, GLuint index, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1722 /* NFOSMESA_GLGETDOUBLEI_VEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetFirstPerfQueryIdINTEL(GLuint *queryId)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1723 /* NFOSMESA_GLGETFIRSTPERFQUERYIDINTEL */, SLB_NARGS(2), gl_pub, &queryId);
}

static void APIENTRY exec_glGetFixedvOES(GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 1724 /* NFOSMESA_GLGETFIXEDVOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetFloatIndexedvEXT(GLenum target, GLuint index, GLfloat *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1725 /* NFOSMESA_GLGETFLOATINDEXEDVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetFloati_v(GLenum target, GLuint index, GLfloat *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1726 /* NFOSMESA_GLGETFLOATI_V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetFloati_vEXT(GLenum pname, GLuint index, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1727 /* NFOSMESA_GLGETFLOATI_VEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static GLint APIENTRY exec_glGetFragDataIndex(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1728 /* NFOSMESA_GLGETFRAGDATAINDEX */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetFragDataLocation(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1729 /* NFOSMESA_GLGETFRAGDATALOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetFragDataLocationEXT(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1730 /* NFOSMESA_GLGETFRAGDATALOCATIONEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1731 /* NFOSMESA_GLGETFRAMEBUFFERATTACHMENTPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1732 /* NFOSMESA_GLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1733 /* NFOSMESA_GLGETFRAMEBUFFERPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1734 /* NFOSMESA_GLGETFRAMEBUFFERPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static GLenum APIENTRY exec_glGetGraphicsResetStatusARB(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLenum)(*exec)(gl_slb, 1735 /* NFOSMESA_GLGETGRAPHICSRESETSTATUSARB */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glGetHistogramParameterxvOES(GLenum target, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1736 /* NFOSMESA_GLGETHISTOGRAMPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static GLuint64 APIENTRY exec_glGetImageHandleARB(GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum format)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(void)level;
	(void)layered;
	(void)layer;
	(void)format;
	(*exec)(gl_slb, 1737 /* NFOSMESA_GLGETIMAGEHANDLEARB */, SLB_NARGS(3), gl_pub, &texture, &__retval);
	return __retval;
}

static GLuint64 APIENTRY exec_glGetImageHandleNV(GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum format)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(void)level;
	(void)layered;
	(void)layer;
	(void)format;
	(*exec)(gl_slb, 1738 /* NFOSMESA_GLGETIMAGEHANDLENV */, SLB_NARGS(3), gl_pub, &texture, &__retval);
	return __retval;
}

static void APIENTRY exec_glGetInteger64i_v(GLenum target, GLuint index, GLint64 *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1739 /* NFOSMESA_GLGETINTEGER64I_V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetInteger64v(GLenum pname, GLint64 *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)data;
	(*exec)(gl_slb, 1740 /* NFOSMESA_GLGETINTEGER64V */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetIntegerIndexedvEXT(GLenum target, GLuint index, GLint *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1741 /* NFOSMESA_GLGETINTEGERINDEXEDVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetIntegeri_v(GLenum target, GLuint index, GLint *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1742 /* NFOSMESA_GLGETINTEGERI_V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetIntegerui64i_vNV(GLenum value, GLuint index, GLuint64EXT *result)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)result;
	(*exec)(gl_slb, 1743 /* NFOSMESA_GLGETINTEGERUI64I_VNV */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glGetIntegerui64vNV(GLenum value, GLuint64EXT *result)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)result;
	(*exec)(gl_slb, 1744 /* NFOSMESA_GLGETINTEGERUI64VNV */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glGetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)pname;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 1745 /* NFOSMESA_GLGETINTERNALFORMATI64V */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)pname;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 1746 /* NFOSMESA_GLGETINTERNALFORMATIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetLightxOES(GLenum light, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1747 /* NFOSMESA_GLGETLIGHTXOES */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glGetMapxvOES(GLenum target, GLenum query, GLfixed *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)v;
	(*exec)(gl_slb, 1748 /* NFOSMESA_GLGETMAPXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetMaterialxOES(GLenum face, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1749 /* NFOSMESA_GLGETMATERIALXOES */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glGetMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1750 /* NFOSMESA_GLGETMULTITEXENVFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1751 /* NFOSMESA_GLGETMULTITEXENVIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1752 /* NFOSMESA_GLGETMULTITEXGENDVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1753 /* NFOSMESA_GLGETMULTITEXGENFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1754 /* NFOSMESA_GLGETMULTITEXGENIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 1755 /* NFOSMESA_GLGETMULTITEXIMAGEEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexLevelParameterfvEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1756 /* NFOSMESA_GLGETMULTITEXLEVELPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexLevelParameterivEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1757 /* NFOSMESA_GLGETMULTITEXLEVELPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1758 /* NFOSMESA_GLGETMULTITEXPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1759 /* NFOSMESA_GLGETMULTITEXPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1760 /* NFOSMESA_GLGETMULTITEXPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1761 /* NFOSMESA_GLGETMULTITEXPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glGetMultisamplefv(GLenum pname, GLuint index, GLfloat *val)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)val;
	(*exec)(gl_slb, 1762 /* NFOSMESA_GLGETMULTISAMPLEFV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetMultisamplefvNV(GLenum pname, GLuint index, GLfloat *val)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)val;
	(*exec)(gl_slb, 1763 /* NFOSMESA_GLGETMULTISAMPLEFVNV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetNamedBufferParameterivEXT(GLuint buffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1764 /* NFOSMESA_GLGETNAMEDBUFFERPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedBufferParameterui64vNV(GLuint buffer, GLenum pname, GLuint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1765 /* NFOSMESA_GLGETNAMEDBUFFERPARAMETERUI64VNV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedBufferPointervEXT(GLuint buffer, GLenum pname, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1766 /* NFOSMESA_GLGETNAMEDBUFFERPOINTERVEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 1767 /* NFOSMESA_GLGETNAMEDBUFFERSUBDATAEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedFramebufferAttachmentParameterivEXT(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1768 /* NFOSMESA_GLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glGetNamedFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1769 /* NFOSMESA_GLGETNAMEDFRAMEBUFFERPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glGetNamedProgramLocalParameterIivEXT(GLuint program, GLenum target, GLuint index, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1770 /* NFOSMESA_GLGETNAMEDPROGRAMLOCALPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetNamedProgramLocalParameterIuivEXT(GLuint program, GLenum target, GLuint index, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1771 /* NFOSMESA_GLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetNamedProgramLocalParameterdvEXT(GLuint program, GLenum target, GLuint index, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1772 /* NFOSMESA_GLGETNAMEDPROGRAMLOCALPARAMETERDVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetNamedProgramLocalParameterfvEXT(GLuint program, GLenum target, GLuint index, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1773 /* NFOSMESA_GLGETNAMEDPROGRAMLOCALPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetNamedProgramStringEXT(GLuint program, GLenum target, GLenum pname, void *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)string;
	(*exec)(gl_slb, 1774 /* NFOSMESA_GLGETNAMEDPROGRAMSTRINGEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetNamedProgramivEXT(GLuint program, GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1775 /* NFOSMESA_GLGETNAMEDPROGRAMIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetNamedRenderbufferParameterivEXT(GLuint renderbuffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1776 /* NFOSMESA_GLGETNAMEDRENDERBUFFERPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static void APIENTRY exec_glGetNamedStringARB(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)bufSize;
	(void)stringlen;
	(void)string;
	(*exec)(gl_slb, 1777 /* NFOSMESA_GLGETNAMEDSTRINGARB */, SLB_NARGS(2), gl_pub, &namelen);
}

static void APIENTRY exec_glGetNamedStringivARB(GLint namelen, const GLchar *name, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1778 /* NFOSMESA_GLGETNAMEDSTRINGIVARB */, SLB_NARGS(2), gl_pub, &namelen);
}

static void APIENTRY exec_glGetNextPerfQueryIdINTEL(GLuint queryId, GLuint *nextQueryId)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)nextQueryId;
	(*exec)(gl_slb, 1779 /* NFOSMESA_GLGETNEXTPERFQUERYIDINTEL */, SLB_NARGS(2), gl_pub, &queryId);
}

static void APIENTRY exec_glGetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)bufSize;
	(void)length;
	(void)label;
	(*exec)(gl_slb, 1780 /* NFOSMESA_GLGETOBJECTLABEL */, SLB_NARGS(2), gl_pub, &identifier);
}

static void APIENTRY exec_glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)object;
	(void)bufSize;
	(void)length;
	(void)label;
	(*exec)(gl_slb, 1781 /* NFOSMESA_GLGETOBJECTLABELEXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glGetObjectParameterivAPPLE(GLenum objectType, GLuint name, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1782 /* NFOSMESA_GLGETOBJECTPARAMETERIVAPPLE */, SLB_NARGS(2), gl_pub, &objectType);
}

static void APIENTRY exec_glGetObjectPtrLabel(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)label;
	(*exec)(gl_slb, 1783 /* NFOSMESA_GLGETOBJECTPTRLABEL */, SLB_NARGS(2), gl_pub, &ptr);
}

static void APIENTRY exec_glGetPathColorGenfvNV(GLenum color, GLenum pname, GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 1784 /* NFOSMESA_GLGETPATHCOLORGENFVNV */, SLB_NARGS(2), gl_pub, &color);
}

static void APIENTRY exec_glGetPathColorGenivNV(GLenum color, GLenum pname, GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 1785 /* NFOSMESA_GLGETPATHCOLORGENIVNV */, SLB_NARGS(2), gl_pub, &color);
}

static void APIENTRY exec_glGetPathCommandsNV(GLuint path, GLubyte *commands)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)commands;
	(*exec)(gl_slb, 1786 /* NFOSMESA_GLGETPATHCOMMANDSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glGetPathCoordsNV(GLuint path, GLfloat *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 1787 /* NFOSMESA_GLGETPATHCOORDSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glGetPathDashArrayNV(GLuint path, GLfloat *dashArray)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dashArray;
	(*exec)(gl_slb, 1788 /* NFOSMESA_GLGETPATHDASHARRAYNV */, SLB_NARGS(2), gl_pub, &path);
}

static GLfloat APIENTRY exec_glGetPathLengthNV(GLuint path, GLsizei startSegment, GLsizei numSegments)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)startSegment;
	(void)numSegments;
	return (GLfloat)(*exec)(gl_slb, 1789 /* NFOSMESA_GLGETPATHLENGTHNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glGetPathMetricRangeNV(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)firstPathName;
	(void)numPaths;
	(void)stride;
	(void)metrics;
	(*exec)(gl_slb, 1790 /* NFOSMESA_GLGETPATHMETRICRANGENV */, SLB_NARGS(2), gl_pub, &metricQueryMask);
}

static void APIENTRY exec_glGetPathMetricsNV(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numPaths;
	(void)pathNameType;
	(void)paths;
	(void)pathBase;
	(void)stride;
	(void)metrics;
	(*exec)(gl_slb, 1791 /* NFOSMESA_GLGETPATHMETRICSNV */, SLB_NARGS(2), gl_pub, &metricQueryMask);
}

static void APIENTRY exec_glGetPathParameterfvNV(GLuint path, GLenum pname, GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 1792 /* NFOSMESA_GLGETPATHPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glGetPathParameterivNV(GLuint path, GLenum pname, GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 1793 /* NFOSMESA_GLGETPATHPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glGetPathSpacingNV(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numPaths;
	(void)pathNameType;
	(void)paths;
	(void)pathBase;
	(void)advanceScale;
	(void)kerningScale;
	(void)transformType;
	(void)returnedSpacing;
	(*exec)(gl_slb, 1794 /* NFOSMESA_GLGETPATHSPACINGNV */, SLB_NARGS(2), gl_pub, &pathListMode);
}

static void APIENTRY exec_glGetPathTexGenfvNV(GLenum texCoordSet, GLenum pname, GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 1795 /* NFOSMESA_GLGETPATHTEXGENFVNV */, SLB_NARGS(2), gl_pub, &texCoordSet);
}

static void APIENTRY exec_glGetPathTexGenivNV(GLenum texCoordSet, GLenum pname, GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 1796 /* NFOSMESA_GLGETPATHTEXGENIVNV */, SLB_NARGS(2), gl_pub, &texCoordSet);
}

static void APIENTRY exec_glGetPerfCounterInfoINTEL(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)counterId;
	(void)counterNameLength;
	(void)counterName;
	(void)counterDescLength;
	(void)counterDesc;
	(void)counterOffset;
	(void)counterDataSize;
	(void)counterTypeEnum;
	(void)counterDataTypeEnum;
	(void)rawCounterMaxValue;
	(*exec)(gl_slb, 1797 /* NFOSMESA_GLGETPERFCOUNTERINFOINTEL */, SLB_NARGS(2), gl_pub, &queryId);
}

static void APIENTRY exec_glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)dataSize;
	(void)data;
	(void)bytesWritten;
	(*exec)(gl_slb, 1798 /* NFOSMESA_GLGETPERFMONITORCOUNTERDATAAMD */, SLB_NARGS(2), gl_pub, &monitor);
}

static void APIENTRY exec_glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)counter;
	(void)pname;
	(void)data;
	(*exec)(gl_slb, 1799 /* NFOSMESA_GLGETPERFMONITORCOUNTERINFOAMD */, SLB_NARGS(2), gl_pub, &group);
}

static void APIENTRY exec_glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)counter;
	(void)bufSize;
	(void)length;
	(void)counterString;
	(*exec)(gl_slb, 1800 /* NFOSMESA_GLGETPERFMONITORCOUNTERSTRINGAMD */, SLB_NARGS(2), gl_pub, &group);
}

static void APIENTRY exec_glGetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numCounters;
	(void)maxActiveCounters;
	(void)counterSize;
	(void)counters;
	(*exec)(gl_slb, 1801 /* NFOSMESA_GLGETPERFMONITORCOUNTERSAMD */, SLB_NARGS(2), gl_pub, &group);
}

static void APIENTRY exec_glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)groupString;
	(*exec)(gl_slb, 1802 /* NFOSMESA_GLGETPERFMONITORGROUPSTRINGAMD */, SLB_NARGS(2), gl_pub, &group);
}

static void APIENTRY exec_glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)groupsSize;
	(void)groups;
	(*exec)(gl_slb, 1803 /* NFOSMESA_GLGETPERFMONITORGROUPSAMD */, SLB_NARGS(2), gl_pub, &numGroups);
}

static void APIENTRY exec_glGetPerfQueryDataINTEL(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid *data, GLuint *bytesWritten)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)flags;
	(void)dataSize;
	(void)data;
	(void)bytesWritten;
	(*exec)(gl_slb, 1804 /* NFOSMESA_GLGETPERFQUERYDATAINTEL */, SLB_NARGS(2), gl_pub, &queryHandle);
}

static void APIENTRY exec_glGetPerfQueryIdByNameINTEL(GLchar *queryName, GLuint *queryId)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)queryId;
	(*exec)(gl_slb, 1805 /* NFOSMESA_GLGETPERFQUERYIDBYNAMEINTEL */, SLB_NARGS(2), gl_pub, &queryName);
}

static void APIENTRY exec_glGetPerfQueryInfoINTEL(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)queryNameLength;
	(void)queryName;
	(void)dataSize;
	(void)noCounters;
	(void)noInstances;
	(void)capsMask;
	(*exec)(gl_slb, 1806 /* NFOSMESA_GLGETPERFQUERYINFOINTEL */, SLB_NARGS(2), gl_pub, &queryId);
}

static void APIENTRY exec_glGetPixelMapxv(GLenum map, GLint size, GLfixed *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)values;
	(*exec)(gl_slb, 1807 /* NFOSMESA_GLGETPIXELMAPXV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetPixelTransformParameterfvEXT(GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1808 /* NFOSMESA_GLGETPIXELTRANSFORMPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetPixelTransformParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1809 /* NFOSMESA_GLGETPIXELTRANSFORMPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetPointerIndexedvEXT(GLenum target, GLuint index, void * *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)data;
	(*exec)(gl_slb, 1810 /* NFOSMESA_GLGETPOINTERINDEXEDVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetPointeri_vEXT(GLenum pname, GLuint index, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1811 /* NFOSMESA_GLGETPOINTERI_VEXT */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)binaryFormat;
	(void)binary;
	(*exec)(gl_slb, 1812 /* NFOSMESA_GLGETPROGRAMBINARY */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramEnvParameterIivNV(GLenum target, GLuint index, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1813 /* NFOSMESA_GLGETPROGRAMENVPARAMETERIIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramEnvParameterIuivNV(GLenum target, GLuint index, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1814 /* NFOSMESA_GLGETPROGRAMENVPARAMETERIUIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)infoLog;
	(*exec)(gl_slb, 1815 /* NFOSMESA_GLGETPROGRAMINFOLOG */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1816 /* NFOSMESA_GLGETPROGRAMINTERFACEIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramLocalParameterIivNV(GLenum target, GLuint index, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1817 /* NFOSMESA_GLGETPROGRAMLOCALPARAMETERIIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramLocalParameterIuivNV(GLenum target, GLuint index, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 1818 /* NFOSMESA_GLGETPROGRAMLOCALPARAMETERIUIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)infoLog;
	(*exec)(gl_slb, 1819 /* NFOSMESA_GLGETPROGRAMPIPELINEINFOLOG */, SLB_NARGS(2), gl_pub, &pipeline);
}

static void APIENTRY exec_glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1820 /* NFOSMESA_GLGETPROGRAMPIPELINEIV */, SLB_NARGS(2), gl_pub, &pipeline);
}

static void APIENTRY exec_glGetProgramRegisterfvMESA(GLenum target, GLsizei len, const GLubyte *name, GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)len;
	(void)name;
	(void)v;
	(*exec)(gl_slb, 1821 /* NFOSMESA_GLGETPROGRAMREGISTERFVMESA */, SLB_NARGS(2), gl_pub, &target);
}

static GLuint APIENTRY exec_glGetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)name;
	return (GLuint)(*exec)(gl_slb, 1822 /* NFOSMESA_GLGETPROGRAMRESOURCEINDEX */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1823 /* NFOSMESA_GLGETPROGRAMRESOURCELOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetProgramResourceLocationIndex(GLuint program, GLenum programInterface, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1824 /* NFOSMESA_GLGETPROGRAMRESOURCELOCATIONINDEX */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)index;
	(void)bufSize;
	(void)length;
	(void)name;
	(*exec)(gl_slb, 1825 /* NFOSMESA_GLGETPROGRAMRESOURCENAME */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)index;
	(void)propCount;
	(void)props;
	(void)bufSize;
	(void)length;
	(void)params;
	(*exec)(gl_slb, 1826 /* NFOSMESA_GLGETPROGRAMRESOURCEIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shadertype;
	(void)pname;
	(void)values;
	(*exec)(gl_slb, 1827 /* NFOSMESA_GLGETPROGRAMSTAGEIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetProgramSubroutineParameteruivNV(GLenum target, GLuint index, GLuint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)param;
	(*exec)(gl_slb, 1828 /* NFOSMESA_GLGETPROGRAMSUBROUTINEPARAMETERUIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetProgramiv(GLuint program, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1829 /* NFOSMESA_GLGETPROGRAMIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1830 /* NFOSMESA_GLGETQUERYINDEXEDIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1831 /* NFOSMESA_GLGETQUERYOBJECTI64V */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1832 /* NFOSMESA_GLGETQUERYOBJECTI64VEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1833 /* NFOSMESA_GLGETQUERYOBJECTUI64V */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1834 /* NFOSMESA_GLGETQUERYOBJECTUI64VEXT */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1835 /* NFOSMESA_GLGETRENDERBUFFERPARAMETERIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1836 /* NFOSMESA_GLGETRENDERBUFFERPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1837 /* NFOSMESA_GLGETSAMPLERPARAMETERIIV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1838 /* NFOSMESA_GLGETSAMPLERPARAMETERIUIV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1839 /* NFOSMESA_GLGETSAMPLERPARAMETERFV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1840 /* NFOSMESA_GLGETSAMPLERPARAMETERIV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)infoLog;
	(*exec)(gl_slb, 1841 /* NFOSMESA_GLGETSHADERINFOLOG */, SLB_NARGS(2), gl_pub, &shader);
}

static void APIENTRY exec_glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)precisiontype;
	(void)range;
	(void)precision;
	(*exec)(gl_slb, 1842 /* NFOSMESA_GLGETSHADERPRECISIONFORMAT */, SLB_NARGS(2), gl_pub, &shadertype);
}

static void APIENTRY exec_glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)length;
	(void)source;
	(*exec)(gl_slb, 1843 /* NFOSMESA_GLGETSHADERSOURCE */, SLB_NARGS(2), gl_pub, &shader);
}

static void APIENTRY exec_glGetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1844 /* NFOSMESA_GLGETSHADERIV */, SLB_NARGS(2), gl_pub, &shader);
}

static const GLubyte * APIENTRY exec_glGetStringi(GLenum name, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	return (const GLubyte *)(*exec)(gl_slb, 1845 /* NFOSMESA_LENGLGETSTRINGI */, SLB_NARGS(2), gl_pub, &name);
}

static GLuint APIENTRY exec_glGetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shadertype;
	(void)name;
	return (GLuint)(*exec)(gl_slb, 1847 /* NFOSMESA_GLGETSUBROUTINEINDEX */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetSubroutineUniformLocation(GLuint program, GLenum shadertype, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shadertype;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1848 /* NFOSMESA_GLGETSUBROUTINEUNIFORMLOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)bufSize;
	(void)length;
	(void)values;
	(*exec)(gl_slb, 1849 /* NFOSMESA_GLGETSYNCIV */, SLB_NARGS(2), gl_pub, &sync);
}

static void APIENTRY exec_glGetTexEnvxvOES(GLenum target, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1850 /* NFOSMESA_GLGETTEXENVXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1851 /* NFOSMESA_GLGETTEXGENXVOES */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glGetTexLevelParameterxvOES(GLenum target, GLint level, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1852 /* NFOSMESA_GLGETTEXLEVELPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1853 /* NFOSMESA_GLGETTEXPARAMETERIIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1854 /* NFOSMESA_GLGETTEXPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1855 /* NFOSMESA_GLGETTEXPARAMETERIUIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1856 /* NFOSMESA_GLGETTEXPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterPointervAPPLE(GLenum target, GLenum pname, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1857 /* NFOSMESA_GLGETTEXPARAMETERPOINTERVAPPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetTexParameterxvOES(GLenum target, GLenum pname, GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1858 /* NFOSMESA_GLGETTEXPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static GLuint64 APIENTRY exec_glGetTextureHandleARB(GLuint texture)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(*exec)(gl_slb, 1859 /* NFOSMESA_GLGETTEXTUREHANDLEARB */, SLB_NARGS(3), gl_pub, &texture, &__retval);
	return __retval;
}

static GLuint64 APIENTRY exec_glGetTextureHandleNV(GLuint texture)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(*exec)(gl_slb, 1860 /* NFOSMESA_GLGETTEXTUREHANDLENV */, SLB_NARGS(3), gl_pub, &texture, &__retval);
	return __retval;
}

static void APIENTRY exec_glGetTextureImageEXT(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 1861 /* NFOSMESA_GLGETTEXTUREIMAGEEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureLevelParameterfvEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1862 /* NFOSMESA_GLGETTEXTURELEVELPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureLevelParameterivEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1863 /* NFOSMESA_GLGETTEXTURELEVELPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1864 /* NFOSMESA_GLGETTEXTUREPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1865 /* NFOSMESA_GLGETTEXTUREPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1866 /* NFOSMESA_GLGETTEXTUREPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1867 /* NFOSMESA_GLGETTEXTUREPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static GLuint64 APIENTRY exec_glGetTextureSamplerHandleARB(GLuint texture, GLuint sampler)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(void)sampler;
	(*exec)(gl_slb, 1868 /* NFOSMESA_GLGETTEXTURESAMPLERHANDLEARB */, SLB_NARGS(3), gl_pub, &texture, &__retval);
	return __retval;
}

static GLuint64 APIENTRY exec_glGetTextureSamplerHandleNV(GLuint texture, GLuint sampler)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(void)sampler;
	(*exec)(gl_slb, 1869 /* NFOSMESA_GLGETTEXTURESAMPLERHANDLENV */, SLB_NARGS(3), gl_pub, &texture, &__retval);
	return __retval;
}

static void APIENTRY exec_glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)bufSize;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 1870 /* NFOSMESA_GLGETTRANSFORMFEEDBACKVARYING */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetTransformFeedbackVaryingEXT(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)bufSize;
	(void)length;
	(void)size;
	(void)type;
	(void)name;
	(*exec)(gl_slb, 1871 /* NFOSMESA_GLGETTRANSFORMFEEDBACKVARYINGEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetTransformFeedbackVaryingNV(GLuint program, GLuint index, GLint *location)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)location;
	(*exec)(gl_slb, 1872 /* NFOSMESA_GLGETTRANSFORMFEEDBACKVARYINGNV */, SLB_NARGS(2), gl_pub, &program);
}

static GLuint APIENTRY exec_glGetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformBlockName;
	return (GLuint)(*exec)(gl_slb, 1873 /* NFOSMESA_GLGETUNIFORMBLOCKINDEX */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetUniformBufferSizeEXT(GLuint program, GLint location)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	return (GLint)(*exec)(gl_slb, 1874 /* NFOSMESA_GLGETUNIFORMBUFFERSIZEEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar *const *uniformNames, GLuint *uniformIndices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformCount;
	(void)uniformNames;
	(void)uniformIndices;
	(*exec)(gl_slb, 1875 /* NFOSMESA_GLGETUNIFORMINDICES */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetUniformLocation(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1876 /* NFOSMESA_GLGETUNIFORMLOCATION */, SLB_NARGS(2), gl_pub, &program);
}

static GLintptr APIENTRY exec_glGetUniformOffsetEXT(GLuint program, GLint location)
{
	GLuint64 __retval = 0;
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *, void *))gl_exec;
	(void)location;
	(*exec)(gl_slb, 1877 /* NFOSMESA_GLGETUNIFORMOFFSETEXT */, SLB_NARGS(3), gl_pub, &program, &__retval);
	return __retval;
}

static void APIENTRY exec_glGetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1878 /* NFOSMESA_GLGETUNIFORMSUBROUTINEUIV */, SLB_NARGS(2), gl_pub, &shadertype);
}

static void APIENTRY exec_glGetUniformdv(GLuint program, GLint location, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1879 /* NFOSMESA_GLGETUNIFORMDV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformfv(GLuint program, GLint location, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1880 /* NFOSMESA_GLGETUNIFORMFV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformi64vNV(GLuint program, GLint location, GLint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1881 /* NFOSMESA_GLGETUNIFORMI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformiv(GLuint program, GLint location, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1882 /* NFOSMESA_GLGETUNIFORMIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformui64vNV(GLuint program, GLint location, GLuint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1883 /* NFOSMESA_GLGETUNIFORMUI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformuiv(GLuint program, GLint location, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1884 /* NFOSMESA_GLGETUNIFORMUIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetUniformuivEXT(GLuint program, GLint location, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)params;
	(*exec)(gl_slb, 1885 /* NFOSMESA_GLGETUNIFORMUIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static GLint APIENTRY exec_glGetVaryingLocationNV(GLuint program, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLint)(*exec)(gl_slb, 1886 /* NFOSMESA_GLGETVARYINGLOCATIONNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetVertexArrayIntegeri_vEXT(GLuint vaobj, GLuint index, GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1887 /* NFOSMESA_GLGETVERTEXARRAYINTEGERI_VEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetVertexArrayIntegervEXT(GLuint vaobj, GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1888 /* NFOSMESA_GLGETVERTEXARRAYINTEGERVEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetVertexArrayPointeri_vEXT(GLuint vaobj, GLuint index, GLenum pname, void * *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1889 /* NFOSMESA_GLGETVERTEXARRAYPOINTERI_VEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetVertexArrayPointervEXT(GLuint vaobj, GLenum pname, void * *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1890 /* NFOSMESA_GLGETVERTEXARRAYPOINTERVEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetVertexAttribIiv(GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1891 /* NFOSMESA_GLGETVERTEXATTRIBIIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribIivEXT(GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1892 /* NFOSMESA_GLGETVERTEXATTRIBIIVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1893 /* NFOSMESA_GLGETVERTEXATTRIBIUIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribIuivEXT(GLuint index, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1894 /* NFOSMESA_GLGETVERTEXATTRIBIUIVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1895 /* NFOSMESA_GLGETVERTEXATTRIBLDV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribLdvEXT(GLuint index, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1896 /* NFOSMESA_GLGETVERTEXATTRIBLDVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribLi64vNV(GLuint index, GLenum pname, GLint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1897 /* NFOSMESA_GLGETVERTEXATTRIBLI64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribLui64vARB(GLuint index, GLenum pname, GLuint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1898 /* NFOSMESA_GLGETVERTEXATTRIBLUI64VARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribLui64vNV(GLuint index, GLenum pname, GLuint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1899 /* NFOSMESA_GLGETVERTEXATTRIBLUI64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribPointerv(GLuint index, GLenum pname, void * *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)pointer;
	(*exec)(gl_slb, 1900 /* NFOSMESA_GLGETVERTEXATTRIBPOINTERV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1901 /* NFOSMESA_GLGETVERTEXATTRIBDV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1902 /* NFOSMESA_GLGETVERTEXATTRIBFV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1903 /* NFOSMESA_GLGETVERTEXATTRIBIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glGetVideoCaptureStreamdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1904 /* NFOSMESA_GLGETVIDEOCAPTURESTREAMDVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glGetVideoCaptureStreamfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1905 /* NFOSMESA_GLGETVIDEOCAPTURESTREAMFVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glGetVideoCaptureStreamivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1906 /* NFOSMESA_GLGETVIDEOCAPTURESTREAMIVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glGetVideoCaptureivNV(GLuint video_capture_slot, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1907 /* NFOSMESA_GLGETVIDEOCAPTUREIVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glGetVideoi64vNV(GLuint video_slot, GLenum pname, GLint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1908 /* NFOSMESA_GLGETVIDEOI64VNV */, SLB_NARGS(2), gl_pub, &video_slot);
}

static void APIENTRY exec_glGetVideoivNV(GLuint video_slot, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1909 /* NFOSMESA_GLGETVIDEOIVNV */, SLB_NARGS(2), gl_pub, &video_slot);
}

static void APIENTRY exec_glGetVideoui64vNV(GLuint video_slot, GLenum pname, GLuint64EXT *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1910 /* NFOSMESA_GLGETVIDEOUI64VNV */, SLB_NARGS(2), gl_pub, &video_slot);
}

static void APIENTRY exec_glGetVideouivNV(GLuint video_slot, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1911 /* NFOSMESA_GLGETVIDEOUIVNV */, SLB_NARGS(2), gl_pub, &video_slot);
}

static void APIENTRY exec_glGetnColorTableARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)table;
	(*exec)(gl_slb, 1912 /* NFOSMESA_GLGETNCOLORTABLEARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnCompressedTexImageARB(GLenum target, GLint lod, GLsizei bufSize, void *img)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)lod;
	(void)bufSize;
	(void)img;
	(*exec)(gl_slb, 1913 /* NFOSMESA_GLGETNCOMPRESSEDTEXIMAGEARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnConvolutionFilterARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)image;
	(*exec)(gl_slb, 1914 /* NFOSMESA_GLGETNCONVOLUTIONFILTERARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnHistogramARB(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 1915 /* NFOSMESA_GLGETNHISTOGRAMARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMapdvARB(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)bufSize;
	(void)v;
	(*exec)(gl_slb, 1916 /* NFOSMESA_GLGETNMAPDVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMapfvARB(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)bufSize;
	(void)v;
	(*exec)(gl_slb, 1917 /* NFOSMESA_GLGETNMAPFVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMapivARB(GLenum target, GLenum query, GLsizei bufSize, GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)bufSize;
	(void)v;
	(*exec)(gl_slb, 1918 /* NFOSMESA_GLGETNMAPIVARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMinmaxARB(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 1919 /* NFOSMESA_GLGETNMINMAXARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnPixelMapfvARB(GLenum map, GLsizei bufSize, GLfloat *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 1920 /* NFOSMESA_GLGETNPIXELMAPFVARB */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetnPixelMapuivARB(GLenum map, GLsizei bufSize, GLuint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 1921 /* NFOSMESA_GLGETNPIXELMAPUIVARB */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetnPixelMapusvARB(GLenum map, GLsizei bufSize, GLushort *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 1922 /* NFOSMESA_GLGETNPIXELMAPUSVARB */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetnPolygonStippleARB(GLsizei bufSize, GLubyte *pattern)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pattern;
	(*exec)(gl_slb, 1923 /* NFOSMESA_GLGETNPOLYGONSTIPPLEARB */, SLB_NARGS(2), gl_pub, &bufSize);
}

static void APIENTRY exec_glGetnSeparableFilterARB(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)rowBufSize;
	(void)row;
	(void)columnBufSize;
	(void)column;
	(void)span;
	(*exec)(gl_slb, 1924 /* NFOSMESA_GLGETNSEPARABLEFILTERARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnTexImageARB(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *img)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)img;
	(*exec)(gl_slb, 1925 /* NFOSMESA_GLGETNTEXIMAGEARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnUniformdvARB(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 1926 /* NFOSMESA_GLGETNUNIFORMDVARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetnUniformfvARB(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 1927 /* NFOSMESA_GLGETNUNIFORMFVARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetnUniformivARB(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 1928 /* NFOSMESA_GLGETNUNIFORMIVARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetnUniformuivARB(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 1929 /* NFOSMESA_GLGETNUNIFORMUIVARB */, SLB_NARGS(2), gl_pub, &program);
}

static GLsync APIENTRY exec_glImportSyncEXT(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)external_sync;
	(void)flags;
	return (GLsync)(*exec)(gl_slb, 1930 /* NFOSMESA_GLIMPORTSYNCEXT */, SLB_NARGS(2), gl_pub, &external_sync_type);
}

static void APIENTRY exec_glIndexFormatNV(GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(*exec)(gl_slb, 1931 /* NFOSMESA_GLINDEXFORMATNV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glIndexxOES(GLfixed component)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1932 /* NFOSMESA_GLINDEXXOES */, SLB_NARGS(2), gl_pub, &component);
}

static void APIENTRY exec_glIndexxvOES(const GLfixed *component)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1933 /* NFOSMESA_GLINDEXXVOES */, SLB_NARGS(2), gl_pub, &component);
}

static void APIENTRY exec_glInsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)marker;
	(*exec)(gl_slb, 1934 /* NFOSMESA_GLINSERTEVENTMARKEREXT */, SLB_NARGS(2), gl_pub, &length);
}

static void APIENTRY exec_glInterpolatePathsNV(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pathA;
	(void)pathB;
	(void)weight;
	(*exec)(gl_slb, 1935 /* NFOSMESA_GLINTERPOLATEPATHSNV */, SLB_NARGS(2), gl_pub, &resultPath);
}

static void APIENTRY exec_glInvalidateBufferData(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1936 /* NFOSMESA_GLINVALIDATEBUFFERDATA */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(*exec)(gl_slb, 1937 /* NFOSMESA_GLINVALIDATEBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numAttachments;
	(void)attachments;
	(*exec)(gl_slb, 1938 /* NFOSMESA_GLINVALIDATEFRAMEBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numAttachments;
	(void)attachments;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 1939 /* NFOSMESA_GLINVALIDATESUBFRAMEBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glInvalidateTexImage(GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(*exec)(gl_slb, 1940 /* NFOSMESA_GLINVALIDATETEXIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glInvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(*exec)(gl_slb, 1941 /* NFOSMESA_GLINVALIDATETEXSUBIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static GLboolean APIENTRY exec_glIsBufferResidentNV(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1942 /* NFOSMESA_GLISBUFFERRESIDENTNV */, SLB_NARGS(2), gl_pub, &target);
}

static GLboolean APIENTRY exec_glIsEnabledIndexedEXT(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	return (GLboolean)(*exec)(gl_slb, 1943 /* NFOSMESA_GLISENABLEDINDEXEDEXT */, SLB_NARGS(2), gl_pub, &target);
}

static GLboolean APIENTRY exec_glIsEnabledi(GLenum target, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	return (GLboolean)(*exec)(gl_slb, 1944 /* NFOSMESA_GLISENABLEDI */, SLB_NARGS(2), gl_pub, &target);
}

static GLboolean APIENTRY exec_glIsFramebuffer(GLuint framebuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1945 /* NFOSMESA_GLISFRAMEBUFFER */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static GLboolean APIENTRY exec_glIsFramebufferEXT(GLuint framebuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1946 /* NFOSMESA_GLISFRAMEBUFFEREXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static GLboolean APIENTRY exec_glIsImageHandleResidentARB(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1947 /* NFOSMESA_GLISIMAGEHANDLERESIDENTARB */, SLB_NARGS(2), gl_pub, &handle);
}

static GLboolean APIENTRY exec_glIsImageHandleResidentNV(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1948 /* NFOSMESA_GLISIMAGEHANDLERESIDENTNV */, SLB_NARGS(2), gl_pub, &handle);
}

static GLboolean APIENTRY exec_glIsNameAMD(GLenum identifier, GLuint name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLboolean)(*exec)(gl_slb, 1949 /* NFOSMESA_GLISNAMEAMD */, SLB_NARGS(2), gl_pub, &identifier);
}

static GLboolean APIENTRY exec_glIsNamedBufferResidentNV(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1950 /* NFOSMESA_GLISNAMEDBUFFERRESIDENTNV */, SLB_NARGS(2), gl_pub, &buffer);
}

static GLboolean APIENTRY exec_glIsNamedStringARB(GLint namelen, const GLchar *name)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	return (GLboolean)(*exec)(gl_slb, 1951 /* NFOSMESA_GLISNAMEDSTRINGARB */, SLB_NARGS(2), gl_pub, &namelen);
}

static GLboolean APIENTRY exec_glIsPathNV(GLuint path)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1952 /* NFOSMESA_GLISPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static GLboolean APIENTRY exec_glIsPointInFillPathNV(GLuint path, GLuint mask, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mask;
	(void)x;
	(void)y;
	return (GLboolean)(*exec)(gl_slb, 1953 /* NFOSMESA_GLISPOINTINFILLPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static GLboolean APIENTRY exec_glIsPointInStrokePathNV(GLuint path, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	return (GLboolean)(*exec)(gl_slb, 1954 /* NFOSMESA_GLISPOINTINSTROKEPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static GLboolean APIENTRY exec_glIsProgram(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1955 /* NFOSMESA_GLISPROGRAM */, SLB_NARGS(2), gl_pub, &program);
}

static GLboolean APIENTRY exec_glIsProgramPipeline(GLuint pipeline)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1956 /* NFOSMESA_GLISPROGRAMPIPELINE */, SLB_NARGS(2), gl_pub, &pipeline);
}

static GLboolean APIENTRY exec_glIsRenderbuffer(GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1957 /* NFOSMESA_GLISRENDERBUFFER */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static GLboolean APIENTRY exec_glIsRenderbufferEXT(GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1958 /* NFOSMESA_GLISRENDERBUFFEREXT */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static GLboolean APIENTRY exec_glIsSampler(GLuint sampler)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1959 /* NFOSMESA_GLISSAMPLER */, SLB_NARGS(2), gl_pub, &sampler);
}

static GLboolean APIENTRY exec_glIsShader(GLuint shader)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1960 /* NFOSMESA_GLISSHADER */, SLB_NARGS(2), gl_pub, &shader);
}

static GLboolean APIENTRY exec_glIsSync(GLsync sync)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1961 /* NFOSMESA_GLISSYNC */, SLB_NARGS(2), gl_pub, &sync);
}

static GLboolean APIENTRY exec_glIsTextureHandleResidentARB(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1962 /* NFOSMESA_GLISTEXTUREHANDLERESIDENTARB */, SLB_NARGS(2), gl_pub, &handle);
}

static GLboolean APIENTRY exec_glIsTextureHandleResidentNV(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1963 /* NFOSMESA_GLISTEXTUREHANDLERESIDENTNV */, SLB_NARGS(2), gl_pub, &handle);
}

static GLboolean APIENTRY exec_glIsTransformFeedback(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1964 /* NFOSMESA_GLISTRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, &id);
}

static GLboolean APIENTRY exec_glIsTransformFeedbackNV(GLuint id)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1965 /* NFOSMESA_GLISTRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, &id);
}

static GLboolean APIENTRY exec_glIsVertexArray(GLuint array)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 1966 /* NFOSMESA_GLISVERTEXARRAY */, SLB_NARGS(2), gl_pub, &array);
}

static GLboolean APIENTRY exec_glIsVertexAttribEnabledAPPLE(GLuint index, GLenum pname)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	return (GLboolean)(*exec)(gl_slb, 1967 /* NFOSMESA_GLISVERTEXATTRIBENABLEDAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)object;
	(void)length;
	(void)label;
	(*exec)(gl_slb, 1968 /* NFOSMESA_GLLABELOBJECTEXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glLightModelxOES(GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1969 /* NFOSMESA_GLLIGHTMODELXOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glLightModelxvOES(GLenum pname, const GLfixed *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 1970 /* NFOSMESA_GLLIGHTMODELXVOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glLightxOES(GLenum light, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 1971 /* NFOSMESA_GLLIGHTXOES */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glLightxvOES(GLenum light, GLenum pname, const GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 1972 /* NFOSMESA_GLLIGHTXVOES */, SLB_NARGS(2), gl_pub, &light);
}

static void APIENTRY exec_glLineWidthxOES(GLfixed width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1973 /* NFOSMESA_GLLINEWIDTHXOES */, SLB_NARGS(2), gl_pub, &width);
}

static void APIENTRY exec_glLinkProgram(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1974 /* NFOSMESA_GLLINKPROGRAM */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glLoadMatrixxOES(const GLfixed *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1975 /* NFOSMESA_GLLOADMATRIXXOES */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glLoadTransposeMatrixxOES(const GLfixed *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1976 /* NFOSMESA_GLLOADTRANSPOSEMATRIXXOES */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMakeBufferNonResidentNV(GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1977 /* NFOSMESA_GLMAKEBUFFERNONRESIDENTNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMakeBufferResidentNV(GLenum target, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	(*exec)(gl_slb, 1978 /* NFOSMESA_GLMAKEBUFFERRESIDENTNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMakeImageHandleNonResidentARB(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1979 /* NFOSMESA_GLMAKEIMAGEHANDLENONRESIDENTARB */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeImageHandleNonResidentNV(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1980 /* NFOSMESA_GLMAKEIMAGEHANDLENONRESIDENTNV */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeImageHandleResidentARB(GLuint64 handle, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	(*exec)(gl_slb, 1981 /* NFOSMESA_GLMAKEIMAGEHANDLERESIDENTARB */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeImageHandleResidentNV(GLuint64 handle, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	(*exec)(gl_slb, 1982 /* NFOSMESA_GLMAKEIMAGEHANDLERESIDENTNV */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeNamedBufferNonResidentNV(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1983 /* NFOSMESA_GLMAKENAMEDBUFFERNONRESIDENTNV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glMakeNamedBufferResidentNV(GLuint buffer, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	(*exec)(gl_slb, 1984 /* NFOSMESA_GLMAKENAMEDBUFFERRESIDENTNV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glMakeTextureHandleNonResidentARB(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1985 /* NFOSMESA_GLMAKETEXTUREHANDLENONRESIDENTARB */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeTextureHandleNonResidentNV(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1986 /* NFOSMESA_GLMAKETEXTUREHANDLENONRESIDENTNV */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeTextureHandleResidentARB(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1987 /* NFOSMESA_GLMAKETEXTUREHANDLERESIDENTARB */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMakeTextureHandleResidentNV(GLuint64 handle)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 1988 /* NFOSMESA_GLMAKETEXTUREHANDLERESIDENTNV */, SLB_NARGS(2), gl_pub, &handle);
}

static void APIENTRY exec_glMap1xOES(GLenum target, GLfixed u1, GLfixed u2, GLint stride, GLint order, GLfixed points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)stride;
	(void)order;
	(void)points;
	(*exec)(gl_slb, 1989 /* NFOSMESA_GLMAP1XOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMap2xOES(GLenum target, GLfixed u1, GLfixed u2, GLint ustride, GLint uorder, GLfixed v1, GLfixed v2, GLint vstride, GLint vorder, GLfixed points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)points;
	(*exec)(gl_slb, 1990 /* NFOSMESA_GLMAP2XOES */, SLB_NARGS(2), gl_pub, &target);
}

static void * APIENTRY exec_glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(void)access;
	return (void *)(*exec)(gl_slb, 1991 /* NFOSMESA_GLMAPBUFFERRANGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glMapGrid1xOES(GLint n, GLfixed u1, GLfixed u2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(*exec)(gl_slb, 1992 /* NFOSMESA_GLMAPGRID1XOES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glMapGrid2xOES(GLint n, GLfixed u1, GLfixed u2, GLfixed v1, GLfixed v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)u1;
	(void)u2;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 1993 /* NFOSMESA_GLMAPGRID2XOES */, SLB_NARGS(2), gl_pub, &n);
}

static void * APIENTRY exec_glMapNamedBufferEXT(GLuint buffer, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	return (void *)(*exec)(gl_slb, 1994 /* NFOSMESA_GLMAPNAMEDBUFFEREXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void * APIENTRY exec_glMapNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(void)access;
	return (void *)(*exec)(gl_slb, 1995 /* NFOSMESA_GLMAPNAMEDBUFFERRANGEEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void * APIENTRY exec_glMapTexture2DINTEL(GLuint texture, GLint level, GLbitfield access, const GLint *stride, const GLenum *layout)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)access;
	(void)stride;
	(void)layout;
	return (void *)(*exec)(gl_slb, 1996 /* NFOSMESA_GLMAPTEXTURE2DINTEL */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMapVertexAttrib1dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)u1;
	(void)u2;
	(void)stride;
	(void)order;
	(void)points;
	(*exec)(gl_slb, 1997 /* NFOSMESA_GLMAPVERTEXATTRIB1DAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glMapVertexAttrib1fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)u1;
	(void)u2;
	(void)stride;
	(void)order;
	(void)points;
	(*exec)(gl_slb, 1998 /* NFOSMESA_GLMAPVERTEXATTRIB1FAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glMapVertexAttrib2dAPPLE(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)points;
	(*exec)(gl_slb, 1999 /* NFOSMESA_GLMAPVERTEXATTRIB2DAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glMapVertexAttrib2fAPPLE(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)u1;
	(void)u2;
	(void)ustride;
	(void)uorder;
	(void)v1;
	(void)v2;
	(void)vstride;
	(void)vorder;
	(void)points;
	(*exec)(gl_slb, 2000 /* NFOSMESA_GLMAPVERTEXATTRIB2FAPPLE */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glMaterialxOES(GLenum face, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2001 /* NFOSMESA_GLMATERIALXOES */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glMaterialxvOES(GLenum face, GLenum pname, const GLfixed *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2002 /* NFOSMESA_GLMATERIALXVOES */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glMatrixFrustumEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)left;
	(void)right;
	(void)bottom;
	(void)top;
	(void)zNear;
	(void)zFar;
	(*exec)(gl_slb, 2003 /* NFOSMESA_GLMATRIXFRUSTUMEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixLoadIdentityEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2004 /* NFOSMESA_GLMATRIXLOADIDENTITYEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixLoadTransposedEXT(GLenum mode, const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2005 /* NFOSMESA_GLMATRIXLOADTRANSPOSEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixLoadTransposefEXT(GLenum mode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2006 /* NFOSMESA_GLMATRIXLOADTRANSPOSEFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixLoaddEXT(GLenum mode, const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2007 /* NFOSMESA_GLMATRIXLOADDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixLoadfEXT(GLenum mode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2008 /* NFOSMESA_GLMATRIXLOADFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixMultTransposedEXT(GLenum mode, const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2009 /* NFOSMESA_GLMATRIXMULTTRANSPOSEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixMultTransposefEXT(GLenum mode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2010 /* NFOSMESA_GLMATRIXMULTTRANSPOSEFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixMultdEXT(GLenum mode, const GLdouble *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2011 /* NFOSMESA_GLMATRIXMULTDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixMultfEXT(GLenum mode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2012 /* NFOSMESA_GLMATRIXMULTFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixOrthoEXT(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)left;
	(void)right;
	(void)bottom;
	(void)top;
	(void)zNear;
	(void)zFar;
	(*exec)(gl_slb, 2013 /* NFOSMESA_GLMATRIXORTHOEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixPopEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2014 /* NFOSMESA_GLMATRIXPOPEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixPushEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2015 /* NFOSMESA_GLMATRIXPUSHEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixRotatedEXT(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)angle;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2016 /* NFOSMESA_GLMATRIXROTATEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixRotatefEXT(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)angle;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2017 /* NFOSMESA_GLMATRIXROTATEFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixScaledEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2018 /* NFOSMESA_GLMATRIXSCALEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixScalefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2019 /* NFOSMESA_GLMATRIXSCALEFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixTranslatedEXT(GLenum mode, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2020 /* NFOSMESA_GLMATRIXTRANSLATEDEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMatrixTranslatefEXT(GLenum mode, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2021 /* NFOSMESA_GLMATRIXTRANSLATEFEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMemoryBarrier(GLbitfield barriers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2022 /* NFOSMESA_GLMEMORYBARRIER */, SLB_NARGS(2), gl_pub, &barriers);
}

static void APIENTRY exec_glMemoryBarrierEXT(GLbitfield barriers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2023 /* NFOSMESA_GLMEMORYBARRIEREXT */, SLB_NARGS(2), gl_pub, &barriers);
}

static void APIENTRY exec_glMinSampleShading(GLfloat value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2024 /* NFOSMESA_GLMINSAMPLESHADING */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glMinSampleShadingARB(GLfloat value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2025 /* NFOSMESA_GLMINSAMPLESHADINGARB */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glMultMatrixxOES(const GLfixed *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2026 /* NFOSMESA_GLMULTMATRIXXOES */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultTransposeMatrixxOES(const GLfixed *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2027 /* NFOSMESA_GLMULTTRANSPOSEMATRIXXOES */, SLB_NARGS(2), gl_pub, &m);
}

static void APIENTRY exec_glMultiDrawArraysIndirect(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirect;
	(void)drawcount;
	(void)stride;
	(*exec)(gl_slb, 2028 /* NFOSMESA_GLMULTIDRAWARRAYSINDIRECT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawArraysIndirectAMD(GLenum mode, const void *indirect, GLsizei primcount, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirect;
	(void)primcount;
	(void)stride;
	(*exec)(gl_slb, 2029 /* NFOSMESA_GLMULTIDRAWARRAYSINDIRECTAMD */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawArraysIndirectBindlessNV(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirect;
	(void)drawCount;
	(void)stride;
	(void)vertexBufferCount;
	(*exec)(gl_slb, 2030 /* NFOSMESA_GLMULTIDRAWARRAYSINDIRECTBINDLESSNV */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawArraysIndirectCountARB(GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirect;
	(void)drawcount;
	(void)maxdrawcount;
	(void)stride;
	(*exec)(gl_slb, 2031 /* NFOSMESA_GLMULTIDRAWARRAYSINDIRECTCOUNTARB */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei drawcount, const GLint *basevertex)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)type;
	(void)indices;
	(void)drawcount;
	(void)basevertex;
	(*exec)(gl_slb, 2032 /* NFOSMESA_GLMULTIDRAWELEMENTSBASEVERTEX */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementsIndirect(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)indirect;
	(void)drawcount;
	(void)stride;
	(*exec)(gl_slb, 2033 /* NFOSMESA_GLMULTIDRAWELEMENTSINDIRECT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementsIndirectAMD(GLenum mode, GLenum type, const void *indirect, GLsizei primcount, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)indirect;
	(void)primcount;
	(void)stride;
	(*exec)(gl_slb, 2034 /* NFOSMESA_GLMULTIDRAWELEMENTSINDIRECTAMD */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementsIndirectBindlessNV(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)indirect;
	(void)drawCount;
	(void)stride;
	(void)vertexBufferCount;
	(*exec)(gl_slb, 2035 /* NFOSMESA_GLMULTIDRAWELEMENTSINDIRECTBINDLESSNV */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiDrawElementsIndirectCountARB(GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)indirect;
	(void)drawcount;
	(void)maxdrawcount;
	(void)stride;
	(*exec)(gl_slb, 2036 /* NFOSMESA_GLMULTIDRAWELEMENTSINDIRECTCOUNTARB */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glMultiTexBufferEXT(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)internalformat;
	(void)buffer;
	(*exec)(gl_slb, 2037 /* NFOSMESA_GLMULTITEXBUFFEREXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexCoord1bOES(GLenum texture, GLbyte32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 2038 /* NFOSMESA_GLMULTITEXCOORD1BOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord1bvOES(GLenum texture, const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2039 /* NFOSMESA_GLMULTITEXCOORD1BVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord1xOES(GLenum texture, GLfixed s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(*exec)(gl_slb, 2040 /* NFOSMESA_GLMULTITEXCOORD1XOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord1xvOES(GLenum texture, const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2041 /* NFOSMESA_GLMULTITEXCOORD1XVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord2bOES(GLenum texture, GLbyte32 s, GLbyte32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 2042 /* NFOSMESA_GLMULTITEXCOORD2BOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord2bvOES(GLenum texture, const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2043 /* NFOSMESA_GLMULTITEXCOORD2BVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord2xOES(GLenum texture, GLfixed s, GLfixed t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(*exec)(gl_slb, 2044 /* NFOSMESA_GLMULTITEXCOORD2XOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord2xvOES(GLenum texture, const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2045 /* NFOSMESA_GLMULTITEXCOORD2XVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord3bOES(GLenum texture, GLbyte32 s, GLbyte32 t, GLbyte32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 2046 /* NFOSMESA_GLMULTITEXCOORD3BOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord3bvOES(GLenum texture, const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2047 /* NFOSMESA_GLMULTITEXCOORD3BVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord3xOES(GLenum texture, GLfixed s, GLfixed t, GLfixed r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 2048 /* NFOSMESA_GLMULTITEXCOORD3XOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord3xvOES(GLenum texture, const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2049 /* NFOSMESA_GLMULTITEXCOORD3XVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord4bOES(GLenum texture, GLbyte32 s, GLbyte32 t, GLbyte32 r, GLbyte32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 2050 /* NFOSMESA_GLMULTITEXCOORD4BOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord4bvOES(GLenum texture, const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2051 /* NFOSMESA_GLMULTITEXCOORD4BVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord4xOES(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)s;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 2052 /* NFOSMESA_GLMULTITEXCOORD4XOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoord4xvOES(GLenum texture, const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2053 /* NFOSMESA_GLMULTITEXCOORD4XVOES */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2054 /* NFOSMESA_GLMULTITEXCOORDP1UI */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2055 /* NFOSMESA_GLMULTITEXCOORDP1UIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2056 /* NFOSMESA_GLMULTITEXCOORDP2UI */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2057 /* NFOSMESA_GLMULTITEXCOORDP2UIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2058 /* NFOSMESA_GLMULTITEXCOORDP3UI */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2059 /* NFOSMESA_GLMULTITEXCOORDP3UIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2060 /* NFOSMESA_GLMULTITEXCOORDP4UI */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)coords;
	(*exec)(gl_slb, 2061 /* NFOSMESA_GLMULTITEXCOORDP4UIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glMultiTexCoordPointerEXT(GLenum texunit, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2062 /* NFOSMESA_GLMULTITEXCOORDPOINTEREXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexEnvfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2063 /* NFOSMESA_GLMULTITEXENVFEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2064 /* NFOSMESA_GLMULTITEXENVFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexEnviEXT(GLenum texunit, GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2065 /* NFOSMESA_GLMULTITEXENVIEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2066 /* NFOSMESA_GLMULTITEXENVIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexGendEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2067 /* NFOSMESA_GLMULTITEXGENDEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2068 /* NFOSMESA_GLMULTITEXGENDVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexGenfEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2069 /* NFOSMESA_GLMULTITEXGENFEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2070 /* NFOSMESA_GLMULTITEXGENFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexGeniEXT(GLenum texunit, GLenum coord, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2071 /* NFOSMESA_GLMULTITEXGENIEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coord;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2072 /* NFOSMESA_GLMULTITEXGENIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2073 /* NFOSMESA_GLMULTITEXIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2074 /* NFOSMESA_GLMULTITEXIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2075 /* NFOSMESA_GLMULTITEXIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2076 /* NFOSMESA_GLMULTITEXPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2077 /* NFOSMESA_GLMULTITEXPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexParameterfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2078 /* NFOSMESA_GLMULTITEXPARAMETERFEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2079 /* NFOSMESA_GLMULTITEXPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexParameteriEXT(GLenum texunit, GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2080 /* NFOSMESA_GLMULTITEXPARAMETERIEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2081 /* NFOSMESA_GLMULTITEXPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexRenderbufferEXT(GLenum texunit, GLenum target, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)renderbuffer;
	(*exec)(gl_slb, 2082 /* NFOSMESA_GLMULTITEXRENDERBUFFEREXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2083 /* NFOSMESA_GLMULTITEXSUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2084 /* NFOSMESA_GLMULTITEXSUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2085 /* NFOSMESA_GLMULTITEXSUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texunit);
}

static void APIENTRY exec_glNamedBufferDataEXT(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)data;
	(void)usage;
	(*exec)(gl_slb, 2086 /* NFOSMESA_GLNAMEDBUFFERDATAEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glNamedBufferStorageEXT(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)data;
	(void)flags;
	(*exec)(gl_slb, 2087 /* NFOSMESA_GLNAMEDBUFFERSTORAGEEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 2088 /* NFOSMESA_GLNAMEDBUFFERSUBDATAEXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glNamedCopyBufferSubDataEXT(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)writeBuffer;
	(void)readOffset;
	(void)writeOffset;
	(void)size;
	(*exec)(gl_slb, 2089 /* NFOSMESA_GLNAMEDCOPYBUFFERSUBDATAEXT */, SLB_NARGS(2), gl_pub, &readBuffer);
}

static void APIENTRY exec_glNamedFramebufferParameteriEXT(GLuint framebuffer, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2090 /* NFOSMESA_GLNAMEDFRAMEBUFFERPARAMETERIEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferRenderbufferEXT(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)renderbuffertarget;
	(void)renderbuffer;
	(*exec)(gl_slb, 2091 /* NFOSMESA_GLNAMEDFRAMEBUFFERRENDERBUFFEREXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferTexture1DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 2092 /* NFOSMESA_GLNAMEDFRAMEBUFFERTEXTURE1DEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferTexture2DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 2093 /* NFOSMESA_GLNAMEDFRAMEBUFFERTEXTURE2DEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferTexture3DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)textarget;
	(void)texture;
	(void)level;
	(void)zoffset;
	(*exec)(gl_slb, 2094 /* NFOSMESA_GLNAMEDFRAMEBUFFERTEXTURE3DEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferTextureEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(*exec)(gl_slb, 2095 /* NFOSMESA_GLNAMEDFRAMEBUFFERTEXTUREEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferTextureFaceEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)face;
	(*exec)(gl_slb, 2096 /* NFOSMESA_GLNAMEDFRAMEBUFFERTEXTUREFACEEXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedFramebufferTextureLayerEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)layer;
	(*exec)(gl_slb, 2097 /* NFOSMESA_GLNAMEDFRAMEBUFFERTEXTURELAYEREXT */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glNamedProgramLocalParameter4dEXT(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2098 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETER4DEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameter4dvEXT(GLuint program, GLenum target, GLuint index, const GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2099 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETER4DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameter4fEXT(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2100 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETER4FEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameter4fvEXT(GLuint program, GLenum target, GLuint index, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2101 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETER4FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameterI4iEXT(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2102 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERI4IEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameterI4ivEXT(GLuint program, GLenum target, GLuint index, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2103 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERI4IVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameterI4uiEXT(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2104 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERI4UIEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameterI4uivEXT(GLuint program, GLenum target, GLuint index, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2105 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERI4UIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParameters4fvEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2106 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERS4FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParametersI4ivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2107 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERSI4IVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramLocalParametersI4uivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2108 /* NFOSMESA_GLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedProgramStringEXT(GLuint program, GLenum target, GLenum format, GLsizei len, const void *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)format;
	(void)len;
	(void)string;
	(*exec)(gl_slb, 2109 /* NFOSMESA_GLNAMEDPROGRAMSTRINGEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glNamedRenderbufferStorageEXT(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2110 /* NFOSMESA_GLNAMEDRENDERBUFFERSTORAGEEXT */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static void APIENTRY exec_glNamedRenderbufferStorageMultisampleCoverageEXT(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coverageSamples;
	(void)colorSamples;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2111 /* NFOSMESA_GLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXT */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static void APIENTRY exec_glNamedRenderbufferStorageMultisampleEXT(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2112 /* NFOSMESA_GLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXT */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static void APIENTRY exec_glNamedStringARB(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)namelen;
	(void)name;
	(void)stringlen;
	(void)string;
	(*exec)(gl_slb, 2113 /* NFOSMESA_GLNAMEDSTRINGARB */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glNormal3xOES(GLfixed nx, GLfixed ny, GLfixed nz)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ny;
	(void)nz;
	(*exec)(gl_slb, 2114 /* NFOSMESA_GLNORMAL3XOES */, SLB_NARGS(2), gl_pub, &nx);
}

static void APIENTRY exec_glNormal3xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2115 /* NFOSMESA_GLNORMAL3XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glNormalFormatNV(GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(*exec)(gl_slb, 2116 /* NFOSMESA_GLNORMALFORMATNV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glNormalP3ui(GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2117 /* NFOSMESA_GLNORMALP3UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glNormalP3uiv(GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2118 /* NFOSMESA_GLNORMALP3UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)length;
	(void)label;
	(*exec)(gl_slb, 2119 /* NFOSMESA_GLOBJECTLABEL */, SLB_NARGS(2), gl_pub, &identifier);
}

static void APIENTRY exec_glObjectPtrLabel(const void *ptr, GLsizei length, const GLchar *label)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)length;
	(void)label;
	(*exec)(gl_slb, 2120 /* NFOSMESA_GLOBJECTPTRLABEL */, SLB_NARGS(2), gl_pub, &ptr);
}

static GLenum APIENTRY exec_glObjectPurgeableAPPLE(GLenum objectType, GLuint name, GLenum option)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)option;
	return (GLenum)(*exec)(gl_slb, 2121 /* NFOSMESA_GLOBJECTPURGEABLEAPPLE */, SLB_NARGS(2), gl_pub, &objectType);
}

static GLenum APIENTRY exec_glObjectUnpurgeableAPPLE(GLenum objectType, GLuint name, GLenum option)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)name;
	(void)option;
	return (GLenum)(*exec)(gl_slb, 2122 /* NFOSMESA_GLOBJECTUNPURGEABLEAPPLE */, SLB_NARGS(2), gl_pub, &objectType);
}

static void APIENTRY exec_glOrthofOES(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)b;
	(void)t;
	(void)n;
	(void)f;
	(*exec)(gl_slb, 2123 /* NFOSMESA_GLORTHOFOES */, SLB_NARGS(2), gl_pub, &l);
}

static void APIENTRY exec_glOrthoxOES(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)r;
	(void)b;
	(void)t;
	(void)n;
	(void)f;
	(*exec)(gl_slb, 2124 /* NFOSMESA_GLORTHOXOES */, SLB_NARGS(2), gl_pub, &l);
}

static void APIENTRY exec_glPassThroughxOES(GLfixed token)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2125 /* NFOSMESA_GLPASSTHROUGHXOES */, SLB_NARGS(2), gl_pub, &token);
}

static void APIENTRY exec_glPatchParameterfv(GLenum pname, const GLfloat *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)values;
	(*exec)(gl_slb, 2126 /* NFOSMESA_GLPATCHPARAMETERFV */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPatchParameteri(GLenum pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2127 /* NFOSMESA_GLPATCHPARAMETERI */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPathColorGenNV(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)genMode;
	(void)colorFormat;
	(void)coeffs;
	(*exec)(gl_slb, 2128 /* NFOSMESA_GLPATHCOLORGENNV */, SLB_NARGS(2), gl_pub, &color);
}

static void APIENTRY exec_glPathCommandsNV(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numCommands;
	(void)commands;
	(void)numCoords;
	(void)coordType;
	(void)coords;
	(*exec)(gl_slb, 2129 /* NFOSMESA_GLPATHCOMMANDSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathCoordsNV(GLuint path, GLsizei numCoords, GLenum coordType, const void *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numCoords;
	(void)coordType;
	(void)coords;
	(*exec)(gl_slb, 2130 /* NFOSMESA_GLPATHCOORDSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathCoverDepthFuncNV(GLenum func)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2131 /* NFOSMESA_GLPATHCOVERDEPTHFUNCNV */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glPathDashArrayNV(GLuint path, GLsizei dashCount, const GLfloat *dashArray)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)dashCount;
	(void)dashArray;
	(*exec)(gl_slb, 2132 /* NFOSMESA_GLPATHDASHARRAYNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathFogGenNV(GLenum genMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2133 /* NFOSMESA_GLPATHFOGGENNV */, SLB_NARGS(2), gl_pub, &genMode);
}

static void APIENTRY exec_glPathGlyphRangeNV(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fontTarget;
	(void)fontName;
	(void)fontStyle;
	(void)firstGlyph;
	(void)numGlyphs;
	(void)handleMissingGlyphs;
	(void)pathParameterTemplate;
	(void)emScale;
	(*exec)(gl_slb, 2134 /* NFOSMESA_GLPATHGLYPHRANGENV */, SLB_NARGS(2), gl_pub, &firstPathName);
}

static void APIENTRY exec_glPathGlyphsNV(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fontTarget;
	(void)fontName;
	(void)fontStyle;
	(void)numGlyphs;
	(void)type;
	(void)charcodes;
	(void)handleMissingGlyphs;
	(void)pathParameterTemplate;
	(void)emScale;
	(*exec)(gl_slb, 2135 /* NFOSMESA_GLPATHGLYPHSNV */, SLB_NARGS(2), gl_pub, &firstPathName);
}

static void APIENTRY exec_glPathParameterfNV(GLuint path, GLenum pname, GLfloat value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2136 /* NFOSMESA_GLPATHPARAMETERFNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathParameterfvNV(GLuint path, GLenum pname, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2137 /* NFOSMESA_GLPATHPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathParameteriNV(GLuint path, GLenum pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2138 /* NFOSMESA_GLPATHPARAMETERINV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathParameterivNV(GLuint path, GLenum pname, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2139 /* NFOSMESA_GLPATHPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathStencilDepthOffsetNV(GLfloat factor, GLfloat units)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)units;
	(*exec)(gl_slb, 2140 /* NFOSMESA_GLPATHSTENCILDEPTHOFFSETNV */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glPathStencilFuncNV(GLenum func, GLint ref, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ref;
	(void)mask;
	(*exec)(gl_slb, 2141 /* NFOSMESA_GLPATHSTENCILFUNCNV */, SLB_NARGS(2), gl_pub, &func);
}

static void APIENTRY exec_glPathStringNV(GLuint path, GLenum format, GLsizei length, const void *pathString)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)length;
	(void)pathString;
	(*exec)(gl_slb, 2142 /* NFOSMESA_GLPATHSTRINGNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathSubCommandsNV(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)commandStart;
	(void)commandsToDelete;
	(void)numCommands;
	(void)commands;
	(void)numCoords;
	(void)coordType;
	(void)coords;
	(*exec)(gl_slb, 2143 /* NFOSMESA_GLPATHSUBCOMMANDSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathSubCoordsNV(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coordStart;
	(void)numCoords;
	(void)coordType;
	(void)coords;
	(*exec)(gl_slb, 2144 /* NFOSMESA_GLPATHSUBCOORDSNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPathTexGenNV(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)genMode;
	(void)components;
	(void)coeffs;
	(*exec)(gl_slb, 2145 /* NFOSMESA_GLPATHTEXGENNV */, SLB_NARGS(2), gl_pub, &texCoordSet);
}

static void APIENTRY exec_glPauseTransformFeedback(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2146 /* NFOSMESA_GLPAUSETRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPauseTransformFeedbackNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2147 /* NFOSMESA_GLPAUSETRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPixelMapx(GLenum map, GLint size, const GLfixed *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)values;
	(*exec)(gl_slb, 2148 /* NFOSMESA_GLPIXELMAPX */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glPixelStorex(GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 2149 /* NFOSMESA_GLPIXELSTOREX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelTransferxOES(GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)param;
	(*exec)(gl_slb, 2150 /* NFOSMESA_GLPIXELTRANSFERXOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPixelZoomxOES(GLfixed xfactor, GLfixed yfactor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)yfactor;
	(*exec)(gl_slb, 2151 /* NFOSMESA_GLPIXELZOOMXOES */, SLB_NARGS(2), gl_pub, &xfactor);
}

static GLboolean APIENTRY exec_glPointAlongPathNV(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)startSegment;
	(void)numSegments;
	(void)distance;
	(void)x;
	(void)y;
	(void)tangentX;
	(void)tangentY;
	return (GLboolean)(*exec)(gl_slb, 2152 /* NFOSMESA_GLPOINTALONGPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glPointParameterxvOES(GLenum pname, const GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)params;
	(*exec)(gl_slb, 2153 /* NFOSMESA_GLPOINTPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glPointSizePointerAPPLE(GLenum type, GLsizei stride, const GLvoid *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2154 /* NFOSMESA_GLPOINTSIZEPOINTERAPPLE */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glPointSizexOES(GLfixed size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2155 /* NFOSMESA_GLPOINTSIZEXOES */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glPolygonOffsetxOES(GLfixed factor, GLfixed units)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)units;
	(*exec)(gl_slb, 2156 /* NFOSMESA_GLPOLYGONOFFSETXOES */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glPopDebugGroup(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2157 /* NFOSMESA_GLPOPDEBUGGROUP */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPopGroupMarkerEXT(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2158 /* NFOSMESA_GLPOPGROUPMARKEREXT */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glPresentFrameDualFillNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)minPresentTime;
	(void)beginPresentTimeId;
	(void)presentDurationId;
	(void)type;
	(void)target0;
	(void)fill0;
	(void)target1;
	(void)fill1;
	(void)target2;
	(void)fill2;
	(void)target3;
	(void)fill3;
	(*exec)(gl_slb, 2159 /* NFOSMESA_GLPRESENTFRAMEDUALFILLNV */, SLB_NARGS(2), gl_pub, &video_slot);
}

static void APIENTRY exec_glPresentFrameKeyedNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)minPresentTime;
	(void)beginPresentTimeId;
	(void)presentDurationId;
	(void)type;
	(void)target0;
	(void)fill0;
	(void)key0;
	(void)target1;
	(void)fill1;
	(void)key1;
	(*exec)(gl_slb, 2160 /* NFOSMESA_GLPRESENTFRAMEKEYEDNV */, SLB_NARGS(2), gl_pub, &video_slot);
}

static void APIENTRY exec_glPrimitiveRestartIndex(GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2161 /* NFOSMESA_GLPRIMITIVERESTARTINDEX */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glPrioritizeTexturesxOES(GLsizei n, const GLuint *textures, const GLfixed *priorities)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)textures;
	(void)priorities;
	(*exec)(gl_slb, 2162 /* NFOSMESA_GLPRIORITIZETEXTURESXOES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glProgramBinary(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)binaryFormat;
	(void)binary;
	(void)length;
	(*exec)(gl_slb, 2163 /* NFOSMESA_GLPROGRAMBINARY */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramBufferParametersIivNV(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bindingIndex;
	(void)wordIndex;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2164 /* NFOSMESA_GLPROGRAMBUFFERPARAMETERSIIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramBufferParametersIuivNV(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bindingIndex;
	(void)wordIndex;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2165 /* NFOSMESA_GLPROGRAMBUFFERPARAMETERSIUIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramBufferParametersfvNV(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bindingIndex;
	(void)wordIndex;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2166 /* NFOSMESA_GLPROGRAMBUFFERPARAMETERSFVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramCallbackMESA(GLenum target, GLprogramcallbackMESA callback, GLvoid *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)callback;
	(void)data;
	(*exec)(gl_slb, 2167 /* NFOSMESA_GLPROGRAMCALLBACKMESA */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2168 /* NFOSMESA_GLPROGRAMENVPARAMETERI4INV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameterI4ivNV(GLenum target, GLuint index, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2169 /* NFOSMESA_GLPROGRAMENVPARAMETERI4IVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2170 /* NFOSMESA_GLPROGRAMENVPARAMETERI4UINV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameterI4uivNV(GLenum target, GLuint index, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2171 /* NFOSMESA_GLPROGRAMENVPARAMETERI4UIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2172 /* NFOSMESA_GLPROGRAMENVPARAMETERS4FVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2173 /* NFOSMESA_GLPROGRAMENVPARAMETERSI4IVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramEnvParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2174 /* NFOSMESA_GLPROGRAMENVPARAMETERSI4UIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2175 /* NFOSMESA_GLPROGRAMLOCALPARAMETERI4INV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameterI4ivNV(GLenum target, GLuint index, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2176 /* NFOSMESA_GLPROGRAMLOCALPARAMETERI4IVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2177 /* NFOSMESA_GLPROGRAMLOCALPARAMETERI4UINV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameterI4uivNV(GLenum target, GLuint index, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)params;
	(*exec)(gl_slb, 2178 /* NFOSMESA_GLPROGRAMLOCALPARAMETERI4UIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2179 /* NFOSMESA_GLPROGRAMLOCALPARAMETERS4FVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2180 /* NFOSMESA_GLPROGRAMLOCALPARAMETERSI4IVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramLocalParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2181 /* NFOSMESA_GLPROGRAMLOCALPARAMETERSI4UIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramParameteri(GLuint program, GLenum pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2182 /* NFOSMESA_GLPROGRAMPARAMETERI */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramParameteriARB(GLuint program, GLenum pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2183 /* NFOSMESA_GLPROGRAMPARAMETERIARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramParameteriEXT(GLuint program, GLenum pname, GLint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)value;
	(*exec)(gl_slb, 2184 /* NFOSMESA_GLPROGRAMPARAMETERIEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramSubroutineParametersuivNV(GLenum target, GLsizei count, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)params;
	(*exec)(gl_slb, 2185 /* NFOSMESA_GLPROGRAMSUBROUTINEPARAMETERSUIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProgramUniform1d(GLuint program, GLint location, GLdouble v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2186 /* NFOSMESA_GLPROGRAMUNIFORM1D */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1dEXT(GLuint program, GLint location, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(*exec)(gl_slb, 2187 /* NFOSMESA_GLPROGRAMUNIFORM1DEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2188 /* NFOSMESA_GLPROGRAMUNIFORM1DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2189 /* NFOSMESA_GLPROGRAMUNIFORM1DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1f(GLuint program, GLint location, GLfloat v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2190 /* NFOSMESA_GLPROGRAMUNIFORM1F */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2191 /* NFOSMESA_GLPROGRAMUNIFORM1FEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2192 /* NFOSMESA_GLPROGRAMUNIFORM1FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2193 /* NFOSMESA_GLPROGRAMUNIFORM1FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1i(GLuint program, GLint location, GLint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2194 /* NFOSMESA_GLPROGRAMUNIFORM1I */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1i64NV(GLuint program, GLint location, GLint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(*exec)(gl_slb, 2195 /* NFOSMESA_GLPROGRAMUNIFORM1I64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2196 /* NFOSMESA_GLPROGRAMUNIFORM1I64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1iEXT(GLuint program, GLint location, GLint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2197 /* NFOSMESA_GLPROGRAMUNIFORM1IEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2198 /* NFOSMESA_GLPROGRAMUNIFORM1IV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2199 /* NFOSMESA_GLPROGRAMUNIFORM1IVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1ui(GLuint program, GLint location, GLuint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2200 /* NFOSMESA_GLPROGRAMUNIFORM1UI */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1ui64NV(GLuint program, GLint location, GLuint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(*exec)(gl_slb, 2201 /* NFOSMESA_GLPROGRAMUNIFORM1UI64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2202 /* NFOSMESA_GLPROGRAMUNIFORM1UI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(*exec)(gl_slb, 2203 /* NFOSMESA_GLPROGRAMUNIFORM1UIEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2204 /* NFOSMESA_GLPROGRAMUNIFORM1UIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform1uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2205 /* NFOSMESA_GLPROGRAMUNIFORM1UIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2d(GLuint program, GLint location, GLdouble v0, GLdouble v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2206 /* NFOSMESA_GLPROGRAMUNIFORM2D */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2dEXT(GLuint program, GLint location, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2207 /* NFOSMESA_GLPROGRAMUNIFORM2DEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2208 /* NFOSMESA_GLPROGRAMUNIFORM2DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2209 /* NFOSMESA_GLPROGRAMUNIFORM2DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2210 /* NFOSMESA_GLPROGRAMUNIFORM2F */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2211 /* NFOSMESA_GLPROGRAMUNIFORM2FEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2212 /* NFOSMESA_GLPROGRAMUNIFORM2FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2213 /* NFOSMESA_GLPROGRAMUNIFORM2FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2214 /* NFOSMESA_GLPROGRAMUNIFORM2I */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2215 /* NFOSMESA_GLPROGRAMUNIFORM2I64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2216 /* NFOSMESA_GLPROGRAMUNIFORM2I64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2217 /* NFOSMESA_GLPROGRAMUNIFORM2IEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2218 /* NFOSMESA_GLPROGRAMUNIFORM2IV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2219 /* NFOSMESA_GLPROGRAMUNIFORM2IVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2220 /* NFOSMESA_GLPROGRAMUNIFORM2UI */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2221 /* NFOSMESA_GLPROGRAMUNIFORM2UI64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2222 /* NFOSMESA_GLPROGRAMUNIFORM2UI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2223 /* NFOSMESA_GLPROGRAMUNIFORM2UIEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2224 /* NFOSMESA_GLPROGRAMUNIFORM2UIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform2uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2225 /* NFOSMESA_GLPROGRAMUNIFORM2UIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2226 /* NFOSMESA_GLPROGRAMUNIFORM3D */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3dEXT(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2227 /* NFOSMESA_GLPROGRAMUNIFORM3DEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2228 /* NFOSMESA_GLPROGRAMUNIFORM3DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2229 /* NFOSMESA_GLPROGRAMUNIFORM3DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2230 /* NFOSMESA_GLPROGRAMUNIFORM3F */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2231 /* NFOSMESA_GLPROGRAMUNIFORM3FEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2232 /* NFOSMESA_GLPROGRAMUNIFORM3FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2233 /* NFOSMESA_GLPROGRAMUNIFORM3FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2234 /* NFOSMESA_GLPROGRAMUNIFORM3I */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2235 /* NFOSMESA_GLPROGRAMUNIFORM3I64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2236 /* NFOSMESA_GLPROGRAMUNIFORM3I64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2237 /* NFOSMESA_GLPROGRAMUNIFORM3IEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2238 /* NFOSMESA_GLPROGRAMUNIFORM3IV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2239 /* NFOSMESA_GLPROGRAMUNIFORM3IVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2240 /* NFOSMESA_GLPROGRAMUNIFORM3UI */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2241 /* NFOSMESA_GLPROGRAMUNIFORM3UI64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2242 /* NFOSMESA_GLPROGRAMUNIFORM3UI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2243 /* NFOSMESA_GLPROGRAMUNIFORM3UIEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2244 /* NFOSMESA_GLPROGRAMUNIFORM3UIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform3uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2245 /* NFOSMESA_GLPROGRAMUNIFORM3UIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2246 /* NFOSMESA_GLPROGRAMUNIFORM4D */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4dEXT(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2247 /* NFOSMESA_GLPROGRAMUNIFORM4DEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4dv(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2248 /* NFOSMESA_GLPROGRAMUNIFORM4DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4dvEXT(GLuint program, GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2249 /* NFOSMESA_GLPROGRAMUNIFORM4DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2250 /* NFOSMESA_GLPROGRAMUNIFORM4F */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2251 /* NFOSMESA_GLPROGRAMUNIFORM4FEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2252 /* NFOSMESA_GLPROGRAMUNIFORM4FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2253 /* NFOSMESA_GLPROGRAMUNIFORM4FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2254 /* NFOSMESA_GLPROGRAMUNIFORM4I */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2255 /* NFOSMESA_GLPROGRAMUNIFORM4I64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2256 /* NFOSMESA_GLPROGRAMUNIFORM4I64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2257 /* NFOSMESA_GLPROGRAMUNIFORM4IEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2258 /* NFOSMESA_GLPROGRAMUNIFORM4IV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2259 /* NFOSMESA_GLPROGRAMUNIFORM4IVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2260 /* NFOSMESA_GLPROGRAMUNIFORM4UI */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2261 /* NFOSMESA_GLPROGRAMUNIFORM4UI64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2262 /* NFOSMESA_GLPROGRAMUNIFORM4UI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2263 /* NFOSMESA_GLPROGRAMUNIFORM4UIEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2264 /* NFOSMESA_GLPROGRAMUNIFORM4UIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniform4uivEXT(GLuint program, GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2265 /* NFOSMESA_GLPROGRAMUNIFORM4UIVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformHandleui64ARB(GLuint program, GLint location, GLuint64 value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)value;
	(*exec)(gl_slb, 2266 /* NFOSMESA_GLPROGRAMUNIFORMHANDLEUI64ARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformHandleui64NV(GLuint program, GLint location, GLuint64 value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)value;
	(*exec)(gl_slb, 2267 /* NFOSMESA_GLPROGRAMUNIFORMHANDLEUI64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformHandleui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)values;
	(*exec)(gl_slb, 2268 /* NFOSMESA_GLPROGRAMUNIFORMHANDLEUI64VARB */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformHandleui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64 *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)values;
	(*exec)(gl_slb, 2269 /* NFOSMESA_GLPROGRAMUNIFORMHANDLEUI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2270 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2271 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2272 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2273 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x3dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2274 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X3DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2275 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X3DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2276 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X3FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2277 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X3FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x4dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2278 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X4DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2279 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X4DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2280 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X4FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix2x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2281 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX2X4FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2282 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2283 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2284 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2285 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x2dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2286 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X2DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2287 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X2DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2288 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X2FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2289 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X2FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x4dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2290 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X4DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2291 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X4DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2292 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X4FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix3x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2293 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX3X4FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2294 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2295 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2296 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2297 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x2dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2298 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X2DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x2dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2299 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X2DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2300 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X2FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2301 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X2FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x3dv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2302 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X3DV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x3dvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2303 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X3DVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2304 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X3FV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformMatrix4x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2305 /* NFOSMESA_GLPROGRAMUNIFORMMATRIX4X3FVEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformui64NV(GLuint program, GLint location, GLuint64EXT value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)value;
	(*exec)(gl_slb, 2306 /* NFOSMESA_GLPROGRAMUNIFORMUI64NV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramUniformui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2307 /* NFOSMESA_GLPROGRAMUNIFORMUI64VNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glProgramVertexLimitNV(GLenum target, GLint limit)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)limit;
	(*exec)(gl_slb, 2308 /* NFOSMESA_GLPROGRAMVERTEXLIMITNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glProvokingVertex(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2309 /* NFOSMESA_GLPROVOKINGVERTEX */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glProvokingVertexEXT(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2310 /* NFOSMESA_GLPROVOKINGVERTEXEXT */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glPushClientAttribDefaultEXT(GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2311 /* NFOSMESA_GLPUSHCLIENTATTRIBDEFAULTEXT */, SLB_NARGS(2), gl_pub, &mask);
}

static void APIENTRY exec_glPushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)length;
	(void)message;
	(*exec)(gl_slb, 2312 /* NFOSMESA_GLPUSHDEBUGGROUP */, SLB_NARGS(2), gl_pub, &source);
}

static void APIENTRY exec_glPushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)marker;
	(*exec)(gl_slb, 2313 /* NFOSMESA_GLPUSHGROUPMARKEREXT */, SLB_NARGS(2), gl_pub, &length);
}

static void APIENTRY exec_glQueryCounter(GLuint id, GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(*exec)(gl_slb, 2314 /* NFOSMESA_GLQUERYCOUNTER */, SLB_NARGS(2), gl_pub, &id);
}

static GLbitfield APIENTRY exec_glQueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)exponent;
	return (GLbitfield)(*exec)(gl_slb, 2315 /* NFOSMESA_GLQUERYMATRIXXOES */, SLB_NARGS(2), gl_pub, &mantissa);
}

static void APIENTRY exec_glQueryObjectParameteruiAMD(GLenum target, GLuint id, GLenum pname, GLuint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)id;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2316 /* NFOSMESA_GLQUERYOBJECTPARAMETERUIAMD */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glRasterPos2xOES(GLfixed x, GLfixed y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 2317 /* NFOSMESA_GLRASTERPOS2XOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos2xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2318 /* NFOSMESA_GLRASTERPOS2XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glRasterPos3xOES(GLfixed x, GLfixed y, GLfixed z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2319 /* NFOSMESA_GLRASTERPOS3XOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos3xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2320 /* NFOSMESA_GLRASTERPOS3XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glRasterPos4xOES(GLfixed x, GLfixed y, GLfixed z, GLfixed w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2321 /* NFOSMESA_GLRASTERPOS4XOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRasterPos4xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2322 /* NFOSMESA_GLRASTERPOS4XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glReadnPixelsARB(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)data;
	(*exec)(gl_slb, 2323 /* NFOSMESA_GLREADNPIXELSARB */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glRectxOES(GLfixed x1, GLfixed y1, GLfixed x2, GLfixed y2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y1;
	(void)x2;
	(void)y2;
	(*exec)(gl_slb, 2324 /* NFOSMESA_GLRECTXOES */, SLB_NARGS(2), gl_pub, &x1);
}

static void APIENTRY exec_glRectxvOES(const GLfixed *v1, const GLfixed *v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v2;
	(*exec)(gl_slb, 2325 /* NFOSMESA_GLRECTXVOES */, SLB_NARGS(2), gl_pub, &v1);
}

static void APIENTRY exec_glReleaseShaderCompiler(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2326 /* NFOSMESA_GLRELEASESHADERCOMPILER */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2327 /* NFOSMESA_GLRENDERBUFFERSTORAGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glRenderbufferStorageEXT(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2328 /* NFOSMESA_GLRENDERBUFFERSTORAGEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2329 /* NFOSMESA_GLRENDERBUFFERSTORAGEMULTISAMPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glRenderbufferStorageMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coverageSamples;
	(void)colorSamples;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2330 /* NFOSMESA_GLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2331 /* NFOSMESA_GLRENDERBUFFERSTORAGEMULTISAMPLEEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glResumeTransformFeedback(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2332 /* NFOSMESA_GLRESUMETRANSFORMFEEDBACK */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glResumeTransformFeedbackNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2333 /* NFOSMESA_GLRESUMETRANSFORMFEEDBACKNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glRotatexOES(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2334 /* NFOSMESA_GLROTATEXOES */, SLB_NARGS(2), gl_pub, &angle);
}

static void APIENTRY exec_glSampleCoverageOES(GLfixed value, GLboolean32 invert)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)invert;
	(*exec)(gl_slb, 2335 /* NFOSMESA_GLSAMPLECOVERAGEOES */, SLB_NARGS(2), gl_pub, &value);
}

static void APIENTRY exec_glSampleMaskIndexedNV(GLuint index, GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mask;
	(*exec)(gl_slb, 2336 /* NFOSMESA_GLSAMPLEMASKINDEXEDNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glSampleMaski(GLuint maskNumber, GLbitfield mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mask;
	(*exec)(gl_slb, 2337 /* NFOSMESA_GLSAMPLEMASKI */, SLB_NARGS(2), gl_pub, &maskNumber);
}

static void APIENTRY exec_glSamplePass(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2338 /* NFOSMESA_GLSAMPLEPASS */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glSamplePassARB(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2339 /* NFOSMESA_GLSAMPLEPASSARB */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2340 /* NFOSMESA_GLSAMPLERPARAMETERIIV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2341 /* NFOSMESA_GLSAMPLERPARAMETERIUIV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2342 /* NFOSMESA_GLSAMPLERPARAMETERF */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2343 /* NFOSMESA_GLSAMPLERPARAMETERFV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glSamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2344 /* NFOSMESA_GLSAMPLERPARAMETERI */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2345 /* NFOSMESA_GLSAMPLERPARAMETERIV */, SLB_NARGS(2), gl_pub, &sampler);
}

static void APIENTRY exec_glScalexOES(GLfixed x, GLfixed y, GLfixed z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2346 /* NFOSMESA_GLSCALEXOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glScissorArrayv(GLuint first, GLsizei count, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 2347 /* NFOSMESA_GLSCISSORARRAYV */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)left;
	(void)bottom;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2348 /* NFOSMESA_GLSCISSORINDEXED */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glScissorIndexedv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2349 /* NFOSMESA_GLSCISSORINDEXEDV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glSecondaryColorFormatNV(GLint size, GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(*exec)(gl_slb, 2350 /* NFOSMESA_GLSECONDARYCOLORFORMATNV */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glSecondaryColorP3ui(GLenum type, GLuint color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(*exec)(gl_slb, 2351 /* NFOSMESA_GLSECONDARYCOLORP3UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glSecondaryColorP3uiv(GLenum type, const GLuint *color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)color;
	(*exec)(gl_slb, 2352 /* NFOSMESA_GLSECONDARYCOLORP3UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean32 enable, GLuint group, GLint numCounters, GLuint *counterList)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)enable;
	(void)group;
	(void)numCounters;
	(void)counterList;
	(*exec)(gl_slb, 2353 /* NFOSMESA_GLSELECTPERFMONITORCOUNTERSAMD */, SLB_NARGS(2), gl_pub, &monitor);
}

static void APIENTRY exec_glSetMultisamplefvAMD(GLenum pname, GLuint index, const GLfloat *val)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)val;
	(*exec)(gl_slb, 2354 /* NFOSMESA_GLSETMULTISAMPLEFVAMD */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glShaderBinary(GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)shaders;
	(void)binaryformat;
	(void)binary;
	(void)length;
	(*exec)(gl_slb, 2355 /* NFOSMESA_GLSHADERBINARY */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glShaderSource(GLuint shader, GLsizei count, const GLchar *const *string, const GLint *length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)string;
	(void)length;
	(*exec)(gl_slb, 2356 /* NFOSMESA_GLSHADERSOURCE */, SLB_NARGS(2), gl_pub, &shader);
}

static void APIENTRY exec_glShaderStorageBlockBinding(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)storageBlockIndex;
	(void)storageBlockBinding;
	(*exec)(gl_slb, 2357 /* NFOSMESA_GLSHADERSTORAGEBLOCKBINDING */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glStencilClearTagEXT(GLsizei stencilTagBits, GLuint stencilClearTag)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stencilClearTag;
	(*exec)(gl_slb, 2358 /* NFOSMESA_GLSTENCILCLEARTAGEXT */, SLB_NARGS(2), gl_pub, &stencilTagBits);
}

static void APIENTRY exec_glStencilFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pathNameType;
	(void)paths;
	(void)pathBase;
	(void)fillMode;
	(void)mask;
	(void)transformType;
	(void)transformValues;
	(*exec)(gl_slb, 2359 /* NFOSMESA_GLSTENCILFILLPATHINSTANCEDNV */, SLB_NARGS(2), gl_pub, &numPaths);
}

static void APIENTRY exec_glStencilFillPathNV(GLuint path, GLenum fillMode, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)fillMode;
	(void)mask;
	(*exec)(gl_slb, 2360 /* NFOSMESA_GLSTENCILFILLPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)func;
	(void)ref;
	(void)mask;
	(*exec)(gl_slb, 2361 /* NFOSMESA_GLSTENCILFUNCSEPARATE */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glStencilMaskSeparate(GLenum face, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)mask;
	(*exec)(gl_slb, 2362 /* NFOSMESA_GLSTENCILMASKSEPARATE */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sfail;
	(void)dpfail;
	(void)dppass;
	(*exec)(gl_slb, 2363 /* NFOSMESA_GLSTENCILOPSEPARATE */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glStencilOpValueAMD(GLenum face, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2364 /* NFOSMESA_GLSTENCILOPVALUEAMD */, SLB_NARGS(2), gl_pub, &face);
}

static void APIENTRY exec_glStencilStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pathNameType;
	(void)paths;
	(void)pathBase;
	(void)reference;
	(void)mask;
	(void)transformType;
	(void)transformValues;
	(*exec)(gl_slb, 2365 /* NFOSMESA_GLSTENCILSTROKEPATHINSTANCEDNV */, SLB_NARGS(2), gl_pub, &numPaths);
}

static void APIENTRY exec_glStencilStrokePathNV(GLuint path, GLint reference, GLuint mask)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reference;
	(void)mask;
	(*exec)(gl_slb, 2366 /* NFOSMESA_GLSTENCILSTROKEPATHNV */, SLB_NARGS(2), gl_pub, &path);
}

static void APIENTRY exec_glStringMarkerGREMEDY(GLsizei len, const void *string)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)string;
	(*exec)(gl_slb, 2367 /* NFOSMESA_GLSTRINGMARKERGREMEDY */, SLB_NARGS(2), gl_pub, &len);
}

static void APIENTRY exec_glSwapAPPLE(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2368 /* NFOSMESA_GLSWAPAPPLE */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glSyncTextureINTEL(GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2369 /* NFOSMESA_GLSYNCTEXTUREINTEL */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTessellationFactorAMD(GLfloat factor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2370 /* NFOSMESA_GLTESSELLATIONFACTORAMD */, SLB_NARGS(2), gl_pub, &factor);
}

static void APIENTRY exec_glTessellationModeAMD(GLenum mode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2371 /* NFOSMESA_GLTESSELLATIONMODEAMD */, SLB_NARGS(2), gl_pub, &mode);
}

static void APIENTRY exec_glTexBuffer(GLenum target, GLenum internalformat, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)buffer;
	(*exec)(gl_slb, 2372 /* NFOSMESA_GLTEXBUFFER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexBufferARB(GLenum target, GLenum internalformat, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)buffer;
	(*exec)(gl_slb, 2373 /* NFOSMESA_GLTEXBUFFERARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)buffer;
	(*exec)(gl_slb, 2374 /* NFOSMESA_GLTEXBUFFEREXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexBufferRange(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)buffer;
	(void)offset;
	(void)size;
	(*exec)(gl_slb, 2375 /* NFOSMESA_GLTEXBUFFERRANGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexCoord1bOES(GLbyte32 s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2376 /* NFOSMESA_GLTEXCOORD1BOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2377 /* NFOSMESA_GLTEXCOORD1BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord1xOES(GLfixed s)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2378 /* NFOSMESA_GLTEXCOORD1XOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord1xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2379 /* NFOSMESA_GLTEXCOORD1XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord2bOES(GLbyte32 s, GLbyte32 t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 2380 /* NFOSMESA_GLTEXCOORD2BOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2381 /* NFOSMESA_GLTEXCOORD2BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord2xOES(GLfixed s, GLfixed t)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(*exec)(gl_slb, 2382 /* NFOSMESA_GLTEXCOORD2XOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord2xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2383 /* NFOSMESA_GLTEXCOORD2XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord3bOES(GLbyte32 s, GLbyte32 t, GLbyte32 r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 2384 /* NFOSMESA_GLTEXCOORD3BOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2385 /* NFOSMESA_GLTEXCOORD3BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord3xOES(GLfixed s, GLfixed t, GLfixed r)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(*exec)(gl_slb, 2386 /* NFOSMESA_GLTEXCOORD3XOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord3xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2387 /* NFOSMESA_GLTEXCOORD3XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord4bOES(GLbyte32 s, GLbyte32 t, GLbyte32 r, GLbyte32 q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 2388 /* NFOSMESA_GLTEXCOORD4BOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2389 /* NFOSMESA_GLTEXCOORD4BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoord4xOES(GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)t;
	(void)r;
	(void)q;
	(*exec)(gl_slb, 2390 /* NFOSMESA_GLTEXCOORD4XOES */, SLB_NARGS(2), gl_pub, &s);
}

static void APIENTRY exec_glTexCoord4xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2391 /* NFOSMESA_GLTEXCOORD4XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glTexCoordFormatNV(GLint size, GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(*exec)(gl_slb, 2392 /* NFOSMESA_GLTEXCOORDFORMATNV */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glTexCoordP1ui(GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2393 /* NFOSMESA_GLTEXCOORDP1UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP1uiv(GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2394 /* NFOSMESA_GLTEXCOORDP1UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP2ui(GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2395 /* NFOSMESA_GLTEXCOORDP2UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP2uiv(GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2396 /* NFOSMESA_GLTEXCOORDP2UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP3ui(GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2397 /* NFOSMESA_GLTEXCOORDP3UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP3uiv(GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2398 /* NFOSMESA_GLTEXCOORDP3UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP4ui(GLenum type, GLuint coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2399 /* NFOSMESA_GLTEXCOORDP4UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexCoordP4uiv(GLenum type, const GLuint *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coords;
	(*exec)(gl_slb, 2400 /* NFOSMESA_GLTEXCOORDP4UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glTexEnvxOES(GLenum target, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2401 /* NFOSMESA_GLTEXENVXOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexEnvxvOES(GLenum target, GLenum pname, const GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2402 /* NFOSMESA_GLTEXENVXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2403 /* NFOSMESA_GLTEXGENXOES */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2404 /* NFOSMESA_GLTEXGENXVOES */, SLB_NARGS(2), gl_pub, &coord);
}

static void APIENTRY exec_glTexImage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)fixedsamplelocations;
	(*exec)(gl_slb, 2405 /* NFOSMESA_GLTEXIMAGE2DMULTISAMPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexImage2DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coverageSamples;
	(void)colorSamples;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)fixedSampleLocations;
	(*exec)(gl_slb, 2406 /* NFOSMESA_GLTEXIMAGE2DMULTISAMPLECOVERAGENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexImage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)fixedsamplelocations;
	(*exec)(gl_slb, 2407 /* NFOSMESA_GLTEXIMAGE3DMULTISAMPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexImage3DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)coverageSamples;
	(void)colorSamples;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)depth;
	(void)fixedSampleLocations;
	(*exec)(gl_slb, 2408 /* NFOSMESA_GLTEXIMAGE3DMULTISAMPLECOVERAGENV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexPageCommitmentARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 commit)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)commit;
	(*exec)(gl_slb, 2409 /* NFOSMESA_GLTEXPAGECOMMITMENTARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2410 /* NFOSMESA_GLTEXPARAMETERIIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterIivEXT(GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2411 /* NFOSMESA_GLTEXPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2412 /* NFOSMESA_GLTEXPARAMETERIUIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2413 /* NFOSMESA_GLTEXPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterxOES(GLenum target, GLenum pname, GLfixed param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2414 /* NFOSMESA_GLTEXPARAMETERXOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexParameterxvOES(GLenum target, GLenum pname, const GLfixed *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2415 /* NFOSMESA_GLTEXPARAMETERXVOES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexRenderbufferNV(GLenum target, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffer;
	(*exec)(gl_slb, 2416 /* NFOSMESA_GLTEXRENDERBUFFERNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexScissorFuncINTEL(GLenum target, GLenum lfunc, GLenum hfunc)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)lfunc;
	(void)hfunc;
	(*exec)(gl_slb, 2417 /* NFOSMESA_GLTEXSCISSORFUNCINTEL */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexScissorINTEL(GLenum target, GLclampf tlow, GLclampf thigh)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)tlow;
	(void)thigh;
	(*exec)(gl_slb, 2418 /* NFOSMESA_GLTEXSCISSORINTEL */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexStorage1D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)levels;
	(void)internalformat;
	(void)width;
	(*exec)(gl_slb, 2419 /* NFOSMESA_GLTEXSTORAGE1D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)levels;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2420 /* NFOSMESA_GLTEXSTORAGE2D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)fixedsamplelocations;
	(*exec)(gl_slb, 2421 /* NFOSMESA_GLTEXSTORAGE2DMULTISAMPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)levels;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(*exec)(gl_slb, 2422 /* NFOSMESA_GLTEXSTORAGE3D */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexStorage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)fixedsamplelocations;
	(*exec)(gl_slb, 2423 /* NFOSMESA_GLTEXSTORAGE3DMULTISAMPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTexStorageSparseAMD(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)depth;
	(void)layers;
	(void)flags;
	(*exec)(gl_slb, 2424 /* NFOSMESA_GLTEXSTORAGESPARSEAMD */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTextureBarrierNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2425 /* NFOSMESA_GLTEXTUREBARRIERNV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glTextureBufferEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)internalformat;
	(void)buffer;
	(*exec)(gl_slb, 2426 /* NFOSMESA_GLTEXTUREBUFFEREXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureBufferRangeEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)internalformat;
	(void)buffer;
	(void)offset;
	(void)size;
	(*exec)(gl_slb, 2427 /* NFOSMESA_GLTEXTUREBUFFERRANGEEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureFogSGIX(GLenum pname)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2428 /* NFOSMESA_GLTEXTUREFOGSGIX */, SLB_NARGS(2), gl_pub, &pname);
}

static void APIENTRY exec_glTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2429 /* NFOSMESA_GLTEXTUREIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2430 /* NFOSMESA_GLTEXTUREIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureImage2DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)coverageSamples;
	(void)colorSamples;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)fixedSampleLocations;
	(*exec)(gl_slb, 2431 /* NFOSMESA_GLTEXTUREIMAGE2DMULTISAMPLECOVERAGENV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureImage2DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)samples;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)fixedSampleLocations;
	(*exec)(gl_slb, 2432 /* NFOSMESA_GLTEXTUREIMAGE2DMULTISAMPLENV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)border;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2433 /* NFOSMESA_GLTEXTUREIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureImage3DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)coverageSamples;
	(void)colorSamples;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)depth;
	(void)fixedSampleLocations;
	(*exec)(gl_slb, 2434 /* NFOSMESA_GLTEXTUREIMAGE3DMULTISAMPLECOVERAGENV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureImage3DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)samples;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)depth;
	(void)fixedSampleLocations;
	(*exec)(gl_slb, 2435 /* NFOSMESA_GLTEXTUREIMAGE3DMULTISAMPLENV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTexturePageCommitmentEXT(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 commit)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)commit;
	(*exec)(gl_slb, 2436 /* NFOSMESA_GLTEXTUREPAGECOMMITMENTEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2437 /* NFOSMESA_GLTEXTUREPARAMETERIIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, const GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2438 /* NFOSMESA_GLTEXTUREPARAMETERIUIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureParameterfEXT(GLuint texture, GLenum target, GLenum pname, GLfloat param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2439 /* NFOSMESA_GLTEXTUREPARAMETERFEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2440 /* NFOSMESA_GLTEXTUREPARAMETERFVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureParameteriEXT(GLuint texture, GLenum target, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2441 /* NFOSMESA_GLTEXTUREPARAMETERIEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2442 /* NFOSMESA_GLTEXTUREPARAMETERIVEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureRangeAPPLE(GLenum target, GLsizei length, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)length;
	(void)pointer;
	(*exec)(gl_slb, 2443 /* NFOSMESA_GLTEXTURERANGEAPPLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glTextureRenderbufferEXT(GLuint texture, GLenum target, GLuint renderbuffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)renderbuffer;
	(*exec)(gl_slb, 2444 /* NFOSMESA_GLTEXTURERENDERBUFFEREXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)levels;
	(void)internalformat;
	(void)width;
	(*exec)(gl_slb, 2445 /* NFOSMESA_GLTEXTURESTORAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)levels;
	(void)internalformat;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2446 /* NFOSMESA_GLTEXTURESTORAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureStorage2DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)fixedsamplelocations;
	(*exec)(gl_slb, 2447 /* NFOSMESA_GLTEXTURESTORAGE2DMULTISAMPLEEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)levels;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(*exec)(gl_slb, 2448 /* NFOSMESA_GLTEXTURESTORAGE3DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureStorage3DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)samples;
	(void)internalformat;
	(void)width;
	(void)height;
	(void)depth;
	(void)fixedsamplelocations;
	(*exec)(gl_slb, 2449 /* NFOSMESA_GLTEXTURESTORAGE3DMULTISAMPLEEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureStorageSparseAMD(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)internalFormat;
	(void)width;
	(void)height;
	(void)depth;
	(void)layers;
	(void)flags;
	(*exec)(gl_slb, 2450 /* NFOSMESA_GLTEXTURESTORAGESPARSEAMD */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2451 /* NFOSMESA_GLTEXTURESUBIMAGE1DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2452 /* NFOSMESA_GLTEXTURESUBIMAGE2DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)type;
	(void)pixels;
	(*exec)(gl_slb, 2453 /* NFOSMESA_GLTEXTURESUBIMAGE3DEXT */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTextureView(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)origtexture;
	(void)internalformat;
	(void)minlevel;
	(void)numlevels;
	(void)minlayer;
	(void)numlayers;
	(*exec)(gl_slb, 2454 /* NFOSMESA_GLTEXTUREVIEW */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glTransformFeedbackAttribsNV(GLsizei count, const GLint *attribs, GLenum bufferMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attribs;
	(void)bufferMode;
	(*exec)(gl_slb, 2455 /* NFOSMESA_GLTRANSFORMFEEDBACKATTRIBSNV */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glTransformFeedbackStreamAttribsNV(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attribs;
	(void)nbuffers;
	(void)bufstreams;
	(void)bufferMode;
	(*exec)(gl_slb, 2456 /* NFOSMESA_GLTRANSFORMFEEDBACKSTREAMATTRIBSNV */, SLB_NARGS(2), gl_pub, &count);
}

static void APIENTRY exec_glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar *const *varyings, GLenum bufferMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)varyings;
	(void)bufferMode;
	(*exec)(gl_slb, 2457 /* NFOSMESA_GLTRANSFORMFEEDBACKVARYINGS */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glTransformFeedbackVaryingsEXT(GLuint program, GLsizei count, const GLchar *const *varyings, GLenum bufferMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)varyings;
	(void)bufferMode;
	(*exec)(gl_slb, 2458 /* NFOSMESA_GLTRANSFORMFEEDBACKVARYINGSEXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glTransformFeedbackVaryingsNV(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)locations;
	(void)bufferMode;
	(*exec)(gl_slb, 2459 /* NFOSMESA_GLTRANSFORMFEEDBACKVARYINGSNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glTransformPathNV(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)srcPath;
	(void)transformType;
	(void)transformValues;
	(*exec)(gl_slb, 2460 /* NFOSMESA_GLTRANSFORMPATHNV */, SLB_NARGS(2), gl_pub, &resultPath);
}

static void APIENTRY exec_glTranslatexOES(GLfixed x, GLfixed y, GLfixed z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2461 /* NFOSMESA_GLTRANSLATEXOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glUniform1d(GLint location, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2462 /* NFOSMESA_GLUNIFORM1D */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1dv(GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2463 /* NFOSMESA_GLUNIFORM1DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1f(GLint location, GLfloat v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(*exec)(gl_slb, 2464 /* NFOSMESA_GLUNIFORM1F */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2465 /* NFOSMESA_GLUNIFORM1FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1i(GLint location, GLint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(*exec)(gl_slb, 2466 /* NFOSMESA_GLUNIFORM1I */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1i64NV(GLint location, GLint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2467 /* NFOSMESA_GLUNIFORM1I64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2468 /* NFOSMESA_GLUNIFORM1I64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1iv(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2469 /* NFOSMESA_GLUNIFORM1IV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1ui(GLint location, GLuint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(*exec)(gl_slb, 2470 /* NFOSMESA_GLUNIFORM1UI */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1ui64NV(GLint location, GLuint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2471 /* NFOSMESA_GLUNIFORM1UI64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2472 /* NFOSMESA_GLUNIFORM1UI64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1uiEXT(GLint location, GLuint v0)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(*exec)(gl_slb, 2473 /* NFOSMESA_GLUNIFORM1UIEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1uiv(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2474 /* NFOSMESA_GLUNIFORM1UIV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform1uivEXT(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2475 /* NFOSMESA_GLUNIFORM1UIVEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2d(GLint location, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2476 /* NFOSMESA_GLUNIFORM2D */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2dv(GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2477 /* NFOSMESA_GLUNIFORM2DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2f(GLint location, GLfloat v0, GLfloat v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2478 /* NFOSMESA_GLUNIFORM2F */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2479 /* NFOSMESA_GLUNIFORM2FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2i(GLint location, GLint v0, GLint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2480 /* NFOSMESA_GLUNIFORM2I */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2i64NV(GLint location, GLint64EXT x, GLint64EXT y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2481 /* NFOSMESA_GLUNIFORM2I64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2482 /* NFOSMESA_GLUNIFORM2I64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2iv(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2483 /* NFOSMESA_GLUNIFORM2IV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2ui(GLint location, GLuint v0, GLuint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2484 /* NFOSMESA_GLUNIFORM2UI */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2485 /* NFOSMESA_GLUNIFORM2UI64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2486 /* NFOSMESA_GLUNIFORM2UI64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2uiEXT(GLint location, GLuint v0, GLuint v1)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(*exec)(gl_slb, 2487 /* NFOSMESA_GLUNIFORM2UIEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2uiv(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2488 /* NFOSMESA_GLUNIFORM2UIV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform2uivEXT(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2489 /* NFOSMESA_GLUNIFORM2UIVEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2490 /* NFOSMESA_GLUNIFORM3D */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3dv(GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2491 /* NFOSMESA_GLUNIFORM3DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2492 /* NFOSMESA_GLUNIFORM3F */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2493 /* NFOSMESA_GLUNIFORM3FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2494 /* NFOSMESA_GLUNIFORM3I */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2495 /* NFOSMESA_GLUNIFORM3I64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2496 /* NFOSMESA_GLUNIFORM3I64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3iv(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2497 /* NFOSMESA_GLUNIFORM3IV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2498 /* NFOSMESA_GLUNIFORM3UI */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2499 /* NFOSMESA_GLUNIFORM3UI64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2500 /* NFOSMESA_GLUNIFORM3UI64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(*exec)(gl_slb, 2501 /* NFOSMESA_GLUNIFORM3UIEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3uiv(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2502 /* NFOSMESA_GLUNIFORM3UIV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform3uivEXT(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2503 /* NFOSMESA_GLUNIFORM3UIVEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2504 /* NFOSMESA_GLUNIFORM4D */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4dv(GLint location, GLsizei count, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2505 /* NFOSMESA_GLUNIFORM4DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2506 /* NFOSMESA_GLUNIFORM4F */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2507 /* NFOSMESA_GLUNIFORM4FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2508 /* NFOSMESA_GLUNIFORM4I */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2509 /* NFOSMESA_GLUNIFORM4I64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4i64vNV(GLint location, GLsizei count, const GLint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2510 /* NFOSMESA_GLUNIFORM4I64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4iv(GLint location, GLsizei count, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2511 /* NFOSMESA_GLUNIFORM4IV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2512 /* NFOSMESA_GLUNIFORM4UI */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2513 /* NFOSMESA_GLUNIFORM4UI64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4ui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2514 /* NFOSMESA_GLUNIFORM4UI64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v0;
	(void)v1;
	(void)v2;
	(void)v3;
	(*exec)(gl_slb, 2515 /* NFOSMESA_GLUNIFORM4UIEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4uiv(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2516 /* NFOSMESA_GLUNIFORM4UIV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniform4uivEXT(GLint location, GLsizei count, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2517 /* NFOSMESA_GLUNIFORM4UIVEXT */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)uniformBlockIndex;
	(void)uniformBlockBinding;
	(*exec)(gl_slb, 2518 /* NFOSMESA_GLUNIFORMBLOCKBINDING */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glUniformBufferEXT(GLuint program, GLint location, GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)buffer;
	(*exec)(gl_slb, 2519 /* NFOSMESA_GLUNIFORMBUFFEREXT */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glUniformHandleui64ARB(GLint location, GLuint64 value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2520 /* NFOSMESA_GLUNIFORMHANDLEUI64ARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformHandleui64NV(GLint location, GLuint64 value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2521 /* NFOSMESA_GLUNIFORMHANDLEUI64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformHandleui64vARB(GLint location, GLsizei count, const GLuint64 *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2522 /* NFOSMESA_GLUNIFORMHANDLEUI64VARB */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformHandleui64vNV(GLint location, GLsizei count, const GLuint64 *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2523 /* NFOSMESA_GLUNIFORMHANDLEUI64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2524 /* NFOSMESA_GLUNIFORMMATRIX2DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2525 /* NFOSMESA_GLUNIFORMMATRIX2FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2526 /* NFOSMESA_GLUNIFORMMATRIX2X3DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2527 /* NFOSMESA_GLUNIFORMMATRIX2X3FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2528 /* NFOSMESA_GLUNIFORMMATRIX2X4DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2529 /* NFOSMESA_GLUNIFORMMATRIX2X4FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2530 /* NFOSMESA_GLUNIFORMMATRIX3DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2531 /* NFOSMESA_GLUNIFORMMATRIX3FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2532 /* NFOSMESA_GLUNIFORMMATRIX3X2DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2533 /* NFOSMESA_GLUNIFORMMATRIX3X2FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2534 /* NFOSMESA_GLUNIFORMMATRIX3X4DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2535 /* NFOSMESA_GLUNIFORMMATRIX3X4FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2536 /* NFOSMESA_GLUNIFORMMATRIX4DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2537 /* NFOSMESA_GLUNIFORMMATRIX4FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2538 /* NFOSMESA_GLUNIFORMMATRIX4X2DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2539 /* NFOSMESA_GLUNIFORMMATRIX4X2FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2540 /* NFOSMESA_GLUNIFORMMATRIX4X3DV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)transpose;
	(void)value;
	(*exec)(gl_slb, 2541 /* NFOSMESA_GLUNIFORMMATRIX4X3FV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)indices;
	(*exec)(gl_slb, 2542 /* NFOSMESA_GLUNIFORMSUBROUTINESUIV */, SLB_NARGS(2), gl_pub, &shadertype);
}

static void APIENTRY exec_glUniformui64NV(GLint location, GLuint64EXT value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2543 /* NFOSMESA_GLUNIFORMUI64NV */, SLB_NARGS(2), gl_pub, &location);
}

static void APIENTRY exec_glUniformui64vNV(GLint location, GLsizei count, const GLuint64EXT *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)value;
	(*exec)(gl_slb, 2544 /* NFOSMESA_GLUNIFORMUI64VNV */, SLB_NARGS(2), gl_pub, &location);
}

static GLboolean APIENTRY exec_glUnmapNamedBufferEXT(GLuint buffer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 2545 /* NFOSMESA_GLUNMAPNAMEDBUFFEREXT */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glUnmapTexture2DINTEL(GLuint texture, GLint level)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(*exec)(gl_slb, 2546 /* NFOSMESA_GLUNMAPTEXTURE2DINTEL */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glUseProgram(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2547 /* NFOSMESA_GLUSEPROGRAM */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stages;
	(void)program;
	(*exec)(gl_slb, 2548 /* NFOSMESA_GLUSEPROGRAMSTAGES */, SLB_NARGS(2), gl_pub, &pipeline);
}

static void APIENTRY exec_glUseShaderProgramEXT(GLenum type, GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)program;
	(*exec)(gl_slb, 2549 /* NFOSMESA_GLUSESHADERPROGRAMEXT */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVDPAUFiniNV(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2550 /* NFOSMESA_GLVDPAUFININV */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glVDPAUGetSurfaceivNV(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)bufSize;
	(void)length;
	(void)values;
	(*exec)(gl_slb, 2551 /* NFOSMESA_GLVDPAUGETSURFACEIVNV */, SLB_NARGS(2), gl_pub, &surface);
}

static void APIENTRY exec_glVDPAUInitNV(const void *vdpDevice, const void *getProcAddress)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)getProcAddress;
	(*exec)(gl_slb, 2552 /* NFOSMESA_GLVDPAUINITNV */, SLB_NARGS(2), gl_pub, &vdpDevice);
}

static GLboolean APIENTRY exec_glVDPAUIsSurfaceNV(GLvdpauSurfaceNV surface)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 2553 /* NFOSMESA_GLVDPAUISSURFACENV */, SLB_NARGS(2), gl_pub, &surface);
}

static void APIENTRY exec_glVDPAUMapSurfacesNV(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)surfaces;
	(*exec)(gl_slb, 2554 /* NFOSMESA_GLVDPAUMAPSURFACESNV */, SLB_NARGS(2), gl_pub, &numSurfaces);
}

static GLvdpauSurfaceNV APIENTRY exec_glVDPAURegisterOutputSurfaceNV(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)numTextureNames;
	(void)textureNames;
	return (GLvdpauSurfaceNV)(*exec)(gl_slb, 2555 /* NFOSMESA_GLVDPAUREGISTEROUTPUTSURFACENV */, SLB_NARGS(2), gl_pub, &vdpSurface);
}

static GLvdpauSurfaceNV APIENTRY exec_glVDPAURegisterVideoSurfaceNV(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	(void)numTextureNames;
	(void)textureNames;
	return (GLvdpauSurfaceNV)(*exec)(gl_slb, 2556 /* NFOSMESA_GLVDPAUREGISTERVIDEOSURFACENV */, SLB_NARGS(2), gl_pub, &vdpSurface);
}

static void APIENTRY exec_glVDPAUSurfaceAccessNV(GLvdpauSurfaceNV surface, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	(*exec)(gl_slb, 2557 /* NFOSMESA_GLVDPAUSURFACEACCESSNV */, SLB_NARGS(2), gl_pub, &surface);
}

static void APIENTRY exec_glVDPAUUnmapSurfacesNV(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)surfaces;
	(*exec)(gl_slb, 2558 /* NFOSMESA_GLVDPAUUNMAPSURFACESNV */, SLB_NARGS(2), gl_pub, &numSurface);
}

static void APIENTRY exec_glVDPAUUnregisterSurfaceNV(GLvdpauSurfaceNV surface)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2559 /* NFOSMESA_GLVDPAUUNREGISTERSURFACENV */, SLB_NARGS(2), gl_pub, &surface);
}

static void APIENTRY exec_glValidateProgram(GLuint program)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2560 /* NFOSMESA_GLVALIDATEPROGRAM */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glValidateProgramPipeline(GLuint pipeline)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2561 /* NFOSMESA_GLVALIDATEPROGRAMPIPELINE */, SLB_NARGS(2), gl_pub, &pipeline);
}

static void APIENTRY exec_glVertex2bOES(GLbyte32 x, GLbyte32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 2562 /* NFOSMESA_GLVERTEX2BOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2563 /* NFOSMESA_GLVERTEX2BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glVertex2xOES(GLfixed x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2564 /* NFOSMESA_GLVERTEX2XOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex2xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2565 /* NFOSMESA_GLVERTEX2XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glVertex3bOES(GLbyte32 x, GLbyte32 y, GLbyte32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2566 /* NFOSMESA_GLVERTEX3BOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2567 /* NFOSMESA_GLVERTEX3BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glVertex3xOES(GLfixed x, GLfixed y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(*exec)(gl_slb, 2568 /* NFOSMESA_GLVERTEX3XOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex3xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2569 /* NFOSMESA_GLVERTEX3XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glVertex4bOES(GLbyte32 x, GLbyte32 y, GLbyte32 z, GLbyte32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2570 /* NFOSMESA_GLVERTEX4BOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4bvOES(const GLbyte *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2571 /* NFOSMESA_GLVERTEX4BVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glVertex4xOES(GLfixed x, GLfixed y, GLfixed z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2572 /* NFOSMESA_GLVERTEX4XOES */, SLB_NARGS(2), gl_pub, &x);
}

static void APIENTRY exec_glVertex4xvOES(const GLfixed *coords)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2573 /* NFOSMESA_GLVERTEX4XVOES */, SLB_NARGS(2), gl_pub, &coords);
}

static void APIENTRY exec_glVertexArrayBindVertexBufferEXT(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bindingindex;
	(void)buffer;
	(void)offset;
	(void)stride;
	(*exec)(gl_slb, 2574 /* NFOSMESA_GLVERTEXARRAYBINDVERTEXBUFFEREXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayColorOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2575 /* NFOSMESA_GLVERTEXARRAYCOLOROFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayEdgeFlagOffsetEXT(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2576 /* NFOSMESA_GLVERTEXARRAYEDGEFLAGOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayFogCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2577 /* NFOSMESA_GLVERTEXARRAYFOGCOORDOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayIndexOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2578 /* NFOSMESA_GLVERTEXARRAYINDEXOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayMultiTexCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)texunit;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2579 /* NFOSMESA_GLVERTEXARRAYMULTITEXCOORDOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayNormalOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2580 /* NFOSMESA_GLVERTEXARRAYNORMALOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArraySecondaryColorOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2581 /* NFOSMESA_GLVERTEXARRAYSECONDARYCOLOROFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayTexCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2582 /* NFOSMESA_GLVERTEXARRAYTEXCOORDOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribBindingEXT(GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attribindex;
	(void)bindingindex;
	(*exec)(gl_slb, 2583 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBBINDINGEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribDivisorEXT(GLuint vaobj, GLuint index, GLuint divisor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)divisor;
	(*exec)(gl_slb, 2584 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBDIVISOREXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attribindex;
	(void)size;
	(void)type;
	(void)normalized;
	(void)relativeoffset;
	(*exec)(gl_slb, 2585 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBFORMATEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribIFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attribindex;
	(void)size;
	(void)type;
	(void)relativeoffset;
	(*exec)(gl_slb, 2586 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBIFORMATEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribIOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)index;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2587 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBIOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribLFormatEXT(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attribindex;
	(void)size;
	(void)type;
	(void)relativeoffset;
	(*exec)(gl_slb, 2588 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBLFORMATEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribLOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)index;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2589 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBLOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexAttribOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)index;
	(void)size;
	(void)type;
	(void)normalized;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2590 /* NFOSMESA_GLVERTEXARRAYVERTEXATTRIBOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexBindingDivisorEXT(GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bindingindex;
	(void)divisor;
	(*exec)(gl_slb, 2591 /* NFOSMESA_GLVERTEXARRAYVERTEXBINDINGDIVISOREXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexArrayVertexOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)size;
	(void)type;
	(void)stride;
	(void)offset;
	(*exec)(gl_slb, 2592 /* NFOSMESA_GLVERTEXARRAYVERTEXOFFSETEXT */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glVertexAttrib1d(GLuint index, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2593 /* NFOSMESA_GLVERTEXATTRIB1D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2594 /* NFOSMESA_GLVERTEXATTRIB1DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1f(GLuint index, GLfloat x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2595 /* NFOSMESA_GLVERTEXATTRIB1F */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1fv(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2596 /* NFOSMESA_GLVERTEXATTRIB1FV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1s(GLuint index, GLshort32 x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2597 /* NFOSMESA_GLVERTEXATTRIB1S */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib1sv(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2598 /* NFOSMESA_GLVERTEXATTRIB1SV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2599 /* NFOSMESA_GLVERTEXATTRIB2D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2600 /* NFOSMESA_GLVERTEXATTRIB2DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2601 /* NFOSMESA_GLVERTEXATTRIB2F */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2fv(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2602 /* NFOSMESA_GLVERTEXATTRIB2FV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2s(GLuint index, GLshort32 x, GLshort32 y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2603 /* NFOSMESA_GLVERTEXATTRIB2S */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib2sv(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2604 /* NFOSMESA_GLVERTEXATTRIB2SV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2605 /* NFOSMESA_GLVERTEXATTRIB3D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2606 /* NFOSMESA_GLVERTEXATTRIB3DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2607 /* NFOSMESA_GLVERTEXATTRIB3F */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3fv(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2608 /* NFOSMESA_GLVERTEXATTRIB3FV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3s(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2609 /* NFOSMESA_GLVERTEXATTRIB3S */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib3sv(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2610 /* NFOSMESA_GLVERTEXATTRIB3SV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Nbv(GLuint index, const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2611 /* NFOSMESA_GLVERTEXATTRIB4NBV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Niv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2612 /* NFOSMESA_GLVERTEXATTRIB4NIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Nsv(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2613 /* NFOSMESA_GLVERTEXATTRIB4NSV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Nub(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2614 /* NFOSMESA_GLVERTEXATTRIB4NUB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Nubv(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2615 /* NFOSMESA_GLVERTEXATTRIB4NUBV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Nuiv(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2616 /* NFOSMESA_GLVERTEXATTRIB4NUIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4Nusv(GLuint index, const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2617 /* NFOSMESA_GLVERTEXATTRIB4NUSV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4bv(GLuint index, const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2618 /* NFOSMESA_GLVERTEXATTRIB4BV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2619 /* NFOSMESA_GLVERTEXATTRIB4D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2620 /* NFOSMESA_GLVERTEXATTRIB4DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2621 /* NFOSMESA_GLVERTEXATTRIB4F */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4fv(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2622 /* NFOSMESA_GLVERTEXATTRIB4FV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4iv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2623 /* NFOSMESA_GLVERTEXATTRIB4IV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4s(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2624 /* NFOSMESA_GLVERTEXATTRIB4S */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4sv(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2625 /* NFOSMESA_GLVERTEXATTRIB4SV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4ubv(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2626 /* NFOSMESA_GLVERTEXATTRIB4UBV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4uiv(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2627 /* NFOSMESA_GLVERTEXATTRIB4UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttrib4usv(GLuint index, const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2628 /* NFOSMESA_GLVERTEXATTRIB4USV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribBinding(GLuint attribindex, GLuint bindingindex)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bindingindex;
	(*exec)(gl_slb, 2629 /* NFOSMESA_GLVERTEXATTRIBBINDING */, SLB_NARGS(2), gl_pub, &attribindex);
}

static void APIENTRY exec_glVertexAttribDivisor(GLuint index, GLuint divisor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)divisor;
	(*exec)(gl_slb, 2630 /* NFOSMESA_GLVERTEXATTRIBDIVISOR */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribDivisorARB(GLuint index, GLuint divisor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)divisor;
	(*exec)(gl_slb, 2631 /* NFOSMESA_GLVERTEXATTRIBDIVISORARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)normalized;
	(void)relativeoffset;
	(*exec)(gl_slb, 2632 /* NFOSMESA_GLVERTEXATTRIBFORMAT */, SLB_NARGS(2), gl_pub, &attribindex);
}

static void APIENTRY exec_glVertexAttribFormatNV(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)normalized;
	(void)stride;
	(*exec)(gl_slb, 2633 /* NFOSMESA_GLVERTEXATTRIBFORMATNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1i(GLuint index, GLint x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2634 /* NFOSMESA_GLVERTEXATTRIBI1I */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1iEXT(GLuint index, GLint x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2635 /* NFOSMESA_GLVERTEXATTRIBI1IEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1iv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2636 /* NFOSMESA_GLVERTEXATTRIBI1IV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1ivEXT(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2637 /* NFOSMESA_GLVERTEXATTRIBI1IVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1ui(GLuint index, GLuint x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2638 /* NFOSMESA_GLVERTEXATTRIBI1UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1uiEXT(GLuint index, GLuint x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2639 /* NFOSMESA_GLVERTEXATTRIBI1UIEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1uiv(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2640 /* NFOSMESA_GLVERTEXATTRIBI1UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI1uivEXT(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2641 /* NFOSMESA_GLVERTEXATTRIBI1UIVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2i(GLuint index, GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2642 /* NFOSMESA_GLVERTEXATTRIBI2I */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2iEXT(GLuint index, GLint x, GLint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2643 /* NFOSMESA_GLVERTEXATTRIBI2IEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2iv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2644 /* NFOSMESA_GLVERTEXATTRIBI2IV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2ivEXT(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2645 /* NFOSMESA_GLVERTEXATTRIBI2IVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2ui(GLuint index, GLuint x, GLuint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2646 /* NFOSMESA_GLVERTEXATTRIBI2UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2uiEXT(GLuint index, GLuint x, GLuint y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2647 /* NFOSMESA_GLVERTEXATTRIBI2UIEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2uiv(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2648 /* NFOSMESA_GLVERTEXATTRIBI2UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI2uivEXT(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2649 /* NFOSMESA_GLVERTEXATTRIBI2UIVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3i(GLuint index, GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2650 /* NFOSMESA_GLVERTEXATTRIBI3I */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3iEXT(GLuint index, GLint x, GLint y, GLint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2651 /* NFOSMESA_GLVERTEXATTRIBI3IEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3iv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2652 /* NFOSMESA_GLVERTEXATTRIBI3IV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3ivEXT(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2653 /* NFOSMESA_GLVERTEXATTRIBI3IVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2654 /* NFOSMESA_GLVERTEXATTRIBI3UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3uiEXT(GLuint index, GLuint x, GLuint y, GLuint z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2655 /* NFOSMESA_GLVERTEXATTRIBI3UIEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3uiv(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2656 /* NFOSMESA_GLVERTEXATTRIBI3UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI3uivEXT(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2657 /* NFOSMESA_GLVERTEXATTRIBI3UIVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4bv(GLuint index, const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2658 /* NFOSMESA_GLVERTEXATTRIBI4BV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4bvEXT(GLuint index, const GLbyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2659 /* NFOSMESA_GLVERTEXATTRIBI4BVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2660 /* NFOSMESA_GLVERTEXATTRIBI4I */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4iEXT(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2661 /* NFOSMESA_GLVERTEXATTRIBI4IEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4iv(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2662 /* NFOSMESA_GLVERTEXATTRIBI4IV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4ivEXT(GLuint index, const GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2663 /* NFOSMESA_GLVERTEXATTRIBI4IVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4sv(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2664 /* NFOSMESA_GLVERTEXATTRIBI4SV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4svEXT(GLuint index, const GLshort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2665 /* NFOSMESA_GLVERTEXATTRIBI4SVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4ubv(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2666 /* NFOSMESA_GLVERTEXATTRIBI4UBV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4ubvEXT(GLuint index, const GLubyte *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2667 /* NFOSMESA_GLVERTEXATTRIBI4UBVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2668 /* NFOSMESA_GLVERTEXATTRIBI4UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4uiEXT(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2669 /* NFOSMESA_GLVERTEXATTRIBI4UIEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4uiv(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2670 /* NFOSMESA_GLVERTEXATTRIBI4UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4uivEXT(GLuint index, const GLuint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2671 /* NFOSMESA_GLVERTEXATTRIBI4UIVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4usv(GLuint index, const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2672 /* NFOSMESA_GLVERTEXATTRIBI4USV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribI4usvEXT(GLuint index, const GLushort *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2673 /* NFOSMESA_GLVERTEXATTRIBI4USVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)relativeoffset;
	(*exec)(gl_slb, 2674 /* NFOSMESA_GLVERTEXATTRIBIFORMAT */, SLB_NARGS(2), gl_pub, &attribindex);
}

static void APIENTRY exec_glVertexAttribIFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(*exec)(gl_slb, 2675 /* NFOSMESA_GLVERTEXATTRIBIFORMATNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2676 /* NFOSMESA_GLVERTEXATTRIBIPOINTER */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribIPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2677 /* NFOSMESA_GLVERTEXATTRIBIPOINTEREXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1d(GLuint index, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2678 /* NFOSMESA_GLVERTEXATTRIBL1D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1dEXT(GLuint index, GLdouble x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2679 /* NFOSMESA_GLVERTEXATTRIBL1DEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2680 /* NFOSMESA_GLVERTEXATTRIBL1DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1dvEXT(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2681 /* NFOSMESA_GLVERTEXATTRIBL1DVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1i64NV(GLuint index, GLint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2682 /* NFOSMESA_GLVERTEXATTRIBL1I64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1i64vNV(GLuint index, const GLint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2683 /* NFOSMESA_GLVERTEXATTRIBL1I64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1ui64ARB(GLuint index, GLuint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2684 /* NFOSMESA_GLVERTEXATTRIBL1UI64ARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1ui64NV(GLuint index, GLuint64EXT x)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(*exec)(gl_slb, 2685 /* NFOSMESA_GLVERTEXATTRIBL1UI64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1ui64vARB(GLuint index, const GLuint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2686 /* NFOSMESA_GLVERTEXATTRIBL1UI64VARB */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL1ui64vNV(GLuint index, const GLuint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2687 /* NFOSMESA_GLVERTEXATTRIBL1UI64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2d(GLuint index, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2688 /* NFOSMESA_GLVERTEXATTRIBL2D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2dEXT(GLuint index, GLdouble x, GLdouble y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2689 /* NFOSMESA_GLVERTEXATTRIBL2DEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2690 /* NFOSMESA_GLVERTEXATTRIBL2DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2dvEXT(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2691 /* NFOSMESA_GLVERTEXATTRIBL2DVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2i64NV(GLuint index, GLint64EXT x, GLint64EXT y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2692 /* NFOSMESA_GLVERTEXATTRIBL2I64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2i64vNV(GLuint index, const GLint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2693 /* NFOSMESA_GLVERTEXATTRIBL2I64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(*exec)(gl_slb, 2694 /* NFOSMESA_GLVERTEXATTRIBL2UI64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL2ui64vNV(GLuint index, const GLuint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2695 /* NFOSMESA_GLVERTEXATTRIBL2UI64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2696 /* NFOSMESA_GLVERTEXATTRIBL3D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3dEXT(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2697 /* NFOSMESA_GLVERTEXATTRIBL3DEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2698 /* NFOSMESA_GLVERTEXATTRIBL3DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3dvEXT(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2699 /* NFOSMESA_GLVERTEXATTRIBL3DVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2700 /* NFOSMESA_GLVERTEXATTRIBL3I64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3i64vNV(GLuint index, const GLint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2701 /* NFOSMESA_GLVERTEXATTRIBL3I64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(*exec)(gl_slb, 2702 /* NFOSMESA_GLVERTEXATTRIBL3UI64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL3ui64vNV(GLuint index, const GLuint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2703 /* NFOSMESA_GLVERTEXATTRIBL3UI64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2704 /* NFOSMESA_GLVERTEXATTRIBL4D */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4dEXT(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2705 /* NFOSMESA_GLVERTEXATTRIBL4DEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4dv(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2706 /* NFOSMESA_GLVERTEXATTRIBL4DV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4dvEXT(GLuint index, const GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2707 /* NFOSMESA_GLVERTEXATTRIBL4DVEXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2708 /* NFOSMESA_GLVERTEXATTRIBL4I64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4i64vNV(GLuint index, const GLint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2709 /* NFOSMESA_GLVERTEXATTRIBL4I64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)z;
	(void)w;
	(*exec)(gl_slb, 2710 /* NFOSMESA_GLVERTEXATTRIBL4UI64NV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribL4ui64vNV(GLuint index, const GLuint64EXT *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2711 /* NFOSMESA_GLVERTEXATTRIBL4UI64VNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribLFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)relativeoffset;
	(*exec)(gl_slb, 2712 /* NFOSMESA_GLVERTEXATTRIBLFORMAT */, SLB_NARGS(2), gl_pub, &attribindex);
}

static void APIENTRY exec_glVertexAttribLFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(*exec)(gl_slb, 2713 /* NFOSMESA_GLVERTEXATTRIBLFORMATNV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2714 /* NFOSMESA_GLVERTEXATTRIBLPOINTER */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribLPointerEXT(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2715 /* NFOSMESA_GLVERTEXATTRIBLPOINTEREXT */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP1ui(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2716 /* NFOSMESA_GLVERTEXATTRIBP1UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP1uiv(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2717 /* NFOSMESA_GLVERTEXATTRIBP1UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP2ui(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2718 /* NFOSMESA_GLVERTEXATTRIBP2UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP2uiv(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2719 /* NFOSMESA_GLVERTEXATTRIBP2UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP3ui(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2720 /* NFOSMESA_GLVERTEXATTRIBP3UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP3uiv(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2721 /* NFOSMESA_GLVERTEXATTRIBP3UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP4ui(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2722 /* NFOSMESA_GLVERTEXATTRIBP4UI */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribP4uiv(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)normalized;
	(void)value;
	(*exec)(gl_slb, 2723 /* NFOSMESA_GLVERTEXATTRIBP4UIV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribParameteriAMD(GLuint index, GLenum pname, GLint param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2724 /* NFOSMESA_GLVERTEXATTRIBPARAMETERIAMD */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, const void *pointer)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	(void)type;
	(void)normalized;
	(void)stride;
	(void)pointer;
	(*exec)(gl_slb, 2725 /* NFOSMESA_GLVERTEXATTRIBPOINTER */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glVertexBindingDivisor(GLuint bindingindex, GLuint divisor)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)divisor;
	(*exec)(gl_slb, 2726 /* NFOSMESA_GLVERTEXBINDINGDIVISOR */, SLB_NARGS(2), gl_pub, &bindingindex);
}

static void APIENTRY exec_glVertexFormatNV(GLint size, GLenum type, GLsizei stride)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)type;
	(void)stride;
	(*exec)(gl_slb, 2727 /* NFOSMESA_GLVERTEXFORMATNV */, SLB_NARGS(2), gl_pub, &size);
}

static void APIENTRY exec_glVertexP2ui(GLenum type, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2728 /* NFOSMESA_GLVERTEXP2UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVertexP2uiv(GLenum type, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2729 /* NFOSMESA_GLVERTEXP2UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVertexP3ui(GLenum type, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2730 /* NFOSMESA_GLVERTEXP3UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVertexP3uiv(GLenum type, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2731 /* NFOSMESA_GLVERTEXP3UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVertexP4ui(GLenum type, GLuint value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2732 /* NFOSMESA_GLVERTEXP4UI */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVertexP4uiv(GLenum type, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)value;
	(*exec)(gl_slb, 2733 /* NFOSMESA_GLVERTEXP4UIV */, SLB_NARGS(2), gl_pub, &type);
}

static void APIENTRY exec_glVertexPointSizefAPPLE(GLfloat size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2734 /* NFOSMESA_GLVERTEXPOINTSIZEFAPPLE */, SLB_NARGS(2), gl_pub, &size);
}

static GLenum APIENTRY exec_glVideoCaptureNV(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sequence_num;
	(void)capture_time;
	return (GLenum)(*exec)(gl_slb, 2735 /* NFOSMESA_GLVIDEOCAPTURENV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glVideoCaptureStreamParameterdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2736 /* NFOSMESA_GLVIDEOCAPTURESTREAMPARAMETERDVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glVideoCaptureStreamParameterfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2737 /* NFOSMESA_GLVIDEOCAPTURESTREAMPARAMETERFVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glVideoCaptureStreamParameterivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)stream;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2738 /* NFOSMESA_GLVIDEOCAPTURESTREAMPARAMETERIVNV */, SLB_NARGS(2), gl_pub, &video_capture_slot);
}

static void APIENTRY exec_glViewportArrayv(GLuint first, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 2739 /* NFOSMESA_GLVIEWPORTARRAYV */, SLB_NARGS(2), gl_pub, &first);
}

static void APIENTRY exec_glViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)x;
	(void)y;
	(void)w;
	(void)h;
	(*exec)(gl_slb, 2740 /* NFOSMESA_GLVIEWPORTINDEXEDF */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glViewportIndexedfv(GLuint index, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2741 /* NFOSMESA_GLVIEWPORTINDEXEDFV */, SLB_NARGS(2), gl_pub, &index);
}

static void APIENTRY exec_glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)flags;
	(void)timeout;
	(*exec)(gl_slb, 2742 /* NFOSMESA_GLWAITSYNC */, SLB_NARGS(2), gl_pub, &sync);
}

static void APIENTRY exec_glWeightPathsNV(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numPaths;
	(void)paths;
	(void)weights;
	(*exec)(gl_slb, 2743 /* NFOSMESA_GLWEIGHTPATHSNV */, SLB_NARGS(2), gl_pub, &resultPath);
}

static void APIENTRY exec_glBindTextureUnit(GLuint unit, GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)texture;
	(*exec)(gl_slb, 2744 /* NFOSMESA_GLBINDTEXTUREUNIT */, SLB_NARGS(2), gl_pub, &unit);
}

static void APIENTRY exec_glBlendBarrierKHR(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2745 /* NFOSMESA_GLBLENDBARRIERKHR */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glBlitNamedFramebuffer(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)drawFramebuffer;
	(void)srcX0;
	(void)srcY0;
	(void)srcX1;
	(void)srcY1;
	(void)dstX0;
	(void)dstY0;
	(void)dstX1;
	(void)dstY1;
	(void)mask;
	(void)filter;
	(*exec)(gl_slb, 2746 /* NFOSMESA_GLBLITNAMEDFRAMEBUFFER */, SLB_NARGS(2), gl_pub, &readFramebuffer);
}

static void APIENTRY exec_glBufferPageCommitmentARB(GLenum target, GLintptr offset, GLsizeiptr size, GLboolean32 commit)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)commit;
	(*exec)(gl_slb, 2747 /* NFOSMESA_GLBUFFERPAGECOMMITMENTARB */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCallCommandListNV(GLuint list)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2748 /* NFOSMESA_GLCALLCOMMANDLISTNV */, SLB_NARGS(2), gl_pub, &list);
}

static GLenum APIENTRY exec_glCheckNamedFramebufferStatus(GLuint framebuffer, GLenum target)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)target;
	return (GLenum)(*exec)(gl_slb, 2749 /* NFOSMESA_GLCHECKNAMEDFRAMEBUFFERSTATUS */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glClearNamedBufferData(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 2750 /* NFOSMESA_GLCLEARNAMEDBUFFERDATA */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearNamedBufferSubData(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)offset;
	(void)size;
	(void)format;
	(void)type;
	(void)data;
	(*exec)(gl_slb, 2751 /* NFOSMESA_GLCLEARNAMEDBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glClearNamedFramebufferfi(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)drawbuffer;
	(void)depth;
	(void)stencil;
	(*exec)(gl_slb, 2752 /* NFOSMESA_GLCLEARNAMEDFRAMEBUFFERFI */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glClearNamedFramebufferfv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)drawbuffer;
	(void)value;
	(*exec)(gl_slb, 2753 /* NFOSMESA_GLCLEARNAMEDFRAMEBUFFERFV */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glClearNamedFramebufferiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)drawbuffer;
	(void)value;
	(*exec)(gl_slb, 2754 /* NFOSMESA_GLCLEARNAMEDFRAMEBUFFERIV */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glClearNamedFramebufferuiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint *value)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)drawbuffer;
	(void)value;
	(*exec)(gl_slb, 2755 /* NFOSMESA_GLCLEARNAMEDFRAMEBUFFERUIV */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glClipControl(GLenum origin, GLenum depth)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)depth;
	(*exec)(gl_slb, 2756 /* NFOSMESA_GLCLIPCONTROL */, SLB_NARGS(2), gl_pub, &origin);
}

static void APIENTRY exec_glCommandListSegmentsNV(GLuint list, GLuint segments)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)segments;
	(*exec)(gl_slb, 2757 /* NFOSMESA_GLCOMMANDLISTSEGMENTSNV */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glCompileCommandListNV(GLuint list)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2758 /* NFOSMESA_GLCOMPILECOMMANDLISTNV */, SLB_NARGS(2), gl_pub, &list);
}

static void APIENTRY exec_glCompressedTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)width;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 2759 /* NFOSMESA_GLCOMPRESSEDTEXTURESUBIMAGE1D */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)width;
	(void)height;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 2760 /* NFOSMESA_GLCOMPRESSEDTEXTURESUBIMAGE2D */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCompressedTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)imageSize;
	(void)data;
	(*exec)(gl_slb, 2761 /* NFOSMESA_GLCOMPRESSEDTEXTURESUBIMAGE3D */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyNamedBufferSubData(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)writeBuffer;
	(void)readOffset;
	(void)writeOffset;
	(void)size;
	(*exec)(gl_slb, 2762 /* NFOSMESA_GLCOPYNAMEDBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &readBuffer);
}

static void APIENTRY exec_glCopyTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)x;
	(void)y;
	(void)width;
	(*exec)(gl_slb, 2763 /* NFOSMESA_GLCOPYTEXTURESUBIMAGE1D */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2764 /* NFOSMESA_GLCOPYTEXTURESUBIMAGE2D */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCopyTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2765 /* NFOSMESA_GLCOPYTEXTURESUBIMAGE3D */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glCoverageModulationNV(GLenum components)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2766 /* NFOSMESA_GLCOVERAGEMODULATIONNV */, SLB_NARGS(2), gl_pub, &components);
}

static void APIENTRY exec_glCoverageModulationTableNV(GLsizei n, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2767 /* NFOSMESA_GLCOVERAGEMODULATIONTABLENV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateBuffers(GLsizei n, GLuint *buffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffers;
	(*exec)(gl_slb, 2768 /* NFOSMESA_GLCREATEBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateCommandListsNV(GLsizei n, GLuint *lists)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)lists;
	(*exec)(gl_slb, 2769 /* NFOSMESA_GLCREATECOMMANDLISTSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateFramebuffers(GLsizei n, GLuint *framebuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)framebuffers;
	(*exec)(gl_slb, 2770 /* NFOSMESA_GLCREATEFRAMEBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateProgramPipelines(GLsizei n, GLuint *pipelines)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pipelines;
	(*exec)(gl_slb, 2771 /* NFOSMESA_GLCREATEPROGRAMPIPELINES */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateQueries(GLenum target, GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)ids;
	(*exec)(gl_slb, 2772 /* NFOSMESA_GLCREATEQUERIES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCreateRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)renderbuffers;
	(*exec)(gl_slb, 2773 /* NFOSMESA_GLCREATERENDERBUFFERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateSamplers(GLsizei n, GLuint *samplers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)samplers;
	(*exec)(gl_slb, 2774 /* NFOSMESA_GLCREATESAMPLERS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateStatesNV(GLsizei n, GLuint *states)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)states;
	(*exec)(gl_slb, 2775 /* NFOSMESA_GLCREATESTATESNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateTextures(GLenum target, GLsizei n, GLuint *textures)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)n;
	(void)textures;
	(*exec)(gl_slb, 2776 /* NFOSMESA_GLCREATETEXTURES */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glCreateTransformFeedbacks(GLsizei n, GLuint *ids)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)ids;
	(*exec)(gl_slb, 2777 /* NFOSMESA_GLCREATETRANSFORMFEEDBACKS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glCreateVertexArrays(GLsizei n, GLuint *arrays)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)arrays;
	(*exec)(gl_slb, 2778 /* NFOSMESA_GLCREATEVERTEXARRAYS */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteCommandListsNV(GLsizei n, const GLuint *lists)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)lists;
	(*exec)(gl_slb, 2779 /* NFOSMESA_GLDELETECOMMANDLISTSNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDeleteStatesNV(GLsizei n, const GLuint *states)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)states;
	(*exec)(gl_slb, 2780 /* NFOSMESA_GLDELETESTATESNV */, SLB_NARGS(2), gl_pub, &n);
}

static void APIENTRY exec_glDisableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 2781 /* NFOSMESA_GLDISABLEVERTEXARRAYATTRIB */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glDrawCommandsAddressNV(GLenum primitiveMode, const GLuint64 *indirects, const GLsizei *sizes, GLuint count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirects;
	(void)sizes;
	(void)count;
	(*exec)(gl_slb, 2782 /* NFOSMESA_GLDRAWCOMMANDSADDRESSNV */, SLB_NARGS(2), gl_pub, &primitiveMode);
}

static void APIENTRY exec_glDrawCommandsNV(GLenum primitiveMode, GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, GLuint count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)indirects;
	(void)sizes;
	(void)count;
	(*exec)(gl_slb, 2783 /* NFOSMESA_GLDRAWCOMMANDSNV */, SLB_NARGS(2), gl_pub, &primitiveMode);
}

static void APIENTRY exec_glDrawCommandsStatesAddressNV(const GLuint64 *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)sizes;
	(void)states;
	(void)fbos;
	(void)count;
	(*exec)(gl_slb, 2784 /* NFOSMESA_GLDRAWCOMMANDSSTATESADDRESSNV */, SLB_NARGS(2), gl_pub, &indirects);
}

static void APIENTRY exec_glDrawCommandsStatesNV(GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)indirects;
	(void)sizes;
	(void)states;
	(void)fbos;
	(void)count;
	(*exec)(gl_slb, 2785 /* NFOSMESA_GLDRAWCOMMANDSSTATESNV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glEnableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(*exec)(gl_slb, 2786 /* NFOSMESA_GLENABLEVERTEXARRAYATTRIB */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glFlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(*exec)(gl_slb, 2787 /* NFOSMESA_GLFLUSHMAPPEDNAMEDBUFFERRANGE */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glFragmentCoverageColorNV(GLuint color)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2788 /* NFOSMESA_GLFRAGMENTCOVERAGECOLORNV */, SLB_NARGS(2), gl_pub, &color);
}

static void APIENTRY exec_glFramebufferSampleLocationsfvNV(GLenum target, GLuint start, GLsizei count, const GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)start;
	(void)count;
	(void)v;
	(*exec)(gl_slb, 2789 /* NFOSMESA_GLFRAMEBUFFERSAMPLELOCATIONSFVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glFramebufferTextureMultiviewOVR(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseViewIndex, GLsizei numViews)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)texture;
	(void)level;
	(void)baseViewIndex;
	(void)numViews;
	(*exec)(gl_slb, 2790 /* NFOSMESA_GLFRAMEBUFFERTEXTUREMULTIVIEWOVR */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGenerateTextureMipmap(GLuint texture)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2791 /* NFOSMESA_GLGENERATETEXTUREMIPMAP */, SLB_NARGS(2), gl_pub, &texture);
}

static GLuint APIENTRY exec_glGetCommandHeaderNV(GLenum tokenID, GLuint size)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)size;
	return (GLuint)(*exec)(gl_slb, 2792 /* NFOSMESA_GLGETCOMMANDHEADERNV */, SLB_NARGS(2), gl_pub, &tokenID);
}

static void APIENTRY exec_glGetCompressedTextureImage(GLuint texture, GLint level, GLsizei bufSize, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)bufSize;
	(void)pixels;
	(*exec)(gl_slb, 2793 /* NFOSMESA_GLGETCOMPRESSEDTEXTUREIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetCompressedTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)bufSize;
	(void)pixels;
	(*exec)(gl_slb, 2794 /* NFOSMESA_GLGETCOMPRESSEDTEXTURESUBIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetCoverageModulationTableNV(GLsizei bufsize, GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)v;
	(*exec)(gl_slb, 2795 /* NFOSMESA_GLGETCOVERAGEMODULATIONTABLENV */, SLB_NARGS(2), gl_pub, &bufsize);
}

static GLenum APIENTRY exec_glGetGraphicsResetStatus(void)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLenum)(*exec)(gl_slb, 2796 /* NFOSMESA_GLGETGRAPHICSRESETSTATUS */, SLB_NARGS(2), gl_pub, NULL);
}

static void APIENTRY exec_glGetInternalformatSampleivNV(GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)internalformat;
	(void)samples;
	(void)pname;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 2797 /* NFOSMESA_GLGETINTERNALFORMATSAMPLEIVNV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2798 /* NFOSMESA_GLGETNAMEDBUFFERPARAMETERI64V */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2799 /* NFOSMESA_GLGETNAMEDBUFFERPARAMETERIV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedBufferPointerv(GLuint buffer, GLenum pname, void * *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2800 /* NFOSMESA_GLGETNAMEDBUFFERPOINTERV */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)size;
	(void)data;
	(*exec)(gl_slb, 2801 /* NFOSMESA_GLGETNAMEDBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glGetNamedFramebufferAttachmentParameteriv(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)attachment;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2802 /* NFOSMESA_GLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIV */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glGetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2803 /* NFOSMESA_GLGETNAMEDFRAMEBUFFERPARAMETERIV */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glGetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2804 /* NFOSMESA_GLGETNAMEDRENDERBUFFERPARAMETERIV */, SLB_NARGS(2), gl_pub, &renderbuffer);
}

static void APIENTRY exec_glGetProgramResourcefvNV(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)programInterface;
	(void)index;
	(void)propCount;
	(void)props;
	(void)bufSize;
	(void)length;
	(void)params;
	(*exec)(gl_slb, 2805 /* NFOSMESA_GLGETPROGRAMRESOURCEFVNV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)pname;
	(void)offset;
	(*exec)(gl_slb, 2806 /* NFOSMESA_GLGETQUERYBUFFEROBJECTI64V */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)pname;
	(void)offset;
	(*exec)(gl_slb, 2807 /* NFOSMESA_GLGETQUERYBUFFEROBJECTIV */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryBufferObjectui64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)pname;
	(void)offset;
	(*exec)(gl_slb, 2808 /* NFOSMESA_GLGETQUERYBUFFEROBJECTUI64V */, SLB_NARGS(2), gl_pub, &id);
}

static void APIENTRY exec_glGetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)buffer;
	(void)pname;
	(void)offset;
	(*exec)(gl_slb, 2809 /* NFOSMESA_GLGETQUERYBUFFEROBJECTUIV */, SLB_NARGS(2), gl_pub, &id);
}

static GLushort APIENTRY exec_glGetStageIndexNV(GLenum shadertype)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLushort)(*exec)(gl_slb, 2810 /* NFOSMESA_GLGETSTAGEINDEXNV */, SLB_NARGS(2), gl_pub, &shadertype);
}

static void APIENTRY exec_glGetTextureImage(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)pixels;
	(*exec)(gl_slb, 2811 /* NFOSMESA_GLGETTEXTUREIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureLevelParameterfv(GLuint texture, GLint level, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2812 /* NFOSMESA_GLGETTEXTURELEVELPARAMETERFV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureLevelParameteriv(GLuint texture, GLint level, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2813 /* NFOSMESA_GLGETTEXTURELEVELPARAMETERIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterIiv(GLuint texture, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2814 /* NFOSMESA_GLGETTEXTUREPARAMETERIIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2815 /* NFOSMESA_GLGETTEXTUREPARAMETERIUIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameterfv(GLuint texture, GLenum pname, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2816 /* NFOSMESA_GLGETTEXTUREPARAMETERFV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureParameteriv(GLuint texture, GLenum pname, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)params;
	(*exec)(gl_slb, 2817 /* NFOSMESA_GLGETTEXTUREPARAMETERIV */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)xoffset;
	(void)yoffset;
	(void)zoffset;
	(void)width;
	(void)height;
	(void)depth;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)pixels;
	(*exec)(gl_slb, 2818 /* NFOSMESA_GLGETTEXTURESUBIMAGE */, SLB_NARGS(2), gl_pub, &texture);
}

static void APIENTRY exec_glGetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)index;
	(void)param;
	(*exec)(gl_slb, 2819 /* NFOSMESA_GLGETTRANSFORMFEEDBACKI64_V */, SLB_NARGS(2), gl_pub, &xfb);
}

static void APIENTRY exec_glGetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)index;
	(void)param;
	(*exec)(gl_slb, 2820 /* NFOSMESA_GLGETTRANSFORMFEEDBACKI_V */, SLB_NARGS(2), gl_pub, &xfb);
}

static void APIENTRY exec_glGetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2821 /* NFOSMESA_GLGETTRANSFORMFEEDBACKIV */, SLB_NARGS(2), gl_pub, &xfb);
}

static void APIENTRY exec_glGetVertexArrayIndexed64iv(GLuint vaobj, GLuint index, GLenum pname, GLint64 *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2822 /* NFOSMESA_GLGETVERTEXARRAYINDEXED64IV */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)index;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2823 /* NFOSMESA_GLGETVERTEXARRAYINDEXEDIV */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetVertexArrayiv(GLuint vaobj, GLenum pname, GLint *param)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pname;
	(void)param;
	(*exec)(gl_slb, 2824 /* NFOSMESA_GLGETVERTEXARRAYIV */, SLB_NARGS(2), gl_pub, &vaobj);
}

static void APIENTRY exec_glGetnColorTable(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)table;
	(*exec)(gl_slb, 2825 /* NFOSMESA_GLGETNCOLORTABLE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnCompressedTexImage(GLenum target, GLint lod, GLsizei bufSize, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)lod;
	(void)bufSize;
	(void)pixels;
	(*exec)(gl_slb, 2826 /* NFOSMESA_GLGETNCOMPRESSEDTEXIMAGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnConvolutionFilter(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)image;
	(*exec)(gl_slb, 2827 /* NFOSMESA_GLGETNCONVOLUTIONFILTER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnHistogram(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 2828 /* NFOSMESA_GLGETNHISTOGRAM */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMapdv(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)bufSize;
	(void)v;
	(*exec)(gl_slb, 2829 /* NFOSMESA_GLGETNMAPDV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMapfv(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)bufSize;
	(void)v;
	(*exec)(gl_slb, 2830 /* NFOSMESA_GLGETNMAPFV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMapiv(GLenum target, GLenum query, GLsizei bufSize, GLint *v)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)query;
	(void)bufSize;
	(void)v;
	(*exec)(gl_slb, 2831 /* NFOSMESA_GLGETNMAPIV */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnMinmax(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)reset;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 2832 /* NFOSMESA_GLGETNMINMAX */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnPixelMapfv(GLenum map, GLsizei bufSize, GLfloat *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 2833 /* NFOSMESA_GLGETNPIXELMAPFV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetnPixelMapuiv(GLenum map, GLsizei bufSize, GLuint *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 2834 /* NFOSMESA_GLGETNPIXELMAPUIV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetnPixelMapusv(GLenum map, GLsizei bufSize, GLushort *values)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)bufSize;
	(void)values;
	(*exec)(gl_slb, 2835 /* NFOSMESA_GLGETNPIXELMAPUSV */, SLB_NARGS(2), gl_pub, &map);
}

static void APIENTRY exec_glGetnPolygonStipple(GLsizei bufSize, GLubyte *pattern)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)pattern;
	(*exec)(gl_slb, 2836 /* NFOSMESA_GLGETNPOLYGONSTIPPLE */, SLB_NARGS(2), gl_pub, &bufSize);
}

static void APIENTRY exec_glGetnSeparableFilter(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)format;
	(void)type;
	(void)rowBufSize;
	(void)row;
	(void)columnBufSize;
	(void)column;
	(void)span;
	(*exec)(gl_slb, 2837 /* NFOSMESA_GLGETNSEPARABLEFILTER */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)level;
	(void)format;
	(void)type;
	(void)bufSize;
	(void)pixels;
	(*exec)(gl_slb, 2838 /* NFOSMESA_GLGETNTEXIMAGE */, SLB_NARGS(2), gl_pub, &target);
}

static void APIENTRY exec_glGetnUniformdv(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 2839 /* NFOSMESA_GLGETNUNIFORMDV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetnUniformfv(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 2840 /* NFOSMESA_GLGETNUNIFORMFV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetnUniformiv(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 2841 /* NFOSMESA_GLGETNUNIFORMIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glGetnUniformuiv(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)location;
	(void)bufSize;
	(void)params;
	(*exec)(gl_slb, 2842 /* NFOSMESA_GLGETNUNIFORMUIV */, SLB_NARGS(2), gl_pub, &program);
}

static void APIENTRY exec_glInvalidateNamedFramebufferData(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numAttachments;
	(void)attachments;
	(*exec)(gl_slb, 2843 /* NFOSMESA_GLINVALIDATENAMEDFRAMEBUFFERDATA */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static void APIENTRY exec_glInvalidateNamedFramebufferSubData(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)numAttachments;
	(void)attachments;
	(void)x;
	(void)y;
	(void)width;
	(void)height;
	(*exec)(gl_slb, 2844 /* NFOSMESA_GLINVALIDATENAMEDFRAMEBUFFERSUBDATA */, SLB_NARGS(2), gl_pub, &framebuffer);
}

static GLboolean APIENTRY exec_glIsCommandListNV(GLuint list)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 2845 /* NFOSMESA_GLISCOMMANDLISTNV */, SLB_NARGS(2), gl_pub, &list);
}

static GLboolean APIENTRY exec_glIsStateNV(GLuint state)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	return (GLboolean)(*exec)(gl_slb, 2846 /* NFOSMESA_GLISSTATENV */, SLB_NARGS(2), gl_pub, &state);
}

static void APIENTRY exec_glListDrawCommandsStatesClientNV(GLuint list, GLuint segment, const void * *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)segment;
	(void)indirects;
	(void)sizes;
	(void)states;
	(void)fbos;
	(void)count;
	(*exec)(gl_slb, 2847 /* NFOSMESA_GLLISTDRAWCOMMANDSSTATESCLIENTNV */, SLB_NARGS(2), gl_pub, &list);
}

static void * APIENTRY exec_glMapNamedBuffer(GLuint buffer, GLenum access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)access;
	return (void *)(*exec)(gl_slb, 2848 /* NFOSMESA_GLMAPNAMEDBUFFER */, SLB_NARGS(2), gl_pub, &buffer);
}

static void * APIENTRY exec_glMapNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)offset;
	(void)length;
	(void)access;
	return (void *)(*exec)(gl_slb, 2849 /* NFOSMESA_GLMAPNAMEDBUFFERRANGE */, SLB_NARGS(2), gl_pub, &buffer);
}

static void APIENTRY exec_glMatrixLoad3x2fNV(GLenum matrixMode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2850 /* NFOSMESA_GLMATRIXLOAD3X2FNV */, SLB_NARGS(2), gl_pub, &matrixMode);
}

static void APIENTRY exec_glMatrixLoad3x3fNV(GLenum matrixMode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2851 /* NFOSMESA_GLMATRIXLOAD3X3FNV */, SLB_NARGS(2), gl_pub, &matrixMode);
}

static void APIENTRY exec_glMatrixLoadTranspose3x3fNV(GLenum matrixMode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2852 /* NFOSMESA_GLMATRIXLOADTRANSPOSE3X3FNV */, SLB_NARGS(2), gl_pub, &matrixMode);
}

static void APIENTRY exec_glMatrixMult3x2fNV(GLenum matrixMode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2853 /* NFOSMESA_GLMATRIXMULT3X2FNV */, SLB_NARGS(2), gl_pub, &matrixMode);
}

static void APIENTRY exec_glMatrixMult3x3fNV(GLenum matrixMode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2854 /* NFOSMESA_GLMATRIXMULT3X3FNV */, SLB_NARGS(2), gl_pub, &matrixMode);
}

static void APIENTRY exec_glMatrixMultTranspose3x3fNV(GLenum matrixMode, const GLfloat *m)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(void)m;
	(*exec)(gl_slb, 2855 /* NFOSMESA_GLMATRIXMULTTRANSPOSE3X3FNV */, SLB_NARGS(2), gl_pub, &matrixMode);
}

static void APIENTRY exec_glMemoryBarrierByRegion(GLbitfield barriers)
{
	long  __CDECL (*exec)(SLB_HANDLE, long, long, void *, void *) = (long  __CDECL (*)(SLB_HANDLE, long, long, void *, void *))gl_exec;
	(*exec)(gl_slb, 2856 /* NFOSMESA_GLMEMORYBARRIERBYREGION */, SLB_NARGS(2),