/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:37:03 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import java.awt.Graphics2D;
import java.util.List;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.alignment.BamView;
import uk.ac.sanger.artemis.components.alignment.SnpPanel;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class SnpPanel_ESTest extends SnpPanel_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(0).when(bamView0).getBaseAtStartOfView();
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((char[]) null).when(bases0).getSubSequenceC(any(uk.ac.sanger.artemis.io.Range.class) , anyInt());
      SnpPanel snpPanel0 = new SnpPanel(bamView0, bases0);
      assertNotNull(snpPanel0);
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusCycleRoot());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      
      SAMRecord sAMRecord0 = mock(SAMRecord.class, new ViolatedAssumptionAnswer());
      doReturn((List) null).when(sAMRecord0).getAlignmentBlocks();
      doReturn(0).when(sAMRecord0).getAlignmentEnd();
      doReturn(0).when(sAMRecord0).getAlignmentStart();
      doReturn((byte[]) null).when(sAMRecord0).getBaseQualities();
      doReturn((byte[]) null).when(sAMRecord0).getReadBases();
      // Undeclared exception!
      try { 
        snpPanel0.addRecord(sAMRecord0, (-1));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.SnpPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(522).when(bamView0).getBaseAtStartOfView();
      char[] charArray0 = new char[3];
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn(charArray0).when(bases0).getSubSequenceC(any(uk.ac.sanger.artemis.io.Range.class) , anyInt());
      SnpPanel snpPanel0 = new SnpPanel(bamView0, bases0);
      assertNotNull(snpPanel0);
      assertEquals(3, charArray0.length);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000'}, charArray0);
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusCycleRoot());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      
      byte[] byteArray0 = new byte[0];
      SAMRecord sAMRecord0 = mock(SAMRecord.class, new ViolatedAssumptionAnswer());
      doReturn((List<AlignmentBlock>) null).when(sAMRecord0).getAlignmentBlocks();
      doReturn(2).when(sAMRecord0).getAlignmentEnd();
      doReturn(1).when(sAMRecord0).getAlignmentStart();
      doReturn(byteArray0).when(sAMRecord0).getBaseQualities();
      doReturn(byteArray0).when(sAMRecord0).getReadBases();
      // Undeclared exception!
      try { 
        snpPanel0.addRecord(sAMRecord0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.SnpPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SnpPanel snpPanel0 = new SnpPanel(bamView0, bases0);
      assertNotNull(snpPanel0);
      assertFalse(snpPanel0.isFocusCycleRoot());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      
      snpPanel0.nBins = (-1272);
      assertFalse(snpPanel0.isFocusCycleRoot());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      
      Graphics2D graphics2D0 = mock(Graphics2D.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      try { 
        snpPanel0.draw(graphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.SnpPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      SnpPanel snpPanel0 = new SnpPanel((BamView) null, (Bases) null);
      assertNotNull(snpPanel0);
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusCycleRoot());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      
      SAMFileHeader sAMFileHeader0 = new SAMFileHeader();
      assertNotNull(sAMFileHeader0);
      assertNull(sAMFileHeader0.getTextHeader());
      assertEquals("1.5", sAMFileHeader0.getVersion());
      assertNull(sAMFileHeader0.getCreator());
      
      SAMRecord sAMRecord0 = new SAMRecord(sAMFileHeader0);
      assertEquals(0, SAMRecord.NO_MAPPING_QUALITY);
      assertEquals(255, SAMRecord.UNKNOWN_MAPPING_QUALITY);
      assertEquals(0, SAMRecord.NO_ALIGNMENT_START);
      assertEquals((-1), SAMRecord.NO_ALIGNMENT_REFERENCE_INDEX);
      assertEquals(536870912, SAMRecord.MAX_INSERT_SIZE);
      assertNotNull(sAMRecord0);
      assertNull(sAMFileHeader0.getTextHeader());
      assertEquals("1.5", sAMFileHeader0.getVersion());
      assertNull(sAMFileHeader0.getCreator());
      assertFalse(sAMRecord0.getReadUnmappedFlag());
      assertEquals("*", sAMRecord0.getMateReferenceName());
      assertFalse(sAMRecord0.getReadPairedFlag());
      assertFalse(sAMRecord0.getSupplementaryAlignmentFlag());
      assertNull(sAMRecord0.getReadName());
      assertEquals(0, sAMRecord0.getAlignmentStart());
      assertFalse(sAMRecord0.getReadNegativeStrandFlag());
      assertFalse(sAMRecord0.isSecondaryAlignment());
      assertEquals(ValidationStringency.SILENT, sAMRecord0.getValidationStringency());
      assertEquals(0, sAMRecord0.getMateAlignmentStart());
      assertEquals(0, sAMRecord0.getInferredInsertSize());
      assertFalse(sAMRecord0.isSecondaryOrSupplementary());
      assertFalse(sAMRecord0.getDuplicateReadFlag());
      assertEquals("*", sAMRecord0.getReferenceName());
      assertFalse(sAMRecord0.getReadFailsVendorQualityCheckFlag());
      assertEquals(0, sAMRecord0.getStart());
      assertEquals(0, sAMRecord0.getFlags());
      assertFalse(sAMRecord0.getNotPrimaryAlignmentFlag());
      assertEquals((-1), sAMRecord0.getAttributesBinarySize());
      assertEquals("*", sAMRecord0.getContig());
      assertEquals(0, sAMRecord0.getMappingQuality());
      assertEquals(0, sAMRecord0.getReadLength());
      
      snpPanel0.addRecord(sAMRecord0, 3098);
      assertEquals(0, SAMRecord.NO_MAPPING_QUALITY);
      assertEquals(255, SAMRecord.UNKNOWN_MAPPING_QUALITY);
      assertEquals(0, SAMRecord.NO_ALIGNMENT_START);
      assertEquals((-1), SAMRecord.NO_ALIGNMENT_REFERENCE_INDEX);
      assertEquals(536870912, SAMRecord.MAX_INSERT_SIZE);
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusCycleRoot());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      assertNull(sAMFileHeader0.getTextHeader());
      assertEquals("1.5", sAMFileHeader0.getVersion());
      assertNull(sAMFileHeader0.getCreator());
      assertFalse(sAMRecord0.getReadUnmappedFlag());
      assertEquals("*", sAMRecord0.getMateReferenceName());
      assertFalse(sAMRecord0.getReadPairedFlag());
      assertFalse(sAMRecord0.getSupplementaryAlignmentFlag());
      assertNull(sAMRecord0.getReadName());
      assertEquals(0, sAMRecord0.getAlignmentStart());
      assertFalse(sAMRecord0.getReadNegativeStrandFlag());
      assertFalse(sAMRecord0.isSecondaryAlignment());
      assertEquals(ValidationStringency.SILENT, sAMRecord0.getValidationStringency());
      assertEquals(0, sAMRecord0.getMateAlignmentStart());
      assertEquals(0, sAMRecord0.getInferredInsertSize());
      assertFalse(sAMRecord0.isSecondaryOrSupplementary());
      assertFalse(sAMRecord0.getDuplicateReadFlag());
      assertEquals("*", sAMRecord0.getReferenceName());
      assertFalse(sAMRecord0.getReadFailsVendorQualityCheckFlag());
      assertEquals(0, sAMRecord0.getStart());
      assertEquals(0, sAMRecord0.getFlags());
      assertFalse(sAMRecord0.getNotPrimaryAlignmentFlag());
      assertEquals((-1), sAMRecord0.getAttributesBinarySize());
      assertEquals("*", sAMRecord0.getContig());
      assertEquals(0, sAMRecord0.getMappingQuality());
      assertEquals(0, sAMRecord0.getReadLength());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      SnpPanel snpPanel0 = new SnpPanel((BamView) null, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(snpPanel0);
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusCycleRoot());
      
      // Undeclared exception!
      try { 
        snpPanel0.init((BamView) null, 1.0F, 1, (-5));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.SnpPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SnpPanel snpPanel0 = new SnpPanel(bamView0, bases0);
      assertNotNull(snpPanel0);
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusCycleRoot());
      
      BamView bamView1 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(61443).when(bamView1).getBasesInView();
      snpPanel0.init(bamView1, 2, 0, 61443);
      assertTrue(snpPanel0.getFocusTraversalKeysEnabled());
      assertFalse(snpPanel0.isFocusTraversalPolicySet());
      assertFalse(snpPanel0.getIgnoreRepaint());
      assertFalse(snpPanel0.isFocusTraversalPolicyProvider());
      assertFalse(snpPanel0.isFocusCycleRoot());
      
      // Undeclared exception!
      try { 
        snpPanel0.addRecord((SAMRecord) null, 2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.SnpPanel", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      BamView bamView0 = mock(BamView.class, new ViolatedAssumptionAnswer());
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SnpPanel snpPanel0 = new SnpPanel(bamView0, bases0);
      BamView bamView1 = mock(BamView.class, new ViolatedAssumptionAnswer());
      doReturn(0).when(bamView1).getBasesInView();
      snpPanel0.init(bamView1, 3518.542F, 607, (-259));
      SAMRecord sAMRecord0 = mock(SAMRecord.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      try { 
        snpPanel0.addRecord(sAMRecord0, (-813));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.SnpPanel", e);
      }
  }
}
