(defun ball-traj (pos vel acc)
   (let (newpos)
      (setq pos (v+ pos vel))
      (setq vel (v+ vel acc))
      (when (<= (elt pos 2) 0.0) 
	 (setf (elt pos 2) (- (- (elt pos 2) (elt vel 2))))
	 (setf (elt vel 2) (- (- (elt vel 2) (elt acc 2))) ))
      (when (<= (elt pos 0) 0.0)
	 (setf (elt pos 0) (- (elt pos 0)))
	 (setf (elt vel 0) (- (elt vel 0))) )
      (when (>= (elt pos 0) 300.0)
	 (setf (elt pos 0) (- (elt pos 0) (elt vel 0)))
	 (setf (elt vel 0) (- (elt vel 0))) )
     (list pos vel acc))
   )

(defun ball-move (count)
   (let ((pos (floatvector 100 0 100))
	 (vel (floatvector 10 0 0))
	 (acc (floatvector 0 0 -3))) 
     (dotimes (i count)
	(multiple-value-setq (pos vel acc) (ball-traj pos vel acc))
	(print (list pos vel acc))
	(send b :locate pos :world)
	(draw b)))
