# frozen_string_literal: true

class CreateVulnerabilityExportParts < Gitlab::Database::Migration[2.2]
  milestone '17.1'

  # rubocop:disable Migration/EnsureFactoryForTable -- False Positive
  def change
    create_table :vulnerability_export_parts do |t|
      t.references :vulnerability_export, foreign_key: { on_delete: :cascade }, null: false, index: true
      t.bigint :start_id, null: false
      t.bigint :end_id, null: false
      t.references :organization, foreign_key: { on_delete: :cascade }, null: false, default: 1
      t.integer :file_store
      t.text :file, limit: 255

      t.timestamps_with_timezone null: false
    end
  end
  # rubocop:enable Migration/EnsureFactoryForTable -- False Positive
end
