/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "sn-dbus-menu-gen.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_VariantVariantFunc)
       (void *data1,
        GVariant *arg_updatedProps,
        GVariant *arg_removedProps,
        void *data2);
  _GDbusCodegenMarshalVoid_VariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_VariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_variant (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintIntFunc)
       (void *data1,
        guint arg_revision,
        gint arg_parent,
        void *data2);
  _GDbusCodegenMarshalVoid_UintIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_int (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__INT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_IntUintFunc)
       (void *data1,
        gint arg_id,
        guint arg_timestamp,
        void *data2);
  _GDbusCodegenMarshalVoid_IntUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_IntUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_int (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_parentId,
        gint arg_recursionDepth,
        const gchar *const *arg_propertyNames,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_boxed (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_ids,
        const gchar *const *arg_propertyNames,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_boxed (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_id,
        const gchar *arg_name,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_STRING_VARIANT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntStringVariantUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_id,
        const gchar *arg_eventId,
        GVariant *arg_data,
        guint arg_timestamp,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntStringVariantUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntStringVariantUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              g_marshal_value_peek_uint (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_events,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface com.canonical.dbusmenu
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:SnDBusMenuGen
 * @title: SnDBusMenuGen
 * @short_description: Generated C code for the com.canonical.dbusmenu D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link> D-Bus interface in C.
 */

enum
{
  SN__DBUS_MENU_GEN_ITEMS_PROPERTIES_UPDATED,
  SN__DBUS_MENU_GEN_LAYOUT_UPDATED,
  SN__DBUS_MENU_GEN_ITEM_ACTIVATION_REQUESTED,
};

static unsigned SN__DBUS_MENU_GEN_SIGNALS[3] = { 0 };

/* ---- Introspection data for com.canonical.dbusmenu ---- */

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_layout_IN_ARG_parentId =
{
  {
    -1,
    (gchar *) "parentId",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_layout_IN_ARG_recursionDepth =
{
  {
    -1,
    (gchar *) "recursionDepth",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_layout_IN_ARG_propertyNames =
{
  {
    -1,
    (gchar *) "propertyNames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_get_layout_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_layout_IN_ARG_parentId.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_layout_IN_ARG_recursionDepth.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_layout_IN_ARG_propertyNames.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_layout_OUT_ARG_revision =
{
  {
    -1,
    (gchar *) "revision",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_layout_OUT_ARG_layout =
{
  {
    -1,
    (gchar *) "layout",
    (gchar *) "(ia{sv}av)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_get_layout_OUT_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_layout_OUT_ARG_revision.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_layout_OUT_ARG_layout.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_get_layout =
{
  {
    -1,
    (gchar *) "GetLayout",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_get_layout_IN_ARG_pointers,
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_get_layout_OUT_ARG_pointers,
    NULL
  },
  "handle-get-layout",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_group_properties_IN_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_group_properties_IN_ARG_propertyNames =
{
  {
    -1,
    (gchar *) "propertyNames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_get_group_properties_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_group_properties_IN_ARG_ids.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_group_properties_IN_ARG_propertyNames.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_group_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a(ia{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_get_group_properties_OUT_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_group_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_get_group_properties =
{
  {
    -1,
    (gchar *) "GetGroupProperties",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_get_group_properties_IN_ARG_pointers,
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_get_group_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-group-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_property_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_property_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_get_property_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_property_IN_ARG_id.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_property_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_get_property_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_get_property_OUT_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_property_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_get_property =
{
  {
    -1,
    (gchar *) "GetProperty",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_get_property_IN_ARG_pointers,
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_get_property_OUT_ARG_pointers,
    NULL
  },
  "handle-get-property",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_event_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_event_IN_ARG_eventId =
{
  {
    -1,
    (gchar *) "eventId",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_event_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_event_IN_ARG_timestamp =
{
  {
    -1,
    (gchar *) "timestamp",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_event_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_event_IN_ARG_id.parent_struct,
  &_sn_dbus_menu_gen_method_info_event_IN_ARG_eventId.parent_struct,
  &_sn_dbus_menu_gen_method_info_event_IN_ARG_data.parent_struct,
  &_sn_dbus_menu_gen_method_info_event_IN_ARG_timestamp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_event =
{
  {
    -1,
    (gchar *) "Event",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_event_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-event",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_event_group_IN_ARG_events =
{
  {
    -1,
    (gchar *) "events",
    (gchar *) "a(isvu)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_event_group_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_event_group_IN_ARG_events.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_event_group_OUT_ARG_idErrors =
{
  {
    -1,
    (gchar *) "idErrors",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_event_group_OUT_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_event_group_OUT_ARG_idErrors.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_event_group =
{
  {
    -1,
    (gchar *) "EventGroup",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_event_group_IN_ARG_pointers,
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_event_group_OUT_ARG_pointers,
    NULL
  },
  "handle-event-group",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_about_to_show_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_about_to_show_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_about_to_show_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_about_to_show_OUT_ARG_needUpdate =
{
  {
    -1,
    (gchar *) "needUpdate",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_about_to_show_OUT_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_about_to_show_OUT_ARG_needUpdate.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_about_to_show =
{
  {
    -1,
    (gchar *) "AboutToShow",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_about_to_show_IN_ARG_pointers,
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_about_to_show_OUT_ARG_pointers,
    NULL
  },
  "handle-about-to-show",
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_about_to_show_group_IN_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_about_to_show_group_IN_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_about_to_show_group_IN_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_about_to_show_group_OUT_ARG_updatesNeeded =
{
  {
    -1,
    (gchar *) "updatesNeeded",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_method_info_about_to_show_group_OUT_ARG_idErrors =
{
  {
    -1,
    (gchar *) "idErrors",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_method_info_about_to_show_group_OUT_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_about_to_show_group_OUT_ARG_updatesNeeded.parent_struct,
  &_sn_dbus_menu_gen_method_info_about_to_show_group_OUT_ARG_idErrors.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sn_dbus_menu_gen_method_info_about_to_show_group =
{
  {
    -1,
    (gchar *) "AboutToShowGroup",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_about_to_show_group_IN_ARG_pointers,
    (GDBusArgInfo **) &_sn_dbus_menu_gen_method_info_about_to_show_group_OUT_ARG_pointers,
    NULL
  },
  "handle-about-to-show-group",
  FALSE
};

static const GDBusMethodInfo * const _sn_dbus_menu_gen_method_info_pointers[] =
{
  &_sn_dbus_menu_gen_method_info_get_layout.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_group_properties.parent_struct,
  &_sn_dbus_menu_gen_method_info_get_property.parent_struct,
  &_sn_dbus_menu_gen_method_info_event.parent_struct,
  &_sn_dbus_menu_gen_method_info_event_group.parent_struct,
  &_sn_dbus_menu_gen_method_info_about_to_show.parent_struct,
  &_sn_dbus_menu_gen_method_info_about_to_show_group.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_signal_info_items_properties_updated_ARG_updatedProps =
{
  {
    -1,
    (gchar *) "updatedProps",
    (gchar *) "a(ia{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_signal_info_items_properties_updated_ARG_removedProps =
{
  {
    -1,
    (gchar *) "removedProps",
    (gchar *) "a(ias)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_signal_info_items_properties_updated_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_signal_info_items_properties_updated_ARG_updatedProps.parent_struct,
  &_sn_dbus_menu_gen_signal_info_items_properties_updated_ARG_removedProps.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sn_dbus_menu_gen_signal_info_items_properties_updated =
{
  {
    -1,
    (gchar *) "ItemsPropertiesUpdated",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_signal_info_items_properties_updated_ARG_pointers,
    NULL
  },
  "items-properties-updated"
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_signal_info_layout_updated_ARG_revision =
{
  {
    -1,
    (gchar *) "revision",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_signal_info_layout_updated_ARG_parent =
{
  {
    -1,
    (gchar *) "parent",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_signal_info_layout_updated_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_signal_info_layout_updated_ARG_revision.parent_struct,
  &_sn_dbus_menu_gen_signal_info_layout_updated_ARG_parent.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sn_dbus_menu_gen_signal_info_layout_updated =
{
  {
    -1,
    (gchar *) "LayoutUpdated",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_signal_info_layout_updated_ARG_pointers,
    NULL
  },
  "layout-updated"
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_signal_info_item_activation_requested_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sn_dbus_menu_gen_signal_info_item_activation_requested_ARG_timestamp =
{
  {
    -1,
    (gchar *) "timestamp",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sn_dbus_menu_gen_signal_info_item_activation_requested_ARG_pointers[] =
{
  &_sn_dbus_menu_gen_signal_info_item_activation_requested_ARG_id.parent_struct,
  &_sn_dbus_menu_gen_signal_info_item_activation_requested_ARG_timestamp.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sn_dbus_menu_gen_signal_info_item_activation_requested =
{
  {
    -1,
    (gchar *) "ItemActivationRequested",
    (GDBusArgInfo **) &_sn_dbus_menu_gen_signal_info_item_activation_requested_ARG_pointers,
    NULL
  },
  "item-activation-requested"
};

static const GDBusSignalInfo * const _sn_dbus_menu_gen_signal_info_pointers[] =
{
  &_sn_dbus_menu_gen_signal_info_items_properties_updated.parent_struct,
  &_sn_dbus_menu_gen_signal_info_layout_updated.parent_struct,
  &_sn_dbus_menu_gen_signal_info_item_activation_requested.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _sn_dbus_menu_gen_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_dbus_menu_gen_property_info_text_direction =
{
  {
    -1,
    (gchar *) "TextDirection",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "text-direction",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_dbus_menu_gen_property_info_status =
{
  {
    -1,
    (gchar *) "Status",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _sn_dbus_menu_gen_property_info_icon_theme_path =
{
  {
    -1,
    (gchar *) "IconThemePath",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-theme-path",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _sn_dbus_menu_gen_property_info_pointers[] =
{
  &_sn_dbus_menu_gen_property_info_version.parent_struct,
  &_sn_dbus_menu_gen_property_info_text_direction.parent_struct,
  &_sn_dbus_menu_gen_property_info_status.parent_struct,
  &_sn_dbus_menu_gen_property_info_icon_theme_path.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _sn_dbus_menu_gen_interface_info =
{
  {
    -1,
    (gchar *) "com.canonical.dbusmenu",
    (GDBusMethodInfo **) &_sn_dbus_menu_gen_method_info_pointers,
    (GDBusSignalInfo **) &_sn_dbus_menu_gen_signal_info_pointers,
    (GDBusPropertyInfo **) &_sn_dbus_menu_gen_property_info_pointers,
    NULL
  },
  "dbus-menu-gen",
};


/**
 * sn_dbus_menu_gen_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
sn_dbus_menu_gen_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_sn_dbus_menu_gen_interface_info.parent_struct;
}

/**
 * sn_dbus_menu_gen_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #SnDBusMenuGen interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
sn_dbus_menu_gen_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "text-direction");
  g_object_class_override_property (klass, property_id_begin++, "status");
  g_object_class_override_property (klass, property_id_begin++, "icon-theme-path");
  return property_id_begin - 1;
}


inline static void
sn_dbus_menu_gen_signal_marshal_items_properties_updated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_signal_marshal_layout_updated (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_signal_marshal_item_activation_requested (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_get_layout (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_get_group_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_get_property (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_event (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_STRING_VARIANT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_event_group (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_about_to_show (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
sn_dbus_menu_gen_method_marshal_about_to_show_group (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * SnDBusMenuGen:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link>.
 */

/**
 * SnDBusMenuGenIface:
 * @parent_iface: The parent interface.
 * @handle_about_to_show: Handler for the #SnDBusMenuGen::handle-about-to-show signal.
 * @handle_about_to_show_group: Handler for the #SnDBusMenuGen::handle-about-to-show-group signal.
 * @handle_event: Handler for the #SnDBusMenuGen::handle-event signal.
 * @handle_event_group: Handler for the #SnDBusMenuGen::handle-event-group signal.
 * @handle_get_group_properties: Handler for the #SnDBusMenuGen::handle-get-group-properties signal.
 * @handle_get_layout: Handler for the #SnDBusMenuGen::handle-get-layout signal.
 * @handle_get_property: Handler for the #SnDBusMenuGen::handle-get-property signal.
 * @get_icon_theme_path: Getter for the #SnDBusMenuGen:icon-theme-path property.
 * @get_status: Getter for the #SnDBusMenuGen:status property.
 * @get_text_direction: Getter for the #SnDBusMenuGen:text-direction property.
 * @get_version: Getter for the #SnDBusMenuGen:version property.
 * @item_activation_requested: Handler for the #SnDBusMenuGen::item-activation-requested signal.
 * @items_properties_updated: Handler for the #SnDBusMenuGen::items-properties-updated signal.
 * @layout_updated: Handler for the #SnDBusMenuGen::layout-updated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link>.
 */

typedef SnDBusMenuGenIface SnDBusMenuGenInterface;
G_DEFINE_INTERFACE (SnDBusMenuGen, sn_dbus_menu_gen, G_TYPE_OBJECT)

static void
sn_dbus_menu_gen_default_init (SnDBusMenuGenIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * SnDBusMenuGen::handle-get-layout:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parentId: Argument passed by remote caller.
   * @arg_recursionDepth: Argument passed by remote caller.
   * @arg_propertyNames: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.GetLayout">GetLayout()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_get_layout() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-layout",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_get_layout),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_get_layout,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRV);

  /**
   * SnDBusMenuGen::handle-get-group-properties:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_ids: Argument passed by remote caller.
   * @arg_propertyNames: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.GetGroupProperties">GetGroupProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_get_group_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-group-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_get_group_properties),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_get_group_properties,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_STRV);

  /**
   * SnDBusMenuGen::handle-get-property:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.GetProperty">GetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_get_property() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_get_property),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_get_property,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_STRING);

  /**
   * SnDBusMenuGen::handle-event:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_eventId: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   * @arg_timestamp: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.Event">Event()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_event() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_event),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_event,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT);

  /**
   * SnDBusMenuGen::handle-event-group:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_events: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.EventGroup">EventGroup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_event_group() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-event-group",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_event_group),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_event_group,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * SnDBusMenuGen::handle-about-to-show:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShow">AboutToShow()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_about_to_show() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-about-to-show",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_about_to_show),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_about_to_show,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * SnDBusMenuGen::handle-about-to-show-group:
   * @object: A #SnDBusMenuGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_ids: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShowGroup">AboutToShowGroup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sn_dbus_menu_gen_complete_about_to_show_group() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-about-to-show-group",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SnDBusMenuGenIface, handle_about_to_show_group),
    g_signal_accumulator_true_handled,
    NULL,
      sn_dbus_menu_gen_method_marshal_about_to_show_group,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * SnDBusMenuGen::items-properties-updated:
   * @object: A #SnDBusMenuGen.
   * @arg_updatedProps: Argument.
   * @arg_removedProps: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-canonical-dbusmenu.ItemsPropertiesUpdated">"ItemsPropertiesUpdated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  SN__DBUS_MENU_GEN_SIGNALS[SN__DBUS_MENU_GEN_ITEMS_PROPERTIES_UPDATED] =
    g_signal_new ("items-properties-updated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnDBusMenuGenIface, items_properties_updated),
      NULL,
      NULL,
      sn_dbus_menu_gen_signal_marshal_items_properties_updated,
      G_TYPE_NONE,
      2, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * SnDBusMenuGen::layout-updated:
   * @object: A #SnDBusMenuGen.
   * @arg_revision: Argument.
   * @arg_parent: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-canonical-dbusmenu.LayoutUpdated">"LayoutUpdated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  SN__DBUS_MENU_GEN_SIGNALS[SN__DBUS_MENU_GEN_LAYOUT_UPDATED] =
    g_signal_new ("layout-updated",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnDBusMenuGenIface, layout_updated),
      NULL,
      NULL,
      sn_dbus_menu_gen_signal_marshal_layout_updated,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_INT);

  /**
   * SnDBusMenuGen::item-activation-requested:
   * @object: A #SnDBusMenuGen.
   * @arg_id: Argument.
   * @arg_timestamp: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-canonical-dbusmenu.ItemActivationRequested">"ItemActivationRequested"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  SN__DBUS_MENU_GEN_SIGNALS[SN__DBUS_MENU_GEN_ITEM_ACTIVATION_REQUESTED] =
    g_signal_new ("item-activation-requested",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (SnDBusMenuGenIface, item_activation_requested),
      NULL,
      NULL,
      sn_dbus_menu_gen_signal_marshal_item_activation_requested,
      G_TYPE_NONE,
      2, G_TYPE_INT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * SnDBusMenuGen:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-dbusmenu.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "Version", "Version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnDBusMenuGen:text-direction:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-dbusmenu.TextDirection">"TextDirection"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("text-direction", "TextDirection", "TextDirection", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnDBusMenuGen:status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-dbusmenu.Status">"Status"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("status", "Status", "Status", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * SnDBusMenuGen:icon-theme-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-dbusmenu.IconThemePath">"IconThemePath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("icon-theme-path", "IconThemePath", "IconThemePath", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * sn_dbus_menu_gen_get_version: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-dbusmenu.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
sn_dbus_menu_gen_get_version (SnDBusMenuGen *object)
{
  g_return_val_if_fail (SN_IS_DBUS_MENU_GEN (object), 0);

  return SN_DBUS_MENU_GEN_GET_IFACE (object)->get_version (object);
}

/**
 * sn_dbus_menu_gen_set_version: (skip)
 * @object: A #SnDBusMenuGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-dbusmenu.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_dbus_menu_gen_set_version (SnDBusMenuGen *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * sn_dbus_menu_gen_get_text_direction: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-dbusmenu.TextDirection">"TextDirection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_dbus_menu_gen_dup_text_direction() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_dbus_menu_gen_get_text_direction (SnDBusMenuGen *object)
{
  g_return_val_if_fail (SN_IS_DBUS_MENU_GEN (object), NULL);

  return SN_DBUS_MENU_GEN_GET_IFACE (object)->get_text_direction (object);
}

/**
 * sn_dbus_menu_gen_dup_text_direction: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-dbusmenu.TextDirection">"TextDirection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_dbus_menu_gen_dup_text_direction (SnDBusMenuGen *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "text-direction", &value, NULL);
  return value;
}

/**
 * sn_dbus_menu_gen_set_text_direction: (skip)
 * @object: A #SnDBusMenuGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-dbusmenu.TextDirection">"TextDirection"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_dbus_menu_gen_set_text_direction (SnDBusMenuGen *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "text-direction", value, NULL);
}

/**
 * sn_dbus_menu_gen_get_status: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-dbusmenu.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_dbus_menu_gen_dup_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
sn_dbus_menu_gen_get_status (SnDBusMenuGen *object)
{
  g_return_val_if_fail (SN_IS_DBUS_MENU_GEN (object), NULL);

  return SN_DBUS_MENU_GEN_GET_IFACE (object)->get_status (object);
}

/**
 * sn_dbus_menu_gen_dup_status: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-dbusmenu.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
sn_dbus_menu_gen_dup_status (SnDBusMenuGen *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "status", &value, NULL);
  return value;
}

/**
 * sn_dbus_menu_gen_set_status: (skip)
 * @object: A #SnDBusMenuGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-dbusmenu.Status">"Status"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_dbus_menu_gen_set_status (SnDBusMenuGen *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "status", value, NULL);
}

/**
 * sn_dbus_menu_gen_get_icon_theme_path: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-dbusmenu.IconThemePath">"IconThemePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use sn_dbus_menu_gen_dup_icon_theme_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
sn_dbus_menu_gen_get_icon_theme_path (SnDBusMenuGen *object)
{
  g_return_val_if_fail (SN_IS_DBUS_MENU_GEN (object), NULL);

  return SN_DBUS_MENU_GEN_GET_IFACE (object)->get_icon_theme_path (object);
}

/**
 * sn_dbus_menu_gen_dup_icon_theme_path: (skip)
 * @object: A #SnDBusMenuGen.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-dbusmenu.IconThemePath">"IconThemePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
sn_dbus_menu_gen_dup_icon_theme_path (SnDBusMenuGen *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "icon-theme-path", &value, NULL);
  return value;
}

/**
 * sn_dbus_menu_gen_set_icon_theme_path: (skip)
 * @object: A #SnDBusMenuGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-dbusmenu.IconThemePath">"IconThemePath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
sn_dbus_menu_gen_set_icon_theme_path (SnDBusMenuGen *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "icon-theme-path", value, NULL);
}

/**
 * sn_dbus_menu_gen_emit_items_properties_updated:
 * @object: A #SnDBusMenuGen.
 * @arg_updatedProps: Argument to pass with the signal.
 * @arg_removedProps: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-canonical-dbusmenu.ItemsPropertiesUpdated">"ItemsPropertiesUpdated"</link> D-Bus signal.
 */
void
sn_dbus_menu_gen_emit_items_properties_updated (
    SnDBusMenuGen *object,
    GVariant *arg_updatedProps,
    GVariant *arg_removedProps)
{
  g_signal_emit (object, SN__DBUS_MENU_GEN_SIGNALS[SN__DBUS_MENU_GEN_ITEMS_PROPERTIES_UPDATED], 0, arg_updatedProps, arg_removedProps);
}

/**
 * sn_dbus_menu_gen_emit_layout_updated:
 * @object: A #SnDBusMenuGen.
 * @arg_revision: Argument to pass with the signal.
 * @arg_parent: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-canonical-dbusmenu.LayoutUpdated">"LayoutUpdated"</link> D-Bus signal.
 */
void
sn_dbus_menu_gen_emit_layout_updated (
    SnDBusMenuGen *object,
    guint arg_revision,
    gint arg_parent)
{
  g_signal_emit (object, SN__DBUS_MENU_GEN_SIGNALS[SN__DBUS_MENU_GEN_LAYOUT_UPDATED], 0, arg_revision, arg_parent);
}

/**
 * sn_dbus_menu_gen_emit_item_activation_requested:
 * @object: A #SnDBusMenuGen.
 * @arg_id: Argument to pass with the signal.
 * @arg_timestamp: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-canonical-dbusmenu.ItemActivationRequested">"ItemActivationRequested"</link> D-Bus signal.
 */
void
sn_dbus_menu_gen_emit_item_activation_requested (
    SnDBusMenuGen *object,
    gint arg_id,
    guint arg_timestamp)
{
  g_signal_emit (object, SN__DBUS_MENU_GEN_SIGNALS[SN__DBUS_MENU_GEN_ITEM_ACTIVATION_REQUESTED], 0, arg_id, arg_timestamp);
}

/**
 * sn_dbus_menu_gen_call_get_layout:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_parentId: Argument to pass with the method invocation.
 * @arg_recursionDepth: Argument to pass with the method invocation.
 * @arg_propertyNames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.GetLayout">GetLayout()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_get_layout_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_get_layout_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_get_layout (
    SnDBusMenuGen *proxy,
    gint arg_parentId,
    gint arg_recursionDepth,
    const gchar *const *arg_propertyNames,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetLayout",
    g_variant_new ("(ii^as)",
                   arg_parentId,
                   arg_recursionDepth,
                   arg_propertyNames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_get_layout_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @out_revision: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_layout: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_get_layout().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_get_layout().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_get_layout_finish (
    SnDBusMenuGen *proxy,
    guint *out_revision,
    GVariant **out_layout,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@(ia{sv}av))",
                 out_revision,
                 out_layout);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_get_layout_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_parentId: Argument to pass with the method invocation.
 * @arg_recursionDepth: Argument to pass with the method invocation.
 * @arg_propertyNames: Argument to pass with the method invocation.
 * @out_revision: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_layout: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.GetLayout">GetLayout()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_get_layout() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_get_layout_sync (
    SnDBusMenuGen *proxy,
    gint arg_parentId,
    gint arg_recursionDepth,
    const gchar *const *arg_propertyNames,
    guint *out_revision,
    GVariant **out_layout,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetLayout",
    g_variant_new ("(ii^as)",
                   arg_parentId,
                   arg_recursionDepth,
                   arg_propertyNames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@(ia{sv}av))",
                 out_revision,
                 out_layout);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_get_group_properties:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @arg_propertyNames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.GetGroupProperties">GetGroupProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_get_group_properties_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_get_group_properties_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_get_group_properties (
    SnDBusMenuGen *proxy,
    GVariant *arg_ids,
    const gchar *const *arg_propertyNames,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetGroupProperties",
    g_variant_new ("(@ai^as)",
                   arg_ids,
                   arg_propertyNames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_get_group_properties_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_get_group_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_get_group_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_get_group_properties_finish (
    SnDBusMenuGen *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ia{sv}))",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_get_group_properties_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @arg_propertyNames: Argument to pass with the method invocation.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.GetGroupProperties">GetGroupProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_get_group_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_get_group_properties_sync (
    SnDBusMenuGen *proxy,
    GVariant *arg_ids,
    const gchar *const *arg_propertyNames,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetGroupProperties",
    g_variant_new ("(@ai^as)",
                   arg_ids,
                   arg_propertyNames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ia{sv}))",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_get_property:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.GetProperty">GetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_get_property_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_get_property_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_get_property (
    SnDBusMenuGen *proxy,
    gint arg_id,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperty",
    g_variant_new ("(is)",
                   arg_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_get_property_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_get_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_get_property().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_get_property_finish (
    SnDBusMenuGen *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_get_property_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.GetProperty">GetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_get_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_get_property_sync (
    SnDBusMenuGen *proxy,
    gint arg_id,
    const gchar *arg_name,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperty",
    g_variant_new ("(is)",
                   arg_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_event:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_eventId: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.Event">Event()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_event_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_event_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_event (
    SnDBusMenuGen *proxy,
    gint arg_id,
    const gchar *arg_eventId,
    GVariant *arg_data,
    guint arg_timestamp,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Event",
    g_variant_new ("(is@vu)",
                   arg_id,
                   arg_eventId,
                   arg_data,
                   arg_timestamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_event_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_event().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_event().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_event_finish (
    SnDBusMenuGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_event_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_eventId: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.Event">Event()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_event() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_event_sync (
    SnDBusMenuGen *proxy,
    gint arg_id,
    const gchar *arg_eventId,
    GVariant *arg_data,
    guint arg_timestamp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Event",
    g_variant_new ("(is@vu)",
                   arg_id,
                   arg_eventId,
                   arg_data,
                   arg_timestamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_event_group:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_events: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.EventGroup">EventGroup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_event_group_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_event_group_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_event_group (
    SnDBusMenuGen *proxy,
    GVariant *arg_events,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EventGroup",
    g_variant_new ("(@a(isvu))",
                   arg_events),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_event_group_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @out_idErrors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_event_group().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_event_group().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_event_group_finish (
    SnDBusMenuGen *proxy,
    GVariant **out_idErrors,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_idErrors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_event_group_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_events: Argument to pass with the method invocation.
 * @out_idErrors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.EventGroup">EventGroup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_event_group() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_event_group_sync (
    SnDBusMenuGen *proxy,
    GVariant *arg_events,
    GVariant **out_idErrors,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EventGroup",
    g_variant_new ("(@a(isvu))",
                   arg_events),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_idErrors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_about_to_show:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShow">AboutToShow()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_about_to_show_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_about_to_show_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_about_to_show (
    SnDBusMenuGen *proxy,
    gint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AboutToShow",
    g_variant_new ("(i)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_about_to_show_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @out_needUpdate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_about_to_show().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_about_to_show().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_about_to_show_finish (
    SnDBusMenuGen *proxy,
    gboolean *out_needUpdate,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_needUpdate);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_about_to_show_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_needUpdate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShow">AboutToShow()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_about_to_show() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_about_to_show_sync (
    SnDBusMenuGen *proxy,
    gint arg_id,
    gboolean *out_needUpdate,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AboutToShow",
    g_variant_new ("(i)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_needUpdate);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_about_to_show_group:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShowGroup">AboutToShowGroup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_call_about_to_show_group_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_call_about_to_show_group_sync() for the synchronous, blocking version of this method.
 */
void
sn_dbus_menu_gen_call_about_to_show_group (
    SnDBusMenuGen *proxy,
    GVariant *arg_ids,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AboutToShowGroup",
    g_variant_new ("(@ai)",
                   arg_ids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sn_dbus_menu_gen_call_about_to_show_group_finish:
 * @proxy: A #SnDBusMenuGenProxy.
 * @out_updatesNeeded: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_idErrors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_call_about_to_show_group().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sn_dbus_menu_gen_call_about_to_show_group().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_about_to_show_group_finish (
    SnDBusMenuGen *proxy,
    GVariant **out_updatesNeeded,
    GVariant **out_idErrors,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai@ai)",
                 out_updatesNeeded,
                 out_idErrors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_call_about_to_show_group_sync:
 * @proxy: A #SnDBusMenuGenProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @out_updatesNeeded: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_idErrors: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShowGroup">AboutToShowGroup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_call_about_to_show_group() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
sn_dbus_menu_gen_call_about_to_show_group_sync (
    SnDBusMenuGen *proxy,
    GVariant *arg_ids,
    GVariant **out_updatesNeeded,
    GVariant **out_idErrors,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AboutToShowGroup",
    g_variant_new ("(@ai)",
                   arg_ids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai@ai)",
                 out_updatesNeeded,
                 out_idErrors);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sn_dbus_menu_gen_complete_get_layout:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @revision: Parameter to return.
 * @layout: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.GetLayout">GetLayout()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_get_layout (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint revision,
    GVariant *layout)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@(ia{sv}av))",
                   revision,
                   layout));
}

/**
 * sn_dbus_menu_gen_complete_get_group_properties:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.GetGroupProperties">GetGroupProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_get_group_properties (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(ia{sv}))",
                   properties));
}

/**
 * sn_dbus_menu_gen_complete_get_property:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.GetProperty">GetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_get_property (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   value));
}

/**
 * sn_dbus_menu_gen_complete_event:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.Event">Event()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_event (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * sn_dbus_menu_gen_complete_event_group:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @idErrors: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.EventGroup">EventGroup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_event_group (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *idErrors)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ai)",
                   idErrors));
}

/**
 * sn_dbus_menu_gen_complete_about_to_show:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @needUpdate: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShow">AboutToShow()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_about_to_show (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean needUpdate)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   needUpdate));
}

/**
 * sn_dbus_menu_gen_complete_about_to_show_group:
 * @object: A #SnDBusMenuGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @updatesNeeded: Parameter to return.
 * @idErrors: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-dbusmenu.AboutToShowGroup">AboutToShowGroup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sn_dbus_menu_gen_complete_about_to_show_group (
    SnDBusMenuGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *updatesNeeded,
    GVariant *idErrors)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ai@ai)",
                   updatesNeeded,
                   idErrors));
}

/* ------------------------------------------------------------------------ */

/**
 * SnDBusMenuGenProxy:
 *
 * The #SnDBusMenuGenProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * SnDBusMenuGenProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #SnDBusMenuGenProxy.
 */

struct _SnDBusMenuGenProxyPrivate
{
  GData *qdata;
};

static void sn_dbus_menu_gen_proxy_iface_init (SnDBusMenuGenIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (SnDBusMenuGenProxy, sn_dbus_menu_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (SnDBusMenuGenProxy)
                         G_IMPLEMENT_INTERFACE (SN_TYPE_DBUS_MENU_GEN, sn_dbus_menu_gen_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (SnDBusMenuGenProxy, sn_dbus_menu_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (SN_TYPE_DBUS_MENU_GEN, sn_dbus_menu_gen_proxy_iface_init))

#endif
static void
sn_dbus_menu_gen_proxy_finalize (GObject *object)
{
  SnDBusMenuGenProxy *proxy = SN_DBUS_MENU_GEN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (sn_dbus_menu_gen_proxy_parent_class)->finalize (object);
}

static void
sn_dbus_menu_gen_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _sn_dbus_menu_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
sn_dbus_menu_gen_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface com.canonical.dbusmenu: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
sn_dbus_menu_gen_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _sn_dbus_menu_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "com.canonical.dbusmenu", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) sn_dbus_menu_gen_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
sn_dbus_menu_gen_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_sn_dbus_menu_gen_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], SN_TYPE_DBUS_MENU_GEN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, SN_TYPE_DBUS_MENU_GEN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
sn_dbus_menu_gen_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  SnDBusMenuGenProxy *proxy = SN_DBUS_MENU_GEN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_dbus_menu_gen_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_dbus_menu_gen_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
sn_dbus_menu_gen_proxy_get_version (SnDBusMenuGen *object)
{
  SnDBusMenuGenProxy *proxy = SN_DBUS_MENU_GEN_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_dbus_menu_gen_proxy_get_text_direction (SnDBusMenuGen *object)
{
  SnDBusMenuGenProxy *proxy = SN_DBUS_MENU_GEN_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TextDirection");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
sn_dbus_menu_gen_proxy_get_status (SnDBusMenuGen *object)
{
  SnDBusMenuGenProxy *proxy = SN_DBUS_MENU_GEN_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Status");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
sn_dbus_menu_gen_proxy_get_icon_theme_path (SnDBusMenuGen *object)
{
  SnDBusMenuGenProxy *proxy = SN_DBUS_MENU_GEN_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "IconThemePath");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconThemePath");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "IconThemePath", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
sn_dbus_menu_gen_proxy_init (SnDBusMenuGenProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = sn_dbus_menu_gen_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, SN_TYPE_DBUS_MENU_GEN_PROXY, SnDBusMenuGenProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), sn_dbus_menu_gen_interface_info ());
}

static void
sn_dbus_menu_gen_proxy_class_init (SnDBusMenuGenProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = sn_dbus_menu_gen_proxy_finalize;
  gobject_class->get_property = sn_dbus_menu_gen_proxy_get_property;
  gobject_class->set_property = sn_dbus_menu_gen_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = sn_dbus_menu_gen_proxy_g_signal;
  proxy_class->g_properties_changed = sn_dbus_menu_gen_proxy_g_properties_changed;

  sn_dbus_menu_gen_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (SnDBusMenuGenProxyPrivate));
#endif
}

static void
sn_dbus_menu_gen_proxy_iface_init (SnDBusMenuGenIface *iface)
{
  iface->get_version = sn_dbus_menu_gen_proxy_get_version;
  iface->get_text_direction = sn_dbus_menu_gen_proxy_get_text_direction;
  iface->get_status = sn_dbus_menu_gen_proxy_get_status;
  iface->get_icon_theme_path = sn_dbus_menu_gen_proxy_get_icon_theme_path;
}

/**
 * sn_dbus_menu_gen_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_proxy_new_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
sn_dbus_menu_gen_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (SN_TYPE_DBUS_MENU_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.canonical.dbusmenu", NULL);
}

/**
 * sn_dbus_menu_gen_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with sn_dbus_menu_gen_proxy_new().
 *
 * Returns: (transfer full) (type SnDBusMenuGenProxy): The constructed proxy object or %NULL if @error is set.
 */
SnDBusMenuGen *
sn_dbus_menu_gen_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SN_DBUS_MENU_GEN (ret);
  else
    return NULL;
}

/**
 * sn_dbus_menu_gen_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type SnDBusMenuGenProxy): The constructed proxy object or %NULL if @error is set.
 */
SnDBusMenuGen *
sn_dbus_menu_gen_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (SN_TYPE_DBUS_MENU_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.canonical.dbusmenu", NULL);
  if (ret != NULL)
    return SN_DBUS_MENU_GEN (ret);
  else
    return NULL;
}


/**
 * sn_dbus_menu_gen_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like sn_dbus_menu_gen_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sn_dbus_menu_gen_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See sn_dbus_menu_gen_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
sn_dbus_menu_gen_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (SN_TYPE_DBUS_MENU_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.canonical.dbusmenu", NULL);
}

/**
 * sn_dbus_menu_gen_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sn_dbus_menu_gen_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with sn_dbus_menu_gen_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type SnDBusMenuGenProxy): The constructed proxy object or %NULL if @error is set.
 */
SnDBusMenuGen *
sn_dbus_menu_gen_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SN_DBUS_MENU_GEN (ret);
  else
    return NULL;
}

/**
 * sn_dbus_menu_gen_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like sn_dbus_menu_gen_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See sn_dbus_menu_gen_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type SnDBusMenuGenProxy): The constructed proxy object or %NULL if @error is set.
 */
SnDBusMenuGen *
sn_dbus_menu_gen_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (SN_TYPE_DBUS_MENU_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.canonical.dbusmenu", NULL);
  if (ret != NULL)
    return SN_DBUS_MENU_GEN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * SnDBusMenuGenSkeleton:
 *
 * The #SnDBusMenuGenSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * SnDBusMenuGenSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #SnDBusMenuGenSkeleton.
 */

struct _SnDBusMenuGenSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_sn_dbus_menu_gen_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], SN_TYPE_DBUS_MENU_GEN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, SN_TYPE_DBUS_MENU_GEN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_sn_dbus_menu_gen_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_dbus_menu_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_sn_dbus_menu_gen_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sn_dbus_menu_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _sn_dbus_menu_gen_skeleton_vtable =
{
  _sn_dbus_menu_gen_skeleton_handle_method_call,
  _sn_dbus_menu_gen_skeleton_handle_get_property,
  _sn_dbus_menu_gen_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
sn_dbus_menu_gen_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return sn_dbus_menu_gen_interface_info ();
}

static GDBusInterfaceVTable *
sn_dbus_menu_gen_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_sn_dbus_menu_gen_skeleton_vtable;
}

static GVariant *
sn_dbus_menu_gen_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_sn_dbus_menu_gen_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _sn_dbus_menu_gen_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _sn_dbus_menu_gen_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _sn_dbus_menu_gen_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.canonical.dbusmenu", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _sn_dbus_menu_gen_emit_changed (gpointer user_data);

static void
sn_dbus_menu_gen_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _sn_dbus_menu_gen_emit_changed (skeleton);
}

static void
_sn_dbus_menu_gen_on_signal_items_properties_updated (
    SnDBusMenuGen *object,
    GVariant *arg_updatedProps,
    GVariant *arg_removedProps)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a(ia{sv})@a(ias))",
                   arg_updatedProps,
                   arg_removedProps));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.canonical.dbusmenu", "ItemsPropertiesUpdated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_dbus_menu_gen_on_signal_layout_updated (
    SnDBusMenuGen *object,
    guint arg_revision,
    gint arg_parent)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ui)",
                   arg_revision,
                   arg_parent));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.canonical.dbusmenu", "LayoutUpdated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_sn_dbus_menu_gen_on_signal_item_activation_requested (
    SnDBusMenuGen *object,
    gint arg_id,
    guint arg_timestamp)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(iu)",
                   arg_id,
                   arg_timestamp));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.canonical.dbusmenu", "ItemActivationRequested",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void sn_dbus_menu_gen_skeleton_iface_init (SnDBusMenuGenIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (SnDBusMenuGenSkeleton, sn_dbus_menu_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (SnDBusMenuGenSkeleton)
                         G_IMPLEMENT_INTERFACE (SN_TYPE_DBUS_MENU_GEN, sn_dbus_menu_gen_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (SnDBusMenuGenSkeleton, sn_dbus_menu_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (SN_TYPE_DBUS_MENU_GEN, sn_dbus_menu_gen_skeleton_iface_init))

#endif
static void
sn_dbus_menu_gen_skeleton_finalize (GObject *object)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (sn_dbus_menu_gen_skeleton_parent_class)->finalize (object);
}

static void
sn_dbus_menu_gen_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_sn_dbus_menu_gen_emit_changed (gpointer user_data)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "com.canonical.dbusmenu",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_sn_dbus_menu_gen_schedule_emit_changed (SnDBusMenuGenSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
sn_dbus_menu_gen_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _sn_dbus_menu_gen_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _sn_dbus_menu_gen_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
sn_dbus_menu_gen_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _sn_dbus_menu_gen_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _sn_dbus_menu_gen_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
sn_dbus_menu_gen_skeleton_init (SnDBusMenuGenSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = sn_dbus_menu_gen_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, SN_TYPE_DBUS_MENU_GEN_SKELETON, SnDBusMenuGenSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRV);
}

static guint 
sn_dbus_menu_gen_skeleton_get_version (SnDBusMenuGen *object)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_dbus_menu_gen_skeleton_get_text_direction (SnDBusMenuGen *object)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
sn_dbus_menu_gen_skeleton_get_status (SnDBusMenuGen *object)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
sn_dbus_menu_gen_skeleton_get_icon_theme_path (SnDBusMenuGen *object)
{
  SnDBusMenuGenSkeleton *skeleton = SN_DBUS_MENU_GEN_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
sn_dbus_menu_gen_skeleton_class_init (SnDBusMenuGenSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = sn_dbus_menu_gen_skeleton_finalize;
  gobject_class->get_property = sn_dbus_menu_gen_skeleton_get_property;
  gobject_class->set_property = sn_dbus_menu_gen_skeleton_set_property;
  gobject_class->notify       = sn_dbus_menu_gen_skeleton_notify;


  sn_dbus_menu_gen_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = sn_dbus_menu_gen_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = sn_dbus_menu_gen_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = sn_dbus_menu_gen_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = sn_dbus_menu_gen_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (SnDBusMenuGenSkeletonPrivate));
#endif
}

static void
sn_dbus_menu_gen_skeleton_iface_init (SnDBusMenuGenIface *iface)
{
  iface->items_properties_updated = _sn_dbus_menu_gen_on_signal_items_properties_updated;
  iface->layout_updated = _sn_dbus_menu_gen_on_signal_layout_updated;
  iface->item_activation_requested = _sn_dbus_menu_gen_on_signal_item_activation_requested;
  iface->get_version = sn_dbus_menu_gen_skeleton_get_version;
  iface->get_text_direction = sn_dbus_menu_gen_skeleton_get_text_direction;
  iface->get_status = sn_dbus_menu_gen_skeleton_get_status;
  iface->get_icon_theme_path = sn_dbus_menu_gen_skeleton_get_icon_theme_path;
}

/**
 * sn_dbus_menu_gen_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-com-canonical-dbusmenu.top_of_page">com.canonical.dbusmenu</link>.
 *
 * Returns: (transfer full) (type SnDBusMenuGenSkeleton): The skeleton object.
 */
SnDBusMenuGen *
sn_dbus_menu_gen_skeleton_new (void)
{
  return SN_DBUS_MENU_GEN (g_object_new (SN_TYPE_DBUS_MENU_GEN_SKELETON, NULL));
}

