package main

import (
	"testing"
)

func TestMarshalJID(t *testing.T) {
	jids := [...]string{"user@example.com", "user@example.com."}
	for _, jid := range jids {
		marshalledJid, err := MarshalJID(jid)
		if err != nil {
			t.Errorf("Failed to marshal JID: %v", err)
		}
		if marshalledJid != "user@example.com" {
			t.Errorf("Expected 'user@example.com', got '%s'", marshalledJid)
		}
	}
	badJids := [...]string{
		"@user@example.com.", "@user@example.com",
		"user@example.com/",
	}
	for _, jid := range badJids {
		_, err := MarshalJID(jid)
		if err == nil {
			t.Errorf("Expected error, but got none")
		}
	}
}
