# segment

A Go library for performing Unicode Text Segmentation
as described in [Unicode Standard Annex #29](http://www.unicode.org/reports/tr29/)

## Features

* Currently only segmentation at Word Boundaries is supported.

## License

Apache License Version 2.0

## Usage

The functionality is exposed in two ways:

1.  You can use a bufio.Scanner with the SplitWords implementation of SplitFunc.
The SplitWords function will identify the appropriate word boundaries in the input
text and the Scanner will return tokens at the appropriate place.

		scanner := bufio.NewScanner(...)
		scanner.Split(segment.SplitWords)
		for scanner.Scan() {
			tokenBytes := scanner.Bytes()
		}
		if err := scanner.Err(); err != nil {
			t.Fatal(err)
		}

2.  Sometimes you would also like information returned about the type of token.
To do this we have introduce a new type named Segmenter.  It works just like Scanner
but additionally a token type is returned.

		segmenter := segment.NewWordSegmenter(...)
		for segmenter.Segment() {
			tokenBytes := segmenter.Bytes())
			tokenType := segmenter.Type()
		}
		if err := segmenter.Err(); err != nil {
			t.Fatal(err)
		}

## Choosing Implementation

By default segment does NOT use the fastest runtime implementation.  The reason is that it adds approximately 5s to compilation time and may require more than 1GB of ram on the machine performing compilation.

However, you can choose to build with the fastest runtime implementation by passing the build tag as follows:

		-tags 'prod'

## Generating Code

Several components in this package are generated.

1.  Several Ragel rules files are generated from Unicode properties files.
2.  Ragel machine is generated from the Ragel rules.
3.  Test tables are generated from the Unicode test files.

All of these can be generated by running:

		go generate

## Fuzzing

There is support for fuzzing the segment library with [go-fuzz](https://github.com/dvyukov/go-fuzz).

1.  Install go-fuzz if you haven't already:

		go get github.com/dvyukov/go-fuzz/go-fuzz
		go get github.com/dvyukov/go-fuzz/go-fuzz-build

2.  Build the package with go-fuzz:

		go-fuzz-build github.com/blevesearch/segment

3.  Convert the Unicode provided test cases into the initial corpus for go-fuzz:

		go test -v -run=TestGenerateWordSegmentFuzz -tags gofuzz_generate

4.  Run go-fuzz:

		go-fuzz -bin=segment-fuzz.zip -workdir=workdir

## Status


[![Build Status](https://travis-ci.org/blevesearch/segment.svg?branch=master)](https://travis-ci.org/blevesearch/segment)

[![Coverage Status](https://img.shields.io/coveralls/blevesearch/segment.svg)](https://coveralls.io/r/blevesearch/segment?branch=master)

[![GoDoc](https://godoc.org/github.com/blevesearch/segment?status.svg)](https://godoc.org/github.com/blevesearch/segment)