// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/application_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The Request of the CreateApplication method.
type CreateApplicationRequest struct {
	// Required. Resource name of the profile under which the application is created.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}".
	// For example, "projects/foo/tenants/bar/profiles/baz".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The application to be created.
	Application          *Application `protobuf:"bytes,2,opt,name=application,proto3" json:"application,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateApplicationRequest) Reset()         { *m = CreateApplicationRequest{} }
func (m *CreateApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateApplicationRequest) ProtoMessage()    {}
func (*CreateApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d34b1b7148314cc, []int{0}
}

func (m *CreateApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateApplicationRequest.Unmarshal(m, b)
}
func (m *CreateApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateApplicationRequest.Marshal(b, m, deterministic)
}
func (m *CreateApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateApplicationRequest.Merge(m, src)
}
func (m *CreateApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateApplicationRequest.Size(m)
}
func (m *CreateApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateApplicationRequest proto.InternalMessageInfo

func (m *CreateApplicationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateApplicationRequest) GetApplication() *Application {
	if m != nil {
		return m.Application
	}
	return nil
}

// Request for getting a application by name.
type GetApplicationRequest struct {
	// Required. The resource name of the application to be retrieved.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}/applications/{application_id}".
	// For example, "projects/foo/tenants/bar/profiles/baz/applications/qux".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetApplicationRequest) Reset()         { *m = GetApplicationRequest{} }
func (m *GetApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*GetApplicationRequest) ProtoMessage()    {}
func (*GetApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d34b1b7148314cc, []int{1}
}

func (m *GetApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetApplicationRequest.Unmarshal(m, b)
}
func (m *GetApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetApplicationRequest.Marshal(b, m, deterministic)
}
func (m *GetApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetApplicationRequest.Merge(m, src)
}
func (m *GetApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_GetApplicationRequest.Size(m)
}
func (m *GetApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetApplicationRequest proto.InternalMessageInfo

func (m *GetApplicationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for updating a specified application.
type UpdateApplicationRequest struct {
	// Required. The application resource to replace the current resource in the system.
	Application *Application `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	// Strongly recommended for the best service experience.
	//
	// If [update_mask][google.cloud.talent.v4beta1.UpdateApplicationRequest.update_mask] is provided, only the specified fields in
	// [application][google.cloud.talent.v4beta1.UpdateApplicationRequest.application] are updated. Otherwise all the fields are updated.
	//
	// A field mask to specify the application fields to be updated. Only
	// top level fields of [Application][google.cloud.talent.v4beta1.Application] are supported.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateApplicationRequest) Reset()         { *m = UpdateApplicationRequest{} }
func (m *UpdateApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateApplicationRequest) ProtoMessage()    {}
func (*UpdateApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d34b1b7148314cc, []int{2}
}

func (m *UpdateApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateApplicationRequest.Unmarshal(m, b)
}
func (m *UpdateApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateApplicationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateApplicationRequest.Merge(m, src)
}
func (m *UpdateApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateApplicationRequest.Size(m)
}
func (m *UpdateApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateApplicationRequest proto.InternalMessageInfo

func (m *UpdateApplicationRequest) GetApplication() *Application {
	if m != nil {
		return m.Application
	}
	return nil
}

func (m *UpdateApplicationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to delete a application.
type DeleteApplicationRequest struct {
	// Required. The resource name of the application to be deleted.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}/applications/{application_id}".
	// For example, "projects/foo/tenants/bar/profiles/baz/applications/qux".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteApplicationRequest) Reset()         { *m = DeleteApplicationRequest{} }
func (m *DeleteApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteApplicationRequest) ProtoMessage()    {}
func (*DeleteApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d34b1b7148314cc, []int{3}
}

func (m *DeleteApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteApplicationRequest.Unmarshal(m, b)
}
func (m *DeleteApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteApplicationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteApplicationRequest.Merge(m, src)
}
func (m *DeleteApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteApplicationRequest.Size(m)
}
func (m *DeleteApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteApplicationRequest proto.InternalMessageInfo

func (m *DeleteApplicationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List applications for which the client has ACL visibility.
type ListApplicationsRequest struct {
	// Required. Resource name of the profile under which the application is created.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}", for
	// example, "projects/foo/tenants/bar/profiles/baz".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The starting indicator from which to return results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of applications to be returned, at most 100.
	// Default is 100 if a non-positive number is provided.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListApplicationsRequest) Reset()         { *m = ListApplicationsRequest{} }
func (m *ListApplicationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListApplicationsRequest) ProtoMessage()    {}
func (*ListApplicationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d34b1b7148314cc, []int{4}
}

func (m *ListApplicationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApplicationsRequest.Unmarshal(m, b)
}
func (m *ListApplicationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApplicationsRequest.Marshal(b, m, deterministic)
}
func (m *ListApplicationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApplicationsRequest.Merge(m, src)
}
func (m *ListApplicationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListApplicationsRequest.Size(m)
}
func (m *ListApplicationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApplicationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListApplicationsRequest proto.InternalMessageInfo

func (m *ListApplicationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListApplicationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListApplicationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The List applications response object.
type ListApplicationsResponse struct {
	// Applications for the current client.
	Applications []*Application `protobuf:"bytes,1,rep,name=applications,proto3" json:"applications,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata             *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListApplicationsResponse) Reset()         { *m = ListApplicationsResponse{} }
func (m *ListApplicationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListApplicationsResponse) ProtoMessage()    {}
func (*ListApplicationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5d34b1b7148314cc, []int{5}
}

func (m *ListApplicationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApplicationsResponse.Unmarshal(m, b)
}
func (m *ListApplicationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApplicationsResponse.Marshal(b, m, deterministic)
}
func (m *ListApplicationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApplicationsResponse.Merge(m, src)
}
func (m *ListApplicationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListApplicationsResponse.Size(m)
}
func (m *ListApplicationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApplicationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListApplicationsResponse proto.InternalMessageInfo

func (m *ListApplicationsResponse) GetApplications() []*Application {
	if m != nil {
		return m.Applications
	}
	return nil
}

func (m *ListApplicationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListApplicationsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateApplicationRequest)(nil), "google.cloud.talent.v4beta1.CreateApplicationRequest")
	proto.RegisterType((*GetApplicationRequest)(nil), "google.cloud.talent.v4beta1.GetApplicationRequest")
	proto.RegisterType((*UpdateApplicationRequest)(nil), "google.cloud.talent.v4beta1.UpdateApplicationRequest")
	proto.RegisterType((*DeleteApplicationRequest)(nil), "google.cloud.talent.v4beta1.DeleteApplicationRequest")
	proto.RegisterType((*ListApplicationsRequest)(nil), "google.cloud.talent.v4beta1.ListApplicationsRequest")
	proto.RegisterType((*ListApplicationsResponse)(nil), "google.cloud.talent.v4beta1.ListApplicationsResponse")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/application_service.proto", fileDescriptor_5d34b1b7148314cc)
}

var fileDescriptor_5d34b1b7148314cc = []byte{
	// 809 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcb, 0x6e, 0xd3, 0x4c,
	0x18, 0xd5, 0x24, 0xff, 0x5f, 0xb5, 0x93, 0xff, 0x42, 0x07, 0x41, 0x83, 0x4b, 0xd5, 0x10, 0x24,
	0x88, 0xa2, 0xd6, 0x23, 0x42, 0xbb, 0x69, 0x05, 0xc2, 0x29, 0x17, 0x81, 0x5a, 0x35, 0x72, 0x8a,
	0x90, 0x58, 0x10, 0x4d, 0x9c, 0x49, 0xea, 0xd6, 0xf6, 0x18, 0xcf, 0xa4, 0x85, 0xa2, 0x6e, 0x90,
	0x78, 0x01, 0x78, 0x03, 0x56, 0x6c, 0x79, 0x00, 0x5e, 0x80, 0x15, 0x02, 0x36, 0x84, 0x4d, 0x17,
	0x3c, 0x05, 0x62, 0x81, 0xec, 0x71, 0x52, 0x37, 0xce, 0xa5, 0x69, 0xd9, 0xd9, 0x33, 0xdf, 0x99,
	0x39, 0xe7, 0x3b, 0x33, 0xc7, 0x86, 0x8b, 0x0d, 0xc6, 0x1a, 0x16, 0xc5, 0x86, 0xc5, 0x9a, 0x35,
	0x2c, 0x88, 0x45, 0x1d, 0x81, 0x77, 0x16, 0xaa, 0x54, 0x90, 0x6b, 0x98, 0xb8, 0xae, 0x65, 0x1a,
	0x44, 0x98, 0xcc, 0xa9, 0x70, 0xea, 0xed, 0x98, 0x06, 0x55, 0x5d, 0x8f, 0x09, 0x86, 0xa6, 0x25,
	0x4c, 0x0d, 0x60, 0xaa, 0x84, 0xa9, 0x21, 0x4c, 0xb9, 0x18, 0xae, 0x49, 0x5c, 0x13, 0x13, 0xc7,
	0x61, 0x22, 0x58, 0x81, 0x4b, 0xa8, 0x32, 0x15, 0x99, 0x35, 0x2c, 0xd3, 0x07, 0xca, 0x89, 0xd9,
	0xc8, 0x44, 0xdd, 0xa4, 0x56, 0xad, 0x52, 0xa5, 0x9b, 0x64, 0xc7, 0x64, 0x5e, 0x58, 0x70, 0x21,
	0x52, 0xe0, 0x51, 0xce, 0x9a, 0x5e, 0x9b, 0x8f, 0x32, 0x7f, 0x4c, 0x19, 0x61, 0x79, 0x6e, 0x50,
	0xb9, 0xc1, 0x6c, 0xbb, 0x53, 0x19, 0x0a, 0xc5, 0xc1, 0x5b, 0xb5, 0x59, 0xc7, 0xd4, 0x76, 0xc5,
	0xf3, 0x70, 0x32, 0xd3, 0x3d, 0x29, 0x69, 0xdb, 0x84, 0x6f, 0xcb, 0x8a, 0xec, 0x3b, 0x00, 0xd3,
	0x2b, 0x1e, 0x25, 0x82, 0x6a, 0x87, 0x24, 0x74, 0xfa, 0xb4, 0x49, 0xb9, 0x40, 0xcb, 0x70, 0xcc,
	0x25, 0x1e, 0x75, 0x44, 0x1a, 0x64, 0x40, 0x6e, 0xa2, 0x78, 0xf9, 0x40, 0x4b, 0xfc, 0xd4, 0x66,
	0xe0, 0xf4, 0x16, 0xab, 0x72, 0x55, 0xae, 0x4d, 0x5c, 0x93, 0xab, 0x06, 0xb3, 0x71, 0xc9, 0x63,
	0x75, 0xd3, 0xa2, 0x7a, 0x08, 0x41, 0xeb, 0x30, 0x15, 0xd1, 0x95, 0x4e, 0x64, 0x40, 0x2e, 0x55,
	0xc8, 0xa9, 0x03, 0x7c, 0x51, 0x23, 0x14, 0x8a, 0xc9, 0x03, 0x2d, 0xa1, 0x47, 0x57, 0xc8, 0x6e,
	0xc0, 0x73, 0xf7, 0xa8, 0xe8, 0x49, 0xf3, 0x2f, 0x87, 0xd8, 0x34, 0x24, 0x79, 0x35, 0x20, 0x79,
	0x09, 0xce, 0xf6, 0x22, 0x19, 0x45, 0x07, 0xa0, 0xa0, 0x01, 0x0f, 0xdd, 0x5a, 0xef, 0x06, 0x74,
	0x69, 0x00, 0xa7, 0xd5, 0x80, 0x96, 0x61, 0xaa, 0x19, 0x6c, 0x16, 0x78, 0x10, 0x36, 0x45, 0x69,
	0x2f, 0xd8, 0xb6, 0x49, 0xbd, 0xeb, 0xdb, 0xb4, 0x46, 0xf8, 0xb6, 0x0e, 0x65, 0xb9, 0xff, 0x9c,
	0x7d, 0x04, 0xd3, 0xb7, 0xa9, 0x45, 0xfb, 0x58, 0x75, 0x8a, 0x1e, 0xbc, 0x06, 0x70, 0x6a, 0xd5,
	0xe4, 0xd1, 0xde, 0xf2, 0x3f, 0x72, 0x06, 0x66, 0x20, 0x74, 0x49, 0x83, 0x56, 0x04, 0xdb, 0xa6,
	0xf2, 0x08, 0x4c, 0xe8, 0x13, 0xfe, 0xc8, 0x86, 0x3f, 0x80, 0xa6, 0x61, 0xf0, 0x52, 0xe1, 0xe6,
	0x1e, 0x4d, 0x27, 0x33, 0x20, 0xf7, 0xb7, 0x3e, 0xee, 0x0f, 0x94, 0xcd, 0x3d, 0x9a, 0xfd, 0x0e,
	0x60, 0x3a, 0x4e, 0x8a, 0xbb, 0xcc, 0xe1, 0x14, 0xad, 0xc2, 0x7f, 0x22, 0x6d, 0xe5, 0x69, 0x90,
	0x49, 0x8e, 0xe2, 0x8c, 0x7e, 0x04, 0x8d, 0xae, 0xc0, 0xff, 0x1d, 0xfa, 0x4c, 0x54, 0x62, 0x5c,
	0xff, 0xf5, 0x87, 0x4b, 0x1d, 0xbe, 0xf7, 0xe1, 0xb8, 0x4d, 0x05, 0xa9, 0x11, 0x41, 0x02, 0xba,
	0xa9, 0xc2, 0xfc, 0xc0, 0x1d, 0xdb, 0x74, 0xd7, 0x42, 0x90, 0xde, 0x81, 0x17, 0x7e, 0x8d, 0x43,
	0x14, 0x21, 0x54, 0x96, 0xe1, 0x85, 0xbe, 0x02, 0x38, 0x19, 0xbb, 0x8e, 0x68, 0x71, 0xe0, 0x2e,
	0xfd, 0xae, 0xaf, 0x72, 0xec, 0x76, 0x64, 0x9f, 0xb4, 0x34, 0x24, 0x2d, 0x9b, 0x8b, 0x34, 0xe6,
	0xe5, 0x97, 0x1f, 0x6f, 0x12, 0x2b, 0xd9, 0x9b, 0x9d, 0xe0, 0x79, 0x21, 0x6b, 0x6e, 0xb8, 0x1e,
	0xdb, 0xa2, 0x86, 0xe0, 0x38, 0x8f, 0x05, 0x75, 0x88, 0x13, 0x3c, 0xb9, 0xd2, 0x7b, 0x8e, 0xf3,
	0xfb, 0xd1, 0x40, 0xe3, 0x4b, 0x20, 0x8f, 0x3e, 0x00, 0xf8, 0xdf, 0xd1, 0xbb, 0x8b, 0x0a, 0x03,
	0xc9, 0xf5, 0xbc, 0xe8, 0x23, 0x08, 0x5a, 0x6b, 0x69, 0xc1, 0xd1, 0x0e, 0x24, 0xdc, 0x42, 0x11,
	0x09, 0xfe, 0xe8, 0x30, 0x01, 0x47, 0xf8, 0xe3, 0xfc, 0x3e, 0xfa, 0x06, 0xe0, 0x64, 0x2c, 0x24,
	0x86, 0xd8, 0xd2, 0x2f, 0x54, 0x46, 0x50, 0x61, 0xb4, 0xb4, 0x54, 0xb7, 0x1f, 0xeb, 0x85, 0x07,
	0x87, 0x62, 0xa2, 0x1f, 0x8e, 0x93, 0x08, 0xf3, 0xbd, 0x79, 0x0f, 0xe0, 0x64, 0x2c, 0x56, 0x86,
	0x68, 0xeb, 0x17, 0x43, 0xca, 0xf9, 0x58, 0x94, 0xdd, 0xf1, 0x3f, 0x47, 0x5d, 0x7e, 0xe4, 0x4f,
	0xeb, 0xc7, 0x27, 0x00, 0xcf, 0x74, 0x67, 0x03, 0x5a, 0x18, 0x48, 0xb9, 0x4f, 0xbe, 0x29, 0x8b,
	0x23, 0xa2, 0xe4, 0x8d, 0xce, 0xae, 0xb7, 0xb4, 0x30, 0xe4, 0xe2, 0x47, 0xec, 0x24, 0xb7, 0x44,
	0xb1, 0x3e, 0x6a, 0x67, 0x7b, 0x44, 0xea, 0x67, 0xad, 0xbc, 0x29, 0x84, 0xcb, 0x97, 0x30, 0xde,
	0xdd, 0xdd, 0xed, 0xce, 0x5b, 0xd2, 0x14, 0x9b, 0xf2, 0x1f, 0x61, 0xde, 0xb5, 0x88, 0xa8, 0x33,
	0xcf, 0x9e, 0x1b, 0x56, 0xee, 0x6f, 0x52, 0x7c, 0x05, 0xe0, 0xac, 0xc1, 0xec, 0x41, 0xda, 0x8b,
	0x53, 0xf1, 0x7c, 0x2a, 0xf9, 0xae, 0x96, 0xc0, 0x63, 0x2d, 0xc4, 0x35, 0x98, 0x45, 0x9c, 0x86,
	0xca, 0xbc, 0x06, 0x6e, 0x50, 0x27, 0xf0, 0x1c, 0x1f, 0xee, 0xd9, 0xf3, 0xef, 0x65, 0x59, 0xbe,
	0xbe, 0x4d, 0x24, 0x57, 0x36, 0xca, 0xd5, 0xb1, 0x00, 0x73, 0xfd, 0x77, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x30, 0x61, 0x50, 0x7e, 0xe6, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ApplicationServiceClient is the client API for ApplicationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApplicationServiceClient interface {
	// Creates a new application entity.
	CreateApplication(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Retrieves specified application.
	GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Updates specified application.
	UpdateApplication(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Deletes specified application.
	DeleteApplication(ctx context.Context, in *DeleteApplicationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists all applications associated with the profile.
	ListApplications(ctx context.Context, in *ListApplicationsRequest, opts ...grpc.CallOption) (*ListApplicationsResponse, error)
}

type applicationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationServiceClient(cc grpc.ClientConnInterface) ApplicationServiceClient {
	return &applicationServiceClient{cc}
}

func (c *applicationServiceClient) CreateApplication(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ApplicationService/CreateApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ApplicationService/GetApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) UpdateApplication(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ApplicationService/UpdateApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) DeleteApplication(ctx context.Context, in *DeleteApplicationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ApplicationService/DeleteApplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ListApplications(ctx context.Context, in *ListApplicationsRequest, opts ...grpc.CallOption) (*ListApplicationsResponse, error) {
	out := new(ListApplicationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ApplicationService/ListApplications", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationServiceServer is the server API for ApplicationService service.
type ApplicationServiceServer interface {
	// Creates a new application entity.
	CreateApplication(context.Context, *CreateApplicationRequest) (*Application, error)
	// Retrieves specified application.
	GetApplication(context.Context, *GetApplicationRequest) (*Application, error)
	// Updates specified application.
	UpdateApplication(context.Context, *UpdateApplicationRequest) (*Application, error)
	// Deletes specified application.
	DeleteApplication(context.Context, *DeleteApplicationRequest) (*empty.Empty, error)
	// Lists all applications associated with the profile.
	ListApplications(context.Context, *ListApplicationsRequest) (*ListApplicationsResponse, error)
}

// UnimplementedApplicationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedApplicationServiceServer struct {
}

func (*UnimplementedApplicationServiceServer) CreateApplication(ctx context.Context, req *CreateApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApplication not implemented")
}
func (*UnimplementedApplicationServiceServer) GetApplication(ctx context.Context, req *GetApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApplication not implemented")
}
func (*UnimplementedApplicationServiceServer) UpdateApplication(ctx context.Context, req *UpdateApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApplication not implemented")
}
func (*UnimplementedApplicationServiceServer) DeleteApplication(ctx context.Context, req *DeleteApplicationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteApplication not implemented")
}
func (*UnimplementedApplicationServiceServer) ListApplications(ctx context.Context, req *ListApplicationsRequest) (*ListApplicationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApplications not implemented")
}

func RegisterApplicationServiceServer(s *grpc.Server, srv ApplicationServiceServer) {
	s.RegisterService(&_ApplicationService_serviceDesc, srv)
}

func _ApplicationService_CreateApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).CreateApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ApplicationService/CreateApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).CreateApplication(ctx, req.(*CreateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ApplicationService/GetApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetApplication(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_UpdateApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).UpdateApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ApplicationService/UpdateApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).UpdateApplication(ctx, req.(*UpdateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_DeleteApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).DeleteApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ApplicationService/DeleteApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).DeleteApplication(ctx, req.(*DeleteApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ListApplications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ListApplications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ApplicationService/ListApplications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ListApplications(ctx, req.(*ListApplicationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApplicationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.ApplicationService",
	HandlerType: (*ApplicationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateApplication",
			Handler:    _ApplicationService_CreateApplication_Handler,
		},
		{
			MethodName: "GetApplication",
			Handler:    _ApplicationService_GetApplication_Handler,
		},
		{
			MethodName: "UpdateApplication",
			Handler:    _ApplicationService_UpdateApplication_Handler,
		},
		{
			MethodName: "DeleteApplication",
			Handler:    _ApplicationService_DeleteApplication_Handler,
		},
		{
			MethodName: "ListApplications",
			Handler:    _ApplicationService_ListApplications_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/application_service.proto",
}
