package build

import org.gradle.api.Project
import org.gradle.api.internal.initialization.DefaultClassLoaderScope
import org.gradle.api.tasks.testing.Test
import org.gradle.api.tasks.testing.logging.TestExceptionFormat


fun Project.withTestStrictClassLoading() {
    tasks.withType(Test::class.java) { test ->
        test.systemProperty(DefaultClassLoaderScope.STRICT_MODE_PROPERTY, true)
    }
}


fun Project.withTestWorkersMemoryLimits(min: String = "64m", max: String = "128m") {
    tasks.withType(Test::class.java) { test ->
        test.jvmArgs("-Xms$min", "-Xmx$max")
    }
}


fun Project.withParallelTests() {
    tasks.withType(Test::class.java) { test ->
        test.testLogging { logging ->
            logging.events("failed")
            logging.exceptionFormat = TestExceptionFormat.FULL
        }
        val maxWorkerCount = gradle.startParameter.maxWorkerCount
        test.maxParallelForks = if (maxWorkerCount < 2) 1 else maxWorkerCount / 2
        test.logger.info("${test.path} will run with maxParallelForks=${test.maxParallelForks}.")
    }
}

