#include <stdio.h>
# define U(x) ((x)&0377)
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = NULL, *yyout = NULL;
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* ----------------------------------------------------------------- 
FILE:	    readnets_lex                               
DESCRIPTION:rules for lexical analyzer in readnets.  This lexical
	    analyzer uses a binary search to reduce the size of 
	    the f.a.  generated by lex.  Thanks to Gary Richey who 
	    showed me the trick.  See chapter 3 of "Introduction
	    to Compiler Construction with UNIX" by Schreiner &
	    Friedman for more details.
CONTENTS:   lex rules -
	    screen()
DATE:	    Oct 19, 1988 - original coding 
	    static char SccsId[] = "@(#) readnets.l version 3.9 4/18/91" ;
REVISIONS:  Feb  9, 1990 - expanded ASCII character set.
	    Apr 23, 1990 - added Cstyle comments.
	    Sun Dec 16 00:41:42 EST 1990 - added max_voltage_drop
		and added comma to input format.
	    Thu Dec 20 00:01:20 EST 1990 - updated FLOAT def.
	    Mon Jan 21 22:31:24 PST 1991 - added ASCII charset for
		alphanum.
	    Thu Mar 14 16:13:06 CST 1991 - added missing characters.
	    Fri Mar 22 20:03:52 CST 1991 - made letter more general.
	    Thu Apr 18 01:43:35 EDT 1991 - moved placement of COLON
----------------------------------------------------------------- */
#undef   YYLMAX 
#define  YYLMAX 2000       /* comments may be at most 2000 characters */

#define token(x)      x    /* makes it look like regular lex */
#define END(v) (v-1 + sizeof(v) / sizeof( v[0] ) ) /* for table lookup */

static INT screen() ;
static void check_line_count() ;

static int yylook(void);
static int yyback(int *p, int m);

# define YYNEWLINE 10
INT yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

		      {
			/* C-style comments over multiple lines */
          		check_line_count(yytext) ;
	              }
break;
case 2:
      { 
		         /* convert to an integer */
		         yylval.ival = atoi( yytext ) ;
	  	         return (INTEGER); 
	              }
break;
case 3:
 {
		         /* convert to an integer */
		         yylval.fval = atof( yytext ) ;
	  	         return (FLOAT); 
		      }
break;
case 4:
 {
		         /* convert to an integer */
		         yylval.fval = atof( yytext ) ;
	  	         return (FLOAT); 
		      }
break;
case 5:
              {  return(COLON); }
break;
case 6:
  {  return( screen() ) ; }
break;
case 7:
              {  return(COMMA); }
break;
case 8:
           {  line_countS++;}
break;
case 9:
             ;
break;
case 10:
              {  return( token(yytext[0]) ) ;}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* reserved word screener */
/* ----------------------------------------------------------------- 
    The following is table of the reserved words - Table must be in
    alphabetical order for binary search to work properly.
----------------------------------------------------------------- */
static struct rw_table {  /* reserved word table */
    char *rw_name ;      /* pattern */
    INT rw_yylex  ;      /* lex token number */
} rwtable[] = {
    "cap_match",         token(CAP_MATCH),
    "cap_upper_bound",   token(CAP_UPPER_BOUND),
    "common_point",      token(COMMON_POINT),
    "max_voltage_drop",  token(MAX_VOLTAGE_DROP),
    "net",               token(NET),
    "net_cap_match",     token(NET_CAP_MATCH),
    "net_res_match",     token(NET_RES_MATCH),
    "noisy",             token(NOISY),
    "path",              token(PATH),
    "res_match",         token(RES_MATCH),
    "res_upper_bound",   token(RES_UPPER_BOUND),
    "sensitive",         token(SENSITIVE),
    "shielding",         token(SHIELDING),
    "timing",            token(TIMING)
} ;

static INT screen() 
{
    INT c ;
    struct rw_table  *low = rwtable,        /* ptr to beginning */
		     *mid ,  
		     *high = END(rwtable) ;   /* ptr to end */

    /* binary search to look thru table to find pattern match */
    while( low <= high){
	mid = low + (high-low) / 2 ;
	if( (c = strcmp(mid->rw_name, yytext) ) == STRINGEQ){
	    return( mid->rw_yylex ) ; /* return token number */
	} else if( c < 0 ){
	    low = mid + 1 ;
	} else {
	    high = mid - 1 ;
	}
    }
    /* at this point we haven't found a match so we have a string */
    /* save the string by making copy */
    yylval.string = (char *) Ystrclone( yytext ) ;
    return (STRING); 
		
} /* end screen function */

static void check_line_count( s ) 
char *s ;
{
    if( s ){
	if( strlen(s) >= YYLMAX ){
	    sprintf(YmsgG, "comment beginning at line %d ",line_countS+1 );
	    M( ERRMSG, "lex", YmsgG ) ;
	    sprintf(YmsgG,"exceeds maximum allowed length:%d chars.\n", 
		YYLMAX );
	    M( MSG, NULL, YmsgG ) ;
	    setErrorFlag() ;
	}
	for( ;*s;s++ ){
	    if( *s == '\n'){
		line_countS++;
	    }
	}
    }
} /* end check_line_count */
int yyvstop[] ={
0,

9,
0,

9,
0,

10,
0,

9,
10,
0,

8,
0,

6,
10,
0,

6,
10,
0,

6,
7,
10,
0,

3,
6,
10,
0,

6,
10,
0,

2,
10,
0,

5,
6,
10,
0,

9,
0,

6,
0,

3,
6,
0,

2,
6,
0,

6,
0,

3,
6,
0,

2,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

4,
6,
0,

6,
0,

6,
0,

1,
6,
0,

1,
0,

6,
0,

1,
6,
0,

1,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
4,13,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,6,	4,13,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
1,7,	1,8,	10,17,	1,9,	
1,10,	1,11,	22,22,	29,35,	
30,36,	34,28,	35,29,	36,29,	
0,0,	0,0,	7,15,	1,12,	
7,16,	7,16,	7,16,	7,16,	
7,16,	7,16,	7,16,	7,16,	
7,16,	7,16,	1,6,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	6,14,	6,14,	6,14,	
6,14,	9,15,	9,15,	9,15,	
9,15,	9,15,	9,15,	9,15,	
9,15,	9,15,	9,15,	11,18,	
0,0,	11,19,	11,19,	11,19,	
11,19,	11,19,	11,19,	11,19,	
11,19,	11,19,	11,19,	15,15,	
15,15,	15,15,	15,15,	15,15,	
15,15,	15,15,	15,15,	15,15,	
15,15,	16,18,	11,20,	16,16,	
16,16,	16,16,	16,16,	16,16,	
16,16,	16,16,	16,16,	16,16,	
16,16,	0,0,	0,0,	0,0,	
0,0,	17,21,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
16,20,	17,21,	17,21,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	11,20,	0,0,	
18,18,	18,18,	18,18,	18,18,	
18,18,	18,18,	18,18,	18,18,	
18,18,	18,18,	0,0,	0,0,	
0,0,	17,22,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
16,20,	18,20,	17,23,	17,22,	
17,22,	0,0,	17,22,	17,24,	
17,22,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	19,18,	17,22,	19,19,	
19,19,	19,19,	19,19,	19,19,	
19,19,	19,19,	19,19,	19,19,	
19,19,	17,22,	0,0,	0,0,	
0,0,	18,20,	0,0,	0,0,	
20,25,	0,0,	20,25,	0,0,	
19,20,	20,26,	20,26,	20,26,	
20,26,	20,26,	20,26,	20,26,	
20,26,	20,26,	20,26,	21,21,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	23,28,	
21,27,	21,21,	21,21,	0,0,	
21,21,	21,21,	21,21,	23,28,	
23,28,	0,0,	0,0,	0,0,	
19,20,	0,0,	0,0,	0,0,	
21,21,	25,26,	25,26,	25,26,	
25,26,	25,26,	25,26,	25,26,	
25,26,	25,26,	25,26,	21,21,	
0,0,	0,0,	0,0,	23,29,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
23,30,	23,29,	23,29,	0,0,	
23,29,	23,31,	23,29,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
23,29,	26,26,	26,26,	26,26,	
26,26,	26,26,	26,26,	26,26,	
26,26,	26,26,	26,26,	23,29,	
27,28,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	28,21,	
0,0,	27,32,	27,28,	27,28,	
0,0,	27,28,	27,33,	27,28,	
28,27,	28,21,	28,21,	0,0,	
28,21,	28,34,	28,21,	0,0,	
32,21,	27,28,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
28,21,	32,27,	32,21,	32,21,	
27,28,	32,21,	32,37,	32,21,	
0,0,	0,0,	0,0,	28,21,	
0,0,	0,0,	0,0,	0,0,	
0,0,	32,21,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
32,21,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+0,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+3,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+38,	0,		yyvstop+12,
yycrank+12,	yysvec+6,	yyvstop+15,
yycrank+0,	yysvec+6,	yyvstop+18,
yycrank+117,	yysvec+6,	yyvstop+22,
yycrank+4,	yysvec+6,	yyvstop+26,
yycrank+129,	yysvec+6,	yyvstop+29,
yycrank+0,	yysvec+6,	yyvstop+32,
yycrank+0,	yysvec+4,	yyvstop+36,
yycrank+0,	yysvec+6,	yyvstop+38,
yycrank+139,	yysvec+6,	yyvstop+40,
yycrank+151,	yysvec+6,	yyvstop+43,
yycrank+-212,	0,		yyvstop+46,
yycrank+184,	yysvec+6,	yyvstop+48,
yycrank+223,	yysvec+6,	yyvstop+51,
yycrank+245,	yysvec+6,	yyvstop+53,
yycrank+-270,	yysvec+17,	0,	
yycrank+-3,	yysvec+17,	yyvstop+55,
yycrank+-310,	0,		yyvstop+57,
yycrank+0,	yysvec+17,	yyvstop+59,
yycrank+281,	yysvec+6,	yyvstop+61,
yycrank+321,	yysvec+6,	yyvstop+63,
yycrank+-347,	yysvec+23,	0,	
yycrank+-354,	yysvec+17,	0,	
yycrank+-4,	yysvec+17,	yyvstop+66,
yycrank+-5,	yysvec+17,	yyvstop+68,
yycrank+0,	yysvec+6,	yyvstop+70,
yycrank+-371,	yysvec+17,	0,	
yycrank+0,	0,		yyvstop+73,
yycrank+6,	0,		0,	
yycrank+7,	yysvec+6,	yyvstop+75,
yycrank+8,	yysvec+6,	yyvstop+77,
yycrank+0,	yysvec+34,	yyvstop+80,
0,	0,	0};
struct yywork *yytop = yycrank+440;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'*' ,'+' ,',' ,'+' ,'.' ,'/' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,':' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'E' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'E' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
static int yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	if (yyin == NULL) yyin = stdin;
	if (yyout == NULL) yyout = stdout;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"unsigned char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (long)yyt > (long)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((long)yyt < (long)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
static int yyback(int *p, int m)
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
int yyinput(){
	if (yyin == NULL) yyin = stdin;
	return(input());
	}
void yyoutput(c)
  int c; {
	if (yyout == NULL) yyout = stdout;
	output(c);
	}
void yyunput(c)
   int c; {
	unput(c);
	}
