
// output12au7_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -3.000000
 // --table_div  15.263200
 // --table_op  1.000000

struct tableoutput12au7_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableoutput12au7_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableoutput12au7_neg&() const { return *(tableoutput12au7_neg*)this; }
};

 static tableoutput12au7_neg_imp<2048> output12au7_neg_table __rt_data = {
	0,0.733182,682.333,2048, {
	0.000000000000,0.000592541863,0.001184774742,0.001776698757,0.002368314053,
	0.002959620777,0.003550619072,0.004141309084,0.004731690959,0.005321764841,
	0.005911530875,0.006500989206,0.007090139979,0.007678983340,0.008267519432,
	0.008855748400,0.009443670389,0.010031285543,0.010618594007,0.011205595926,
	0.011792291443,0.012378680704,0.012964763851,0.013550541030,0.014136012385,
	0.014721178058,0.015306038196,0.015890592941,0.016474842437,0.017058786828,
	0.017642426258,0.018225760871,0.018808790810,0.019391516218,0.019973937239,
	0.020556054017,0.021137866695,0.021719375416,0.022300580324,0.022881481561,
	0.023462079271,0.024042373596,0.024622364681,0.025202052667,0.025781437697,
	0.026360519915,0.026939299463,0.027517776483,0.028095951119,0.028673823513,
	0.029251393807,0.029828662143,0.030405628665,0.030982293515,0.031558656834,
	0.032134718765,0.032710479450,0.033285939030,0.033861097649,0.034435955448,
	0.035010512568,0.035584769153,0.036158725342,0.036732381278,0.037305737103,
	0.037878792959,0.038451548985,0.039024005325,0.039596162120,0.040168019510,
	0.040739577637,0.041310836642,0.041881796667,0.042452457852,0.043022820338,
	0.043592884267,0.044162649779,0.044732117015,0.045301286115,0.045870157221,
	0.046438730473,0.047007006012,0.047574983978,0.048142664511,0.048710047752,
	0.049277133842,0.049843922920,0.050410415126,0.050976610602,0.051542509486,
	0.052108111920,0.052673418042,0.053238427993,0.053803141913,0.054367559940,
	0.054931682216,0.055495508880,0.056059040071,0.056622275929,0.057185216593,
	0.057747862202,0.058310212897,0.058872268816,0.059434030098,0.059995496883,
	0.060556669310,0.061117547517,0.061678131644,0.062238421830,0.062798418213,
	0.063358120933,0.063917530127,0.064476645935,0.065035468495,0.065593997946,
	0.066152234426,0.066710178074,0.067267829028,0.067825187426,0.068382253407,
	0.068939027108,0.069495508669,0.070051698226,0.070607595918,0.071163201883,
	0.071718516258,0.072273539182,0.072828270793,0.073382711227,0.073936860623,
	0.074490719117,0.075044286849,0.075597563954,0.076150550571,0.076703246837,
	0.077255652889,0.077807768863,0.078359594899,0.078911131131,0.079462377699,
	0.080013334737,0.080564002384,0.081114380776,0.081664470050,0.082214270343,
	0.082763781790,0.083313004530,0.083861938698,0.084410584432,0.084958941866,
	0.085507011138,0.086054792384,0.086602285740,0.087149491343,0.087696409328,
	0.088243039831,0.088789382990,0.089335438938,0.089881207813,0.090426689750,
	0.090971884885,0.091516793353,0.092061415291,0.092605750833,0.093149800116,
	0.093693563274,0.094237040443,0.094780231759,0.095323137357,0.095865757371,
	0.096408091938,0.096950141192,0.097491905268,0.098033384301,0.098574578426,
	0.099115487778,0.099656112491,0.100196452702,0.100736508543,0.101276280150,
	0.101815767657,0.102354971199,0.102893890910,0.103432526924,0.103970879377,
	0.104508948401,0.105046734132,0.105584236703,0.106121456249,0.106658392903,
	0.107195046800,0.107731418073,0.108267506856,0.108803313283,0.109338837488,
	0.109874079604,0.110409039765,0.110943718105,0.111478114756,0.112012229853,
	0.112546063528,0.113079615916,0.113612887148,0.114145877359,0.114678586682,
	0.115211015249,0.115743163194,0.116275030649,0.116806617748,0.117337924622,
	0.117868951406,0.118399698232,0.118930165232,0.119460352538,0.119990260284,
	0.120519888603,0.121049237625,0.121578307484,0.122107098312,0.122635610241,
	0.123163843404,0.123691797932,0.124219473957,0.124746871612,0.125273991029,
	0.125800832338,0.126327395673,0.126853681165,0.127379688945,0.127905419146,
	0.128430871898,0.128956047334,0.129480945585,0.130005566781,0.130529911056,
	0.131053978539,0.131577769362,0.132101283656,0.132624521553,0.133147483183,
	0.133670168677,0.134192578167,0.134714711783,0.135236569656,0.135758151917,
	0.136279458696,0.136800490125,0.137321246333,0.137841727451,0.138361933610,
	0.138881864940,0.139401521571,0.139920903634,0.140440011259,0.140958844577,
	0.141477403716,0.141995688808,0.142513699982,0.143031437368,0.143548901097,
	0.144066091297,0.144583008099,0.145099651633,0.145616022027,0.146132119412,
	0.146647943918,0.147163495673,0.147678774807,0.148193781450,0.148708515730,
	0.149222977777,0.149737167720,0.150251085689,0.150764731812,0.151278106219,
	0.151791209037,0.152304040397,0.152816600427,0.153328889256,0.153840907012,
	0.154352653824,0.154864129822,0.155375335132,0.155886269885,0.156396934207,
	0.156907328228,0.157417452077,0.157927305880,0.158436889767,0.158946203865,
	0.159455248303,0.159964023209,0.160472528710,0.160980764935,0.161488732011,
	0.161996430066,0.162503859228,0.163011019625,0.163517911384,0.164024534633,
	0.164530889499,0.165036976109,0.165542794592,0.166048345074,0.166553627683,
	0.167058642546,0.167563389791,0.168067869543,0.168572081930,0.169076027080,
	0.169579705119,0.170083116174,0.170586260372,0.171089137840,0.171591748704,
	0.172094093091,0.172596171128,0.173097982940,0.173599528656,0.174100808400,
	0.174601822299,0.175102570481,0.175603053070,0.176103270193,0.176603221977,
	0.177102908547,0.177602330029,0.178101486550,0.178600378235,0.179099005209,
	0.179597367600,0.180095465532,0.180593299132,0.181090868524,0.181588173835,
	0.182085215190,0.182581992714,0.183078506533,0.183574756772,0.184070743557,
	0.184566467012,0.185061927263,0.185557124435,0.186052058652,0.186546730041,
	0.187041138726,0.187535284831,0.188029168482,0.188522789803,0.189016148920,
	0.189509245956,0.190002081037,0.190494654286,0.190986965829,0.191479015790,
	0.191970804292,0.192462331462,0.192953597422,0.193444602297,0.193935346211,
	0.194425829288,0.194916051653,0.195406013429,0.195895714740,0.196385155710,
	0.196874336463,0.197363257122,0.197851917812,0.198340318655,0.198828459777,
	0.199316341299,0.199803963345,0.200291326040,0.200778429506,0.201265273867,
	0.201751859245,0.202238185765,0.202724253548,0.203210062719,0.203695613401,
	0.204180905715,0.204665939786,0.205150715736,0.205635233687,0.206119493764,
	0.206603496087,0.207087240781,0.207570727966,0.208053957768,0.208536930306,
	0.209019645704,0.209502104085,0.209984305571,0.210466250283,0.210947938344,
	0.211429369876,0.211910545002,0.212391463842,0.212872126520,0.213352533157,
	0.213832683876,0.214312578796,0.214792218042,0.215271601734,0.215750729993,
	0.216229602942,0.216708220702,0.217186583394,0.217664691141,0.218142544062,
	0.218620142280,0.219097485916,0.219574575091,0.220051409925,0.220527990541,
	0.221004317060,0.221480389601,0.221956208286,0.222431773237,0.222907084573,
	0.223382142416,0.223856946886,0.224331498103,0.224805796190,0.225279841265,
	0.225753633450,0.226227172864,0.226700459629,0.227173493864,0.227646275690,
	0.228118805227,0.228591082596,0.229063107915,0.229534881306,0.230006402888,
	0.230477672782,0.230948691106,0.231419457981,0.231889973527,0.232360237863,
	0.232830251110,0.233300013386,0.233769524811,0.234238785504,0.234707795586,
	0.235176555176,0.235645064392,0.236113323354,0.236581332181,0.237049090993,
	0.237516599909,0.237983859047,0.238450868526,0.238917628467,0.239384138986,
	0.239850400204,0.240316412239,0.240782175210,0.241247689236,0.241712954434,
	0.242177970924,0.242642738824,0.243107258253,0.243571529329,0.244035552170,
	0.244499326895,0.244962853622,0.245426132469,0.245889163554,0.246351946996,
	0.246814482912,0.247276771420,0.247738812638,0.248200606684,0.248662153677,
	0.249123453733,0.249584506970,0.250045313506,0.250505873459,0.250966186946,
	0.251426254084,0.251886074992,0.252345649786,0.252804978583,0.253264061502,
	0.253722898659,0.254181490171,0.254639836156,0.255097936730,0.255555792011,
	0.256013402115,0.256470767160,0.256927887262,0.257384762538,0.257841393104,
	0.258297779078,0.258753920576,0.259209817715,0.259665470611,0.260120879380,
	0.260576044139,0.261030965005,0.261485642094,0.261940075521,0.262394265403,
	0.262848211857,0.263301914998,0.263755374943,0.264208591806,0.264661565705,
	0.265114296756,0.265566785073,0.266019030773,0.266471033972,0.266922794784,
	0.267374313327,0.267825589715,0.268276624063,0.268727416488,0.269177967105,
	0.269628276029,0.270078343375,0.270528169258,0.270977753795,0.271427097099,
	0.271876199286,0.272325060471,0.272773680770,0.273222060296,0.273670199165,
	0.274118097491,0.274565755390,0.275013172976,0.275460350364,0.275907287668,
	0.276353985003,0.276800442483,0.277246660223,0.277692638337,0.278138376940,
	0.278583876146,0.279029136069,0.279474156823,0.279918938523,0.280363481282,
	0.280807785215,0.281251850435,0.281695677056,0.282139265193,0.282582614959,
	0.283025726468,0.283468599834,0.283911235169,0.284353632589,0.284795792206,
	0.285237714134,0.285679398486,0.286120845376,0.286562054918,0.287003027223,
	0.287443762407,0.287884260581,0.288324521859,0.288764546354,0.289204334179,
	0.289643885448,0.290083200272,0.290522278765,0.290961121040,0.291399727210,
	0.291838097387,0.292276231683,0.292714130212,0.293151793086,0.293589220418,
	0.294026412320,0.294463368904,0.294900090283,0.295336576569,0.295772827875,
	0.296208844312,0.296644625993,0.297080173029,0.297515485534,0.297950563618,
	0.298385407394,0.298820016974,0.299254392469,0.299688533992,0.300122441654,
	0.300556115566,0.300989555841,0.301422762590,0.301855735924,0.302288475956,
	0.302720982795,0.303153256555,0.303585297345,0.304017105278,0.304448680465,
	0.304880023016,0.305311133043,0.305742010657,0.306172655969,0.306603069090,
	0.307033250131,0.307463199203,0.307892916416,0.308322401881,0.308751655710,
	0.309180678012,0.309609468898,0.310038028479,0.310466356865,0.310894454167,
	0.311322320496,0.311749955961,0.312177360672,0.312604534741,0.313031478277,
	0.313458191390,0.313884674191,0.314310926790,0.314736949295,0.315162741819,
	0.315588304470,0.316013637358,0.316438740593,0.316863614285,0.317288258543,
	0.317712673477,0.318136859197,0.318560815813,0.318984543433,0.319408042167,
	0.319831312124,0.320254353414,0.320677166147,0.321099750431,0.321522106375,
	0.321944234089,0.322366133682,0.322787805263,0.323209248940,0.323630464823,
	0.324051453021,0.324472213642,0.324892746795,0.325313052589,0.325733131133,
	0.326152982535,0.326572606903,0.326992004347,0.327411174975,0.327830118895,
	0.328248836215,0.328667327045,0.329085591492,0.329503629664,0.329921441669,
	0.330339027617,0.330756387614,0.331173521769,0.331590430189,0.332007112984,
	0.332423570260,0.332839802125,0.333255808688,0.333671590055,0.334087146335,
	0.334502477635,0.334917584063,0.335332465726,0.335747122732,0.336161555188,
	0.336575763202,0.336989746881,0.337403506332,0.337817041662,0.338230352978,
	0.338643440389,0.339056304000,0.339468943919,0.339881360253,0.340293553108,
	0.340705522592,0.341117268811,0.341528791873,0.341940091883,0.342351168949,
	0.342762023177,0.343172654674,0.343583063546,0.343993249900,0.344403213842,
	0.344812955479,0.345222474917,0.345631772262,0.346040847620,0.346449701098,
	0.346858332802,0.347266742838,0.347674931311,0.348082898328,0.348490643996,
	0.348898168418,0.349305471703,0.349712553954,0.350119415279,0.350526055782,
	0.350932475570,0.351338674748,0.351744653421,0.352150411696,0.352555949677,
	0.352961267469,0.353366365179,0.353771242911,0.354175900771,0.354580338864,
	0.354984557296,0.355388556170,0.355792335592,0.356195895668,0.356599236502,
	0.357002358199,0.357405260865,0.357807944602,0.358210409518,0.358612655716,
	0.359014683300,0.359416492376,0.359818083049,0.360219455421,0.360620609599,
	0.361021545687,0.361422263788,0.361822764007,0.362223046449,0.362623111218,
	0.363022958417,0.363422588152,0.363822000525,0.364221195642,0.364620173606,
	0.365018934520,0.365417478490,0.365815805618,0.366213916009,0.366611809766,
	0.367009486993,0.367406947794,0.367804192272,0.368201220530,0.368598032673,
	0.368994628804,0.369391009025,0.369787173441,0.370183122155,0.370578855270,
	0.370974372889,0.371369675115,0.371764762052,0.372159633802,0.372554290469,
	0.372948732155,0.373342958964,0.373736970998,0.374130768361,0.374524351154,
	0.374917719481,0.375310873444,0.375703813147,0.376096538690,0.376489050178,
	0.376881347713,0.377273431396,0.377665301331,0.378056957620,0.378448400364,
	0.378839629667,0.379230645631,0.379621448357,0.380012037948,0.380402414506,
	0.380792578132,0.381182528930,0.381572267000,0.381961792444,0.382351105365,
	0.382740205865,0.383129094044,0.383517770005,0.383906233848,0.384294485677,
	0.384682525592,0.385070353695,0.385457970087,0.385845374870,0.386232568145,
	0.386619550013,0.387006320576,0.387392879934,0.387779228190,0.388165365443,
	0.388551291796,0.388937007348,0.389322512202,0.389707806458,0.390092890216,
	0.390477763578,0.390862426645,0.391246879517,0.391631122295,0.392015155079,
	0.392398977970,0.392782591069,0.393165994477,0.393549188292,0.393932172617,
	0.394314947551,0.394697513195,0.395079869649,0.395462017013,0.395843955387,
	0.396225684872,0.396607205567,0.396988517573,0.397369620989,0.397750515916,
	0.398131202453,0.398511680701,0.398891950758,0.399272012725,0.399651866701,
	0.400031512787,0.400410951081,0.400790181684,0.401169204694,0.401548020211,
	0.401926628336,0.402305029166,0.402683222801,0.403061209341,0.403438988885,
	0.403816561532,0.404193927382,0.404571086532,0.404948039083,0.405324785134,
	0.405701324782,0.406077658128,0.406453785270,0.406829706306,0.407205421337,
	0.407580930460,0.407956233774,0.408331331377,0.408706223369,0.409080909848,
	0.409455390912,0.409829666660,0.410203737189,0.410577602600,0.410951262989,
	0.411324718456,0.411697969097,0.412071015013,0.412443856299,0.412816493056,
	0.413188925380,0.413561153370,0.413933177124,0.414304996739,0.414676612313,
	0.415048023945,0.415419231732,0.415790235771,0.416161036161,0.416531632998,
	0.416902026381,0.417272216407,0.417642203174,0.418011986779,0.418381567319,
	0.418750944892,0.419120119594,0.419489091524,0.419857860779,0.420226427455,
	0.420594791650,0.420962953461,0.421330912984,0.421698670318,0.422066225558,
	0.422433578802,0.422800730146,0.423167679687,0.423534427523,0.423900973750,
	0.424267318463,0.424633461761,0.424999403740,0.425365144495,0.425730684125,
	0.426096022724,0.426461160390,0.426826097218,0.427190833306,0.427555368749,
	0.427919703643,0.428283838086,0.428647772172,0.429011505998,0.429375039660,
	0.429738373253,0.430101506875,0.430464440621,0.430827174586,0.431189708866,
	0.431552043558,0.431914178757,0.432276114558,0.432637851057,0.432999388350,
	0.433360726532,0.433721865699,0.434082805947,0.434443547370,0.434804090064,
	0.435164434124,0.435524579646,0.435884526724,0.436244275455,0.436603825932,
	0.436963178252,0.437322332509,0.437681288798,0.438040047214,0.438398607852,
	0.438756970808,0.439115136175,0.439473104048,0.439830874523,0.440188447693,
	0.440545823655,0.440903002501,0.441259984327,0.441616769227,0.441973357296,
	0.442329748628,0.442685943318,0.443041941459,0.443397743147,0.443753348475,
	0.444108757537,0.444463970428,0.444818987241,0.445173808072,0.445528433013,
	0.445882862159,0.446237095604,0.446591133442,0.446944975766,0.447298622671,
	0.447652074249,0.448005330595,0.448358391803,0.448711257965,0.449063929177,
	0.449416405530,0.449768687119,0.450120774037,0.450472666377,0.450824364234,
	0.451175867699,0.451527176867,0.451878291831,0.452229212683,0.452579939517,
	0.452930472427,0.453280811504,0.453630956843,0.453980908536,0.454330666675,
	0.454680231355,0.455029602667,0.455378780704,0.455727765560,0.456076557327,
	0.456425156097,0.456773561964,0.457121775019,0.457469795356,0.457817623066,
	0.458165258243,0.458512700978,0.458859951364,0.459207009493,0.459553875458,
	0.459900549350,0.460247031263,0.460593321287,0.460939419516,0.461285326041,
	0.461631040953,0.461976564347,0.462321896312,0.462667036941,0.463011986326,
	0.463356744558,0.463701311730,0.464045687932,0.464389873258,0.464733867797,
	0.465077671642,0.465421284885,0.465764707617,0.466107939928,0.466450981912,
	0.466793833659,0.467136495259,0.467478966806,0.467821248389,0.468163340100,
	0.468505242031,0.468846954272,0.469188476914,0.469529810048,0.469870953766,
	0.470211908157,0.470552673314,0.470893249327,0.471233636287,0.471573834284,
	0.471913843409,0.472253663753,0.472593295406,0.472932738460,0.473271993004,
	0.473611059129,0.473949936926,0.474288626485,0.474627127896,0.474965441249,
	0.475303566636,0.475641504146,0.475979253869,0.476316815896,0.476654190316,
	0.476991377220,0.477328376698,0.477665188839,0.478001813734,0.478338251473,
	0.478674502145,0.479010565840,0.479346442649,0.479682132660,0.480017635963,
	0.480352952649,0.480688082806,0.481023026524,0.481357783894,0.481692355003,
	0.482026739942,0.482360938800,0.482694951667,0.483028778631,0.483362419782,
	0.483695875209,0.484029145002,0.484362229249,0.484695128040,0.485027841464,
	0.485360369609,0.485692712565,0.486024870420,0.486356843264,0.486688631185,
	0.487020234273,0.487351652615,0.487682886301,0.488013935418,0.488344800057,
	0.488675480306,0.489005976252,0.489336287985,0.489666415593,0.489996359164,
	0.490326118788,0.490655694551,0.490985086543,0.491314294851,0.491643319565,
	0.491972160771,0.492300818559,0.492629293016,0.492957584231,0.493285692291,
	0.493613617284,0.493941359299,0.494268918423,0.494596294743,0.494923488349,
	0.495250499327,0.495577327765,0.495903973752,0.496230437373,0.496556718719,
	0.496882817874,0.497208734928,0.497534469968,0.497860023081,0.498185394355,
	0.498510583876,0.498835591732,0.499160418011,0.499485062800,0.499809526185,
	0.500133808254,0.500457909095,0.500781828793,0.501105567437,0.501429125113,
	0.501752501907,0.502075697908,0.502398713202,0.502721547875,0.503044202014,
	0.503366675706,0.503688969039,0.504011082097,0.504333014969,0.504654767740,
	0.504976340497,0.505297733327,0.505618946316,0.505939979550,0.506260833116,
	0.506581507100,0.506902001589,0.507222316668,0.507542452424,0.507862408942,
	0.508182186310,0.508501784613,0.508821203937,0.509140444368,0.509459505992,
	0.509778388896,0.510097093164,0.510415618883,0.510733966138,0.511052135015,
	0.511370125601,0.511687937980,0.512005572238,0.512323028461,0.512640306734,
	0.512957407144,0.513274329774,0.513591074711,0.513907642040,0.514224031847,
	0.514540244217,0.514856279234,0.515172136985,0.515487817554,0.515803321027,
	0.516118647488,0.516433797023,0.516748769716,0.517063565654,0.517378184920,
	0.517692627599,0.518006893777,0.518320983538,0.518634896967,0.518948634149,
	0.519262195168,0.519575580109,0.519888789057,0.520201822096,0.520514679311,
	0.520827360786,0.521139866606,0.521452196854,0.521764351617,0.522076330977,
	0.522388135020,0.522699763828,0.523011217488,0.523322496082,0.523633599695,
	0.523944528411,0.524255282315,0.524565861489,0.524876266018,0.525186495986,
	0.525496551478,0.525806432576,0.526116139364,0.526425671927,0.526735030348,
	0.527044214710,0.527353225099,0.527662061596,0.527970724285,0.528279213251,
	0.528587528577,0.528895670345,0.529203638641,0.529511433546,0.529819055144,
	0.530126503519,0.530433778754,0.530740880931,0.531047810135,0.531354566449,
	0.531661149954,0.531967560735,0.532273798875,0.532579864457,0.532885757562,
	0.533191478275,0.533497026679,0.533802402855,0.534107606888,0.534412638859,
	0.534717498851,0.535022186947,0.535326703230,0.535631047782,0.535935220686,
	0.536239222024,0.536543051879,0.536846710333,0.537150197468,0.537453513368,
	0.537756658113,0.538059631788,0.538362434473,0.538665066251,0.538967527204,
	0.539269817414,0.539571936964,0.539873885935,0.540175664409,0.540477272469,
	0.540778710196,0.541079977672,0.541381074979,0.541682002199,0.541982759414,
	0.542283346704,0.542583764153,0.542884011842,0.543184089852,0.543483998264,
	0.543783737161,0.544083306624,0.544382706735,0.544681937574,0.544980999223,
	0.545279891764,0.545578615277,0.545877169845,0.546175555548,0.546473772467,
	0.546771820684,0.547069700280,0.547367411336,0.547664953932,0.547962328151,
	0.548259534072,0.548556571777,0.548853441347,0.549150142862,0.549446676403,
	0.549743042052,0.550039239888,0.550335269992,0.550631132446,0.550926827330,
	0.551222354723,0.551517714708,0.551812907364,0.552107932772,0.552402791011,
	0.552697482164,0.552992006309,0.553286363528,0.553580553900,0.553874577506,
	0.554168434426,0.554462124740,0.554755648529,0.555049005871,0.555342196848,
	0.555635221539,0.555928080025,0.556220772384,0.556513298698,0.556805659046,
	0.557097853507,0.557389882162,0.557681745091,0.557973442372,0.558264974086,
	0.558556340312,0.558847541130,0.559138576620,0.559429446860,0.559720151931,
	0.560010691911,0.560301066881,0.560591276919,0.560881322105,0.561171202518,
	0.561460918238,0.561750469343,0.562039855913,0.562329078027,0.562618135763,
	0.562907029202,0.563195758422,0.563484323502,0.563772724521,0.564060961558,
	0.564349034692,0.564636944001,0.564924689564,0.565212271461,0.565499689770,
	0.565786944569,0.566074035937,0.566360963953,0.566647728695,0.566934330242,
	0.567220768673,0.567507044065,0.567793156498,0.568079106049,0.568364892797,
	0.568650516821,0.568935978198,0.569221277007,0.569506413325,0.569791387232,
	0.570076198805,0.570360848123,0.570645335262,0.570929660302,0.571213823321,
	0.571497824395,0.571781663604,0.572065341025,0.572348856736,0.572632210814,
	0.572915403338,0.573198434385,0.573481304033,0.573764012359,0.574046559441,
	0.574328945356,0.574611170183,0.574893233998,0.575175136879,0.575456878904,
	0.575738460150,0.576019880693,0.576301140612,0.576582239984,0.576863178886,
	0.577143957395,0.577424575589,0.577705033544,0.577985331337,0.578265469046,
	0.578545446747,0.578825264518,0.579104922436,0.579384420577,0.579663759018,
	0.579942937836,0.580221957108,0.580500816911,0.580779517321,0.581058058415,
	0.581336440270,0.581614662962,0.581892726568,0.582170631164,0.582448376827,
	0.582725963634,0.583003391660,0.583280660982,0.583557771677,0.583834723821,
	0.584111517490,0.584388152760,0.584664629708,0.584940948409,0.585217108940,
	0.585493111377,0.585768955797,0.586044642274,0.586320170885,0.586595541706,
	0.586870754813,0.587145810282,0.587420708188,0.587695448608,0.587970031617,
	0.588244457291,0.588518725706,0.588792836937,0.589066791060,0.589340588150,
	0.589614228283,0.589887711535,0.590161037981,0.590434207696,0.590707220757,
	0.590980077238,0.591252777214,0.591525320761,0.591797707954,0.592069938869,
	0.592342013581,0.592613932164,0.592885694694,0.593157301246,0.593428751895,
	0.593700046716,0.593971185785,0.594242169175,0.594512996962,0.594783669221,
	0.595054186026,0.595324547453,0.595594753576,0.595864804470,0.596134700209,
	0.596404440869,0.596674026523,0.596943457247,0.597212733115,0.597481854202,
	0.597750820581,0.598019632328,0.598288289517,0.598556792222,0.598825140517,
	0.599093334478,0.599361374177,0.599629259690,0.599896991091,0.600164568453,
	0.600431991851,0.600699261359,0.600966377050,0.601233339000,0.601500147282,
	0.601766801970,0.602033303138,0.602299650859,0.602565845208,0.602831886258,
	0.603097774084,0.603363508758,0.603629090355,0.603894518948,0.604159794611,
	0.604424917417,0.604689887441,0.604954704755,0.605219369433,0.605483881549,
	0.605748241175,0.606012448386,0.606276503255,0.606540405854,0.606804156258,
	0.607067754539,0.607331200771,0.607594495027,0.607857637379,0.608120627902,
	0.608383466669,0.608646153751,0.608908689222,0.609171073156,0.609433305625,
	0.609695386702,0.609957316460,0.610219094971,0.610480722309,0.610742198546,
	0.611003523756,0.611264698009,0.611525721381,0.611786593942,0.612047315765,
	0.612307886924,0.612568307490,0.612828577536,0.613088697135,0.613348666359,
	0.613608485279,0.613868153970,0.614127672502,0.614387040949,0.614646259382,
	0.614905327874,0.615164246496,0.615423015322,0.615681634422,0.615940103869,
	0.616198423736,0.616456594094,0.616714615014,0.616972486570,0.617230208833,
	0.617487781874,0.617745205766,0.618002480580,0.618259606389,0.618516583263,
	0.618773411275,0.619030090495,0.619286620997,0.619543002851,0.619799236129,
	0.620055320902,0.620311257242,0.620567045221,0.620822684909,0.621078176379,
	0.621333519701,0.621588714946,0.621843762187,0.622098661494,0.622353412939,
	0.622608016592,0.622862472525,0.623116780809,0.623370941515,0.623624954714,
	0.623878820477,0.624132538875,0.624386109979,0.624639533859,0.624892810588,
	0.625145940235,0.625398922871,0.625651758568,0.625904447395,0.626156989423,
	0.626409384724,0.626661633368,0.626913735425,0.627165690966,0.627417500062,
	0.627669162782,0.627920679198,0.628172049380,0.628423273398,0.628674351323,
	0.628925283225,0.629176069174,0.629426709240,0.629677203494,0.629927552006,
	0.630177754847,0.630427812085,0.630677723792,0.630927490037,0.631177110890,
	0.631426586422,0.631675916702,0.631925101800,0.632174141786,0.632423036731,
	0.632671786703,0.632920391773,0.633168852010,0.633417167484,0.633665338265,
	0.633913364422,0.634161246026,0.634408983144,0.634656575849,0.634904024207,
	0.635151328290,0.635398488167,0.635645503907,0.635892375579,0.636139103253,
	0.636385686998,0.636632126883,0.636878422979,0.637124575353,0.637370584075,
	0.637616449214,0.637862170840,0.638107749021,0.638353183827,0.638598475326,
	0.638843623588,0.639088628681,0.639333490674,0.639578209637,0.639822785638,
	0.640067218746,0.640311509030,0.640555656558,0.640799661400,0.641043523623,
	0.641287243297,0.641530820491,0.641774255272,0.642017547710,0.642260697872,
	0.642503705828,0.642746571646,0.642989295394,0.643231877141,0.643474316954,
	0.643716614904,0.643958771057,0.644200785482,0.644442658247,0.644684389420,
	0.644925979070,0.645167427265,0.645408734073,0.645649899561,0.645890923799,
	0.646131806853,0.646372548792,0.646613149685,0.646853609597,0.647093928599,
	0.647334106757,0.647574144139,0.647814040813,0.648053796847,0.648293412309,
	0.648532887266,0.648772221785,0.649011415935,0.649250469783,0.649489383397,
	0.649728156844,0.649966790191,0.650205283506,0.650443636857,0.650681850311,
	0.650919923935,0.651157857796,0.651395651962,0.651633306501,0.651870821478,
	0.652108196962,0.652345433020,0.652582529719,0.652819487125,0.653056305307,
	0.653292984330,0.653529524262,0.653765925171,0.654002187122,0.654238310183,
	0.654474294420,0.654710139902,0.654945846693,0.655181414862,0.655416844474,
	0.655652135597,0.655887288298,0.656122302642,0.656357178696,0.656591916528,
	0.656826516203,0.657060977789,0.657295301351,0.657529486956,0.657763534671,
	0.657997444562,0.658231216695,0.658464851136,0.658698347953,0.658931707211,
	0.659164928976,0.659398013314,0.659630960293,0.659863769977,0.660096442434,
	0.660328977728,0.660561375927,0.660793637096,0.661025761301,0.661257748608,
	0.661489599083,0.661721312792,0.661952889801,0.662184330175,0.662415633980,
	0.662646801283,0.662877832149,0.663108726643,0.663339484831,0.663570106779,
	0.663800592553,0.664030942217,0.664261155838,0.664491233481,0.664721175212,
	0.664950981096,0.665180651198,0.665410185583,0.665639584318,0.665868847467,
	0.666097975096,0.666326967270,0.666555824054,0.666784545514,0.667013131714,
	0.667241582720,0.667469898596,0.667698079408,0.667926125222,0.668154036101,
	0.668381812110,0.668609453316,0.668836959783,0.669064331574,0.669291568757,
	0.669518671395,0.669745639552,0.669972473295,0.670199172687,0.670425737793,
	0.670652168678,0.670878465407,0.671104628043,0.671330656653,0.671556551299,
	0.671782312047,0.672007938962,0.672233432107,0.672458791547,0.672684017347,
	0.672909109570,0.673134068282,0.673358893545,0.673583585426,0.673808143987,
	0.674032569294,0.674256861410,0.674481020399,0.674705046325,0.674928939253,
	0.675152699247,0.675376326371,0.675599820688,0.675823182262,0.676046411158,
	0.676269507440,0.676492471170,0.676715302414,0.676938001234,0.677160567696,
	0.677383001861,0.677605303795,0.677827473560,0.678049511220,0.678271416840,
	0.678493190482,0.678714832211,0.678936342089,0.679157720180,0.679378966547,
	0.679600081255,0.679821064366,0.680041915944,0.680262636052,0.680483224754,
	0.680703682112,0.680924008190,0.681144203052,0.681364266760,0.681584199377,
	0.681804000967,0.682023671593,0.682243211317,0.682462620204,0.682681898315,
	0.682901045714,0.683120062464,0.683338948628,0.683557704268,0.683776329448,
	0.683994824230,0.684213188677,0.684431422851,0.684649526817,0.684867500635,
	0.685085344370,0.685303058083,0.685520641837,0.685738095695,0.685955419719,
	0.686172613972,0.686389678517,0.686606613415,0.686823418729,0.687040094522,
	0.687256640856,0.687473057794,0.687689345397,0.687905503727,0.688121532848,
	0.688337432822,0.688553203710,0.688768845575,0.688984358478,0.689199742483,
	0.689414997651,0.689630124043,0.689845121723,0.690059990752,0.690274731192,
	0.690489343105,0.690703826553,0.690918181598,0.691132408301,0.691346506724,
	0.691560476930,0.691774318979,0.691988032934,0.692201618857,0.692415076808,
	0.692628406850,0.692841609044,0.693054683451,0.693267630134,0.693480449154,
	0.693693140572,0.693905704450,0.694118140848,0.694330449829,0.694542631455,
	0.694754685785,0.694966612881,0.695178412806,0.695390085619,0.695601631383,
	0.695813050158,0.696024342006,0.696235506987,0.696446545163,0.696657456595,
	0.696868241343,0.697078899470,0.697289431035,0.697499836100,0.697710114726,
	0.697920266974,0.698130292904,0.698340192577,0.698549966054,0.698759613396,
	0.698969134664,0.699178529918,0.699387799219,0.699596942627,0.699805960204,
	0.700014852010,0.700223618105,0.700432258550,0.700640773405,0.700849162732,
	0.701057426590,0.701265565039,0.701473578141,0.701681465956,0.701889228543,
	0.702096865964,0.702304378278,0.702511765545,0.702719027827,0.702926165183,
	0.703133177673,0.703340065358,0.703546828297,0.703753466550,0.703959980179,
	0.704166369242,0.704372633799,0.704578773912,0.704784789638,0.704990681039,
	0.705196448175,0.705402091104,0.705607609888,0.705813004585,0.706018275256,
	0.706223421960,0.706428444757,0.706633343706,0.706838118868,0.707042770301,
	0.707247298066,0.707451702222,0.707655982828,0.707860139944,0.708064173630,
	0.708268083945,0.708471870948,0.708675534698,0.708879075256,0.709082492680,
	0.709285787029,0.709488958364,0.709692006743,0.709894932225,0.710097734869,
	0.710300414736,0.710502971883,0.710705406370,0.710907718256,0.711109907600,
	0.711311974461,0.711513918898,0.711715740970,0.711917440736,0.712119018254,
	0.712320473585,0.712521806786,0.712723017916,0.712924107034,0.713125074199,
	0.713325919470,0.713526642905,0.713727244563,0.713927724502,0.714128082782,
	0.714328319461,0.714528434596,0.714728428248,0.714928300474,0.715128051333,
	0.715327680883,0.715527189183,0.715726576291,0.715925842265,0.716124987165,
	0.716324011047,0.716522913970,0.716721695994,0.716920357175,0.717118897572,
	0.717317317243,0.717515616246,0.717713794640,0.717911852483,0.718109789832,
	0.718307606745,0.718505303281,0.718702879498,0.718900335453,0.719097671205,
	0.719294886810,0.719491982328,0.719688957816,0.719885813331,0.720082548932,
	0.720279164677,0.720475660622,0.720672036826,0.720868293346,0.721064430240,
	0.721260447566,0.721456345381,0.721652123742,0.721847782708,0.722043322335,
	0.722238742682,0.722434043805,0.722629225762,0.722824288611,0.723019232408,
	0.723214057211,0.723408763078,0.723603350066,0.723797818231,0.723992167631,
	0.724186398324,0.724380510366,0.724574503814,0.724768378727,0.724962135160,
	0.725155773171,0.725349292816,0.725542694154,0.725735977240,0.725929142132,
	0.726122188887,0.726315117562,0.726507928212,0.726700620896,0.726893195670,
	0.727085652591,0.727277991715,0.727470213100,0.727662316801,0.727854302877,
	0.728046171382,0.728237922374,0.728429555910,0.728621072046,0.728812470839,
	0.729003752344,0.729194916619,0.729385963720,0.729576893704,0.729767706626,
	0.729958402543,0.730148981512,0.730339443589,0.730529788830,0.730720017291,
	0.730910129028,0.731100124099,0.731290002559,0.731479764463,0.731669409869,
	0.731858938832,0.732048351409,0.732237647655,0.732426827626,0.732615891379,
	0.732804838970,0.732993670453,0.733182385886
	}
};

double always_inline output12au7_negclip(double x) {
    double f = fabs(x);
    f = f * output12au7_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = output12au7_neg_table.data[0];
    } else if (i >= output12au7_neg_table.size-1) {
        f = output12au7_neg_table.data[output12au7_neg_table.size-1];
    } else {
    f -= i;
    f = output12au7_neg_table.data[i]*(1-f) + output12au7_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

