// generated by ../../../../tools/tube_transfer.py
// tube: 7199P
// plate current function: pentode
// mu: 97.9
// kx: 1.35
// kg1: 361.8
// kg2: 4500
// kp: 79.6
// kvb: 21.2
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_7199P[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	142.154063279271,142.0742340672837,141.9943668161626,141.9144615036712,141.83451810751512,
	141.75453660534208,141.67451697474175,141.59445919324554,141.51436323832638,141.43422908739868,
	141.35405671781803,141.2738461068811,141.19359723182558,141.11331006982968,141.03298459801246,
	140.95262079343314,140.8722186330914,140.79177809392672,140.7112991528187,140.6307817865865,
	140.55022597198894,140.469631685724,140.38899890442917,140.30832760468078,140.22761776299393,
	140.14686935582256,140.06608235955892,139.9852567505338,139.9043925050159,139.823489599212,
	139.74254800926656,139.66156771126185,139.5805486812173,139.49949089508968,139.41839432877285,
	139.33725895809744,139.25608475883084,139.17487170667695,139.0936197772759,139.01232894620404,
	138.9309991889736,138.84963048103256,138.76822279776457,138.6867761144884,138.60529040645835,
	138.52376564886345,138.44220181682758,138.3605988854094,138.27895682960187,138.19727562433206,
	138.11555524446123,138.03379566478452,137.9519968600306,137.87015880486157,137.78828147387281,
	137.7063648415929,137.62440888248304,137.54241357093716,137.4603788812818,137.37830478777553,
	137.2961912646091,137.21403828590502,137.1318458257176,137.0496138580324,136.96734235676627,
	136.88503129576728,136.8026806488141,136.72029038961603,136.6378604918129,136.5553909289747,
	136.47288167460133,136.39033270212255,136.30774398489768,136.22511549621535,136.1424472092934,
	136.05973909727857,135.97699113324626,135.8942032902005,135.81137554107337,135.7285078587253,
	135.64560021594437,135.56265258544636,135.4796649398744,135.39663725179895,135.3135694937172,
	135.23046163805333,135.1473136571579,135.06412552330772,134.9808972087058,134.89762868548095,
	134.81431992568747,134.73097090130526,134.64758158423925,134.56415194631933,134.48068195929997,
	134.3971715948603,134.31362082460365,134.23002962005722,134.14639795267206,134.06272579382275,
	133.97901311480712,133.8952598868462,133.81146608108364,133.7276316685857,133.6437566203412,
	133.5598409072607,133.47588450017693,133.39188736984414,133.30784948693778,133.22377082205466,
	133.13965134571228,133.0554910283489,132.97128984032312,132.88704775191357,132.80276473331892,
	132.71844075465742,132.63407578596662,132.54966979720314,132.4652227582428,132.38073463887957,
	132.29620540882618,132.2116350377132,132.12702349508913,132.04237075042008,131.9576767730894,
	131.8729415323976,131.7881649975618,131.70334713771592,131.61848792190992,131.53358731910984,
	131.4486452981974,131.36366182796988,131.2786368771397,131.19357041433418,131.1084624080953,
	131.02331282687945,130.93812163905704,130.85288881291234,130.76761431664335,130.68229811836102,
	130.59694018608948,130.51154048776556,130.42609899123855,130.34061566426976,130.2550904745325,
	130.16952338961164,130.0839143770032,129.99826340411443,129.91257043826315,129.82683544667765,
	129.74105839649636,129.6552392547675,129.56937798844896,129.48347456440771,129.39752894941998,
	129.3115411101703,129.22551101325178,129.13943862516558,129.05332391232048,128.96716684103305,
	128.88096737752664,128.7947254879317,128.70844113828505,128.6221142945299,128.53574492251536,
	128.4493329879961,128.36287845663213,128.27638129398844,128.18984146553478,128.1032589366451,
	128.01663367259758,127.929965638574,127.84325479965968,127.75650112084284,127.66970456701462,
	127.58286510296854,127.4959826934003,127.40905730290724,127.32208889598836,127.23507743704363,
	127.14802289037387,127.06092522018038,126.9737843905647,126.88660036552791,126.79937310897071,
	126.71210258469301,126.62478875639334,126.5374315876687,126.45003104201429,126.36258708282291,
	126.27509967338493,126.18756877688764,126.0999943564151,126.01237637494775,125.92471479536198,
	125.83700958042989,125.74926069281878,125.66146809509108,125.57363174970361,125.48575161900753,
	125.39782766524772,125.30985985056275,125.22184813698418,125.13379248643635,125.04569286073605,
	124.95754922159213,124.86936153060488,124.78112974926614,124.69285383895854,124.60453376095518,
	124.5161694764194,124.42776094640428,124.3393081318523,124.2508109935949,124.16226949235218,
	124.07368358873245,123.98505324323199,123.8963784162343,123.8076590680101,123.71889515871675,
	123.63008664839786,123.54123349698294,123.45233566428699,123.36339311001,123.2744057937367,
	123.18537367493607,123.09629671296094,123.0071748670476,122.91800809631533,122.82879635976609,
	122.73953961628405,122.65023782463513,122.56089094346669,122.47149893130697,122.38206174656479,
	122.2925793475291,122.20305169236848,122.11347873913076,122.02386044574261,121.93419677000917,
	121.84448766961344,121.75473310211595,121.6649330249544,121.57508739544303,121.48519617077234,
	121.39525930800856,121.30527676409321,121.21524849584279,121.1251744599481,121.03505461297388,
	120.9448889113585,120.85467731141321,120.76441976932202,120.67411624114095,120.58376668279772,
	120.49337105009123,120.40292929869118,120.31244138413746,120.22190726183976,120.13132688707705,
	120.04070021499724,119.95002720061653,119.85930779881896,119.76854196435605,119.67772965184615,
	119.58687081577406,119.4959654104905,119.40501339021172,119.31401470901868,119.22296932085703,
	119.13187717953627,119.04073823872926,118.94955245197187,118.85831977266244,118.76704015406119,
	118.67571354928967,118.5843399113304,118.49291919302628,118.40145134708007,118.3099363260538,
	118.21837408236837,118.12676456830293,118.0351077359944,117.94340353743691,117.8516519244813,
	117.75985284883443,117.66800626205897,117.57611211557251,117.48417036064718,117.39218094840915,
	117.30014382983791,117.20805895576586,117.11592627687781,117.02374574371007,116.93151730665042,
	116.8392409159371,116.74691652165843,116.65454407375225,116.56212352200528,116.46965481605264,
	116.3771379053772,116.2845727393089,116.1919592670244,116.09929743754631,116.00658719974274,
	115.91382850232648,115.82102129385468,115.72816552272805,115.6352611371904,115.54230808532787,
	115.44930631506848,115.35625577418145,115.26315641027657,115.17000817080361,115.07681100305176,
	114.98356485414882,114.89026967106085,114.79692540059123,114.70353198938024,114.61008938390442,
	114.51659753047588,114.42305637524153,114.32946586418268,114.23582594311429,114.14213655768422,
	114.0483976533727,113.9546091754916,113.8607710691838,113.76688327942254,113.67294575101076,
	113.57895842858031,113.48492125659146,113.39083417933205,113.29669714091688,113.20251008528712,
	113.10827295620939,113.01398569727532,112.91964825190067,112.82526056332479,112.73082257460965,
	112.63633422863944,112.54179546811972,112.4472062355767,112.35256647335646,112.25787612362434,
	112.16313512836425,112.0683434293778,111.97350096828355,111.87860768651655,111.78366352532723,
	111.68866842578085,111.59362232875685,111.49852517494782,111.40337690485903,111.3081774588075,
	111.21292677692118,111.11762479913841,111.02227146520703,110.9268667146834,110.831410486932,
	110.7359027211244,110.64034335623845,110.54473233105769,110.44906958417027,110.35335505396849,
	110.25758867864765,110.16177039620547,110.0659001444412,109.96997786095473,109.87400348314598,
	109.77797694821386,109.68189819315553,109.58576715476548,109.48958376963489,109.39334797415053,
	109.2970597044941,109.20071889664132,109.10432548636103,109.00787940921437,108.91138060055385,
	108.81482899552266,108.71822452905361,108.62156713586818,108.52485675047589,108.42809330717328,
	108.33127674004291,108.23440698295266,108.13748396955467,108.04050763328445,107.94347790736006,
	107.84639472478109,107.74925801832782,107.65206772056015,107.55482376381684,107.45752608021445,
	107.36017460164642,107.26276925978215,107.16530998606602,107.06779671171641,106.97022936772481,
	106.87260788485467,106.77493219364075,106.67720222438773,106.57941790716957,106.48157917182829,
	106.38368594797306,106.28573816497929,106.18773575198739,106.08967863790198,105.99156675139074,
	105.89340002088345,105.79517837457084,105.69690174040376,105.59857004609195,105.50018321910309,
	105.40174118666167,105.30324387574804,105.20469121309722,105.1060831251979,105.00741953829137,
	104.90870037837034,104.80992557117804,104.71109504220689,104.61220871669754,104.5132665196378,
	104.41426837576138,104.3152142095469,104.21610394521662,104.1169375067355,104.01771481780993,
	103.91843580188652,103.81910038215118,103.71970848152773,103.62026002267679,103.52075492799467,
	103.42119311961217,103.32157451939344,103.22189904893455,103.12216662956266,103.02237718233448,
	102.92253062803532,102.82262688717768,102.7226658800001,102.62264752646595,102.52257174626207,
	102.42243845879774,102.32224758320321,102.22199903832858,102.12169274274238,102.02132861473054,
	101.92090657229483,101.82042653315172,101.71988841473107,101.61929213417487,101.51863760833578,
	101.41792475377589,101.31715348676545,101.21632372328153,101.11543537900654,101.01448836932693,
	100.91348260933204,100.8124180138124,100.71129449725862,100.61011197385984,100.50887035750243,
	100.40756956176855,100.30620949993482,100.20479008497078,100.10331122953758,100.00177284598642,
	99.90017484635736,99.7985171423775,99.69679964545992,99.5950222667019,99.4931849168836,
	99.39128750646663,99.28932994559233,99.18731214408058,99.08523401142806,98.98309545680688,
	98.88089638906288,98.7786367167143,98.67631634795013,98.57393519062852,98.47149315227531,
	98.36899014008249,98.26642606090643,98.16380082126653,98.06111432734346,97.9583664849776,
	97.8555571996675,97.75268637656816,97.64975392048942,97.54675973589428,97.4437037268974,
	97.34058579726323,97.23740585040458,97.13416378938065,97.03085951689555,96.92749293529657,
	96.82406394657242,96.72057245235153,96.61701835390035,96.51340155212155,96.40972194755233,
	96.30597944036263,96.2021739303533,96.09830531695458,95.99437349922387,95.89037837584442,
	95.78631984512307,95.68219780498877,95.57801215299064,95.47376278629598,95.36944960168867,
	95.26507249556713,95.16063136394256,95.0561261024369,94.95155660628122,94.84692277031341,
	94.74222448897672,94.63746165631744,94.53263416598324,94.4277419112211,94.32278478487537,
	94.21776267938577,94.1126754867855,94.00752309869924,93.902305406341,93.79702230051232,
	93.69167367160013,93.58625940957471,93.48077940398774,93.3752335439702,93.26962171823016,
	93.16394381505098,93.05819972228906,92.95238932737173,92.8465125172952,92.74056917862245,
	92.63455919748101,92.52848245956099,92.42233885011272,92.31612825394481,92.2098505554218,
	92.10350563846204,91.99709338653552,91.89061368266164,91.78406640940706,91.67745144888336,
	91.57076868274495,91.46401799218668,91.35719925794164,91.25031236027903,91.14335717900164,
	91.03633359344376,90.92924148246877,90.82208072446699,90.71485119735316,90.60755277856425,
	90.50018534505712,90.39274877330618,90.28524293930099,90.17766771854394,90.07002298604792,
	89.9623086163338,89.85452448342826,89.74667046086125,89.63874642166363,89.53075223836474,
	89.42268778299008,89.31455292705877,89.20634754158114,89.09807149705641,88.98972466347017,
	88.88130691029183,88.77281810647243,88.66425812044187,88.5556268201068,88.44692407284775,
	88.33814974551704,88.22930370443612,88.12038581539309,88.01139594364025,87.9023339538917,
	87.79319971032066,87.6839930765573,87.57471391568592,87.46536209024273,87.35593746221319,
	87.24643989302972,87.13686924356902,87.0272253741498,86.91750814453012,86.8077174139051,
	86.6978530409043,86.5879148835895,86.47790279945202,86.36781664541037,86.25765627780795,
	86.14742155241045,86.03711232440355,85.92672844839052,85.81626977838992,85.70573616783302,
	85.59512746956183,85.48444353582634,85.3736842182826,85.26284936799024,85.15193883541023,
	85.04095247040269,84.92989012222475,84.81875163952819,84.70753687035744,84.59624566214748,
	84.48487786172166,84.3734333152897,84.26191186844575,84.15031336616633,84.03863765280843,
	83.92688457210771,83.81505396717662,83.7031456805026,83.59115955394641,83.47909542874048,
	83.36695314548723,83.25473254415762,83.14243346408963,83.0300557439869,82.91759922191737,
	82.80506373531206,82.69244912096387,82.57975521502657,82.46698185301375,82.35412886979792,
	82.24119609960982,82.12818337603765,82.01509053202646,81.90191739987787,81.78866381124948,
	81.67532959715487,81.56191458796344,81.44841861340043,81.33484150254726,81.22118308384171,
	81.10744318507867,80.9936216334106,80.87971825534851,80.76573287676302,80.65166532288559,
	80.53751541830995,80.4232829869937,80.30896785226025,80.1945698368009,80.0800887626772,
	79.96552445132343,79.85087672354959,79.73614539954444,79.62133029887887,79.50643124050977,
	79.39144804278374,79.27638052344177,79.16122849962366,79.04599178787313,78.93067020414325,
	78.81526356380218,78.69977168163929,78.58419437187187,78.46853144815208,78.35278272357446,
	78.23694801068386,78.12102712148395,78.00501986744608,77.88892605951891,77.77274550813846,
	77.65647802323859,77.54012341426247,77.42368149017435,77.30715205947217,77.19053493020071,
	77.07382990996564,76.95703680594815,76.84015542492054,76.7231855732624,76.60612705697777,
	76.48897968171325,76.37174325277684,76.25441757515792,76.13700245354804,76.01949769236296,
	75.90190309576559,75.78421846769018,75.66644361186754,75.54857833185172,75.43062243104758,
	75.3125757127402,75.19443798012514,75.07620903634052,74.95788868450035,74.83947672772963,
	74.72097296920089,74.60237721217244,74.4836892600285,74.36490891632106,74.24603598481363,
	74.12707026952697,74.00801157478699,73.8888597052746,73.7696144660781,73.65027566274735,
	73.53084310135114,73.41131658853628,73.29169593158986,73.17198093850395,73.0521714180433,
	72.93226717981588,72.81226803434653,72.69217379315374,72.57198426883001,72.45169927512515,
	72.33131862703382,72.21084214088629,72.09026963444327,71.96960092699496,71.848835839464,
	71.72797419451307,71.60701581665676,71.48596053237851,71.36480817025229,71.24355856106929,
	71.12221153797016,71.00076693658268,70.87922459516528,70.75758435475628,70.63584605932974,
	70.5140095559574,70.39207469497781,70.27004133017181,70.14790931894599,70.02567852252308,
	69.90334880614064,69.78092003925774,69.65839209576998,69.53576485423359,69.41303819809849,
	69.2902120159509,69.16728620176589,69.04426065517016,68.9211352817154,68.79790999316279,
	68.67458470777909,68.55115935064445,68.4276338539728,68.30400815744495,68.18028220855525,
	68.05645596297192,67.93252938491182,67.80850244753023,67.684375133326,67.56014743456285,
	67.43581935370734,67.31139090388412,67.186862109349,67.06223300598076,66.93750364179225,
	66.81267407746127,66.68774438688236,66.56271465773983,66.43758499210324,66.31235550704577,
	66.18702633528635,66.06159762585656,65.93606954479318,65.81044227585683,65.68471602127833,
	65.55889100253309,65.43296746114483,65.30694565951954,65.1808258818107,65.05460843481671,
	64.92829364891163,64.80188187901054,64.67537350557022,64.54876893562658,64.42206860386983,
	64.29527297375864,64.16838253867468,64.041397823118,63.914319383946165,63.78714781165418,
	63.65988373170466,63.532527805899456,63.405080733801334,63.27754325420388,63.14991614665183,
	63.02220023301252,62.894396379100286,62.76650549635468,62.63852854357396,62.51046652870506,
	62.38232051069095,62.254091601377205,62.12578096747816,61.99738983260431,61.868919479351725,
	61.74037125145459,61.61174655600162,61.48304686571738,61.35427372130916,61.22542873388006,
	61.096513587408744,60.96753004129659,60.838479932981905,60.70936518062218,60.580187785843385,
	60.45094983655695,60.32165350984337,60.192301074902176,60.06289489606717,59.933437435885956,
	59.80393125826217,59.67437903165879,59.544783532360654,59.415147647793276,59.285474379895945,
	59.15576684854527,59.02602829502607,58.89626208554526,58.76647171478447,58.63666080948627,
	58.5068331320685,58.37699258426049,58.24714321075476,58.11728920286662,57.987434902193954,
	57.857584804268264,57.72774356218816,57.59791599022472,57.468107067388516,57.33832194094625,
	57.20856592987516,57.07884452824181,56.94916340849173,56.819528424634655,56.689945615310606,
	56.560421206719795,56.430961615399816,56.3015734508321,56.1722635178587,56.04303881889059,
	55.913906555887024,55.78487413208551,55.65594915346107,55.52713942989302,55.398452976016884,
	55.26989801173954,55.1414829623937,55.01321645850985,54.88510733518202,54.75716463100476,
	54.629397586558774,54.501815642422926,54.374428436691076,54.247245801973136,54.120277761860045,
	53.99353452683453,53.86702648960982,53.74076421988095,53.614758458474356,53.489020110884,
	53.363560240184114,53.23839005931158,53.11352092271272,52.98896431735331,52.86473185309258,
	52.74083525242605,52.617286339604846,52.49409702914295,52.371279313727534,52.248845251551344,
	52.12680695308953,52.00517656734768,51.883966267611555,51.76318823673273,51.64285465198815,
	51.522977669555566,51.403569408649815,51.28464193536894,51.16620724630153,51.04827725195014,
	50.930863760027655,50.81397845868622,50.69763289973964,50.581838481942064,50.46660643438644,
	50.35194780008687,50.23787341980939,50.1243939162147,50.01151967837616,49.89926084673469,
	49.78762729855039,49.67662863390847,49.56627416233464,49.45657289007139,49.34753350806362,
	49.23916438069803,49.13147353533622,49.02446865267741,48.91815705798173,48.81254571318004,
	48.707641209891605,48.60344976336529,48.49997720735543,48.3972289899378,48.29521017026632,
	48.19392541626635,48.09337900325531,47.99357481347666,47.89451633652951,47.79620667067111,
	47.69864852496651,47.60184422225544,47.50579570290365,47.41050452930324,47.3159718910836,
	47.22219861099265,47.12918515140663,47.03693162142473,46.94543778450421,46.85470306659084,
	46.764726564699224,46.675507055897185,46.58704300664913,46.499332582473464,46.41237365786999,
	46.326163826474314,46.24070041139738,46.155980475709754,46.07200083303179,45.9887580581923,
	45.90624849792073,45.8244682815389,45.7434133316212,45.663079374593444,45.58346195124302,
	45.50455642711486,45.426358002770094,45.348861723885676,45.272062491175895,45.195955070118515,
	45.12053410046975,45.04579410555463,44.97172950132109,44.89833460514715,44.82560364439319,
	44.75353076469197,44.68211003797089,44.61133547020247,44.541201008879874,44.47170055021599,
	44.40282794606519,44.33457701056829,44.26694152652188,44.19991525147424,44.13349192355056,
	44.067665267011336,44.00242899754756,43.937776827318174,43.87370246973415,43.81019964399545,
	43.7472620793864,43.684883519335905,43.62305772524891,43.561778480115855,43.5010395919068,
	43.44083489675748,43.38115826195387,43.32200358872273,43.263364814835,43.20523591702902,
	43.14761091326091,43.09048386478867,43.03384887809709,42.97770010667028,42.92203175261824,
	42.86683806816424,42.81211335699923,42.75785197550946,42.70404833388357,42.65069689710493,
	42.59779218583485,42.54532877719247,42.493301305436475,42.441704462553965,42.390532998761444,
	42.339781722922794,42.28944550288891,42.23951926576339,42.1899979980987,42.14087674602687,
	42.09215061532876,42.04381477144557,41.99586443943644,41.948294903885234,41.901101508760405,
	41.85427965723044,41.80782481142736,41.761732492229015,41.71599827888829,41.67061780875087,
	41.6255867768799,41.58090093566554,41.53655609440881,41.4925481188817,41.448872930865626,
	41.405526507670025,41.36250488163304,41.319804139605935,41.27742042242262,41.23534992435633,
	41.19358889256414,41.152133626521426,41.110980477446965,41.07012584772012,41.02956619029125,
	40.989298008086216,40.9493178534062,40.90962232732356,40.87020807907469,40.83107180545072,
	40.792210250186685,40.75362020335001,40.71529850072893,40.67724202322135,40.639447696224906,
	40.60191248902857,40.56463341420652,40.52760752701434,40.490831924788495,40.45430374634903,
	40.418020171406,40.381978419970125,40.34617575176761,40.310609465659844,40.27527689906779,
	40.24017542740167,40.20530246349593,40.17065545704966,40.13623189407285,40.10202929633837,
	40.06804522084001,40.03427725925655,40.00072303742205,39.96738021480246,39.9342464839786,
	39.90131957013542,39.86859723055794,39.83607725413363,39.803757460861235,39.77163570136638,
	39.73970985642358,39.70797783648495,39.67643758121546,39.64508705903485,39.61392426666592,
	39.58294722868966,39.55215399710664,39.52154265090506,39.49111129563515,39.460858062990084,
	39.43078111039319,39.4008786205915,39.37114880125558,39.34158988458563,39.31220012692364,
	39.282977808371804,39.253921232416765,39.225028725560065,39.196298636954346,39.1677293380455,
	39.13931922222058,39.11106670446132,39.08297022100349,39.05502822900163,39.02723920619942,
	38.99960165060539,38.972114080174066,38.9447750324923,38.917583064470904,38.89053675204135,
	38.86363468985751,38.836875491002544,38.81025778670045,38.78378022603266,38.75744147565932,
	38.73124021954527,38.70517515869064,38.679245010866005,38.65344851035204,38.62778440768351,
	38.60225146938481,38.57684847777558,38.55157423064566,38.52642754107237,38.501407237170994,
	38.47651216186377,38.451741172652895,38.42709314139725,38.40256695409306,38.3781615106582,
	38.35387572472023,38.32970852340793,38.305658847146546,38.281725649456334,38.25790789675466,
	38.2342045681614,38.21061465530771,38.18713716214789,38.16377110477466,38.140515511237396,
	38.11736942136348,38.094331886582765,38.0714019697549,38.04857874499961,38.02586129752986,
	38.00324872348788,37.98074012978383,37.95833463393729,37.93603136392137,37.91382945800949,
	37.89172806462466,37.86972634219133,37.847823458989765,37.826018593012755,37.80431093182481,
	37.78269967242368,37.76118402110416,37.739763193324194,37.71843641357319,37.6972029152425,
	37.67606194049814,37.65501274015548,37.63405457355613,37.61318670844678,37.592408420860075,
	37.571718994997404,37.551117723113734,37.53060390540416,37.51017684989249,37.48983587232149,
	37.46958029604506,37.4494094519221,37.429322678212074,37.409319320472356,37.389398731457156,
	37.36956027101815,37.34980330600668,37.33012721017752,37.31053136409426,37.29101515503612,
	37.27157797690631,37.25221923014186,37.2329383216249,37.213734664595314,37.1946076785648,
	37.175556789232374,37.15658142840109,37.137681033896136,37.118855049484274,37.10010292479449,
	37.08142411523987,37.06281808194081,37.0442842916493,37.02582221667455,37.00743133480953,
	36.989111129259044,36.97086108856847,36.952680706553956,36.934569482233535,36.916526919759384,
	36.89855252835102,36.88064582222967,36.8628063205535,36.845033547353985,36.82732703147315,
	36.80968630650181,36.79211091071873,36.77460038703073,36.75715428291376,36.7397721503547,
	36.72245354579422,36.705198030070406,36.688005168363254,36.67087453014005,36.65380568910143,
	36.63679822312843,36.61985171423019,36.60296574849251,36.586139916027115,36.56937381092176,
	36.55266703119095,36.53601917872751,36.519429859254814,36.50289868227968,36.486425261046065,
	36.470009212489295,36.45365015719113,36.43734771933533,36.4211015266639,36.40491121043414,
	36.38877640537608,36.37269674965064,36.3566718848084,36.34070145574901,36.32478511068104,
	36.30892250108254,36.293113281662094,36.27735711032052,36.26165364809864,36.24600255919874,
	36.230403510857535,36.2148561733717,36.19936022004632,36.18391532715964,36.16852117392834,
	36.15317744247334,36.13788381778602,36.12263998769492,36.10744564283298,36.09230047660514,
	36.077204185156454,36.0621564673406,36.047157024688865,36.03220556137954,36.01730178420772,
	36.002445402555566,35.987636128362944,35.97287367609842,35.958157762730785,35.943488107700794,
	35.92886443289344,35.91428646261049,35.899753923543514,35.885266544747125,35.87082405761272,
	35.85642619584252,35.84207269542392,35.82776329460424,35.81349773386578,35.79927575590123,
	35.78509710558942,35.770961529971316,35.75686877822643,35.742818601649475,35.728810753627364,
	35.71484498961651,35.70092106712036,35.687038745667365,35.673197786789046,35.659397953998564,
	35.645639012769394,35.63192073051429,35.61824287656467,35.60460522215013,35.59100754037819,
	35.57744960621452,35.563931196463166,35.55045208974709,35.53701206648916,35.52361090889312,
	35.5102484009249,35.49692432829426,35.48363847843651,35.47039064049452,35.45718060530107,
	35.44400816536121,35.43087311483505,35.417775249520574,35.40471436683686,35.39169026580738,
	35.378702747043526,35.365751612728396,35.35283666660073,35.33995771393906,35.327114561546054,
	35.3143070177331,35.301534892304964,35.28879799654477,35.27609614319909,35.26342914646325,
	35.25079682196673,35.23819898675889,35.225635459294736,35.213106059420944,35.200610608362034,
	35.188148928706624,35.175720844394014,35.16332618070081,35.15096476422774,35.13863642288659,
	35.126340985887424,35.11407828372581,35.101848148170255,35.089650412249824,35.07748491024181,
	35.06535147765976,35.053249951241305,35.041180168936464,35.02914196989592,35.017135194459414,
	35.00515968414435,34.99321528163456,34.98130183076906,34.969419176531105,34.95756716503719,
	34.94574564352637,34.933954460349604,34.92219346495917,34.910462507898345,34.898761440791034,
	34.887090116331684,34.875448388275196,34.86383611142703,34.85225314163332,34.84069933577121,
	34.8291745517393,34.81767864844809,34.80621148581059,34.79477292473317,34.78336282710621,
	34.77198105579522,34.76062747463172,34.74930194840446,34.7380043428507,34.7267345246474,
	34.715492361402816,34.704277721647905,34.69309047482803,34.68193049129464,34.67079764229701,
	34.65969179997429,34.648612837334625,34.63756062829968,34.62653504761587,34.61553597090223,
	34.604563274628376,34.59361683610693,34.58269653348606,34.57180224574197,34.560933852671646,
	34.55009123488558,34.539274273800544,34.528482851632525,34.51771685138973,34.50697615686555,
	34.496260652631754,34.48557022403169,34.4749047571735,34.46426413892351,34.45364825689963,
	34.44305699946483,34.43249025572071,34.421947915501065,34.41142986936571,34.40093600859408,
	34.39046622517909,34.38002041182113,34.369598461921846,34.35920026957831,34.34882572957699,
	34.338474737387905,34.3281471891589,34.31784298170981,34.307562012526816,34.29730417975684,
	34.28706938220197,34.27685751931392,34.26666849118866,34.25650219856093,34.246358542798966,
	34.2362374258992,34.22613875048099,34.21606241978154,34.20600833765065,34.19597640854578,
	34.185966537526916,34.175978630251656,34.16601259297026,34.15606833252089,34.146145756324586,
	34.136244772380714,34.12636528926207,34.11650721611034,34.106670462631335,34.09685493909054,
	34.087060556308494,34.077287225656306,34.06753485905127,34.057803368952364,34.048092668355935,
	34.03840267079144,34.028733290317085,34.019084441515616,34.00945603949017,33.999847999860094,
	33.990260238756825,33.980692672819806,33.97114521919255,33.96161779551852,33.95211031993734,
	33.94262271108068,33.93315488806855,33.92370677050538,33.91427827847627,33.90486933254317,
	33.8954798537412,33.88610976357493,33.876758984014735,33.86742743749319,33.85811504690145,
	33.84882173558572,33.83954742734375,33.83029204642132,33.821055517490095,33.81183776572296,
	33.80263871666586,33.79345829632266,33.784296431128354,33.7751530479457,33.766028074062035,
	33.756921437185966,33.74783306544425,33.73876288737859,33.72971083194247,33.720676828498064,
	33.71166080681321,33.702662697058244,33.693682429803076,33.68471993601416,33.675775147051496,
	33.66684799466572,33.65793841099521,33.649046328563124,33.64017168027459,33.6313143994139,
	33.622474419641634,33.61365167499189,33.6048460998696,33.59605762904765,33.587286197664326,
	33.57853174122054,33.56979419557718,33.561073496952474,33.55236958191944,33.543682387397205,
	33.535011850677165,33.52635790936679,33.51772050143491,33.509099565349224,33.50049503928223,
	33.491906862694755,33.48333497474958,33.474779315090736,33.46623982370876,33.457716440909735,
	33.44920910732804,33.44071776392086,33.4322423519659,33.42378281305913,33.41533908911245,
	33.40691112235151,33.39849885531346,33.39010223084474,33.381721192098894,33.373355682534424,
	33.365005645912625,33.35667102629543,33.34835176804336,33.34004781581336,33.33175911455675,
	33.323485609517235,33.31522724622874,33.3069839705135,33.29875572847995,33.29054246652087,
	33.282344131311284,33.274160669806584,33.26599202924055,33.257838157123466,33.2496990012402,
	33.2415745096483,33.23346463067613,33.22536931292104,33.21728850524745,33.20922215678517,
	33.20117021695092,33.193132635357976,33.18510936194034,33.17710034687115,33.16910554057997,
	33.161124893751,33.15315835732145,33.14520588247973,33.13726742066385,33.12934292355966,
	33.12143234309927,33.11353563145932,33.10565274105941,33.09778362456042,33.089928234862946,
	33.08208652510569,33.07425844866385,33.066443959147584,33.05864301040045,33.05085555649786,
	33.043081551745516,33.03532095067792,33.02757370805686,33.01983977886995,33.01211911832907,
	33.00441168186897,32.996717425145775,32.9890363040355,32.98136827463276,32.97371329324914,
	32.966071316411956,32.95844230086274,32.95082620355594,32.943222981657456,32.93563259254335,
	32.92805499379844,32.92049014321495,32.91293799879121,32.905398518730316,32.897871661438806,
	32.89035738552536,32.88285564979955,32.875366413270456,32.8678896351455,32.860425274829126,
	32.85297329192155,32.84553364621755,32.83810629770516,32.83069120656457,32.82328833316678,
	32.81589763807247,32.80851908203078,32.80115262597814,32.79379823103709,32.7864558585151,
	32.77912546990339,32.77180702687588,32.76450049128789,32.75720582517518,32.74992299075267,
	32.74265195041346,32.735392666727606,32.72814510244114,32.72090922047486,32.713684983923365,
	32.70647235605388,32.69927130030525,32.6920817802869,32.68490375977773,32.67773720272512,
	32.67058207324386,32.66343833561518,32.65630595428567,32.64918489386633,32.6420751191315,
	32.63497659501794,32.627889286623805,32.62081315920767,32.61374817818756,32.60669430913995,
	32.599651517798904,32.592619770055,32.58559903195451,32.57858926969837,32.57159044964128,
	32.5646025382908,32.55762550230642,32.550659308498666,32.543703923828176,32.5367593154048,
	32.52982545048674,32.52290229647967,32.515989820935815,32.50908799155313,32.502196776174436,
	32.4953161427865,32.488446059519255,32.481586494644965,32.474737416577305,32.4678987938565,
	32.461070595203594,32.4542527894388,32.44744534553338,32.44064823259599,32.43386141987183,
	32.42708487674186,32.420318572722024,32.413562477462456,32.406816560746705,32.40008079249094,
	32.39335514274321,32.38663958168269,32.379934079618856,32.37323860699082,32.36655313436655,
	32.3598776324421,32.35321207204093,32.34655642411313,32.339910659734684,32.333274750106824,
	32.326648666555236,32.3200323805294,32.31342586360183,32.30682908746747,32.30024202394289,
	32.293664644965666,32.287096922593676,32.28053882900439,32.27399033649428,32.267451417478036,
	32.26092204448797,32.25440219017335,32.247891827299725,32.24139092874829,32.2348994675152,
	32.228417416710975,32.22194474955986,32.21548143939913,32.209027459678516,32.20258278395958,
	32.19614738591507,32.189721239328286,32.18330431809251,32.1768965962104,32.170498047793316,
	32.164108647060814,32.15772836833997,32.151357186064836,32.14499507477583,32.13864200911916,
	32.13229796384624,32.125962913813126,32.11963683397992,32.11331969941021,32.10701148527055,
	32.10071216682979,32.094421719458644,32.08814011862905,32.081867339913664,32.07560335898531,
	32.069348151616424,32.06310169367849,32.05686396114157,32.05063493007373,32.044414576640506,
	32.03820287710442,32.03199980782439,32.02580534525529,32.01961946594742,32.0134421465459,
	32.007273363790304,32.00111309451408,31.994961315644055,31.988818004199942,31.982683137293847,
	31.97655669212978,31.97043864600317,31.964328976300376,31.958227660498192,31.952134676163436,
	31.946050000952358,31.939973612610267,31.933905488971035,31.927845607956613,31.92179394757659,
	31.915750485927717,31.90971520119345,31.903688071643536,31.89766907563352,31.891658191604282,
	31.885655398081653,31.879660673675918,31.873673997081415,31.867695347076058,31.86172470252095,
	31.855762042359924,31.84980734561912,31.843860591406546,31.83792175891169,31.83199082740508,
	31.826067776237863,31.82015258484138,31.8142452327268,31.808345699484654,31.802453964784462,
	31.796570008374346,31.790693810080555,31.784825349807164,31.77896460753559,31.773111563324278,
	31.767266197308235,31.761428489698698,31.755598420782707,31.74977597092275,31.74396112055637,
	31.738153850195783,31.732354140427518,31.726561971912005,31.720777325383235,31.715000181648392,
	31.70923052158748,31.70346832615293,31.69771357636928,31.691966253332783,31.68622633821107,
	31.68049381224278,31.674768656737207,31.669050853073973,31.663340382702625,31.657637227142324,
	31.65194136798152,31.64625278687757,31.64057146555641,31.634897385812184,31.62923052950702,
	31.623570878570533,31.617918414999604,31.612273120858042,31.60663497827621,31.60100396945071,
	31.595380076644084,31.58976328218449,31.58415356846533,31.578550917945005,31.572955313146526,
	31.56736673665728,31.56178517112863,31.55621059927566,31.550643003876857,31.545082367773773,
	31.53952867387078,31.533981905134702,31.528442044594545,31.522909075341197,31.51738298052713,
	31.51186374336608,31.50635134713279,31.500845775162684,31.495347010851585,31.48985503765546,
	31.48436983909006,31.478891398730706,31.473419700211963,31.467954727227358,31.462496463529135,
	31.457044892927918,31.451599999292483,31.44616176654946,31.440730178683065,31.435305219734815,
	31.429886873803284,31.424475125043795,31.419069957668185,31.41367135594451,31.408279304196814,
	31.402893786804846,31.397514788203786,31.39214229288398,31.38677628539076,31.381416750324068,
	31.37606367233828,31.370717036141915,31.36537682649743,31.36004302822089,31.354715626181804,
	31.349394605302805,31.34407995055945,31.33877164697994,31.333469679644917,31.32817403368719,
	31.322884694291485,31.31760164669424,31.31232487618333,31.307054368097862,31.301790107827927,
	31.296532080814355,31.29128027254847,31.286034668571908,31.280795254476335,31.27556201588577,
	31.270334938525316,31.265114008118854,31.25989921045595,31.254690531375132,31.249487956763605,
	31.24429147255705,31.23910106473938,31.23391671934256,31.228738422446362,31.223566160178176,
	31.218399918712738,31.21323968427199,31.208085443124794,31.20293718158679,31.197794886020137,
	31.192658542833296,31.18752813848087,31.182403659463372,31.17728509232701,31.172172423663483,
	31.16706564010978,31.161964728347993,31.156869675105106,31.151780467152776,31.14669709130718,
	31.141619534428735,31.13654778342201,31.131481825235454,31.12642164686118,31.121367235334883,
	31.116318577735502,31.11127566118517,31.10623847284892,31.101206999934515,31.096181229692313,
	31.091161149415008,31.08614674643751,31.081138008136698,31.076134921931285,31.071137475281613,
	31.066145655689443,31.06115945069785,31.05617884789095,31.0512038348938,31.046234399372143,
	31.041270529032342,31.036312211621063,31.031359434925193,31.026412186771672,31.021470455027256,
	31.016534227598378,31.011603492431007,31.006678237510403,31.001758450861036,30.996844120546335,
	30.99193523466857,30.9870317813687,30.98213374882611,30.97724112525857,30.972353898921995,
	30.967472058110303,30.96259559115524,30.957724486426226,30.95285873233022,30.947998317311495,
	30.943143229851565,30.938293458468923,30.933448991718993,30.928609818193895,30.923775926522307,
	30.91894730536932,30.914123943436287,30.909305829460664,30.90449295221587,30.89968530051106,
	30.894882863191118,30.890085629136365,30.88529358726248,30.880506726520345,30.87572503589588,
	30.870948504409938,30.86617712111807,30.861410875110508,30.85664975551186,30.851893751481143,
	30.847142852211487,30.84239704693007,30.837656324898006,30.83292067541008,30.82819008779474,
	30.823464551413903,30.81874405566279,30.81402858996984,30.809318143796535,30.804612706637265,
	30.799912268019234,30.79521681750224,30.79052634467864,30.785840839173144,30.781160290642717,
	30.776484688776424,30.771814023295313,30.767148283952277,30.762487460531936,30.757831542850468,
	30.753180520755556,30.748534384126156,30.743893122872464,30.739256726935732,30.734625186288156,
	30.729998490932765,30.72537663090326,30.72075959626392,30.716147377109483,30.711539963565,
	30.706937345785715,30.70233951395694,30.697746458293945,30.693158169041876,30.688574636475526,
	30.68399585089929,30.67942180264708,30.67485248208214,30.670287879596934,30.665727985613053,
	30.6611727905811,30.656622284980553,30.652076459319662,30.647535304135317,30.642998809992992,
	30.63846696748653,30.633939767238125,30.629417199898146,30.624899256145067,30.620385926685312,
	30.615877202253206,30.611373073610785,30.606873531547752,30.602378566881352,30.597888170456223,
	30.593402333144322,30.588921045844852,30.58444429948408,30.579972085015257,30.57550439341856,
	30.57104121570091,30.566582542895905,30.562128366063728,30.557678676291044,30.553233464690823,
	30.54879272240236,30.544356440591045,30.53992461044836,30.53549722319174,30.531074270064437,
	30.526655742335482,30.522241631299533,30.51783192827682,30.513426624612993,30.50902571167908,
	30.504629180871344,30.50023702361121,30.49584923134515,30.491465795544613,30.487086707705874,
	30.482711959350027,30.47834154202279,30.473975447294485,30.469613666759876,30.465256192038197,
	30.460903014772864,30.45655412663158,30.452209519306123,30.447869184512275,30.443533113989762,
	30.4392012995021,30.43487373283661,30.430550405804194,30.426231310239356,30.42191643800005,
	30.41760578096762,30.413299331046694,30.40899708016508,30.404699020273735,30.400405143346624,
	30.396115441380644,30.391829906395564,30.38754853043388,30.383271305560807,30.378998223864134,
	30.374729277454144,30.370464458463577,30.366203759047476,30.36194717138316,30.357694687670094,
	30.353446300129864,30.34920200100603,30.34496178256408,30.340725637091357,30.336493556896933,
	30.332265534311592,30.32804156168767,30.323821631399063,30.31960573584105,30.31539386743032,
	30.311186018604786
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	142.154063279271,142.0742340672837,141.9943668161626,141.9144615036712,141.83451810751512,
	141.75453660534208,141.6745169747418,141.59445919324554,141.5143632383264,141.43422908739868,
	141.35405671781803,141.2738461068811,141.19359723182555,141.11331006982968,141.03298459801246,
	140.95262079343317,140.8722186330914,140.79177809392672,140.7112991528187,140.6307817865865,
	140.55022597198894,140.469631685724,140.38899890442917,140.30832760468076,140.2276177629939,
	140.1468693558226,140.06608235955898,139.9852567505338,139.9043925050159,139.823489599212,
	139.74254800926659,139.66156771126185,139.5805486812173,139.49949089508968,139.41839432877282,
	139.33725895809744,139.25608475883084,139.17487170667695,139.0936197772759,139.01232894620404,
	138.9309991889736,138.8496304810326,138.76822279776457,138.6867761144884,138.60529040645835,
	138.52376564886345,138.44220181682763,138.36059888540944,138.27895682960187,138.19727562433206,
	138.11555524446123,138.03379566478452,137.9519968600306,137.87015880486157,137.78828147387281,
	137.70636484159292,137.62440888248304,137.5424135709372,137.4603788812818,137.37830478777553,
	137.2961912646091,137.21403828590505,137.1318458257176,137.0496138580324,136.9673423567663,
	136.8850312957673,136.8026806488141,136.72029038961608,136.63786049181294,136.5553909289747,
	136.47288167460133,136.3903327021226,136.3077439848977,136.22511549621538,136.14244720929344,
	136.0597390972786,135.97699113324634,135.8942032902005,135.81137554107346,135.72850785872532,
	135.6456002159444,135.56265258544641,135.47966493987445,135.396637251799,135.31356949371724,
	135.2304616380534,135.14731365715792,135.06412552330778,134.98089720870584,134.897628685481,
	134.81431992568753,134.73097090130534,134.64758158423936,134.56415194631936,134.48068195930006,
	134.39717159486045,134.3136208246037,134.23002962005725,134.14639795267212,134.06272579382284,
	133.97901311480723,133.8952598868463,133.81146608108372,133.72763166858576,133.64375662034124,
	133.55984090726082,133.47588450017705,133.39188736984423,133.30784948693787,133.22377082205477,
	133.13965134571237,133.05549102834902,132.9712898403232,132.88704775191368,132.80276473331907,
	132.71844075465754,132.6340757859667,132.5496697972033,132.46522275824293,132.38073463887977,
	132.29620540882635,132.21163503771336,132.12702349508933,132.04237075042028,131.9576767730896,
	131.8729415323978,131.788164997562,131.70334713771618,131.61848792191014,131.53358731911007,
	131.44864529819765,131.3636618279701,131.27863687713995,131.19357041433446,131.1084624080956,
	131.02331282687973,130.9381216390573,130.85288881291268,130.76761431664363,130.68229811836136,
	130.59694018608985,130.51154048776596,130.42609899123892,130.34061566427013,130.25509047453292,
	130.169523389612,130.08391437700362,129.99826340411488,129.91257043826366,129.82683544667813,
	129.74105839649684,129.65523925476802,129.56937798844947,129.4834745644083,129.39752894942058,
	129.31154111017088,129.2255110132524,129.1394386251662,129.05332391232122,128.9671668410338,
	128.8809673775274,128.79472548793248,128.70844113828588,128.62211429453075,128.53574492251627,
	128.44933298799702,128.36287845663307,128.27638129398946,128.1898414655358,128.10325893664617,
	128.0166336725987,127.92996563857518,127.8432547996609,127.75650112084409,127.66970456701596,
	127.58286510296995,127.49598269340173,127.40905730290876,127.32208889598994,127.23507743704526,
	127.14802289037559,127.06092522018218,126.97378439056652,126.8866003655298,126.79937310897272,
	126.71210258469507,126.62478875639547,126.53743158767095,126.45003104201659,126.3625870828253,
	126.27509967338746,126.18756877689025,126.09999435641784,126.01237637495055,125.92471479536492,
	125.8370095804329,125.74926069282196,125.6614680950944,125.57363174970706,125.48575161901107,
	125.39782766525144,125.30985985056664,125.22184813698819,125.13379248644056,125.04569286074039,
	124.95754922159664,124.86936153060958,124.78112974927106,124.6928538389636,124.60453376096045,
	124.51616947642489,124.42776094640998,124.33930813185823,124.25081099360106,124.16226949235859,
	124.07368358873913,123.98505324323892,123.8963784162415,123.80765906801761,123.71889515872454,
	123.630086648406,123.54123349699141,123.45233566429576,123.36339311001915,123.27440579374623,
	123.18537367494599,123.09629671297124,123.00717486705827,122.91800809632647,122.82879635977768,
	122.73953961629607,122.65023782464765,122.56089094347972,122.4714989313205,122.3820617465789,
	122.29257934754375,122.2030516923837,122.11347873914661,122.02386044575911,121.93419677002632,
	121.84448766963128,121.75473310213448,121.66493302497369,121.57508739546307,121.48519617079317,
	121.39525930803023,121.30527676411577,121.21524849586626,121.1251744599725,121.03505461299923,
	120.94488891138488,120.85467731144067,120.76441976935058,120.67411624117061,120.58376668282857,
	120.49337105012334,120.40292929872457,120.31244138417217,120.22190726187586,120.13132688711461,
	120.04070021503631,119.95002720065717,119.85930779886124,119.76854196440001,119.67772965189184,
	119.5868708158216,119.49596541054,119.40501339026312,119.31401470907217,119.2229693209127,
	119.13187717959414,119.04073823878942,118.94955245203447,118.85831977272754,118.76704015412885,
	118.67571354936004,118.58433991140365,118.49291919310245,118.40145134715928,118.3099363261362,
	118.21837408245405,118.12676456839206,118.03510773608708,117.94340353753333,117.85165192458152,
	117.75985284893872,117.66800626216742,117.57611211568528,117.48417036076448,117.39218094853113,
	117.30014382996478,117.20805895589785,117.11592627701505,117.02374574385283,116.93151730679888,
	116.8392409160915,116.74691652181902,116.65454407391927,116.56212352217904,116.46965481623336,
	116.3771379055651,116.28457273950434,116.19195926722767,116.09929743775774,116.00658719996261,
	115.91382850255516,115.82102129409253,115.72816552297543,115.63526113744766,115.54230808559545,
	115.44930631534679,115.3562557744709,115.2631564105776,115.17000817111673,115.0768110033774,
	114.98356485448753,114.89026967141311,114.79692540095759,114.70353198976129,114.61008938430075,
	114.51659753088802,114.42305637567021,114.32946586462856,114.23582594357805,114.14213655816653,
	114.04839765387432,113.95460917601332,113.86077106972643,113.76688327998694,113.67294575159775,
	113.57895842919083,113.48492125722638,113.39083417999241,113.2966971416037,113.20251008600147,
	113.10827295695235,113.01398569804806,112.9196482527044,112.82526056416071,112.73082257547902,
	112.63633422954368,112.5417954690602,112.44720623655483,112.3525664743738,112.25787612468247,
	112.1631351294647,112.06834343052235,111.973500969474,111.87860768775468,111.78366352661496,
	111.68866842712019,111.59362233014984,111.49852517639665,111.40337690636592,111.30817746037474,
	111.21292677855122,111.11762480083381,111.02227146697031,110.92686671651735,110.83141048883948,
	110.73590272310831,110.64034335830185,110.54473233320375,110.44906958640237,110.35335505629004,
	110.25758868106223,110.16177039871681,110.06590014705314,109.96997786367137,109.87400348597151,
	109.77797695115262,109.68189819621205,109.58576715794453,109.48958377294132,109.39334797758946,
	109.29705970807086,109.20071890036142,109.10432549023025,109.00787941323864,108.91138060473945,
	108.814828999876,108.71822453358139,108.62156714057743,108.52485675537396,108.42809331226762,
	108.33127674534146,108.23440698846359,108.13748397528649,108.040507639246,107.94347791356057,
	107.84639473123015,107.74925802503536,107.65206772753658,107.55482377107292,107.45752608776138,
	107.36017460949587,107.26276926794625,107.16530999455739,107.06779672054819,106.9702293769106,
	106.87260789440873,106.7749322035778,106.67720223472314,106.5794179179193,106.48157918300896,
	106.383685959602,106.28573817707442,106.18773576456742,106.08967865098636,105.99156676499967,
	105.89340003503798,105.79517838929289,105.69690175571604,105.59857006201817,105.50018323566788,
	105.4017412038906,105.30324389366774,105.20469123173542,105.1060831445834,105.0074195584541,
	104.90870039934157,104.80992559299013,104.71109506489358,104.61220874029392,104.51326654418037,
	104.41426840128804,104.31521423609716,104.21610397283152,104.11693753545775,104.01771484768399,
	103.91843583295855,103.81910041446925,103.71970851514179,103.62026005763886,103.52075496435884,
	103.42119315743464,103.3215745587327,103.22189908985153,103.1221666721206,103.02237722659925,
	102.92253067407535,102.82262693506418,102.72266592980715,102.62264757827063,102.52257180014452,
	102.4224385148413,102.32224764149463,102.221999098958,102.12169280580365,102.02132868032119,
	101.92090664051635,101.8204266041097,101.71988848853532,101.61929221093953,101.51863768817968,
	101.41792483682259,101.31715357314349,101.21632381312453,101.11543547245357,101.01448846652266,
	100.91348271042683,100.81241811896277,100.71129460662726,100.61011208761606,100.50887047582229,
	100.40756968483524,100.30620962793883,100.20479021811025,100.1033113680186,100.00177299002343,
	99.90017499617328,99.7985172982043,99.69679980753884,99.59502243528388,99.49318509222965,
	99.39128768884822,99.2893301352919,99.18731234139186,99.08523421665659,98.98309567027044,
	98.88089661109203,98.77863694765288,98.67631658815577,98.57393544047324,98.47149341214605,
	98.3689904103817,98.2664263420528,98.16380111369553,98.06111463150799,97.95836680134886,
	97.85555752873552,97.75268671884268,97.64975427650067,97.5467601061938,97.44370411205881,
	97.34058619788331,97.23740626710394,97.13416422280491,97.03085996771628,96.92749340421226,
	96.8240644343097,96.72057295966616,96.61701888157839,96.51340210098076,96.40972251844323,
	96.30598003416998,96.20217454799739,96.09830595939259,95.9943741674516,95.89037907089748,
	95.7863205680788,95.68219855696783,95.57801293515858,95.47376359986531,95.36945044792054,
	95.26507337577343,95.16063227948781,95.05612705474056,94.95155759681967,94.84692380062245,
	94.74222556065382,94.63746277102432,94.53263532544833,94.42774311724231,94.32278603932286,
	94.21776398420494,94.11267684399986,94.00752451041356,93.9023068747448,93.79702382788302,
	93.69167526030671,93.58626106208138,93.48078112285776,93.3752353318698,93.26962357793283,
	93.16394574944168,93.05820173436868,92.95239142026182,92.84651469424279,92.74057144300508,
	92.6345615528121,92.52848490949506,92.42234139845137,92.31613090464235,92.20985331259152,
	92.10350850638272,91.99709636965788,91.89061678561542,91.78406963700814,91.67745480614121,
	91.57077217487053,91.46402162460043,91.35720303628204,91.25031629041125,91.14336126702672,
	91.03633784570805,90.92924590557396,90.82208532528014,90.71485598301751,90.60755775651046,
	90.50019052301457,90.3927541593152,90.28524854172524,90.17767354608353,90.07002904775281,
	89.9623149216181,89.8545310420847,89.7466772830765,89.6387535180341,89.5307596199131,
	89.42269546118244,89.31456091382249,89.20635584932349,89.09808013868371,88.98973365240806,
	88.88131626050614,88.77282783249075,88.66426823737642,88.55563734367779,88.446935019408,
	88.33816113207735,88.22931554869166,88.1203981357512,88.01140875924898,87.90234728466957,
	87.7932135769879,87.68400750066785,87.57472891966121,87.46537769740652,87.35595369682801,
	87.2464567803345,87.1368868098186,87.02724364665569,86.91752715170318,86.80773718529973,
	86.6978736072646,86.58793627689703,86.47792505297576,86.36783979375856,86.25768035698204,
	86.14744659986118,86.03713837908936,85.92675555083832,85.8162979707582,85.70576549397771,
	85.59515797510443,85.48447526822532,85.37371722690736,85.26288370419795,85.15197455262604,
	85.04098962420306,84.92992877042407,84.818791842269,84.70757869020426,84.59628916418428,
	84.48492311365356,84.37348038754853,84.26196083429984,84.15036430183494,84.03869063758069,
	83.9269396884662,83.81511130092618,83.70320532090422,83.59122159385646,83.47915996475575,
	83.36702027809558,83.2548023778948,83.14250610770259,83.03013131060335,82.9176778292225,
	82.80514550573216,82.69253418185757,82.5798436988835,82.4670738976615,82.35422461861725,
	82.24129570175843,82.12828698668315,82.01519831258865,81.90202951828077,81.78878044218355,
	81.6754509223499,81.56204079647222,81.44854990189414,81.33497807562253,81.22132515434024,
	81.10759097441955,80.99377537193628,80.87987818268459,80.7658992421925,80.6518383857382,
	80.53769544836737,80.42347026491095,80.3091626700041,80.19477249810605,80.0802995835207,
	79.96574376041833,79.85110486285856,79.73638272481394,79.621577180195,79.50668806287635,
	79.39171520672402,79.27665844562397,79.16151761351209,79.04629254440539,78.93098307243471,
	78.81558903187894,78.70011025720063,78.58454658308342,78.46889784447099,78.35316387660774,
	78.23734451508145,78.12143959586759,78.00544895537575,77.88937243049813,77.77320985866002,
	77.65696107787257,77.54062592678788,77.42420424475642,77.30769587188703,77.1911006491094,
	77.07441841823935,76.95764902204675,76.84079230432671,76.72384810997326,76.60681628505672,
	76.48969667690402,76.3724891341826,76.25519350698775,76.13780964693369,76.02033740724859,
	75.90277664287343,75.78512721056518,75.66738896900382,75.54956177890489,75.43164550313556,
	75.31364000683631,75.19554515754734,75.07736082534032,74.9590868829556,74.84072320594518,
	74.7222696728214,74.60372616521192,74.48509256802107,74.36636876959773,74.24755466191019,
	74.12865014072815,74.00965510581221,73.89056946111101,73.77139311496634,73.65212598032687,
	73.53276797497033,73.41331902173467,73.29377904875881,73.17414798973286,73.05442578415862,
	72.93461237762045,72.81470772206708,72.69471177610481,72.57462450530213,72.45444588250704,
	72.3341758881766,72.21381451071969,72.09336174685353,71.9728176019742,71.85218209054193,
	71.73145523648157,71.6106370735986,71.48972764601208,71.368727008604,71.2476352274865,
	71.12645238048717,71.00517855765357,70.88381386177701,70.76235840893672,70.64081232906514,
	70.51917576653491,70.39744888076844,70.27563184687075,70.1537248562866,70.03172811748257,
	69.90964185665493,69.78746631846438,69.66520176679848,69.54284848556249,69.42040677949997,
	69.29787697504388,69.17525942119913,69.0525544904577,68.92976257974748,68.80688411141577,
	68.68391953424843,68.56086932452591,68.43773398711738,68.31451405661404,68.19121009850247,
	68.0678227103797,67.94435252321078,67.82080020263031,67.69716645028886,67.57345200524587,
	67.44965764540966,67.32578418902665,67.20183249621984,67.07780347057879,66.95369806080183,
	66.82951726239142,66.7052621194044,66.5809337262578,66.45653322959137,66.3320618301881,
	66.20752078495332,66.08291140895383,65.95823507751757,65.8334932283945,65.7086873639801,
	65.58381905360136,65.45888993586615,65.33390172107636,65.2088561937052,65.08375521493845,
	64.95860072528,64.83339474722139,64.70813938797501,64.58283684227007,64.4574893952122,
	64.33209942519902,64.20666940690543,64.08120191431775,63.95569962382896,63.83016531738728,
	63.70460188569644,63.57901233146471,63.45339977269938,63.32776744604306,63.20211871014737,
	63.07645704907956,62.95078607575687,62.82510953540278,62.69943130901925,62.573755416867634,
	62.448086021951326,62.32242743349183,62.19678411038955,62.071160664659885,61.94556186483476,
	61.81999263931854,61.69445807968688,61.56896344391609,61.443514159530324,61.318115826652416,
	61.19277422094382,61.067495296418514,60.9422851881146,60.817150214606635,60.6920968803413,
	60.567131877778095,60.44226208931589,60.31749458898607,60.19283664389185,60.068295715373274,
	59.94387945987657,59.819595729506744,59.69545257224147,59.5714582317842,59.44762114703495,
	59.32394995115663,59.20045347021529,59.077140721373055,58.95402091061283,58.83110342997479,
	58.708397854285444,58.58591393736086,58.463661607667355,58.34165096342401,58.219892267133126,
	58.09839593952676,57.97717255291917,57.85623282395772,57.735587605767,57.61524787948345,
	57.49522474518116,57.37552941219199,57.25617318882673,57.1371674715072,57.018523733322695,
	56.90025351202793,56.78236839750284,56.664880018699115,56.54780003010085,56.43114009773184,
	56.31491188474434,56.199127036628724,56.08379716608613,55.96893383761004,55.85454855182519,
	55.74065272963583,55.62725769623693,55.51437466504491,55.40201472160609,55.290188807542336,
	55.17890770459481,55.06818201882736,54.95802216505089,54.84843835153065,54.73944056503668,
	54.631038556297575,54.5232418259152,54.41605961079665,54.30950087115672,54.20357427814178,
	54.0982882021222,53.993650701697376,53.889669513452716,53.78635204250465,53.683705353864546,
	53.581736164648035,53.48045083715154,53.379855372812706,53.27995540706675,53.18075620510543,
	53.08226265854098,52.98447928297181,52.88741021644303,52.7910592187894,52.69542967184471,
	52.600524580497265,52.50634657456732,52.41289791147901,52.32018047969604,52.22819580288744,
	52.13694504478754,52.046429014711826,51.95664817368868,51.86760264116561,51.779292202247426,
	51.69171631542289,51.60487412073628,51.51876444835983,51.43338582752328,51.34873649575719,
	51.264814408407524,51.18161724837943,51.0991424360699,51.01738713944962,50.93634828425638,
	50.85602256426371,50.77640645158978,50.6974962070143,50.61928789027211,50.541777370294724,
	50.46496033537237,50.38883230321204,50.31338863086814,50.23862452452454,50.16453504910911,
	50.09111513772348,50.018359600872245,49.94626313547854,49.87482033367362,49.804025691350546,
	49.73387361647316,49.66435843713342,49.5954744093509,49.527215724610826,49.459576517136796,
	49.392550870896734,49.326132826340796,49.260316386871786,49.195095525048586,49.13046418852484,
	49.06641630572551,49.00294579126421,48.94004655110558,48.877712487477126,48.81593750353509,
	48.754715507790145,48.69404041829809,48.63390616662201,48.57430670157176,48.51523599272725,
	48.45668803375227,48.398656845505535,48.34113647895546,48.28412101790583,48.22760458153908,
	48.17158132678395,48.11604545051441,48.060991191586616,48.00641283272039,47.95230470223208,
	47.898661175624994,47.845476677043905,47.79274568059978,47.74046271157079,47.68862234748542,
	47.637219219093794,47.586248011232136,47.53570346358653,47.48558037136061,47.43587358585265,
	47.38657801494678,47.33768862351189,47.289200433781076,47.24110852554173,47.19340803637804,
	47.14609416178755,47.099162155250454,47.05260732824255,47.00642505019525,46.96061074840623,
	46.91515990790401,46.87006807126918,46.82533083841571,46.780943866334866,46.7369028688044,
	46.693203616065766,46.649841934471446,46.60681370610518,46.564114868376606,46.521741413593155,
	46.47968938851041,46.43795489386336,46.39653408387999,46.355423165778994,46.31461839925297,
	46.274116095939064,46.23391261887777,46.19400438196185,46.154387849376114,46.11505953502958,
	46.07601600198088,46.037253861857984,45.99876977427339,45.96056044623536,45.92262263155634,
	45.884953130259134,45.847548787981815,45.81040649538174,45.77352318753968,45.73689584336429,
	45.700521484997914,45.66439717722369,45.62852002687497,45.592887182247225,45.557495832512735,
	45.52234320713893,45.487426575309996,45.452743245352714,45.418290564166654,45.38406591665864,
	45.350066725182316,45.316290448982514,45.282734583644924,45.249396660551255,45.216274246339786,
	45.18336494237178,45.150666384203724,45.1181762410654,45.08589221534418,45.053812042075435,
	45.02193348843896,44.990254353262095,44.95877246652865,44.92748568889468,44.89639191121033,
	44.86548905404832,44.834775067238674,44.804247929410074,44.773905647537525,44.743746256496514,
	44.71376781862353,44.683968423283034,44.65434618644082,44.62489925024359,44.59562578260496,
	44.56652397679773,44.53759205105221,44.50882824816093,44.480230835089394,44.45179810259278,
	44.42352836483894,44.39541995903697,44.36747124507208,44.339680605146,44.31204644342329,
	44.28456718568336,44.25724127897805,44.23006719129487,44.20304341122571,44.176168447640926,
	44.149440829368885,44.122859104880774,44.09642184198057,44.07012762750023,44.04397506699986,
	44.01796278447314,43.99208942205726,43.966353639748185,43.940754115120264,43.91528954305099,
	43.88995863545,43.864760120993004,43.839692744859896,43.814755268477555,43.78994646926691,
	43.76526514039419,43.74071009052663,43.71628014359216,43.69197413854318,43.667790929124465,
	43.64372938363282,43.61978838474232,43.59596682920778,43.5722636276999,43.54867770457898,
	43.52520799768555,43.50185345813444,43.47861305011256,43.455485750679955,43.43247054957436,
	43.40956644901908,43.38677246353402,43.36408761975017,43.341510956226955,43.319041523272965,
	43.29667838276955,43.274420607997484,43.25226728346655,43.230217504748076,43.2082703783102,
	43.18642502135604,43.16468056166452,43.14303613743388,43.12149089712802,43.10004399932508,
	43.07869461256895,43.05744191522299,43.0362850953264,43.01522335045291,42.99425588757184,
	42.97338192291155,42.95260068182515,42.931911398658364,42.91131331661978,42.890805687653064,
	42.870387772311496,42.85005883963442,42.82981816702589,42.80966504013517,42.789598752739366,
	42.76961860662796,42.749723911489156,42.72991398479819,42.71018815170744,42.690545744938454,
	42.67098610467546,42.65150857846096,42.632112521092886,42.61279729452328,42.59356226775893,
	42.57440681676341,42.555330324360725,42.53633218014058,42.5174117803652,42.498568527877545,
	42.47980183201113,42.46111110850115,42.442495779397284,42.42395527297754,42.405489023663776,
	42.38709647193851,42.368777064262865,42.35053025299614,42.332355496316325,42.31425225814213,
	42.2962200080562,42.27825822122932,42.26036637834616,42.242543965531965,42.224790474280404,
	42.207105401382655,42.1894882488575,42.17193852388257,42.15445573872659,42.13703941068286,
	42.119689062003445,42.10240421983472,42.085184416153695,42.068029187705434,42.050938075941296,
	42.0339106269584,42.01694639143965,42.00004492459498,41.983205786103326,41.9664285400556,
	41.9497127548984,41.933058003378655,41.916463862489145,41.89992991341474,41.883455741479516,
	41.86704093609466,41.85068509070714,41.83438780274914,41.81814867358833,41.8019673084787,
	41.78584331651236,41.76977631057182,41.753765907283125,41.737811726969746,41.72191339360686,
	41.7060705347767,41.6902827816242,41.67454976881351,41.658871134485125,41.64324652021351,
	41.62767557096547,41.61215793505914,41.596693264123445,41.58128121305822,41.565921439994945,
	41.55061360625799,41.53535737632643,41.52015241779635,41.50499840134388,41.48989500068852,
	41.47484189255712,41.45983875664836,41.44488527559773,41.42998113494296,41.41512602309003,
	41.400319631279565,41.38556165355374,41.370851786723684,41.356189730337306,41.34157518664754,
	41.32700786058114,41.31248745970772,41.29801369420948,41.28358627685108,41.26920492295019,
	41.254869350348194,41.24057927938155,41.22633443285333,41.21213453600525,41.19797931649009,
	41.18386850434448,41.16980183196201,41.155779034066775,41.14179984768723,41.12786401213042,
	41.11397126895656,41.100121361953946,41.08631403711421,41.07254904260788,41.05882612876036,
	41.04514504802809,41.03150555497514,41.01790740625005,41.00435036056305,40.99083417866344,
	40.97735862331746,40.96392345928627,40.950528453304415,40.93717337405829,40.923857992165246,
	40.910582080152636,40.89734541243735,40.88414776530554,40.87098891689263,40.8578686471635,
	40.84478673789307,40.83174297264704,40.81873713676287,40.80576901733108,40.79283840317674,
	40.77994508484113,40.76708885456381,40.754269506264706,40.741486835512326,40.72874063956445,
	40.71603071726248,40.7033568690745,40.69071889706327,40.67811660486986,40.66554979769718,
	40.653018282294084,40.640521866939345,40.62806036142603,40.615633577046026,40.603241326574675,
	40.59088342425576,40.578559685786495,40.56626992830285,40.55401397036499,40.54179163194284,
	40.529602734402,40.51744710048957,40.505324554320445,40.49323492136352,40.48117802842824,
	40.46915370365123,40.45716177648304,40.44520207767523,40.43327443926742,40.421378694574535,
	40.40951467817436,40.397682225894975,40.38588117480263,40.374111363189485,40.36237263056178,
	40.35066481762787,40.33898776628662,40.32734131961579,40.31572532186068,40.304139618422795,
	40.2925840558487,40.28105848181904,40.26956274513761,40.258096695720596,40.246660184585956,
	40.23525306384291,40.22387518668156,40.21252640736254,40.201206581206954,40.18991556458636,
	40.178653214912735,40.167419390628815,40.156213951198254,40.145036757096214,40.13388766979975,
	40.12276655177852,40.11167326648551,40.10060767834794,40.0895696527581,40.07855905606454,
	40.06757575556311,40.056619619488345,40.0456905170047,40.03478831819807,40.02391289406735,
	40.01306411651604,40.002241858344,39.9914459932393,39.98067639577012,39.969932941376754,
	39.95921550636373,39.948523967891994,39.93785820397118,39.92721809345198,39.91660351601853,
	39.90601435218106,39.89545048326838,39.884911791420585,39.874398159581936,39.863909471493564,
	39.853445611686446,39.84300646547451,39.83259191894752,39.8222018589644,39.81183617314636,
	39.801494749870265,39.79117747826191,39.78088424818962,39.77061495025759,39.76036947579959,
	39.75014771687257,39.73994956625039,39.72977491741757,39.71962366456323,39.709495702574905,
	39.6993909270326,39.689309234202796,39.679250521032564,39.66921468514377,39.65920162482724,
	39.649211239037115,39.63924342738516,39.62929809013523,39.61937512819764,39.6094744431238,
	39.5995959371007,39.589739512945656,39.5799050741009,39.57009252462838,39.560301769204564,
	39.55053271311532,39.54078526225073,39.53105932310018,39.52135480274726,39.51167160886492,
	39.50200964971052,39.49236883412104,39.48274907150821,39.4731502718539,39.463572345705344,
	39.45401520417048,39.44447875891343,39.434962922149865,39.42546760664256,39.415992725696974,
	39.40653819315666,39.39710392339913,39.38768983133136,39.37829583238553,39.36892184251487,
	39.35956777818935,39.35023355639162,39.340919094612794,39.33162431084847,39.32234912359462,
	39.31309345184365,39.30385721508039,39.294640333278224,39.2854427268952,39.27626431687012,
	39.26710502461887,39.257964772030505,39.24884348146362,39.23974107574261,39.23065747815403,
	39.221592612442976,39.21254640280945,39.20351877390487,39.194509650828486,39.18551895912396,
	39.176546624775845,39.16759257420623,39.15865673427128,39.14973903225797,39.140839395880676,
	39.131957753277916,39.12309403300911,39.11424816405134,39.10542007579611,39.09660969804623,
	39.087816961012656,39.07904179531138,39.070284131960335,39.061543902376364,39.052821038372194,
	39.044115472153415,39.035427136315555,39.02675596384111,39.01810188809663,39.00946484282986,
	39.00084476216683,38.99224158060909,38.98365523303085,38.975085654676235,38.966532781156474,
	38.95799654844725,38.94947689288591,38.94097375116888,38.93248706034893,38.92401675783257,
	38.91556278137742,38.9071250690897,38.898703559421556,38.89029819116865,38.881908903467505,
	38.87353563579313,38.86517832795654,38.85683692010219,38.84851135270573,38.840201566571416,
	38.83190750282989,38.82362910293572,38.81536630866507,38.80711906211345,38.798887305693334,
	38.7906709821319,38.7824700344688,38.77428440605393,38.76611404054517,38.75795888190619,
	38.74981887440434,38.74169396260838,38.73358409138642,38.725489205903784,38.717409251620865,
	38.70934417429109,38.701293919958836,38.693258434957364,38.6852376659068,38.677231559712126,
	38.669240063561176,38.66126312492267,38.65330069154422,38.64535271145041,38.63741913294086,
	38.62949990458836,38.621594975236846,38.613704293999675,38.60582781025766,38.597965473657275,
	38.59011723410877,38.582283041784414,38.57446284711668,38.566656600796385,38.55886425377105,
	38.55108575724302,38.543321062667836,38.535570121752386,38.527832886453325,38.52010930897526,
	38.51239934176913,38.50470293753056,38.49702004919813,38.48935062995181,38.48169463321126,
	38.474052012634296,38.46642272211522,38.45880671578327,38.451203948001044,38.44361437336291,
	38.436037946693524,38.42847462304621,38.42092435770149,38.413387106165565,38.40586282416879,
	38.39835146766426,38.39085299282627,38.383367356048836,38.37589451394433,38.36843442334197,
	38.36098704128641,38.35355232503636,38.34613023206313,38.3387207200493,38.33132374688726,
	38.323939270677926,38.31656724972931,38.309207642555215,38.3018604078739,38.29452550460672,
	38.287202891876845,38.27989252900797,38.27259437552292,38.265308391142504,38.25803453578418,
	38.250772769560726,38.24352305277912,38.23628534593918,38.229059609732396,38.22184580504067,
	38.21464389293515,38.207453834660726,38.20027559169237,38.193109125646835,38.185954398340144,
	38.178811371771616,38.171680008122685,38.16456026975575,38.15745211921306,38.15035551921557,
	38.1432704326618,38.13619682262675,38.12913465236076,38.12208388528848,38.11504448500771,
	38.108016415288326,38.10099964007126,38.093994123467404,38.08699982975653,38.08001672338632,
	38.07304476897123,38.06608393129153,38.05913417529225,38.05219546608216,38.04526776893279,
	38.038351049277416,38.03144527271006,38.02455040498449,38.017666412013305,38.0107932598669,
	38.00393091477252,37.99707934311331,37.99023851142738,37.98340838640685,37.9765889348969,
	37.96978012389492,37.962981920549424,37.956194292159346,37.949417206172974,37.942650630187124,
	37.935894531946225,37.929148879341454,37.922413640409815,37.91568878333331,37.90897427643804,
	37.90227008819336,37.89557618721104,37.88889254224436,37.88221912218738,37.87555589607394,
	37.86890283307702,37.86225990250773,37.85562707381467,37.849004316582935,37.842391600533524,
	37.83578889552233,37.82919617153948,37.8226133987085,37.81604054728556,37.80947758765866,
	37.802924490346875,37.79638122599961,37.78984776539581,37.78332407944324,37.77681013917768,
	37.770305915762236,37.763811380486615,37.75732650476632,37.750851260141964,37.74438561827856,
	37.73792955096481,37.73148303011236,37.725046027755084,37.71861851604842,37.7122004672687,
	37.705791853812336,37.69939264819531,37.6930028230523,37.68662235113618,37.680251205317205,
	37.67388935858246,37.667536784035065,37.66119345489368,37.654859344491705,37.648534426276704,
	37.64221867380977,37.6359120607648,37.629614560928005,37.623326148197116,37.61704679658088,
	37.61077648019836,37.604515173278415,37.59826285015893,37.59201948528635,37.58578505321502,
	37.57955952860656,37.573342886229334,37.567135100957756,37.56093614777183,37.554746001756435,
	37.54856463810082,37.54239203209805,37.53622815914435,37.530072994738596,37.52392651448176,
	37.51778869407627,37.51165950932555,37.505538936133384,37.49942695050349,37.49332352853875,
	37.48722864644094,37.481142280509964,37.47506440714348,37.46899500283623,37.46293404417965,
	37.45688150786125,37.4508373706641,37.44480160946634,37.43877420124069,37.43275512305389,
	37.42674435206622,37.42074186553096,37.414747640793955,37.40876165529305,37.40278388655765,
	37.3968143122082,37.3908529099557,37.38489965760121,37.37895453303544,37.37301751423814,
	37.36708857927777,37.36116770631092,37.35525487358191,37.349350059422285,37.34345324225036,
	37.337564400570784,37.33168351297405,37.32581055813606,37.31994551481772,37.31408836186437,
	37.30823907820546,37.302397642854075,37.296564034906474,37.29073823354167,37.28492021802097,
	37.27910996768761,37.273307461966276,37.267512680362685,37.26172560246315,37.25594620793423,
	37.250174476522204,37.24441038805278,37.23865392243056,37.232905059638746,37.22716377973865,
	37.221430062869345,37.21570388924722,37.20998523916563,37.20427409299445,37.19857043117972,
	37.19287423424322,37.187185482782155,37.18150415746868,37.17583023904954,37.17016370834574,
	37.164504546252154,37.15885273373702,37.15320825184182,37.147571081680645,37.14194120443999,
	37.136318601378335,37.13070325382581,37.12509514318378,37.11949425092452,37.11390055859087,
	37.10831404779584,37.10273470022233,37.097162497622634,37.09159742181831,37.0860394546996,
	37.08048857822527,37.074944774422185,37.06940802538494,37.063878313275595,37.05835562032328,
	37.05283992882394,37.047331221139885,37.041829479699565,37.036334686997186,37.03084682559242,
	37.02536587811004,37.019891827239654,37.01442465573529,37.00896434641523,37.00351088216155,
	36.99806424591986,36.992624420699016,36.987191389570775,36.981765135669505,36.97634564219188,
	36.97093289239655,36.965526869603885,36.96012755719563,36.95473493861463,36.949348997364524,
	36.94396971700945,36.93859708117378,36.933231073541755,36.92787167785729,36.92251887792359,
	36.91717265760296,36.91183300081646,36.9064998915436,36.90117331382212,36.895853251747695,
	36.89053968947364,36.88523261121062,36.8799320012264,36.87463784384556,36.86935012344927,
	36.86406882447492,36.85879393141596,36.85352542882156,36.848263301296356,36.84300753350025,
	36.83775811014805,36.83251501600927,36.827278235907876,36.82204775472199,36.81682355738367,
	36.811605628878645,36.80639395424603,36.80118851857812,36.79598930702016,36.790796304769984,
	36.785609497077886,36.78042886924634,36.775254406629756,36.770086094634195,36.764923918717166,
	36.7597678643874,36.754617917204584,36.749474062779136,36.74433628677197,36.73920457489423,
	36.73407891290713,36.72895928662164,36.723845681898304,36.71873808464701,36.713636480826736,
	36.70854085644535,36.70345119755936,36.698367490273725,36.693289720741596,36.688217875164106,
	36.68315193979017,36.67809190091623,36.673037744886074,36.667989458090595,36.6629470269676,
	36.65791043800156,36.652879677723405,36.64785473271037,36.6428355895857,36.6378222350185,
	36.63281465572351,36.627812838460855,36.622816770035946,36.61782643729918,36.61284182714573,
	36.60786292651545,36.60288972239254,36.59792220180544,36.5929603518266,36.588004159572264,
	36.58305361220234,36.5781086969201,36.573169400972056,36.568235711647795,36.56330761627969,
	36.55838510224279,36.55346815695461,36.548556767874906,36.54365092250558,36.53875060839035,
	36.533855813114684,36.52896652430558,36.52408272963137,36.51920441680155,36.51433157356656,
	36.50946418771768,36.50460224708678,36.49974573954617,36.49489465300842,36.490048975426184,
	36.48520869479202,36.480373799138206,36.4755442765366,36.47072011509843,36.46590130297411,
	36.46108782835314,36.45627967946388,36.45147684457336,36.44667931198714,36.441887070049205,
	36.43710010714166,36.43231841168472,36.42754197213636,36.42277077699239,36.418004814786045,
	36.41324407408801,36.40848854350615,36.40373821168539,36.39899306730757,36.39425309909125,
	36.389518295791554,36.384788646200086,36.38006413914463,36.37534476348917,36.37063050813356,
	36.365921362013545,36.36121731410043,36.35651835340109,36.351824468957695,36.347135649847644,
	36.34245188518337,36.337773164112185,36.33309947581618,36.32843080951202,36.323767154450834,
	36.31910849991807,36.31445483523332,36.309806149750216,36.30516243285626,36.30052367397266,
	36.29588986255423,36.29126098808928,36.28663704009934,36.28201800813919,36.277403881796594,
	36.27279465069222,36.26819030447948,36.26359083284443,36.2589962255056,36.25440647221381,
	36.249821562752174,36.24524148693582,36.240666234611844,36.23609579565917,36.231530159988345,
	36.22696931754153,36.22241325829225,36.21786197224534,36.21331544943676,36.208773679933564,
	36.20423665383366,36.1997043612657,36.19517679238904,36.19065393739353,36.18613578649941,
	36.18162232995719,36.17711355804753,36.17260946108112,36.16811002939854,36.16361525337013,
	36.15912512339592,36.15463962990542,36.15015876335764,36.1456825142408,36.14121087307233,
	36.13674383039873,36.13228137679538,36.127823502866555,36.12337019922934,36.11892145657746,
	36.114477265584554,36.11003761696899,36.10560250147735,36.10117190988441,36.09674583299287,
	36.0923242616334,36.087907186664445,36.0834945989721,36.079086489470065,36.074682849099474,
	36.070283668828814,36.06588893965381,36.06149865259733,36.05711279870923,36.0527313690663,
	36.048354354772144,36.04398174695703,36.03961353677784,36.035249715417976,36.03089027408715,
	36.026535204021414,36.022184496482936,36.017838142760006,36.01349613416685,36.00915846204357,
	36.004825117756035,36.00049609269574,35.996171378279755,35.99185096595065,35.98753484717628,
	35.9832230134498,35.97891545628952,35.97461216723883,35.970313137866036,35.96601835976434,
	35.9617278245517,35.957441523870756,35.953159449388714,35.948881592797264,35.94460794581244,
	35.940338500174654,35.936073247648416,35.93181218002239,35.92755528910923,35.9233025667455,
	35.9190540047916,35.91480959513163,35.910569329673365,35.90633320034811,35.9021011991106,
	35.897873317938966,35.893649548834595,35.889429883822075,35.885214314949074,35.88100283428627,
	35.87679543392727,35.8725921059885,35.86839284260913,35.864197635950994,35.86000647819848,
	35.855819361558495,35.851636278260294,35.847457220555484,35.8432821807179,35.839111151043454,
	35.83494412385023,35.83078109147817,35.826622046289216,35.82246698066702,35.818315887017036,
	35.814168757766325,35.81002558536349,35.80588636227867,35.80175108100336,35.7976197340504,
	35.793492313953834,35.7893688132689,35.78524922457191,35.78113354046016,35.777021753551885,
	35.77291385648613,35.76880984192276,35.764709702542255,35.76061343104578,35.756521020154985,
	35.75243246261198,35.74834775117929,35.74426687863967,35.7401898377962,35.73611662147203,
	35.732047222510424,35.727981633774675,35.72391984814794,35.719861858533314,35.715807657853595,
	35.71175723905134,35.70771059508871,35.70366771894748,35.69962860362886,35.6955932421535,
	35.69156162756142,35.68753375291188,35.6835096112834,35.67948919577356,35.67547249949909,
	35.67145951559563,35.66745023721783,35.66344465753913,35.65944276975179,35.65544456706679,
	35.651450042713755,35.64745918994088,35.643472002014924,35.63948847222103,35.63550859386276,
	35.63153236026199,35.62755976475883,35.62359080071156,35.61962546149664,35.61566374050849,
	35.61170563115958
	}}
};
table1d_imp<2001> tubetable2_7199P[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	26841.00738226179,26815.730592135267,26790.475270993065,26765.241389312894,26740.028917616168,
	26714.837826464754,26689.6680864691,26664.519668277262,26639.392542583024,26614.286680121033,
	26589.20205167105,26564.138628052653,26539.096380128904,26514.075278806537,26489.075295031747,
	26464.096399797803,26439.13856413573,26414.20175911922,26389.28595586622,26364.391125536604,
	26339.51723932653,26314.66426848279,26289.832184287498,26265.02095806481,26240.230561184177,
	26215.46096505343,26190.7121411221,26165.98406088222,26141.276695865763,26116.59001764662,
	26091.923997840524,26067.2786081017,26042.653820127292,26018.04960565658,25993.465936465698,
	25968.90278437561,25944.360121244114,25919.83791897316,25895.336149502553,25870.854784812807,
	25846.393796927212,25821.953157906893,25797.532839852563,25773.132814907483,25748.7530552529,
	25724.39353311185,25700.05422074436,25675.735090451944,25651.436114578304,25627.15726550319,
	25602.898515646786,25578.659837468076,25554.44120346862,25530.242586187313,25506.06395820101,
	25481.905292127085,25457.766560622462,25433.647736382336,25409.548792141053,25385.469700673762,
	25361.410434790134,25337.370967342387,25313.351271220257,25289.35131935285,25265.371084705435,
	25241.410540284418,25217.469659133625,25193.5484143347,25169.64677900831,25145.76472631392,
	25121.902229447485,25098.05926164214,25074.235796173412,25050.431806350523,25026.64726552317,
	25002.882147074783,24979.136424433047,24955.41007105731,24931.70306044817,24908.015366140608,
	24884.34696171008,24860.697820767193,24837.067916962467,24813.457223979607,24789.86571554338,
	24766.293365412803,24742.74014738507,24719.20603529596,24695.691003016742,24672.19502445229,
	24648.718073549244,24625.260124289685,24601.82115068989,24578.40112680497,24555.000026725116,
	24531.617824578967,24508.254494529698,24484.91001077598,24461.58434755584,24438.277479139408,
	24414.989379837123,24391.72002399184,24368.469385984128,24345.23744023009,24322.024161182257,
	24298.829523328473,24275.653501190325,24252.496069329474,24229.357202338222,24206.236874846705,
	24183.135061521374,24160.051737063237,24136.98687620662,24113.94045372461,24090.912444421763,
	24067.902823142293,24044.911564759965,24021.938644187623,23998.98403637217,23976.047716294357,
	23953.129658969203,23930.22983944924,23907.34823281919,23884.484814199335,23861.639558743507,
	23838.812441639682,23816.00343811344,23793.212523422513,23770.439672857166,23747.684861744958,
	23724.94806544649,23702.22925935478,23679.52841889933,23656.845519542378,23634.180536781056,
	23611.533446144247,23588.90422319653,23566.292843536245,23543.699282793958,23521.12351663492,
	23498.565520758868,23476.02527089643,23453.502742812936,23430.997912308412,23408.51075521423,
	23386.041247395715,23363.589364752348,23341.15508321456,23318.73837874829,23296.33922735071,
	23273.957605052245,23251.593487916947,23229.24685204201,23206.917673555712,23184.60592861992,
	23162.3115934309,23140.03464421376,23117.775057229206,23095.53280877033,23073.30787516048,
	23051.100232757537,23028.909857951207,23006.73672716178,22984.580816845046,22962.44210348526,
	22940.320563602512,22918.216173745175,22896.128910496504,22874.058750469638,22852.00567031187,
	22829.969646699148,22807.950656343346,22785.948675983953,22763.963682393416,22741.99565237776,
	22720.044562772047,22698.110390444752,22676.19311229369,22654.29270524979,22632.4091462741,
	22610.542412360235,22588.692480531812,22566.85932784533,22545.042931385222,22523.243268270795,
	22501.46031564887,22479.69405070055,22457.944450634837,22436.2114926937,22414.495154148804,
	22392.795412302534,22371.112244488664,22349.44562807096,22327.795540444622,22306.16195903446,
	22284.544861295228,22262.944224715262,22241.36002680907,22219.792245124227,22198.240857237113,
	22176.705840755625,22155.18717331755,22133.6848325896,22112.19879626997,22090.72904208699,
	22069.275547797293,22047.838291189357,22026.417250079634,22005.01240231732,21983.623725778398,
	21962.251198368882,21940.894798026995,21919.554502718525,21898.230290438085,21876.922139212656,
	21855.630027096006,21834.353932173457,21813.093832558123,21791.84970639253,21770.621531849392,
	21749.409287130482,21728.212950467652,21707.03250011868,21685.867914374623,21664.719171553017,
	21643.586250000637,21622.469128094268,21601.367784238755,21580.28219686853,21559.21234444623,
	21538.158205463846,21517.119758441677,21496.09698192817,21475.089854501603,21454.098354769732,
	21433.12246136577,21412.162152954246,21391.217408227243,21370.288205904955,21349.374524735842,
	21328.47634349836,21307.59364099784,21286.726396067494,21265.874587569746,21245.038194395187,
	21224.217195462585,21203.411569717304,21182.621296134952,21161.846353718392,21141.086721497617,
	21120.34237853169,21099.613303906943,21078.899476737733,21058.20087616645,21037.517481363204,
	21016.849271525545,20996.19622587809,20975.558323675472,20954.935544197306,20934.327866752126,
	20913.735270676374,20893.157735332068,20872.595240111266,20852.047764432056,20831.515287739516,
	20810.997789506757,20790.49524923516,20770.007646450074,20749.53496070922,20729.077171592242,
	20708.634258710295,20688.20620169777,20667.79298021886,20647.39457396478,20627.010962652002,
	20606.642126026247,20586.28804385798,20565.948695945644,20545.624062115476,20525.31412221855,
	20505.01885613389,20484.738243767963,20464.472265052744,20444.220899946693,20423.98412843708,
	20403.761930535446,20383.554286281007,20363.361175740265,20343.182579004224,20323.0184761928,
	20302.868847450194,20282.73367294828,20262.612932886423,20242.50660748748,20222.41467700347,
	20202.33712171062,20182.27392191386,20162.225057941276,20142.19051014938,20122.17025892177,
	20102.164284664756,20082.172567814087,20062.19508883017,20042.23182819961,20022.282766435936,
	20002.34788407747,19982.427161688483,19962.520579860844,19942.628119210334,19922.749760381186,
	19902.885484040777,19883.035270883523,19863.199101630424,19843.37695702755,19823.568817846517,
	19803.77466488623,19783.994478968394,19764.2282409433,19744.475931685964,19724.737532096773,
	19705.013023102118,19685.302385653416,19665.605600728497,19645.92264933036,19626.253512487758,
	19606.598171255097,19586.956606711377,19567.32879996245,19547.714732138436,19528.114384395845,
	19508.527737916647,19488.95477390673,19469.3954735995,19449.84981825167,19430.317789147026,
	19410.799367594132,19391.294534926237,19371.803272502806,19352.325561708072,19332.861383951644,
	19313.41072066811,19293.97355331801,19274.54986338601,19255.139632383198,19235.74284184473,
	19216.35947333227,19196.989508431212,19177.63292875288,19158.28971593353,19138.95985163478,
	19119.64331754266,19100.34009536911,19081.050166850506,19061.77351374884,19042.510117851096,
	19023.259960968448,19004.02302493835,18984.799291622043,18965.588742906875,18946.391360704332,
	18927.20712695186,18908.036023610643,18888.87803266787,18869.73313613504,18850.601316049204,
	18831.482554471888,18812.3768334896,18793.284135214442,18774.20444178178,18755.13773535362,
	18736.083998116843,18717.0432122813,18698.015360085003,18679.00042378763,18659.998385675535,
	18641.009228059575,18622.032933275717,18603.06948368426,18584.118861671,18565.181049646006,
	18546.25603004509,18527.343785328627,18508.444297981085,18489.55755051323,18470.683525459714,
	18451.822205380136,18432.973572859806,18414.13761050803,18395.314300958787,18376.50362687251,
	18357.70557093325,18338.920115850397,18320.14724435826,18301.386939215514,18282.639183206928,
	18263.90395914141,18245.181249853085,18226.471038200627,18207.77330706894,18189.088039365884,
	18170.415218025908,18151.754826008564,18133.10684629713,18114.4712619012,18095.84805585452,
	18077.237211216645,18058.63871107145,18040.05253852837,18021.478676721912,18002.91710881197,
	17984.36781798245,17965.83078744427,17947.306000431647,17928.793440205438,17910.293090050185,
	17891.80493327737,17873.328953222714,17854.865133247,17836.4134567373,17817.97390710545,
	17799.546467787975,17781.1311222479,17762.72785397282,17744.33664647612,17725.957483297123,
	17707.590347999085,17689.235224172164,17670.892095432122,17652.56094541862,17634.24175779891,
	17615.934516264933,17597.639204534345,17579.355806349628,17561.084305481043,17542.82468572209,
	17524.57693089411,17506.34102484356,17488.116951442113,17469.904694588353,17451.70423820604,
	17433.515566245107,17415.33866268169,17397.17351151767,17379.02009678107,17360.878402526716,
	17342.748412834255,17324.630111810926,17306.523483589248,17288.428512328624,17270.345182214704,
	17252.27347745887,17234.213382300168,17216.164881003184,17198.127957859444,17180.10259718699,
	17162.088783330615,17144.086500661524,17126.095733578237,17108.11646650521,17090.148683894655,
	17072.19237022538,17054.24751000329,17036.31408776083,17018.392088058314,17000.48149548262,
	16982.582294648273,16964.69447019716,16946.81800679789,16928.95288914684,16911.099101968422,
	16893.256630013977,16875.425458062546,16857.60557092104,16839.79695342439,16821.99959043488,
	16804.213466842924,16786.438567567177,16768.674877553436,16750.922381777444,16733.181065241362,
	16715.45091297663,16697.731910043374,16680.024041529217,16662.32729255052,16644.641648253553,
	16626.967093811498,16609.303614428023,16591.651195334616,16574.00982179199,16556.37947909051,
	16538.7601525493,16521.15182751649,16503.55448937005,16485.968123517563,16468.392715395737,
	16450.828250471237,16433.27471424082,16415.732092230282,16398.20036999649,16380.679533125203,
	16363.169567233665,16345.67045796881,16328.182191007638,16310.704752058777,16293.238126860504,
	16275.782301182444,16258.33726082491,16240.902991619421,16223.479479428133,16206.066710145096,
	16188.664669695985,16171.273344036907,16153.89271915663,16136.522781075668,16119.163515845323,
	16101.814909550316,16084.476948307134,16067.149618264126,16049.832905602494,16032.526796536487,
	16015.231277311963,15997.94633420894,15980.671953539651,15963.408121649984,15946.154824918629,
	15928.91204975816,15911.679782615323,15894.45800996966,15877.246718334925,15860.045894260045,
	15842.85552432664,15825.675595152128,15808.506093387849,15791.347005720352,15774.198318870509,
	15757.06001959537,15739.9320946864,15722.814530970842,15705.707315312098,15688.610434609005,
	15671.523875796156,15654.447625844909,15637.381671763085,15620.326000594854,15603.280599421509,
	15586.245455361035,15569.220555568898,15552.205887238058,15535.201437598633,15518.207193919237,
	15501.223143506119,15484.24927370412,15467.285571896093,15450.332025504264,15433.388621988997,
	15416.455348850604,15399.532193628093,15382.61914390073,15365.716187287118,15348.823311446151,
	15331.940504077113,15315.067752919753,15298.205045754148,15281.352370402401,15264.50971472724,
	15247.677066633247,15230.854414066576,15214.041745015536,15197.239047510846,15180.446309625502,
	15163.663519475911,15146.89066522128,15130.127735063954,15113.37471725058,15096.631600071316,
	15079.898371860703,15063.17502099784,15046.461535906321,15029.757905055607,15013.064116959744,
	14996.38016017914,14979.706023319448,14963.041695033773,14946.387164020613,14929.742419026385,
	14913.107448844088,14896.48224231481,14879.866788327015,14863.261075817938,14846.665093773106,
	14830.078831227023,14813.502277263307,14796.935421015203,14780.378251665785,14763.830758448525,
	14747.292930647494,14730.764757597826,14714.246228685717,14697.737333349402,14681.238061078742,
	14664.748401416638,14648.268343957754,14631.797878351175,14615.336994298812,14598.885681556732,
	14582.443929935238,14566.011729299362,14549.589069569449,14533.175940720977,14516.772332785837,
	14500.378235851755,14483.99364006356,14467.618535623356,14451.25291279009,14434.896761881444,
	14418.55007327337,14402.212837400266,14385.88504475616,14369.566685894832,14353.257751429992,
	14336.958232035986,14320.668118448544,14304.38740146435,14288.11607194219,14271.854120803524,
	14255.601539032428,14239.358317676197,14223.12444784607,14206.899920717904,14190.684727531328,
	14174.47885959194,14158.282308270876,14142.0950650052,14125.917121298986,14109.7484687229,
	14093.589098915847,14077.439003584168,14061.298174503472,14045.16660351797,14029.044282541583,
	14012.931203558399,13996.827358623053,13980.732739861229,13964.647339470552,13948.57114972002,
	13932.504162952016,13916.446371581449,13900.397768097288,13884.358345062317,13868.328095114262,
	13852.307010965693,13836.295085405129,13820.292311297004,13804.298681582748,13788.314189280864,
	13772.338827487361,13756.372589376557,13740.415468201774,13724.467457295264,13708.52855006912,
	13692.598740015348,13676.678020707272,13660.766385798834,13644.863829026195,13628.970344207202,
	13613.08592524265,13597.210566116377,13581.344260896041,13565.487003732833,13549.638788863245,
	13533.799610607992,13517.9694633736,13502.14834165247,13486.336240023198,13470.533153150876,
	13454.739075788111,13438.954002774715,13423.17792903818,13407.410849594793,13391.652759548882,
	13375.903654094112,13360.16352851335,13344.432378178868,13328.71019855288,13312.996985187736,
	13297.292733726772,13281.597439903016,13265.911099541056,13250.233708556421,13234.565262956003,
	13218.905758837931,13203.255192391709,13187.61355989889,13171.980857732684,13156.357082358001,
	13140.7422303313,13125.136298301239,13109.539283007947,13093.951181283093,13078.371990050153,
	13062.801706323688,13047.240327209567,13031.687849904503,13016.144271695744,13000.609589961206,
	12985.08380216809,12969.566905873873,12954.058898724288,12938.559778454182,12923.069542885927,
	12907.588189929222,12892.11571758042,12876.652123921494,12861.197407119618,12845.751565425857,
	12830.314597174245,12814.886500781262,12799.467274743805,12784.056917638934,12768.655428122185,
	12753.262804925924,12737.879046858292,12722.50415280177,12707.138121711112,12691.780952612233,
	12676.432644599576,12661.093196835067,12645.76260854566,12630.440879021196,12615.128007612115,
	12599.823993727727,12584.528836832744,12569.242536445685,12553.965092135417,12538.696503518933,
	12523.43677025801,12508.185892056521,12492.943868656714,12477.71069983655,12462.486385405793,
	12447.270925202147,12432.06431908865,12416.866566948323,12401.677668681425,12386.497624200525,
	12371.326433426697,12356.164096284554,12341.010612698487,12325.865982587271,12310.730205859418,
	12295.603282408398,12280.48521210754,12265.375994804566,12250.275630316588,12235.184118424331,
	12220.101458867055,12205.02765133638,12189.962695470982,12174.906590850722,12159.859336990452,
	12144.82093333475,12129.791379251557,12114.770674026246,12099.758816855712,12084.755806842935,
	12069.761642990246,12054.776324194516,12039.799849241146,12024.832216798613,12009.873425412967,
	11994.92347350363,11979.982359357507,11965.050081125702,11950.126636818739,11935.212024303657,
	11920.306241300264,11905.409285379474,11890.521153961203,11875.64184431329,11860.771353551805,
	11845.909678641518,11831.056816397948,11816.21276349074,11801.377516447565,11786.551071660837,
	11771.733425394368,11756.924573793356,11742.124512895245,11727.333238643701,11712.550746903142,
	11697.777033478415,11683.012094135325,11668.255924624558,11653.508520709369,11638.769878196801,
	11624.039992971955,11609.318861038184,11594.60647855963,11579.902841910804,11565.207947730076,
	11550.521792979442,11535.844375010367,11521.17569163631,11506.515741212437,11491.864522722499,
	11477.222035874463,11462.588281204748,11447.963260191318,11433.346975377699,11418.739430506446,
	11404.140630665006,11389.550582442864,11374.969294101616,11360.39677575901,11345.833039586647,
	11331.278100023357,11316.731974004204,11302.194681206622,11287.666244314085,11273.146689298399,
	11258.636045722034,11244.13434706005,11229.641631044191,11215.157940028861,11200.683321380353,
	11186.21782789045,11171.761518214887,11157.314457337434,11142.876717060806,11128.448376524997,
	11114.02952275382,11099.620251229644,11085.220666497964,11070.830882801167,11056.451024742764,
	11042.081227981422,11027.721639955284,11013.372420636533,10999.033743315977,10984.70579541626,
	10970.388779334793,10956.082913313227,10941.788432334395,10927.505589043938,10913.23465469492,
	10898.975920114417,10884.729696688535,10870.496317363295,10856.276137660057,10842.069536698826,
	10827.876918228803,10813.69871166037,10799.535373094208,10785.38738634288,10771.255263939685,
	10757.1395481283,10743.040811828747,10728.95965957146,10714.896728394306,10700.852688695208,
	10686.828245032171,10672.824136865334,10658.841139231086,10644.880063342784,10630.941757108209,
	10617.027105558314,10603.13703117684,10589.27249412602,10575.434492358634,10561.624061611199,
	10547.842275270117,10534.090244105515,10520.369115866952,10506.68007473462,10493.024340623893,
	10479.40316833742,10465.817846562693,10452.269696713754,10438.76007161536,10425.290354029383,
	10411.861955025688,10398.476312198572,10385.134887733078,10371.839166324282,10358.590652957251,
	10345.390870551853,10332.241357482882,10319.143664982015,10306.099354433723,10293.109994573384,
	10280.177158602579,10267.302421230735,10254.487355658855,10241.733530518068,10229.042506776757,
	10216.415834632562,10203.855050401444,10191.361673422303,10178.937202988305,10166.583115322257,
	10154.300860609983,10142.091860104425,10129.95750331604,10117.899145300884,10105.918104059121,
	10094.015658055148,10082.19304386947,10070.451453992922,10058.79203476962,10047.215884497728,
	10035.724051693158,10024.317533521838,10012.997274403373,10001.764164790025,9990.619040121717,
	9979.562679957773,9968.595807284371,9957.719087996575,9946.933130551777,9936.238485791235,
	9925.635646925135,9915.125049675205,9904.707072571524,9894.382037392239,9884.150209745258,
	9874.011799777918,9863.966963011915,9854.015801292231,9844.158363842454,9834.394648418047,
	9824.724602549031,9815.148124861638,9805.665066473663,9796.275232451339,9786.9783833215,
	9777.774236630044,9768.66246853934,9759.642715456368,9750.714575683927,9741.877611089394,
	9733.13134878235,9724.475282795971,9715.908875767747,9707.431560609744,9699.042742168409,
	9690.741798865974,9682.528084319973,9674.400928937683,9666.359641480976,9658.403510598971,
	9650.531806326178,9642.743781542797,9635.038673395526,9627.41570467708,9619.874085164063,
	9612.413012909221,9605.031675490014,9597.729251211833,9590.504910265121,9583.357815836158,
	9576.287125171826,9569.291990598742,9562.371560496957,9555.524980226945,9548.751393014201,
	9542.049940788318,9535.419764979431,9528.860007272802,9522.369810321808,9515.948318420742,
	9509.594678138608,9503.308038915266,9497.087553620211,9490.932379076043,9484.84167654781,
	9478.814612199028,9472.850357515466,9466.948089698608,9461.106992030056,9455.326254207228,
	9449.605072651495,9443.942650792238,9438.338199324882,9432.79093644528,9427.300088063015,
	9421.864887992604,9416.484578124971,9411.158408576595,9405.885637828535,9400.66553283963,
	9395.497369147599,9390.380430954403,9385.314011197243,9380.297411605508,9375.329942745135,
	9370.410924051439,9365.539683849773,9360.715559366878,9355.937896730731,9351.20605096314,
	9346.51938596218,9341.877274477767,9337.279098078434,9332.724247113365,9328.212120665974,
	9323.742126502695,9319.313681014062,9314.926209161184,9310.5791443971,9306.271928603937,
	9302.004012017533,9297.774853148585,9293.583918702509,9289.430683495239,9285.314630367344,
	9281.23525009519,9277.192041300688,9273.184510358924,9269.212171305375,9265.274545738981,
	9261.371162728328,9257.501558712967,9253.665277406533,9249.86186969788,9246.090893552928,
	9242.351913915581,9238.644502608415,9234.968238233676,9231.32270607385,9227.707497993772,
	9224.122212341113,9220.566453848702,9217.03983353698,9213.541968616524,9210.07248239211,
	9206.63100416616,9203.217169144593,9199.830618341302,9196.470998486255,9193.137961932083,
	9189.831166562419,9186.550275701684,9183.294958025364,9180.06488747116,9176.859743151972,
	9173.6792092683,9170.522975024667,9167.390734543342,9164.282186783195,9161.197035455649,
	9158.13498894544,9155.0957602298,9152.079066800581,9149.084630586529,9146.112177877058,
	9143.161439246669,9140.232149482179,9137.32404750871,9134.436876318448,9131.570382900287,
	9128.724318170573,9125.898436904286,9123.092497668391,9120.306262755708,9117.539498120172,
	9114.791973312658,9112.063461418282,9109.35373899553,9106.662586014838,9103.989785798807,
	9101.335124965102,9098.698393366987,9096.079384039318,9093.477893140524,9090.89371989995,
	9088.326666563626,9085.776538341943,9083.243143358091,9080.726292596928,9078.225799855538,
	9075.741481696332,9073.273157393087,9070.820648891633,9068.383780758952,9065.96238013897,
	9063.556276707744,9061.165302630097,9058.789292516174,9056.42808338024,9054.081514598785,
	9051.749427869801,9049.431667173203,9047.128078731843,9044.83851097315,9042.56281449121,
	9040.300842010345,9038.052448348302,9035.81749038114,9033.59582700805,9031.387319117102,
	9029.191829549794,9027.009223076908,9024.839366351702,9022.682127888418,9020.537378028892,
	9018.404988910079,9016.284834436936,9014.176790250454,9012.080733700353,9009.996543815289,
	9007.924101276414,9005.863288389392,9003.81398905731,9001.776088755032,8999.749474502572,
	8997.734034840278,8995.729659803817,8993.736240900542,8991.753671083408,8989.781844729638,
	8987.820657616641,8985.870006899006,8983.929791087652,8981.999910025464,8980.080264869624,
	8978.170758066233,8976.271293333426,8974.381775638123,8972.502111178266,8970.632207362014,
	8968.77197278925,8966.921317232276,8965.080151617945,8963.24838800808,8961.42593958346,
	8959.612720624998,8957.80864649666,8956.013633630015,8954.227599505371,8952.450462637298,
	8950.682142557253,8948.922559799625,8947.17163588452,8945.42929330343,8943.695455504212,
	8941.97004687701,8940.25299273876,8938.544219320427,8936.843653751646,8935.151224048153,
	8933.466859099008,8931.790488651586,8930.122043300138,8928.46145447233,8926.808654417524,
	8925.16357619469,8923.526153658211,8921.896321449109,8920.274014981635,8918.659170431536,
	8917.05172472687,8915.451615534026,8913.858781249506,8912.273160988483,8910.694694573434,
	8909.12332252457,8907.55898605031,8906.001627035597,8904.451188034833,8902.907612259472,
	8901.370843569826,8899.840826466248,8898.317506079185,8896.800828160787,8895.290739075655,
	8893.787185791944,8892.290115874102,8890.799477472987,8889.315219318105,8887.837290709596,
	8886.365641510894,8884.900222139486,8883.44098356097,8881.987877279596,8880.540855331255,
	8879.099870278249,8877.664875198554,8876.235823681298,8874.812669819348,8873.395368201202,
	8871.983873906027,8870.578142495333,8869.17813000801,8867.783792951977,8866.395088299445,
	8865.01197348086,8863.634406376143,8862.262345312582,8860.895749056657,8859.534576805849,
	8858.178788187637,8856.828343252208,8855.483202464442,8854.143326702137,8852.808677246543,
	8851.479215781423,8850.15490438384,8848.835705521753,8847.521582047724,8846.212497194292,
	8844.908414568752,8843.609298148573,8842.315112276645,8841.025821656016,8839.74139134634,
	8838.461786757922,8837.186973649339,8835.916918120565,8834.651586607279,8833.390945888206,
	8832.134963061504,8830.883605555777,8829.636841119782,8828.394637819842,8827.156964036481,
	8825.92378845976,8824.695080084259,8823.470808207652,8822.250942424724,8821.035452626062,
	8819.824308992245,8818.617481991312,8817.4149423744,8816.216661174778,8815.022609700556,
	8813.832759534025,8812.647082528649,8811.465550803729,8810.288136742076,8809.114812988137,
	8807.945552442714,8806.780328261271,8805.61911385082,8804.461882865819,8803.308609207037,
	8802.159267016708,8801.013830677559,8799.872274808135,8798.73457426141,8797.600704121076,
	8796.47063969925,8795.3443565351,8794.22183038902,8793.103037243183,8791.987953296672,
	8790.87655496552,8789.7688188776,8788.66472187114,8787.564240993672,8786.4673534967,
	8785.374036836838,8784.284268670259,8783.198026851975,8782.115289434378,8781.036034663955,
	8779.960240977676,8778.887887004907,8777.818951560062,8776.753413645774,8775.691252445202,
	8774.632447326423,8773.576977833607,8772.524823690708,8771.475964796226,8770.43038122248,
	8769.388053213497,8768.34896118208,8767.313085710177,8766.28040754437,8765.250907597436,
	8764.224566942728,8763.201366814337,8762.18128860645,8761.164313869534,8760.150424309468,
	8759.139601785635,8758.131828310641,8757.127086046921,8756.12535730494,8755.126624544246,
	8754.1308703687,8753.138077525535,8752.148228908163,8751.161307545943,8750.177296612093,
	8749.196179416322,8748.217939404756,8747.242560158817,8746.270025394155,8745.300318958869,
	8744.3334248323,8743.369327122364,8742.408010065588,8741.449458026716,8740.4936554946,
	8739.540587084019,8738.590237531116,8737.642591695,8736.69763455523,8735.755351210262,
	8734.815726876606,8733.878746888882,8732.944396696159,8732.012661862282,8731.083528064702,
	8730.156981093254,8729.233006848472,8728.311591340864,8727.392720690446,8726.476381125241,
	8725.562558978023,8724.65124069042,8723.742412804611,8722.836061969765,8721.932174935877,
	8721.03073855576,8720.131739781287,8719.235165664562,8718.341003356818,8717.449240105543,
	8716.559863256076,8715.672860248198,8714.788218617949,8713.905925993844,8713.025970098324,
	8712.148338745177,8711.273019839964,8710.400001377306,8709.529271442916,8708.660818209793,
	8707.794629938591,8706.93069497577,8706.069001758731,8705.20953880494,8704.352294717512,
	8703.497258183874,8702.644417972924,8701.793762937377,8700.945282009518,8700.09896420399,
	8699.254798613174,8698.412774409313,8697.572880843227,8696.735107242617,8695.89944301291,
	8695.065877633522,8694.234400661817,8693.405001727811,8692.577670537485,8691.752396867629,
	8690.92917056941,8690.107981566089,8689.288819850988,8688.471675488914,8687.656538614327,
	8686.84339943154,8686.032248212903,8685.223075299304,8684.415871099276,8683.610626088159,
	8682.807330806589,8682.005975862632,8681.206551928068,8680.409049739488,8679.613460097895,
	8678.819773867725,8678.027981974268,8677.238075408673,8676.450045219948,8675.663882521507,
	8674.879578484526,8674.097124342214,8673.316511386804,8672.537730969232,8671.760774498644,
	8670.985633443986,8670.21229932874,8669.440763736053,8668.671018303896,8667.903054727303,
	8667.136864755947,8666.372440194991,8665.609772904214,8664.848854796652,8664.089677840633,
	8663.332234055804,8662.576515515328,8661.822514345473,8661.07022272283,8660.319632875642,
	8659.570737083966,8658.823527677965,8658.077997036864,8657.33413759232,8656.591941819945,
	8655.851402249607,8655.112511457315,8654.375262066555,8653.639646749805,8652.905658225573,
	8652.173289259108,8651.442532663994,8650.713381296346,8649.98582806124,8649.259865907683,
	8648.535487828585,8647.812686863632,8647.091456094435,8646.371788647737,8645.653677693457,
	8644.937116444373,8644.222098155384,8643.508616125471,8642.796663691592,8642.08623424089,
	8641.377321193577,8640.669918013029,8639.964018204757,8639.259615313285,8638.556702923777,
	8637.855274661295,8637.155324189693,8636.456845212175,8635.759831470446,8635.06427674652,
	8634.370174857087,8633.677519658539,8632.986305046003,8632.296524938485,8631.608173339468,
	8630.921244218112,8630.23573162665,8629.551629644397,8628.86893238265,8628.187633990028,
	8627.507728651126,8626.829210583492,8626.15207404134,8625.47631331243,8624.801922718545,
	8624.128896614626,8623.457229392676,8622.786915472758,8622.117949312393,8621.450325397967,
	8620.784038255559,8620.119082434943,8619.455452522794,8618.793143160916,8618.132148927592,
	8617.472464573279,8616.814084788102,8616.157004311986,8615.501217920195,8614.846720416403,
	8614.193506634208,8613.541571437245,8612.89090971958,8612.241516403468,8611.593386442313,
	8610.946514817484,8610.300896538636,8609.656526645394,8609.013400205029,8608.371512312835,
	8607.730858091218,8607.091432694368,8606.453231300691,8605.816249116175,8605.180481373423,
	8604.545923334217,8603.912570285454,8603.280417541368,8602.649460441238,8602.01969435421,
	8601.391114670383,8600.763716808451,8600.13749621321,8599.512448353607,8598.888568725068,
	8598.265852846429,8597.644296262966,8597.023894543901,8596.404643283182,8595.786538098886,
	8595.169574637117,8594.553748559056,8593.939055556068,8593.325491343807,8592.71305165867,
	8592.101732262336,8591.49152893798,8590.882437493097,8590.274453757786,8589.667573584189,
	8589.061792847146,8588.457107444534,8587.853513295344,8587.251006341807,8586.649582547692,
	8586.049237896783,8585.449968396862,8584.851770076746,8584.254638985369,8583.658571192876,
	8583.063562791514,8582.469609894146,8581.87670863376,8581.284855163602,8580.69404565841,
	8580.104276311142,8579.515543338292,8578.92784297345,8578.34117147105,8577.75552510526,
	8577.170900169847,8576.58729297776,8576.00469986159,8575.423117171913,8574.842541281205,
	8574.262968577777,8573.684395470833,8573.106818386583,8572.530233770663,8571.95463808757,
	8571.380027819532,8570.806399466685,8570.233749548235,8569.662074599617,8569.091371175811,
	8568.521635848216,8567.952865206284,8567.385055856668,8566.818204425064,8566.252307551234,
	8565.687361894607,8565.123364130202,8564.560310951354,8563.998199066085,8563.437025201436,
	8562.87678609901,8562.317478517376,8561.759099231696,8561.201645035399,8560.645112733391,
	8560.089499149472,8559.534801123942,8558.981015511696,8558.428139183372,8557.876169025654,
	8557.325101940667,8556.774934845618,8556.225664672607,8555.677288370614,8555.129802901507,
	8554.583205243645,8554.037492390322,8553.492661348257,8552.948709140112,8552.405632803288,
	8551.863429388968,8551.322095962909,8550.781629605674,8550.242027411226,8549.703286490107,
	8549.1654039626,8548.62837696587,8548.092202651243,8547.556878182677,8547.022400739042,
	8546.48876751066,8545.955975704512,8545.424022537894,8544.892905242921,8544.362621066013,
	8543.833167265662,8543.304541112348,8542.776739891307,8542.249760901603,8541.723601452031,
	8541.198258866132,8540.673730481092,8540.150013645327,8539.627105718964,8539.105004075342,
	8538.5837061036,8538.063209200685,8537.543510776968,8537.024608255533,8536.506499072219,
	8535.989180673194,8535.472650517419,8534.956906076535,8534.441944832359,8533.927764280405,
	8533.414361925556,8532.901735286707,8532.389881892655,8531.878799283786,8531.368485012727,
	8530.858936641955,8530.350151746674,8529.842127914251,8529.334862738364,8528.828353829302,
	8528.322598806055,8527.817595297918,8527.313340945573,8526.809833400583,8526.307070325225,
	8525.805049392666,8525.303768286332,8524.803224699463,8524.303416337514,8523.804340916016,
	8523.305996158151,8522.808379800565,8522.311489589114,8521.815323279643,8521.31987863834,
	8520.825153440654,8520.331145473087,8519.83785253098,8519.34527242131,8518.853402958921,
	8518.362241969528,8517.871787287811,8517.382036758841,8516.892988236646,8516.40463958552,
	8515.916988677876,8515.430033397079,8514.943771636163,8514.458201294645,8513.97332028383,
	8513.489126523671,8513.005617943805,8512.522792481719,8512.040648084476,8511.559182707557,
	8511.07839431771,8510.598280887374,8510.11884040052,8509.640070848009,8509.161970229665,
	8508.684536555878,8508.207767843354,8507.731662118184,8507.256217415852,8506.781431779627,
	8506.307303259771,8505.833829918822,8505.361009822931,8504.88884104908,8504.417321684577,
	8503.9464498209,8503.47622355925,8503.006641009766,8502.5377002899,8502.069399525592,
	8501.601736849418,8501.13471040363,8500.668318337615,8500.202558809066,8499.737429983044,
	8499.272930030997,8498.809057135386,8498.345809482968,8497.88318527037,8497.42118270205,
	8496.959799986726,8496.49903534437,8496.038887001136,8495.579353190917,8495.12043215301,
	8494.662122137239,8494.20442139803,8493.747328198193,8493.290840806952,8492.83495750431,
	8492.379676571734,8491.924996301117,8491.470914993724,8491.017430951153,8490.56454248796,
	8490.112247923178,8489.660545584607,8489.209433803537,8488.758910920478,8488.308975284646,
	8487.859625246398,8487.410859168322,8486.962675417779,8486.515072367873,8486.068048398007,
	8485.62160189691,8485.175731257874,8484.73043488044,8484.2857111716,8483.841558545548,
	8483.39797542005,8482.954960221796,8482.512511382616,8482.070627340778,8481.629306542738,
	8481.18854743866,8480.748348485027,8480.308708146053,8479.869624892397,8479.43109719857,
	8478.993123547405,8478.555702425185,8478.118832327818,8477.682511753701,8477.246739210086,
	8476.811513208115,8476.3768322659,8475.942694906911,8475.50909965959,8475.076045061533,
	8474.643529651607,8474.2115519782,8473.780110592985,8473.349204054412,8472.918830926401,
	8472.488989778061,8472.059679185184,8471.630897728248,8471.202643993785,8470.774916573657,
	8470.347714063662,8469.92103506845,8469.494878195455,8469.069242058828,8468.644125275434,
	8468.219526472581,8467.795444277677,8467.371877326597,8466.948824259187,8466.52628372141,
	8466.104254363574,8465.682734841379,8465.261723816771,8464.841219954562,8464.421221927041,
	8464.001728409678,8463.582738085603,8463.164249639227,8462.746261762733,8462.3287731536,
	8461.91178251331,8461.495288545855,8461.079289965659,8460.663785486337,8460.248773831607,
	8459.834253723671,8459.420223897285,8459.00668308464,8458.593630028241,8458.181063472291,
	8457.768982165428,8457.357384864077,8456.946270326238,8456.535637315692,8456.125484602533,
	8455.715810956914,8455.306615157868,8454.897895987247,8454.489652231785,8454.0818826836,
	8453.6745861373,8453.267761392748,8452.861407255674,8452.455522535602,8452.050106043625,
	8451.64515659931,8451.240673024538,8450.836654147797,8450.433098796204,8450.030005807843,
	8449.627374020987,8449.225202279575,8448.82348943202,8448.422234330123,8448.021435826773,
	8447.62109278991,8447.221204079795,8446.821768566224,8446.422785122077,8446.024252624764,
	8445.626169954336,8445.228535997674,8444.831349642982,8444.434609783653,8444.038315317786,
	8443.642465145544,8443.247058172648,8442.852093308255,8442.457569467255,8442.063485563225,
	8441.669840520177,8441.27663326151,8440.883862716535,8440.491527818063,8440.09962750137,
	8439.70816070671,8439.3171263782,8438.92652346562,8438.536350917515,8438.14660768996,
	8437.757292743285,8437.36840503762,8436.97994354092,8436.59190722306,8436.204295056186,
	8435.81710601911,8435.43033909285,8435.043993260304,8434.658067510594,8434.27256083558,
	8433.8874722287,8433.502800691032,8433.118545222005,8432.734704829074,8432.351278521008,
	8431.968265310607,8431.585664212807,8431.203474247957,8430.82169443994,8430.440323813276,
	8430.059361397603,8429.67880622829,8429.298657339072,8428.918913771784,8428.539574567612,
	8428.160638773461,8427.782105440581,8427.403973620038,8427.026242368429,8426.648910745966,
	8426.271977815108,8425.895442641728,8425.519304294357,8425.143561845667,8424.768214372727,
	8424.393260951205,8424.01870066552,8423.6445325984,8423.270755839982,8422.897369480428,
	8422.524372614365,8422.151764339555,8421.779543754914,8421.407709964446,8421.03626207596,
	8420.665199199006,8420.294520443798,8419.924224928058,8419.554311767963,8419.184780088832,
	8418.815629011475,8418.446857666659,8418.078465181437,8417.710450690187,8417.342813330873,
	8416.975552240296,8416.608666560911,8416.24215543774,8415.87601801891,8415.510253454364,
	8415.144860898601,8414.779839505918,8414.415188436154,8414.050906851282,8413.68699391619,
	8413.32344879738,8412.960270665977,8412.597458693266,8412.235012056812,8411.872929932295,
	8411.511211503506,8411.149855951699,8410.788862465133,8410.428230231522,8410.067958443791,
	8409.7080462958,8409.348492984429,8408.989297709393,8408.630459671862,8408.271978078812,
	8407.913852136968,8407.55608105477,8407.198664047,8406.841600328633,8406.484889116085,
	8406.128529630378,8405.772521094243,8405.416862734042,8405.061553775571,8404.706593451216,
	8404.351980992464,8403.997715634241,8403.643796616456,8403.290223177308,8402.936994560225,
	8402.584110010619,8402.231568774216,8401.879370102266,8401.527513249677,8401.175997467719,
	8400.824822014452,8400.473986149269,8400.12348913562,8399.773330234406,8399.423508715445,
	8399.07402384605,8398.724874898851,8398.376061145484,8398.027581862962,8397.679436329703,
	8397.331623825008,8396.984143632204,8396.636995037104,8396.290177325887,8395.94368978752,
	8395.5975317147,8395.251702402555,8394.906201144422,8394.561027242595,8394.216179993025,
	8393.871658701375,8393.527462672377,8393.183591213578,8392.840043632485,8392.496819242318,
	8392.153917355488,8391.811337289651,8391.469078359976,8391.12713988848,8390.78552119724,
	8390.444221610347,8390.103240453303,8389.762577056174,8389.422230747101,8389.08220086122,
	8388.742486730323,8388.40308769358,8388.064003090003,8387.725232258856,8387.38677454201,
	8387.048629287843,8386.71079583926,8386.373273547206,8386.036061763723,8385.699159839098,
	8385.362567129514,8385.026282991828,8384.690306784485,8384.354637868382,8384.019275605364,
	8383.684219362509,8383.34946850397,8383.015022397534,8382.680880416194,8382.347041931604,
	8382.01350631735,8381.680272948941,8381.347341205917,8381.01471046655,8380.682380114042,
	8380.350349531323,8380.018618103006,8379.687185218447,8379.356050265516,8379.025212635484,
	8378.694671720596,8378.364426916973,8378.034477619976,8377.704823227601,8377.375463140273,
	8377.046396761032,8376.717623493312,8376.389142740192,8376.060953911387,8375.733056415005,
	8375.405449661812,8375.078133065666,8374.751106037651,8374.424367996487,8374.097918358711,
	8373.771756544114
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	26841.00738226179,26815.730592135267,26790.475270992407,26765.24138931242,26740.028917615105,
	26714.83782646534,26689.668086468813,26664.519668277262,26639.392542583497,26614.286680121033,
	26589.20205167075,26564.138628052653,26539.096380128627,26514.07527880559,26489.075295032024,
	26464.09639979714,26439.13856413573,26414.20175911922,26389.285955866875,26364.391125535767,
	26339.51723932653,26314.664268482513,26289.832184287498,26265.020958065368,26240.2305611839,
	26215.46096505297,26190.712141122836,26165.98406088222,26141.276695865763,26116.59001764662,
	26091.923997840888,26067.2786081017,26042.653820127292,26018.04960565658,25993.465936466237,
	25968.90278437525,25944.360121244823,25919.837918972888,25895.336149502553,25870.854784812807,
	25846.393796927212,25821.95315790698,25797.532839852563,25773.132814907753,25748.753055252717,
	25724.393533111488,25700.0542207442,25675.735090452727,25651.436114578635,25627.15726550319,
	25602.89851564592,25578.659837468076,25554.44120346862,25530.24258618782,25506.063958200742,
	25481.905292127172,25457.766560622422,25433.64773638202,25409.548792141013,25385.46970067358,
	25361.410434789865,25337.370967342118,25313.351271220563,25289.351319352147,25265.371084705435,
	25241.410540284636,25217.469659133276,25193.54841433478,25169.646779009057,25145.764726313224,
	25121.90222944644,25098.05926164204,25074.23579617319,25050.431806350523,25026.647265522475,
	25002.88214707511,24979.136424433233,24955.41007105818,24931.703060447624,24908.01536613984,
	24884.346961710096,24860.69782076731,24837.067916962846,24813.457223979607,24789.8657155433,
	24766.293365411668,24742.740147386055,24719.206035296753,24695.69100301693,24672.195024452478,
	24648.718073549615,24625.260124289423,24601.82115068911,24578.40112680463,24555.000026725633,
	24531.617824579305,24508.254494529207,24484.910010775304,24461.584347554908,24438.277479139066,
	24414.989379837298,24391.720023991427,24368.469385983964,24345.237440230427,24322.0241611831,
	24298.829523328382,24275.653501191067,24252.496069329212,24229.357202338295,24206.236874847105,
	24183.13506152144,24160.051737063153,24136.98687620695,24113.94045372441,24090.912444422418,
	24067.902823142096,24044.911564759837,24021.938644188183,23998.9840363723,23976.04771629426,
	23953.129658969654,23930.22983944969,23907.348232819633,23884.48481419898,23861.639558742496,
	23838.812441640046,23816.00343811405,23793.21252342247,23770.43967285748,23747.68486174473,
	23724.948065446264,23702.229259354688,23679.528418899412,23656.845519542523,23634.180536780204,
	23611.533446144455,23588.904223196583,23566.29284353655,23543.69928279402,23521.12351663541,
	23498.56552075879,23476.02527089635,23453.50274281367,23430.997912308692,23408.510755214633,
	23386.041247396053,23363.58936475173,23341.155083214675,23318.738378748483,23296.339227350767,
	23273.95760505191,23251.593487916656,23229.24685204152,23206.91767355528,23184.605928620098,
	23162.311593430433,23140.034644213596,23117.775057229297,23095.53280877017,23073.307875160484,
	23051.10023275741,23028.90985795123,23006.73672716149,22984.580816844904,22962.44210348554,
	22940.320563602138,22918.21617374529,22896.12891049636,22874.058750469714,22852.00567031177,
	22829.969646700054,22807.95065634345,22785.948675983258,22763.963682393558,22741.995652377973,
	22720.04456277218,22698.11039044429,22676.1931122933,22654.29270524889,22632.40914627366,
	22610.54241235993,22588.692480532532,22566.859327845188,22545.04293138561,22523.243268270217,
	22501.460315648936,22479.694050700313,22457.944450634794,22436.211492693797,22414.49515414821,
	22392.795412302305,22371.112244488137,22349.445628070724,22327.79554044434,22306.161959033496,
	22284.54486129604,22262.944224715004,22241.360026808994,22219.792245123703,22198.240857236946,
	22176.70584075556,22155.187173316557,22133.684832589308,22112.198796270368,22090.72904208616,
	22069.27554779685,22047.83829118899,22026.417250079812,22005.01240231728,21983.623725778067,
	21962.25119836861,21940.8947980266,21919.554502717885,21898.23029043813,21876.922139212504,
	21855.630027095704,21834.353932172653,21813.09383255733,21791.84970639186,21770.621531848887,
	21749.409287130828,21728.212950467223,21707.032500118614,21685.867914373775,21664.719171552224,
	21643.586250000004,21622.46912809372,21601.367784238046,21580.282196868287,21559.212344445976,
	21538.158205462823,21517.11975844056,21496.096981927498,21475.089854501395,21454.09835476882,
	21433.122461365383,21412.16215295377,21391.217408226552,21370.28820590347,21349.374524735184,
	21328.476343497667,21307.59364099715,21286.72639606628,21265.874587568786,21245.038194394303,
	21224.217195460704,21203.411569716005,21182.621296133853,21161.846353716868,21141.08672149627,
	21120.3423785304,21099.613303905135,21078.899476736387,21058.20087616504,21037.517481361334,
	21016.84927152378,20996.196225876254,20975.5583236736,20954.935544195334,20934.327866750147,
	20913.735270674177,20893.157735330293,20872.595240109356,20852.047764429295,20831.515287736926,
	20810.99778950426,20790.495249232004,20770.007646448044,20749.534960706296,20729.077171589448,
	20708.634258706505,20688.20620169401,20667.79298021545,20647.394573961297,20627.01096264897,
	20606.64212602257,20586.288043854296,20565.94869594188,20545.624062111267,20525.31412221369,
	20505.01885612945,20484.73824376349,20464.47226504739,20444.220899941734,20423.98412843179,
	20403.761930530054,20383.554286275186,20363.361175734415,20343.182578997876,20323.018476185818,
	20302.868847443184,20282.733672941642,20262.612932879318,20242.506607479874,20222.41467699511,
	20202.33712170222,20182.273921904663,20162.225057932003,20142.190510140103,20122.17025891195,
	20102.164284654544,20082.17256780314,20062.195088819353,20042.23182818866,20022.28276642408,
	20002.347884064922,19982.427161675532,19962.52057984734,19942.628119196892,19922.749760366674,
	19902.885484025333,19883.03527086801,19863.19910161412,19843.376957010772,19823.568817829135,
	19803.774664867695,19783.994478949237,19764.228240923785,19744.47593166569,19724.737532075134,
	19705.01302308001,19685.30238563021,19665.6056007044,19645.92264930531,19626.25351246129,
	19606.598171228037,19586.95660668325,19567.32879993325,19547.714732108176,19528.114384364224,
	19508.52773788348,19488.954773872465,19469.39547356348,19449.84981821463,19430.317789108158,
	19410.799367553544,19391.294534884237,19371.803272459227,19352.325561662532,19332.86138390463,
	19313.41072061915,19293.973553266664,19274.54986333303,19255.13963232814,19235.742841787564,
	19216.359473273,19196.98950836906,19177.63292868848,19158.289715866544,19138.959851564923,
	19119.643317469858,19100.340095293395,19081.05016677192,19061.773513667198,19042.510117765978,
	19023.25996088025,19004.02302484622,18984.799291526142,18965.588742807075,18946.391360601116,
	18927.207126843965,18908.036023498837,18888.878032551544,18869.73313601413,18850.601315923323,
	18831.482554340953,18812.376833353293,18793.2841350724,18774.204441634378,18755.13773520039,
	18736.08399795727,18717.043212115874,18698.015359912526,18679.000423608253,18659.99838548874,
	18641.009227865365,18622.032933074057,18603.06948347422,18584.1188614528,18565.18104941921,
	18546.256029809272,18527.34378508314,18508.444297726313,18489.557550247882,18470.683525183962,
	18451.82220509343,18432.97357256124,18414.137610197173,18395.314300636073,18376.503626536796,
	18357.70557058439,18338.92011548724,18320.147243980453,18301.38693882261,18282.639182798404,
	18263.90395871647,18245.181249411504,18226.471037741576,18207.77330659107,18189.088038869355,
	18170.415217509286,18151.754825471256,18133.106845738625,18114.47126132013,18095.84805525017,
	18077.23721058812,18058.638710418043,18040.05253784876,18021.47867601531,18002.917108077152,
	17984.367817218594,17965.83078664986,17947.30599960536,17928.793439345714,17910.293089156385,
	17891.80493234797,17873.328952256248,17854.86513224211,17836.413455692124,17817.97390601819,
	17799.546466657714,17781.131121072736,17762.727852750664,17744.336645205516,17725.957481975478,
	17707.590346624896,17689.235222743275,17670.89209394616,17652.560943873574,17634.241756192558,
	17615.934514594363,17597.63920279664,17579.355804543087,17561.084303602325,17542.824683768908,
	17524.576928862825,17506.34102273158,17488.116949246043,17469.904692304615,17451.70423583111,
	17433.515563775647,17415.338660114074,17397.17350884785,17379.020094005053,17360.878399640038,
	17342.748409832857,17324.630108689944,17306.52348034421,17288.42850895443,17270.345178705855,
	17252.27347381063,17234.213378506854,17216.16487705893,17198.127953758347,17180.102592922787,
	17162.088778896516,17144.08649605093,17126.0957287843,17108.116461520684,17090.148678712096,
	17072.192364836752,17054.247504399962,17036.314081934946,17018.392082000824,17000.481489184698,
	16982.58228809991,16964.694463388267,16946.817999718493,16928.952881785975,16911.099094315203,
	16893.256622056608,16875.425449789138,16857.605562318877,16839.79694448042,16821.999581135446,
	16804.213457174155,16786.438557514313,16768.67486710164,16750.92237091015,16733.181053942782,
	16715.450901229528,16697.731897829613,16680.024028830452,16662.327279347865,16644.64163452642,
	16626.967079539612,16609.30359958984,16591.651179907516,16574.009805752827,16556.379462414734,
	16538.760135211913,16521.1518094909,16503.554470629664,16485.968104033676,16468.39269513902,
	16450.82822941121,16433.274692345,16415.73206946643,16398.20034632955,16380.679508519961,
	16363.169541652738,16345.670431373574,16328.182163358231,16310.704723313138,16293.238096975361,
	16275.78227011276,16258.337228523851,16240.902958037994,16223.4794445158,16206.0666738496,
	16188.664631962092,16171.273304808183,16153.892678373812,16136.52273867691,16119.163471767042,
	16101.814863726113,16084.476900668016,16067.149568738314,16049.832854115255,16032.526743010398,
	16015.231221666641,15997.946276360697,15980.671893400793,15963.408059130614,15946.154759924306,
	15928.911982191321,15911.679712374276,15894.457936948469,15877.246642424461,15860.04581534538,
	15842.855442289605,15825.67550986916,15808.506004730942,15791.34691355607,15774.198223060728,
	15757.059919995498,15739.931991147427,15722.814423337004,15705.707203421738,15688.610318294064,
	15671.523754882042,15654.447500150423,15637.381541099112,15620.325864765571,15603.280458222995,
	15586.245308581476,15569.220402987965,15552.205728626846,15535.201272719389,15518.207022524746,
	15501.222965339448,15484.249088497912,15467.28537937324,15450.331825375613,15433.388413955152,
	15416.455132599756,15399.531968836225,15382.618910231196,15365.715944389805,15348.823058957401,
	15331.940241618862,15315.067480099027,15298.204762162919,15281.352075616036,15264.50940830469,
	15247.67674811603,15230.854082977927,15214.041400860491,15197.238689774824,15180.445937773515,
	15163.663132951839,15146.890263447256,15130.12731743975,15113.37428315186,15096.631148849454,
	15079.897902841476,15063.17453348063,15046.461029163325,15029.757378329741,15013.063569464517,
	14996.379591097084,14979.705431801302,14963.041080196319,14946.386524946709,14929.74175476227,
	14913.106758398757,14896.481524658424,14879.866042389327,14863.260300486541,14846.664287892152,
	14830.077993594807,14813.501406631478,14796.93451608607,14780.377311091212,14763.829780827076,
	14747.291914522842,14730.763701456583,14714.245130955109,14697.7361923947,14681.236875201752,
	14664.747168851856,14648.267062871122,14631.796546836407,14615.335610374532,14598.884243164472,
	14582.442434935638,14566.010175469326,14549.587454598528,14533.174262208484,14516.77058823675,
	14500.376422673613,14483.991755562112,14467.616576998795,14451.25087713333,14434.894646169045,
	14418.547874363736,14402.210552029033,14385.882669530823,14369.564217290303,14353.255185783137,
	14336.955565540551,14320.665347149092,14304.384521250773,14288.113078543767,14271.851009782406,
	14255.598305777063,14239.354957394982,14223.120955560164,14206.896291253315,14190.680955512402,
	14174.474939432874,14158.278234167452,14142.090830926452,14125.91272097847,14109.74389564948,
	14093.584346324145,14077.434064444666,14061.293041511943,14045.16126908555,14029.038738783345,
	14012.925442281197,13996.82137131476,13980.726517677514,13964.640873222035,13948.564429859367,
	13932.497179559601,13916.439114351137,13900.39022632134,13884.350507616207,13868.31995043973,
	13852.298547054737,13836.286289782294,13820.28317100148,13804.28918314904,13788.30431871998,
	13772.328570266407,13756.36193039754,13740.404391779939,13724.455947136226,13708.5165892456,
	13692.586310943148,13676.66510511913,13660.752964718737,13644.849882741935,13628.955852242105,
	13613.070866326136,13597.19491815377,13581.328000936335,13565.470107936815,13549.621232468522,
	13533.781367894058,13517.950507625217,13502.128645121755,13486.315773889779,13470.511887481489,
	13454.716979493656,13438.931043566632,13423.15407338283,13407.386062665795,13391.627005178478,
	13375.876894721801,13360.135725133574,13344.403490285873,13328.680184084831,13312.965800467502,
	13297.260333400318,13281.563776877634,13265.876124919383,13250.197371568493,13234.527510889642,
	13218.86653696556,13203.214443895777,13187.571225793512,13171.936876782893,13156.311390996478,
	13140.694762572102,13125.086985650092,13109.488054369718,13093.897962866311,13078.316705267804,
	13062.744275691037,13047.180668238118,13031.625876992475,13016.07989601541,13000.54271934168,
	12985.014340974863,12969.494754883879,12953.983954997739,12938.481935200984,12922.988689329492,
	12907.50421116461,12892.028494428612,12876.56153277908,12861.10331980419,12845.653849016051,
	12830.213113846088,12814.781107638508,12799.357823644608,12783.943255016251,12768.537394800556,
	12753.140235932524,12737.751771229048,12722.371993382128,12707.000894952389,12691.638468362149,
	12676.284705888742,12660.939599657338,12645.603141634332,12630.275323619842,12614.956137241656,
	12599.645573947422,12584.343624997995,12569.050281460657,12553.765534202817,12538.489373884791,
	12523.221790953661,12507.962775637116,12492.71231793791,12477.470407627703,12462.237034242245,
	12447.012187076756,12431.795855181366,12416.588027357837,12401.38869215593,12386.197837872469,
	12371.015452548403,12355.84152396965,12340.676039667076,12325.51898691825,12310.370352751203,
	12295.230123948177,12280.098287052704,12264.974828376715,12249.859734010908,12234.752989836668,
	12219.654581540379,12204.564494630431,12189.482714456773,12174.409226233542,12159.344015065612,
	12144.28706597742,12129.238363947377,12114.197893944665,12099.165640972196,12084.141590113606,
	12069.125726586006,12054.11803579793,12039.118503414116,12024.127115426578,12009.143858232917,
	11994.16871872211,11979.201684369127,11964.242743337292,11949.291884591361,11934.349098019442,
	11919.414374566146,11904.487706377451,11889.569086957032,11874.658511336123,11859.755976256563,
	11844.861480368494,11829.975024443691,11815.096611604471,11800.226247570168,11785.36394092193,
	11770.509703384461,11755.66355013142,11740.825500107483,11725.995576375062,11711.17380648229,
	11696.360222855343,11681.554863215417,11666.757771020912,11651.968995936255,11637.188594328214,
	11622.416629790057,11607.653173695027,11592.898305778901,11578.152114753399,11563.414698949504,
	11548.686166992838,11533.966638509612,11519.256244864904,11504.555129931765,11489.863450892219,
	11475.181379068983,11460.509100787616,11445.846818268199,11431.194750545665,11416.553134416754,
	11401.92222541312,11387.302298797656,11372.693650581985,11358.096598562934,11343.511483374748,
	11328.938669553307,11314.37854660977,11299.83153010793,11285.298062742932,11270.778615414152,
	11256.27368828898,11241.78381185027,11227.309547923156,11212.851490672341,11198.410267566936,
	11183.986540301075,11169.581005667449,11155.194396373181,11140.827481792125,11126.481068643603,
	11112.156001592743,11097.853163761052,11083.573477140837,11069.317902906381,11055.087441611817,
	11040.883133270463,11026.706057306987,11012.5573323761,10998.438116042245,10984.349604312643,
	10970.29303102132,10956.269667057408,10942.280819436013,10928.327830207927,10914.412075207316,
	10900.53496263639,10886.697931487777,10872.902449806405,10859.150012792703,10845.442140752602,
	10831.780376897643,10818.166285002973,10804.601446929726,10791.08746002048,10777.625934377971,
	10764.218490036434,10750.866754038596,10737.572357429268,10724.336932180353,10711.162108059218,
	10698.049509456681,10685.000752188102,10672.01744028335,10659.10116278103,10646.253490541789,
	10633.475973096607,10620.770135545044,10608.137475517402,10595.579460216612,10583.097523551465,
	10570.693063376377,10558.367438847983,10546.121967910743,10533.957924921922,10521.876538425247,
	10509.878989080362,10497.96640775679,10486.139873796987,10474.400413453679,10462.748998504989,
	10451.186545049233,10439.713912481271,10428.331902649763,10417.041259194066,10405.842667060508,
	10394.736752191366,10383.724081386446,10372.805162329876,10361.980443777302,10351.250315897048,
	10340.615110758805,10330.075102960947,10319.630510391155,10309.281495108738,10299.028164343612,
	10288.870571600446,10278.808717860142,10268.842552871096,10258.97197651818,10249.196840264134,
	10239.516948651595,10229.932060859976,10220.44189230674,10211.046116286254,10201.74436563763,
	10192.536234435733,10183.42127969606,10174.399023088921,10165.468952655063,10156.63052451855,
	10147.883164589231,10139.226270252057,10130.659212036504,10122.181335264266,10113.791961668476,
	10105.490390983261,10097.2759025004,10089.147756588594,10081.105196174762,10073.147448185207,
	10065.273724943714,10057.48322552657,10049.775137072604,10042.148636047077,10034.602889460119,
	10027.137056038555,10019.750287349249,10012.441728878037,10005.21052106012,9998.055800265152,
	9990.97669973661,9983.972350484582,9977.041882136738,9970.184423743201,9963.399104539918,
	9956.685054670621,9950.041405867378,9943.467292092342,9936.961850140773,9930.52422020731,
	9924.153546415524,9917.848977315307,9911.60966634004,9905.434772242837,9899.32345949162,
	9893.274898638947,9887.288266663305,9881.362747282059,9875.497531239962,9869.691816570772,
	9863.94480883736,9858.25572134786,9852.623775350234,9847.048200208335,9841.528233555777,
	9836.063121434148,9830.652118412416,9825.294487690682,9819.989501188013,9814.736439615013,
	9809.534592535565,9804.383258409684,9799.281744637237,9794.229367569038,9789.22545252716,
	9784.269333806216,9779.360354666354,9774.497867318556,9769.681232900477,9764.90982144637,
	9760.18301184842,9755.500191813548,9750.860757812057,9746.264115022868,9741.709677271678,
	9737.196866966664,9732.725115027892,9728.293860813928,9723.902552045247,9719.550644723317,
	9715.237603048037,9710.962899331103,9706.726013909121,9702.526435052465,9698.363658874216,
	9694.23718923623,9690.14653765464,9686.091223202839,9682.070772417244,9678.084719195775,
	9674.132604703493,9670.213977270872,9666.328392296744,9662.475412147041,9658.65460605776,
	9654.865550034356,9651.107826752857,9647.381025460983,9643.684741880525,9640.018578108444,
	9636.382142519586,9632.775049670172,9629.196920201555,9625.647380743847,9622.126063822783,
	9618.63260776489,9615.166656603713,9611.727859990066,9608.315873098332,9604.930356537358,
	9601.570976261875,9598.23740348336,9594.929314583931,9591.646391028946,9588.388319284366,
	9585.154790730421,9581.94550158091,9578.760152800698,9575.59845002579,9572.460103483421,
	9569.34482791509,9566.25234249872,9563.182370772625,9560.13464056184,9557.108883904804,
	9554.104836979212,9551.122240032691,9548.160837311625,9545.22037699321,9542.300611116667,
	9539.401295516907,9536.522189759144,9533.663057074325,9530.823664295276,9528.003781794896,
	9525.203183425067,9522.421646455487,9519.658951515177,9516.91488253406,9514.18922668693,
	9511.481774334987,9508.792318973236,9506.120657173904,9503.466588536123,9500.829915630415,
	9498.210443949929,9495.607981858428,9493.022340542253,9490.453333959978,9487.90077879652,
	9485.364494415491,9482.844302811007,9480.340028566763,9477.851498809197,9475.378543164332,
	9472.920993714233,9470.478684956928,9468.051453763837,9465.639139338855,9463.241583180912,
	9460.858629042701,9458.490122893825,9456.135912882519,9453.795849299931,9451.46978454233,
	9449.15757307722,9446.85907140808,9444.574138038888,9442.302633443187,9440.04442002859,
	9437.799362103482,9435.567325854658,9433.348179301938,9431.141792276432,9428.948036389802,
	9426.76678500309,9424.597913197862,9422.441297750662,9420.296817101495,9418.164351328156,
	9416.043782120047,9413.934992751327,9411.837868054134,9409.752294394853,9407.678159648129,
	9405.615353173365,9403.56376578918,9401.523289751838,9399.493818730449,9397.475247785354,
	9395.467473345194,9393.470393186317,9391.48390640898,9389.507913418602,9387.54231590396,
	9385.587016816386,9383.641920352327,9381.706931928858,9379.781958170244,9377.86690688551,
	9375.961687050018,9374.06620878822,9372.180383356324,9370.30412312279,9368.437341552562,
	9366.579953190065,9364.731873641918,9362.893019560961,9361.063308630057,9359.242659547053,
	9357.430992008665,9355.628226693501,9353.834285251474,9352.049090285158,9350.27256533638,
	9348.504634873805,9346.745224276046,9344.994259821196,9343.25166867004,9341.51737885686,
	9339.791319271968,9338.073419652315,9336.363610567229,9334.66182340792,9332.967990372592,
	9331.282044457397,9329.603919442588,9327.933549883151,9326.270871094526,9324.615819144945,
	9322.968330842032,9321.328343723499,9319.695796045145,9318.070626771892,9316.45277556722,
	9314.8421827833,9313.238789450428,9311.642537268042,9310.053368594452,9308.471226438389,
	9306.896054450071,9305.327796910718,9303.766398724345,9302.211805409785,9300.663963090763,
	9299.122818489092,9297.588318914048,9296.060412255914,9294.539046978238,9293.024172109173,
	9291.515737232634,9290.013692482604,9288.517988533586,9287.02857659649,9285.545408407128,
	9284.06843622174,9282.59761280978,9281.132891445055,9279.674225902736,9278.221570447546,
	9276.774879831444,9275.334109284093,9273.899214510388,9272.470151678339,9271.046877417912,
	9269.629348813402,9268.217523396212,9266.81135914052,9265.410814456,9264.015848183592,
	9262.626419589387,9261.24248835783,9259.864014588024,9258.490958787144,9257.123281866867,
	9255.760945134338,9254.403910291147,9253.052139427937,9251.705595015519,9250.364239904595,
	9249.028037317355,9247.696950846044,9246.370944445194,9245.049982429076,9243.734029466219,
	9242.423050575155,9241.1170111201,9239.815876805924,9238.519613676503,9237.228188105428,
	9235.941566797395,9234.65971678009,9233.382605403734,9232.110200332485,9230.842469545363,
	9229.579381328851,9228.320904274819,9227.067007277003,9225.817659525148,9224.572830505596,
	9223.332489992748,9222.096608048341,9220.865155018026,9219.63810152709,9218.41541847872,
	9217.197077046445,9215.98304867701,9214.77330508205,9213.567818236696,9212.366560378148,
	9211.169503999687,9209.976621848658,9208.787886925253,9207.603272476439,9206.422751995542,
	9205.246299218017,9204.073888119507,9202.905492912045,9201.741088043314,9200.5806481889,
	9199.424148256847,9198.271563379702,9197.122868914379,9195.978040438235,9194.83705374622,
	9193.699884851429,9192.566509977529,9191.436905561848,9190.311048249452,9189.188914889884,
	9188.070482539057,9186.955728454774,9185.844630091022,9184.737165102686,9183.633311336755,
	9182.533046834502,9181.436349826889,9180.343198733808,9179.253572159852,9178.167448899312,
	9177.084807923646,9176.005628385214,9174.92988961523,9173.857571121809,9172.788652586869,
	9171.723113864908,9170.66093498121,9169.602096129382,9168.546577670037,9167.494360130295,
	9166.445424199013,9165.399750725757,9164.357320722973,9163.318115358261,9162.282115958105,
	9161.249304001429,9160.219661121753,9159.193169103879,9158.169809882314,9157.14956553975,
	9156.132418305571,9155.118350554882,9154.10734480608,9153.099383719167,9152.094450095681,
	9151.092526876435,9150.093597139206,9149.097644098232,9148.104651103804,9147.114601637584,
	9146.12747931598,9145.143267883339,9144.16195121616,9143.183513317053,9142.20793831608,
	9141.23521046958,9140.26531415629,9139.298233879723,9138.333954264937,9137.372460055996,
	9136.413736117298,9135.457767431526,9134.504539097084,9133.554036329524,9132.606244458642,
	9131.661148925894,9130.71873528739,9129.778989208487,9128.841896467186,9127.90744294623,
	9126.975614641313,9126.046397650356,9125.119778179449,9124.195742540105,9123.274277145729,
	9122.355368512472,9121.439003259964,9120.525168106866,9119.613849871832,9118.705035473547,
	9117.79871192557,9116.894866342074,9115.993485930616,9115.094557994738,9114.19806993051,
	9113.304009229934,9112.412363475612,9111.523120340735,9110.636267591148,9109.751793080619,
	9108.869684752728,9107.989930639122,9107.112518857342,9106.237437612914,9105.364675196412,
	9104.494219982005,9103.626060429631,9102.760185080771,9101.896582560585,9101.035241574258,
	9100.176150909436,9099.319299434022,9098.464676093738,9097.612269913869,9096.762069997238,
	9095.914065524128,9095.068245751992,9094.22460001296,9093.383117714257,9092.543788338364,
	9091.706601441618,9090.871546651895,9090.03861367101,9089.207792271909,9088.379072299069,
	9087.552443666578,9086.727896359418,9085.90542043086,9085.08500600325,9084.266643266157,
	9083.450322478804,9082.636033964354,9081.823768113109,9081.013515382,9080.205266291396,
	9079.399011427753,9078.594741440193,9077.792447041713,9076.99211900674,9076.193748173284,
	9075.397325441925,9074.602841772356,9073.81028818526,9073.019655762619,9072.230935644184,
	9071.444119031128,9070.6591971797,9069.876161407456,9069.095003087958,9068.315713651677,
	9067.538284586302,9066.762707435519,9065.98897379697,9065.217075325658,9064.447003729803,
	9063.678750772684,9062.912308270355,9062.147668093055,9061.384822163003,9060.623762454969,
	9059.864480995702,9059.106969864275,9058.351221188255,9057.597227150074,9056.8449799777,
	9056.094471952665,9055.345695403168,9054.598642707748,9053.853306293997,9053.109678635416,
	9052.367752256128,9051.627519725087,9050.888973659678,9050.152106723748,9049.416911627373,
	9048.683381125307,9047.951508018485,9047.221285154776,9046.492705423445,9045.765761759507,
	9045.040447143374,9044.316754597252,9043.594677186818,9042.87420802208,9042.155340254189,
	9041.438067076704,9040.72238172529,9040.00827747844,9039.295747652906,9038.584785609884,
	9037.875384748586,9037.167538509617,9036.461240373115,9035.75648385854,9035.053262526146,
	9034.351569973225,9033.65139983694,9032.952745792889,9032.255601554221,9031.559960871524,
	9030.865817534233,9030.173165368327,9029.481998235775,9028.79231003736,9028.104094706994,
	9027.417346218239,9026.732058577283,9026.048225828223,9025.365842048657,9024.684901352231,
	9024.005397886394,9023.327325835433,9022.650679413231,9021.975452872131,9021.301640495678,
	9020.629236601351,9019.95823553988,9019.288631693411,9018.620419480732,9017.953593348953,
	9017.288147778354,9016.624077282246,9015.961376403684,9015.300039719426,9014.640061835702,
	9013.981437391181,9013.324161053462,9012.668227522077,9012.013631525504,9011.360367823674,
	9010.708431205552,9010.057816489372,9009.40851852452,9008.760532186441,9008.11385238309,
	9007.468474047768,9006.824392145038,9006.181601665918,9005.54009763072,9004.899875086765,
	9004.260929109523,9003.62325480227,9002.98684729593,9002.35170174565,9001.717813337342,
	9001.085177281233,9000.453788815084,8999.823643202462,8999.194735733257,8998.567061723432,
	8997.940616514026,8997.315395473292,8996.69139399226,8996.068607489522,8995.447031407533,
	8994.826661214385,8994.207492402122,8993.58952048696,8992.972741010408,8992.357149538177,
	8991.74274165857,8991.129512984677,8990.51745915414,8989.906575826588,8989.296858684558,
	8988.688303436233,8988.080905809971,8987.474661558881,8986.869566458954,8986.265616304556,
	8985.662806919263,8985.06113414345,8984.460593840795,8983.861181898947,8983.262894224978,
	8982.665726748208,8982.069675420555,8981.47473621262,8980.88090511768,8980.288178150411,
	8979.696551346326,8979.106020761634,8978.516582472012,8977.928232575245,8977.34096718732,
	8976.754782446355,8976.169674509712,8975.585639554249,8975.002673778576,8974.420773396732,
	8973.839934646703,8973.260153782616,8972.681427081163,8972.103750833883,8971.527121355713,
	8970.951534976768,8970.376988045151,8969.803476934705,8969.230998030936,8968.659547739035,
	8968.089122483194,8967.519718705536,8966.95133286663,8966.383961443258,8965.817600931228,
	8965.252247845008,8964.68789871367,8964.124550087807,8963.562198529955,8963.00084062506,
	8962.440472972663,8961.88109218865,8961.322694906326,8960.765277776714,8960.208837466555,
	8959.653370659149,8959.0988740544,8958.545344368496,8957.992778333019,8957.441172697552,
	8956.890524225053,8956.340829696615,8955.79208590864,8955.24428967185,8954.697437814566,
	8954.151527179452,8953.606554623266,8953.062517020655,8952.519411260893,8951.977234246466,
	8951.435982897177,8950.895654144973,8950.356244940129,8949.81775224564,8949.280173037563,
	8948.743504309794,8948.207743068968,8947.672886335578,8947.138931145513,8946.605874547937,
	8946.073713606378,8945.542445398687,8945.012067016292,8944.482575563903,8943.953968161217,
	8943.426241940952,8942.899394049868,8942.373421646163,8941.848321904245,8941.324092010116,
	8940.800729162827,8940.278230576221,8939.756593475893,8939.235815100747,8938.715892702165,
	8938.196823545148,8937.678604905957,8937.161234076615,8936.644708358654,8936.129025066995,
	8935.614181528934,8935.100175085985,8934.587003089173,8934.074662903513,8933.563151904413,
	8933.052467482308,8932.542607036668,8932.033567980867,8931.525347738796,8931.017943746741,
	8930.511353453747,8930.005574317433,8929.500603810864,8928.99643941635,8928.493078627382,
	8927.990518949575,8927.488757900002,8926.987793006863,8926.487621808592,8925.988241856925,
	8925.48965071104,8924.991845946468,8924.494825143205,8923.998585897221,8923.503125812715,
	8923.008442505516,8922.514533600934,8922.021396737578,8921.529029561287,8921.03742972964,
	8920.546594911923,8920.056522786292,8919.56721104302,8919.078657378137,8918.590859502878,
	8918.103815137049,8917.61752200836,8917.131977857847,8916.647180432254,8916.163127494208,
	8915.679816811213,8915.197246161271,8914.715413333675,8914.234316126325,8913.753952347728,
	8913.274319814476,8912.795416353547,8912.317239799926,8911.839788000774,8911.363058811503,
	8910.887050093901,8910.41175972375,8909.9371855829,8909.463325562328,8908.990177563961,
	8908.517739496392,8908.04600927781,8907.574984838653,8907.104664113756,8906.635045047706,
	8906.166125595984,8905.697903721146,8905.230377393076,8904.763544594787,8904.297403313121,
	8903.831951543827,8903.367187296588,8902.90310858164,8902.43971342457,8901.976999853128,
	8901.514965909024,8901.053609638393,8900.592929097646,8900.132922348723,8899.673587465979,
	8899.21492252649,8898.756925621225,8898.29959484335,8897.8429282981,8897.386924097811,
	8896.931580359658,8896.47689521351,8896.022866793623,8895.569493242405,8895.11677271131,
	8894.664703357254,8894.213283347148,8893.76251085461,8893.312384057745,8892.862901147528,
	8892.414060319343,8891.96585977636,8891.518297728759,8891.071372392957,8890.625081996166,
	8890.179424768692,8889.734398952054,8889.290002792159,8888.846234541974,8888.403092464363,
	8887.960574824569,8887.518679898883,8887.07740596886,8886.636751324395,8886.196714259733,
	8885.757293078528,8885.31848608872,8884.880291608457,8884.442707958891,8884.005733470183,
	8883.569366479827,8883.133605329653,8882.698448368737,8882.263893953294,8881.82994044886,
	8881.396586221357,8880.963829647162,8880.531669109996,8880.100102995933,8879.669129702339,
	8879.238747629315,8878.80895518274,8878.379750779352,8877.951132837306,8877.523099784288,
	8877.095650051764,8876.668782078845,8876.242494308171,8875.816785195022,8875.391653192004,
	8874.967096764034,8874.543114379308,8874.119704514125,8873.696865647365,8873.274596265297,
	8872.852894862272,8872.431759936597,8872.011189990706,8871.591183536426,8871.171739087942,
	8870.752855167444,8870.334530302933,8869.916763024996,8869.499551873916,8869.082895393693,
	8868.666792133215,8868.251240647067,8867.836239497858,8867.421787248599,8867.007882474814,
	8866.59452375139,8866.181709660765,8865.769438791662,8865.357709736732,8864.94652109446,
	8864.535871469236,8864.125759470366,8863.716183711726,8863.307142812408,8862.89863539911,
	8862.490660100555,8862.083215551318,8861.67630039359,8861.26991327113,8860.864052835046,
	8860.458717741645,8860.05390664815,8859.649618224774,8859.24585113928,8858.842604067526,
	8858.439875690732,8858.037664694022,8857.63596976526,8857.234789602866,8856.834122905819,
	8856.433968377145,8856.034324727858,8855.635190671715,8855.236564927833,8854.838446220672,
	8854.440833275627,8854.043724828884,8853.647119617504,8853.251016383703,8852.855413873425,
	8852.460310839882,8852.065706036243,8851.67159822606,8851.277986174116,8850.884868649682,
	8850.492244425384,8850.100112281467,8849.708471000316,8849.317319367456,8848.926656179303,
	8848.536480227633,8848.146790315683,8847.75758524531,8847.368863828615,8846.980624878111,
	8846.592867211111,8846.205589648873,8845.818791018755,8845.432470150485,8845.046625878756,
	8844.661257040938,8844.276362482713,8843.891941048129,8843.507991589959,8843.124512963612,
	8842.741504027123,8842.35896364429,8841.97689068166,8841.595284013332,8841.214142510016,
	8840.833465055113,8840.453250529918,8840.073497822663,8839.694205821994,8839.315373425963,
	8838.93699953219,8838.559083043741,8838.181622865975,8837.804617910115,8837.42806709047,
	8837.051969325534,8836.67632353769,8836.301128649908,8835.926383593507,8835.552087301594,
	8835.17823871025,8834.804836760053,8834.431880395834,8834.059368563403,8833.68730021706,
	8833.31567430914,8832.944489800102,8832.57374565083,8832.203440828112,8831.833574301612,
	8831.464145042837,8831.095152029024,8830.726594241209,8830.358470662077,8829.990780277436,
	8829.623522079308,8829.256695059497,8828.890298217571,8828.524330552817,8828.158791070786,
	8827.793678777873,8827.428992684674,8827.064731805696,8826.700895158714,8826.337481764418,
	8825.974490648035,8825.611920835421,8825.249771357561,8824.888041250457,8824.52672954842,
	8824.16583529579,8823.805357532588,8823.4452953078,8823.085647671001,8822.726413676277,
	8822.367592379833,8822.009182839993,8821.651184122558,8821.293595290013,8820.936415413593,
	8820.579643566418,8820.223278821188,8819.86732025832,8819.511766957023,8819.156618004617,
	8818.801872484935,8818.447529491667,8818.093588118667,8817.740047459232,8817.386906614642,
	8817.03416468636,8816.68182078331,8816.329874009007,8815.978323477722,8815.627168303567,
	8815.276407602993,8814.926040494405,8814.576066103818,8814.226483555565,8813.87729197725,
	8813.528490499222,8813.180078259236,8812.832054392977,8812.484418040598,8812.137168342999,
	8811.790304446706,8811.44382550139,8811.097730655709,8810.752019064013,8810.406689885274,
	8810.061742274529,8809.717175396472,8809.372988415293,8809.029180497664,8808.685750813562,
	8808.342698537203,8808.000022841228,8807.65772290652,8807.315797907866,8806.97424703617,
	8806.633069474152,8806.292264408237,8805.951831032844,8805.611768538618,8805.272076122286,
	8804.932752984356,8804.593798322838,8804.255211345831,8803.916991255737,8803.579137262535,
	8803.241648577658,8802.904524415771,8802.567763992654,8802.231366526603,8801.895331238456,
	8801.559657352838,8801.224344096028,8800.889390694701,8800.554796382508,8800.220560389993,
	8799.886681954766,8799.553160316322,8799.219994712723,8798.887184387559,8798.554728586032,
	8798.22262655491,8797.89087754758,8797.559480813157,8797.228435608446,8796.897741186775,
	8796.567396810313,8796.237401741071,8795.907755241906,8795.578456577428,8795.249505018664,
	8794.920899835046,8794.592640299687,8794.264725686116,8793.937155274449,8793.609928342128,
	8793.283044173058,8792.956502049119,8792.630301256113,8792.30444108601,8791.978920825673,
	8791.653739769039,8791.328897213489,8791.004392450652,8790.68022478279,8790.356393512071,
	8790.032897941062,8789.709737375799,8789.386911123162,8789.064418492906,8788.742258796503,
	8788.420431350736,8788.098935468082,8787.777770468165,8787.456935670414,8787.136430397744,
	8786.816253974675,8786.496405726475,8786.176884983182,8785.857691072128,8785.538823328721,
	8785.220281086607,8784.902063680016,8784.584170449074,8784.266600734189,8783.949353875762,
	8783.632429221429,8783.315826114262,8782.999543903077,8782.683581939382,8782.36793957395,
	8782.052616159317,8781.7376110547,8781.422923615062,8781.108553201164,8780.794499174215,
	8780.480760899,8780.167337738982,8779.854229062334,8779.541434236375,8779.228952634418,
	8778.916783628181,8778.604926592065,8778.293380905043,8777.98214593916,8777.67122108235,
	8777.360605709842,8777.050299208917,8776.740300965543,8776.430610364929,8776.121226797053,
	8775.812149653215,8775.50337832602,8775.194912208424,8774.886750698075,8774.578893193468,
	8774.271339093628,8773.964087798466,8773.65713871403,8773.35049124334,8773.044144792399,
	8772.738098770145,8772.432352589267,8772.126905657931,8771.821757391539,8771.516907203468,
	8771.212354511004,8770.90809873392,8770.604139292733,8770.30047560758,8769.997107102392,
	8769.69403320128,8769.391253333752,8769.088766926452,8768.786573408144,8768.484672214123,
	8768.183062773627
	}}
};
