#!/bin/python2.7

import os


timezones = []

for root, directories, filenames in os.walk('/usr/share/zoneinfo/'):
    for filename in filenames:
        if filename.endswith('.tab'):
            continue

        if filename.endswith('.zi'):
            continue

        if filename == 'leapseconds':
            continue

        if filename == 'posixrules':
            continue

        if os.path.basename(root) == "posix":
            continue

        if os.path.basename(root) == "right":
            continue

        timezones.append(os.path.join(os.path.basename(root), filename))


timezones = sorted(list(set(timezones)))

tztable = open("tztable.h", "w")
tztable.write("//This file was generated by the zonetabconversion.py script\n")
tztable.write("static const char* olsonTimezones[] = {\n")

tztable.write('    "')
tztable.write('",\n    "'.join(timezones))
tztable.write('"\n};\n')
tztable.write('\n')
tztable.write('static const long unsigned int numOlsonTimezones = sizeof olsonTimezones / sizeof *olsonTimezones;\n')
tztable.write("\n")
