/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class DateSelector
extends BaseExtendSelector {
    private long millis = -1L;
    private String dateTime = null;
    private boolean includeDirs = false;
    private int granularity = 0;
    private int cmp = 2;
    private String pattern;
    public static final String MILLIS_KEY = "millis";
    public static final String DATETIME_KEY = "datetime";
    public static final String CHECKDIRS_KEY = "checkdirs";
    public static final String GRANULARITY_KEY = "granularity";
    public static final String WHEN_KEY = "when";
    public static final String PATTERN_KEY = "pattern";

    public DateSelector() {
        if (Os.isFamily("dos")) {
            this.granularity = 2000;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{dateselector date: ");
        buf.append(this.dateTime);
        buf.append(" compare: ");
        if (this.cmp == 0) {
            buf.append("before");
        } else if (this.cmp == 1) {
            buf.append("after");
        } else {
            buf.append("equal");
        }
        buf.append(" granularity: ");
        buf.append(this.granularity);
        if (this.pattern != null) {
            buf.append(" pattern: ").append(this.pattern);
        }
        buf.append("}");
        return buf.toString();
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public long getMillis() {
        if (this.dateTime != null) {
            this.validate();
        }
        return this.millis;
    }

    public void setDatetime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void setCheckdirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public void setWhen(TimeComparisons cmp) {
        this.cmp = cmp.getIndex();
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                String paramname = parameters[i].getName();
                if (MILLIS_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setMillis(new Long(parameters[i].getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        this.setError("Invalid millisecond setting " + parameters[i].getValue());
                    }
                } else if (DATETIME_KEY.equalsIgnoreCase(paramname)) {
                    this.setDatetime(parameters[i].getValue());
                } else if (CHECKDIRS_KEY.equalsIgnoreCase(paramname)) {
                    this.setCheckdirs(Project.toBoolean(parameters[i].getValue()));
                } else if (GRANULARITY_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setGranularity(new Integer(parameters[i].getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        this.setError("Invalid granularity setting " + parameters[i].getValue());
                    }
                } else if (WHEN_KEY.equalsIgnoreCase(paramname)) {
                    TimeComparisons cmp = new TimeComparisons();
                    cmp.setValue(parameters[i].getValue());
                    this.setWhen(cmp);
                } else if (PATTERN_KEY.equalsIgnoreCase(paramname)) {
                    this.setPattern(parameters[i].getValue());
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++i;
            }
        }
    }

    public void verifySettings() {
        block3: {
            block4: {
                if (this.dateTime != null || this.millis >= 0L) break block4;
                this.setError("You must provide a datetime or the number of milliseconds.");
                break block3;
            }
            if (this.millis >= 0L || this.dateTime == null) break block3;
            DateFormat df = this.pattern == null ? DateFormat.getDateTimeInstance(3, 3, Locale.US) : new SimpleDateFormat(this.pattern);
            try {
                this.setMillis(df.parse(this.dateTime).getTime());
                if (this.millis < 0L) {
                    this.setError("Date of " + this.dateTime + " results in negative milliseconds value" + " relative to epoch (January 1, 1970, 00:00:00 GMT).");
                }
            }
            catch (ParseException pe) {
                this.setError("Date of " + this.dateTime + " Cannot be parsed correctly. It should be in" + (this.pattern == null ? " MM/DD/YYYY HH:MM AM_PM" : this.pattern) + " format.");
            }
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        if (file.isDirectory() && !this.includeDirs) {
            return true;
        }
        if (this.cmp == 0) {
            return file.lastModified() - (long)this.granularity < this.millis;
        }
        if (this.cmp == 1) {
            return file.lastModified() + (long)this.granularity > this.millis;
        }
        return Math.abs(file.lastModified() - this.millis) <= (long)this.granularity;
    }

    public static class TimeComparisons
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"before", "after", "equal"};
        }
    }
}

