# issue #24048

import macros

proc map(fn: proc(val: int): void) = fn(1)

# This works fine, and is the exact same function call as what's
# generated by the macro `aBug`.
map proc(val: auto): void =
  let variable = 123

macro aBug() =
  # 1. let sym = ident("variable")
  let sym = genSym(nskLet, "variable")
  let letStmt = newLetStmt(sym, newLit(123))

  let lambda = newProc(
    params = @[
      ident("void"),
      newIdentDefs(ident("val"), ident("auto")),
      # 2. newIdentDefs(ident("val"), ident("int")),
    ],
    body = newStmtList(letStmt),
    procType = nnkLambda
  )

  result = newCall(bindSym("map"), lambda)

aBug()
