#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include "SECReader.h"
#include "BaseCommunication.h"

#include "eca_defines.h"

#define base CEC30Reader

#define LOG m_Owner->DebugLeveled

CSECReader::CSECReader(CReader *Owner,CBaseCommunication *Communicator)
			  :base(Owner,Communicator)
{
}

CSECReader::~CSECReader(void)
{
}

CJ_RESULT CSECReader::BuildReaderInfo()
{
	CJ_RESULT Res;

	Res = base::BuildReaderInfo();

	m_ReaderInfo.HardwareMask |= RSCT_READER_HARDWARE_MASK_CONTRAST;

	return Res;
}


uint16_t CSECReader::HostToReaderShort(uint16_t Value)
{
   return InversByteOrderShort(htons(Value));
}

uint32_t CSECReader::HostToReaderLong(uint32_t Value)
{
   return InversByteOrderLong(htonl(Value));
}

void CSECReader::SetHWString(char *String)
{
   strcpy(String,"SEC_");
}

void CSECReader::GetProductString(uint8_t *Product)
{
	memcpy(Product,"CJSEC",5);
}


CJ_RESULT CSECReader::CtSetContrast(EContrast eContrast,uint32_t *Result)
{
	CJ_RESULT Res;
	switch(eContrast)
	{
	case ContrastVeryLow:
		Res=_CtSetContrast(0,Result);
		break;
	case ContrastLow:
		Res=_CtSetContrast(70,Result);
		break;
	case ContrastMedium:
		Res=_CtSetContrast(120,Result);
		break;
	case ContrastHigh:
		Res=_CtSetContrast(160,Result);
		break;
	case ContrastVeryHigh:
		Res=_CtSetContrast(255,Result);
		break;
	default:
		Res=CJ_ERR_WRONG_PARAMETER;
	}
	return Res;
}

RSCT_IFD_RESULT CSECReader::_IfdTransmit(const uint8_t *cmd, uint16_t cmd_len,uint8_t *response,uint16_t *response_len,uint8_t Slot)
{
	UNREFERENCED_PARAMETER(Slot);

//	int l;
//	char *str;
	//	uint16_t rest=*response_len;
	if(cmd_len==5 && cmd[0]==0xff && cmd[1]==0x9a && cmd[2]==0x01  && cmd[4]==0)
	{
		switch(cmd[3])
		{
		case 4:
			if(*response_len>=6)
			{
				sprintf((char *)response,"%04X\x90",0x0410);
				*response_len=6;
				return STATUS_SUCCESS;
			}
			else
			{
				*response_len=0;
				return STATUS_BUFFER_TOO_SMALL;
			}
			break;
		default:;
		}
	}

	return base::_IfdTransmit(cmd,cmd_len,response,response_len);
}

CJ_RESULT CSECReader::CtSetMFT(const uint8_t *const pData, uint32_t DataLen, uint32_t *Result)
{
	CJ_RESULT Res;
	if ((Res = Escape(MODULE_ID_KERNEL, CCID_ESCAPE_SET_MFT, const_cast<uint8_t*>(pData), DataLen, Result, 0, 0)) != CJ_SUCCESS)
	{
		m_Owner->DebugLeveled(DEBUG_MASK_COMMUNICATION_ERROR, "Can't set MFT status!");
	}
	return Res;
}

CJ_RESULT CSECReader::CtGetMFT(cj_MFT_Info *const pData, uint32_t *const pNumElemnts)
{
	uint32_t Result;
	uint32_t FeatureMap = 0xFFFFFFFF;
	uint32_t Mask = 1;
	uint32_t Count = 0;
	uint32_t RetLen = sizeof(FeatureMap);
	CJ_RESULT Res;

	if (*pNumElemnts < 1)
	{
		*pNumElemnts = 0;
		return CJ_ERR_RBUFFER_TO_SMALL;
	}
	LOG(LOG_LEVEL_DEBUG, "Hello World");

	//KSE 3.12.2021 - Secoder Modul hinzufgen

	if (FindModule(MODULE_ID_KT_LIGHT))
	{
		pData[Count].FID = 1003;
		pData[Count].Status = 1;
		strcpy((char*)pData[Count].Name, "Secoder 2.0");
		Count++;
	}

	if ((Res = Escape(MODULE_ID_KERNEL, CCID_ESCAPE_GET_MFT, NULL, 0, &Result, (BYTE*)&FeatureMap, &RetLen)) != CJ_SUCCESS)
	{
		m_Owner->DebugLeveled(DEBUG_MASK_COMMUNICATION_ERROR, "Can't get MFT status!");
		return Res;
	}
	FeatureMap = ReaderToHostLong(FeatureMap);
	FeatureMap = ~FeatureMap;
	for (uint32_t idx = 0; idx < 32; idx++, Mask <<= 1)
	{
		if ((FeatureMap & Mask))
		{
			if (Count < *pNumElemnts)
			{
				switch (idx)
				{
				case 0:
					pData[Count].FID = 0x00000001;
					pData[Count].Status = 1;
					strcpy((char*)pData[Count].Name, "chipTAN 1.1");
					break;

				default:
					pData[Count].FID = 0xF0000000 | idx;
					pData[Count].Status = 1;
					strcpy((char*)pData[Count].Name, "UNKONW FEATURE");
					break;
				}
				++Count;
			}
			else
			{
				*pNumElemnts = 0;
				return CJ_ERR_RBUFFER_TO_SMALL;
			}
		}
		else
		{
			switch (idx)
			{
			case 0:
				pData[Count].FID = 0x00000001;
				pData[Count].Status = 0;
				strcpy((char*)pData[Count].Name, "chipTAN 1.1");
				++Count;
				break;

			default:
				break;
			}
		}
	}


	*pNumElemnts = Count;
	return CJ_SUCCESS;
}

#ifdef WITH_SECODER_INFO_OVERRIDE
bool CSECReader::hasReaderChipTanLicense(void)
{
	CJ_RESULT res;
	cj_MFT_Info Features[32];
	uint32_t FeatureCount = 32;

	if ((res = CtGetMFT(Features, &FeatureCount)) == CJ_SUCCESS)
	{
		for (uint32_t i = 0; i < FeatureCount; ++i)
		{
			if (Features[i].FID == 1 && Features[i].Status == 1)
			{
				return true;
			}
		}
	}
	return false;
}

CJ_RESULT CSECReader::KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr)
{
	static const uint8_t SECODER3_INFO_0[] = {
		"\x40\x07""Secoder"
		"\x80\x05""1.2.0"
		"\x80\x05""1.1.2"
		"\x81\x21""Reiner Kartenger\x7b""te GmbH & Co.KG."
	};
	static const uint8_t SECODER3_INFO_1[] = {
		"\x84\x02""de"
		"\x90\x01\x01"
		"\xa0\x13\x40\x03""tan\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""aut\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""sig\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x13\x40\x03""gkp\x80\x05""1.1.2\x83\x05""1.0.0"
		"\xa0\x16\x40\x03""ctn\x80\x05""1.2.1\x83\x05""1.0.0\x84\x01\x33"
		"\x90\x00"
	};

	CJ_RESULT res;
	uint16_t InLenr = *lenr;
	uint8_t ReaderId[20 + 2];
	uint8_t SWImpVers[10 + 2];
	uint8_t ReaderPorp[9 + 2];
	int lenReaderId = 0;
	int lenSWImpVers = 0;
	int lenReaderProp = 0;
	uint8_t *Tag92 = NULL;
	uint8_t *Tag83 = NULL;
	uint8_t *Tag91 = NULL;
	uint8_t inCmd1 = *(cmd + 1);

	memset(ReaderId, 0, sizeof(ReaderId));
	memset(SWImpVers, 0, sizeof(SWImpVers));

	if ((res = base::KTLightCall(sad, dad, cmd, lenc, Lc, data_ptr, Le, response, lenr)) == CJ_SUCCESS)
	{
		if (inCmd1 == 0x70 && hasReaderChipTanLicense())
		{
			if (GetEnviroment("SecoderInfoOverride", 0x00000001) > 0)
			{
				if (GetEnviroment("SecoderInfoOverride_SEC", 0x00000001) > 0)
				{
					if (((Tag91 = GetTag(response, *lenr - 2, 0x91, &lenReaderProp)) != NULL) &&
						((Tag92 = GetTag(response, *lenr - 2, 0x92, &lenReaderId)) != NULL) &&
						((Tag83 = GetTag(response, *lenr - 2, 0x83, &lenSWImpVers)) != NULL) &&
						(lenReaderId <= 20) && (lenSWImpVers <= 10) && (lenReaderProp == 9))
					{
						lenReaderProp += 2;
						memcpy(ReaderPorp, Tag91 - 2, lenReaderProp);

						lenReaderId += 2;
						memcpy(ReaderId, Tag92 - 2, lenReaderId);

						lenSWImpVers += 2;
						memcpy(SWImpVers, Tag83 - 2, lenSWImpVers);

						if (InLenr >= (sizeof(SECODER3_INFO_0) + lenReaderProp + lenReaderId + lenSWImpVers + sizeof(SECODER3_INFO_1)))
						{
							memcpy(response, SECODER3_INFO_0, sizeof(SECODER3_INFO_0) - 1);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1, ReaderPorp, lenReaderProp);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp, ReaderId, lenReaderId);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId, SWImpVers, lenSWImpVers);
							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId + lenSWImpVers, SECODER3_INFO_1, sizeof(SECODER3_INFO_1) - 1);
							*lenr = sizeof(SECODER3_INFO_0) - 1 + (USHORT)lenReaderProp + (USHORT)lenReaderId + (USHORT)lenSWImpVers + sizeof(SECODER3_INFO_1) - 1;
						}
						else
						{
							return CJ_ERR_RBUFFER_TO_SMALL;
						}
					}
				}
			}
		}
	}
	return res;
}
#endif