/* $Cambridge: hermes/src/prayer/session/folderlist.h,v 1.4 2009/08/28 15:13:11 dpc22 Exp $ */

/* folderlist is a combination data structure:
 *   Simple linear list of the \Select item
 *   Tree structure including stubs for \Noselect items, which can be
 *   expanded selectively
 */

struct folderitem {
    struct  folderitem *next; 
    struct  folderitem *child;
    char *name;
    BOOL noselect;
    BOOL noinferiors;
    BOOL haschildren;   /* True unless NoInferiors or HasNoChildren */
    BOOL expanded;
    unsigned long size;  /* Size in bytes, for sizes screen */
};

struct folderlist {
    struct pool *pool;
    struct folderitem *tree;
    BOOL need_update;
    char hiersep;
};

#define FOLDERLIST_PREFERRED_POOL_SIZE (1024)

struct folderlist *
folderlist_create(char *hiersep);
void folderlist_free(struct folderlist *fl);
struct folderlist *folderlist_fetch(struct session *session);

BOOL folderlist_update_sizes(struct folderlist *fl, struct session *session);

void
folderlist_expand(struct session *session, struct folderitem *fi);

void folderlist_invalidate(struct folderlist *fl);
void folderlist_add(struct folderlist *fl, char *name,
                    BOOL noselect, BOOL noinferiors);
void folderlist_delete(struct folderlist *fl, char *name);
void folderlist_rename(struct folderlist *fl, char *oldname, char *newname);

struct folderitem *folderlist_lookup(struct folderlist *fl, char *name);

int
folderlist_count_visible_folders(struct folderlist *fl, BOOL suppress_dotfiles);

void
folderlist_showdirs_select(struct folderlist *fl, BOOL suppress_dotfiles,
                           struct pool *pool, struct buffer *b, char *selected);

void
folderlist_showfolders_select(struct folderlist *fl, BOOL suppress_dotfiles,
                              struct pool *pool, struct buffer *b,
                              char *selected);
void
folderlist_template_vals_tree(struct folderlist *fl, BOOL suppress_dotfiles,
                              struct template_vals *tvals, char *array);
void
folderlist_template_vals_list(struct folderlist *fl, BOOL suppress_dotfiles,
                              struct template_vals *tvals,
                              BOOL showdirs, char *array);
