% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_xgboost.R
\name{scale_pos_weight}
\alias{scale_pos_weight}
\alias{penalty_L2}
\alias{penalty_L1}
\title{Parameters for possible engine parameters for xgboost}
\usage{
scale_pos_weight(range = c(0.8, 1.2), trans = NULL)

penalty_L2(range = c(-10, 1), trans = transform_log10())

penalty_L1(range = c(-10, 1), trans = transform_log10())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
These parameters are auxiliary to tree-based models that use the "xgboost"
engine. They correspond to tuning parameters that would be specified using
\code{set_engine("xgboost", ...)}.
}
\details{
For more information, see the \href{https://xgboost.readthedocs.io/en/latest/parameter.html}{xgboost webpage}.
}
\examples{

scale_pos_weight()
penalty_L2()
penalty_L1()

}
