% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-app.r
\name{oauth_app}
\alias{oauth_app}
\title{Create an OAuth application.}
\usage{
oauth_app(appname, key, secret = NULL, redirect_uri = oauth_callback())
}
\arguments{
\item{appname}{name of the application.  This is not used for OAuth, but is
used to make it easier to identify different applications.}

\item{key}{consumer key, also sometimes called the client ID}

\item{secret}{consumer secret, also sometimes called the client secret.
Despite its name, this does not necessarily need to be protected like a
password, i.e. the user still has to authenticate themselves and grant the
app permission to access resources on their behalf. For example, see
Google's docs for \href{https://developers.google.com/identity/protocols/oauth2}{OAuth2 for installed applications}.}

\item{redirect_uri}{The URL that user will be redirected to after
authorisation is complete. You should generally leave this as the default
unless you're using a non-standard auth flow (like with shiny).}
}
\description{
See the demos for instructions on how to create an OAuth app for linkedin,
twitter, vimeo, facebook, github and google. When wrapping an API from a
package, the author may want to include a default app to facilitate early and
casual use and then provide a method for heavy or advanced users to supply
their own app or key and secret.
}
\examples{
\dontrun{
google_app <- oauth_app(
  "google",
  key = "123456789.apps.googleusercontent.com",
  secret = "abcdefghijklmnopqrstuvwxyz"
)
}
}
\seealso{
Other OAuth: 
\code{\link{oauth1.0_token}()},
\code{\link{oauth2.0_token}()},
\code{\link{oauth_endpoint}()},
\code{\link{oauth_service_token}()}
}
\concept{OAuth}
