% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R, R/proxy.R
\name{c.stars}
\alias{c.stars}
\alias{c.stars_proxy}
\title{combine multiple stars objects, or combine multiple attributes in a single stars object into a single array}
\usage{
\method{c}{stars}(
  ...,
  along = NA_integer_,
  try_hard = FALSE,
  nms = names(list(...)),
  tolerance = sqrt(.Machine$double.eps)
)

\method{c}{stars_proxy}(
  ...,
  along = NA_integer_,
  along_crs = FALSE,
  try_hard = FALSE,
  nms = names(list(...)),
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{...}{object(s) of class \code{star}: in case of multiple arguments, these are combined into a single stars object, in case of a single argument, its attributes are combined into a single attribute. In case of multiple objects, all objects should have the same dimensionality.}

\item{along}{integer; see \link{read_stars}}

\item{try_hard}{logical; if \code{TRUE} and some arrays have different dimensions, combine those that dimensions matching to the first array}

\item{nms}{character; vector with array names}

\item{tolerance}{numeric; values used in \link{all.equal} to compare dimension values
combine those that dimensions matching to the first array}

\item{along_crs}{logical; if \code{TRUE}, combine arrays along a CRS dimension}
}
\value{
a single \code{stars} object with merged (binded) arrays.
}
\description{
combine multiple stars objects, or combine multiple attributes in a single stars object into a single array
}
\details{
An error is raised when attempting to combine arrays with different
measurement units into a single array. If this was intentded, \code{drop_units} 
can be used to remove units of a \code{stars} object before merging.
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
(new = c(x, x))
c(new) # collapses two arrays into one with an additional dimension
c(x, x, along = 3)
}
