# 2024-02-13 Triage Log

Relatively balanced results this week, with more improvements than regressions. Some of the
larger regressions are not relevant, however there was a real large regression on `doc` builds, that was
caused by a correctness fix (`rustdoc` was doing the wrong thing before).

Triage done by **@kobzol**.
Revision range: [0984becf..74c3f5a1](https://perf.rust-lang.org/?start=0984becf01112cbd3583c796541760b65340c8db&end=74c3f5a146860c94ff4d179fc3bfa34f879adf41&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.1%  | [0.2%, 12.0%]  | 44    |
| Regressions ❌ <br /> (secondary)  | 5.2%  | [0.2%, 20.1%]  | 76    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.4%, -0.2%] | 139   |
| Improvements ✅ <br /> (secondary) | -1.3% | [-3.3%, -0.3%] | 86    |
| All ❌✅ (primary)                 | -0.1% | [-2.4%, 12.0%] | 183   |


6 Regressions, 5 Improvements, 8 Mixed; 5 of them in rollups
53 artifact comparisons made in total

#### Regressions

pattern_analysis: Gracefully abort on type incompatibility [#120313](https://github.com/rust-lang/rust/pull/120313) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ea37e8091fe87ae0a7e204c034e7d55061e56790&end=f067fd6084d750f3797f54b71771c5dbc149726f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 1.9% | [1.8%, 2.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

* The pattern matching machinery is now receiving a lot of updates, and the `match-stress` stress test
is swinging back and forth. Marked as triaged.

Rework support for async closures; allow them to return futures that borrow from the closure's captures [#120361](https://github.com/rust-lang/rust/pull/120361) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=037f515caf46846d2bffae55883eebc6c1ccb861&end=4a2fe4491ea616983a0cf0cbbd145a39768f4e7a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.7%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.4%, 0.7%]   | 11    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.5%  | [0.2%, 0.7%]   | 11    |

* This is probably just codegen noise, the changes were reverted in followup commits. Marked as triaged.

Make traits / trait methods detected by the dead code lint [#118257](https://github.com/rust-lang/rust/pull/118257) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=586893c7b0adabf5f0a4c155fd86e13cf470e74b&end=d4f6f9ee6a3b24f2cb97b1a5b82963609b93aa33&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.1%, 1.8%]  | 18    |
| Regressions ❌ <br /> (secondary)  | 9.4% | [0.2%, 16.0%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.1%, 1.8%]  | 18    |

* This PR implements a new lint for unused traits, so the compiler does more work.
The large regression is a red herring, it is a small stress test that didn't produce any warnings before,
but it does now, which causes it to initialize the diagnostics machinery, which is a one-time cost.
Marked as triaged.

Stop bailing out from compilation just because there were incoherent traits [#120558](https://github.com/rust-lang/rust/pull/120558) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=384b02c0825cefa59f2e8a99a33d9a5344959079&end=870a01a30e45d73b8e922a91850919e03f772636&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.0%] | 14    |
| Regressions ❌ <br /> (secondary)  | 1.2% | [0.1%, 3.5%] | 23    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.0%] | 14    |

* The regression was resolved in [#120835](https://github.com/rust-lang/rust/pull/120835).

Rollup of 6 pull requests [#120862](https://github.com/rust-lang/rust/pull/120862) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d44e3b95cb9d410d89cb8ab3233906a33f43756a&end=b5c46dc5426038a49c95398bce30eeb20ec421e2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.3%, 0.7%] | 7     |
| Regressions ❌ <br /> (secondary)  | 4.0% | [1.2%, 7.7%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.3%, 0.7%] | 7     |

* Regression is expected to be partially resolved by [#120942](https://github.com/rust-lang/rust/pull/120942).

Assert that params with the same *index* have the same *name* [#120619](https://github.com/rust-lang/rust/pull/120619) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1a648b397dedc98ada3dd3360f6d661ec2436c56&end=520b0b20aa8c218f84cefc6260f52406b84fa55f&stat=instructions:u)

| (instructions:u)                   | mean  | range         | count |
|:----------------------------------:|:-----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 6.0%  | [1.6%, 19.0%] | 18    |
| Regressions ❌ <br /> (secondary)  | 12.2% | [0.8%, 19.1%] | 22    |
| Improvements ✅ <br /> (primary)   | -     | -             | 0     |
| Improvements ✅ <br /> (secondary) | -     | -             | 0     |
| All ❌✅ (primary)                 | 6.0%  | [1.6%, 19.0%] | 18    |

* The `doc` regressions are unfortunately real, however this is a bugfix, `rustdoc` was doing incorrect work.

#### Improvements

Rollup of 13 pull requests [#120748](https://github.com/rust-lang/rust/pull/120748) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cfb42e5d7f6d5fc39f532ec251e1cea4bbafc746&end=8ace7ea1f7cbba7b4f031e66c54ca237a0d65de6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-2.3%, -0.2%] | 27    |
| Improvements ✅ <br /> (secondary) | -1.7% | [-2.2%, -1.4%] | 11    |
| All ❌✅ (primary)                 | -1.1% | [-2.3%, -0.2%] | 27    |

* Nice win caused by [#120733](https://github.com/rust-lang/rust/pull/120733).

Prevent running some code if it is already in the map [#120579](https://github.com/rust-lang/rust/pull/120579) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=870a01a30e45d73b8e922a91850919e03f772636&end=81bef0b0ba78f9b7bb08beb0575e245fbe18674a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-5.9%, -0.8%] | 19    |
| Improvements ✅ <br /> (secondary) | -4.0% | [-6.4%, -0.6%] | 22    |
| All ❌✅ (primary)                 | -2.3% | [-5.9%, -0.8%] | 19    |

* A nice win for `doc` benchmarks.

Continue to borrowck even if there were previous errors [#120550](https://github.com/rust-lang/rust/pull/120550) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=81bef0b0ba78f9b7bb08beb0575e245fbe18674a&end=af88f7db51f6f2a1472f9279d7c7e7c822afff77&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.8%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.3%] | 17    |
| All ❌✅ (primary)                 | -0.9% | [-1.0%, -0.8%] | 4     |

Harmonize `AsyncFn` implementations, make async closures conditionally impl `Fn*` traits [#120712](https://github.com/rust-lang/rust/pull/120712) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=68125c72d389060fe9aaee8d87ebd834f417c9fc&end=757b8efed44eacbbc6baf4a393f77d23d5be90c8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.7%, -0.5%] | 2     |
| All ❌✅ (primary)                 | -0.5% | [-0.8%, -0.2%] | 5     |


A trait's local impls are trivially coherent if there are no impls. [#120834](https://github.com/rust-lang/rust/pull/120834) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=084ce5bdb5f7dc1c725f6770a8de281165ba3b0a&end=de4d615e6b86f7ef6deacd24610b0678230b8af3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.0%, -0.2%] | 10    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-3.5%, -0.3%] | 24    |
| All ❌✅ (primary)                 | -0.4% | [-1.0%, -0.2%] | 10    |


#### Mixed

Rollup of 9 pull requests [#120660](https://github.com/rust-lang/rust/pull/120660) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0984becf01112cbd3583c796541760b65340c8db&end=8c0b4f67c9b4bf477df38c16669fd576d46a2b3d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.2%, 1.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | 0.8%  | [0.2%, 1.4%]   | 2     |

* The regression was small and looks like noise, marking as triaged.

Make `NonZero` constructors generic. [#120521](https://github.com/rust-lang/rust/pull/120521) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6894f435d35d3d540dcefbc51390158ca5954861&end=384b02c0825cefa59f2e8a99a33d9a5344959079&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.4%, 1.7%]   | 9     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.0%, -1.0%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.3%, -1.3%] | 1     |
| All ❌✅ (primary)                 | 0.5%  | [-1.0%, 1.7%]  | 10    |

* Regression later resolved in [#120809](https://github.com/rust-lang/rust/pull/120809).

Rollup of 9 pull requests [#120767](https://github.com/rust-lang/rust/pull/120767) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=af88f7db51f6f2a1472f9279d7c7e7c822afff77&end=1280928a99ad3ef2c5735b42dc8852456ae3b974&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.8%, -0.2%] | 25    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, 0.4%]  | 15    |

* The improvements outweight the regressions. Marked as triaged.

Toggle assert_unsafe_precondition in codegen instead of expansion [#120594](https://github.com/rust-lang/rust/pull/120594) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=972452c4473b2d8f6f6415614f915296bfc34f12&end=8fb67fb37fed736cb04f307473af7c863be224fb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 1.0%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 2.1%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.4%, -0.2%] | 15    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.4%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -0.1% | [-1.4%, 1.0%]  | 28    |

* The wins and regressions are more or less balanced out.

Rollup of 8 pull requests [#120843](https://github.com/rust-lang/rust/pull/120843) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8fb67fb37fed736cb04f307473af7c863be224fb&end=e28fae52d99d7c14bf0890d1f2b13c2c34fa8932&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.0%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.0%, -0.2%] | 41    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.4%, -0.2%] | 17    |
| All ❌✅ (primary)                 | -0.5% | [-1.0%, 0.2%]  | 42    |

* More wins than losses. Marked as triaged.

Enable MIR JumpThreading by default [#117206](https://github.com/rust-lang/rust/pull/117206) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6cc4843512d613f51ec81aba689180c31b0b28b6&end=42752cbe095b9ad9941f20f22f80788d95f4ab06&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.8%  | [0.4%, 7.1%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.4%, 3.3%]   | 18    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.6%, -0.2%] | 130   |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.5%, -0.3%] | 74    |
| All ❌✅ (primary)                 | -0.4% | [-1.6%, 7.1%]  | 140   |

* Wins outweight the losses here, and this PR should also hopefully improve runtime performance slightly,
which seems to be confirmed by our runtime `hashmap` benchmarks. Marked as triaged.

Fold pointer operations in GVN [#120405](https://github.com/rust-lang/rust/pull/120405) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0cbef48150e1fab161b5fd147b57ceb3f9272a52&end=9aa232ecc7bb006a1fad404f437b049482021a3a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.7%, 1.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 2.7%  | [2.7%, 2.7%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -1.8% | [-1.8%, -1.8%] | 1     |
| All ❌✅ (primary)                 | 0.0%  | [-0.8%, 1.1%]  | 6     |

* There are a few regressions, but nothing too large. This change should eventually help the compiler
optimize Rust code better. Marked as triaged.

Lowering unnamed fields and anonymous adt [#115367](https://github.com/rust-lang/rust/pull/115367) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ed195328689e052b5270b25d0e410b491914fc71&end=bdc15928c8119a86d15e2946cb54851264607842&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 6.1%  | [0.3%, 20.7%]  | 9     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 1     |

* A large regression on a stress test. Not marking as triaged yet.
