# 2023-03-01 Triage Log

Some noisy benchmarks impeded performance review this week. There was a notable
improvement to a broad range of primary benchmarks, first from PR #108440, which
revised the encodable proc macro to handle the discriminant separately from its
fields, and second from PR #108375, which inlined a number of methods that had
only a single caller. Both of these PR's were authored by the same contributor;
many thanks Zoxc!

Triage done by **@pnkfelix**.
Revision range: [3fee48c1..31f858d9](https://perf.rust-lang.org/?start=3fee48c161a48b0c142d3998fff56faee96bd56c&end=31f858d9a511f24fedb8ed997b28304fec809630&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.4%, 1.5%]    | 16    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.3%, 0.9%]    | 18    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-17.1%, -0.3%] | 112   |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.8%, -0.1%]  | 50    |
| All ❌✅ (primary)                 | -0.6% | [-17.1%, 1.5%]  | 128   |


5 Regressions, 4 Improvements, 6 Mixed; 6 of them in rollups
39 artifact comparisons made in total

#### Regressions

errors: generate typed identifiers in each crate [#103042](https://github.com/rust-lang/rust/pull/103042) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3b4d6e080404560f63599deeb328dfa27fe081a6&end=b869e84e581612f4a30a4bca63bd9e90e9a17003&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.0%, 1.2%] | 2     |
| Regressions ❌ <br /> (secondary)  | 2.2% | [2.0%, 2.6%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.0%, 1.2%] | 2     |

* already triaged, believed to be noise.

Rollup of 10 pull requests [#108421](https://github.com/rust-lang/rust/pull/108421) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07c993eba8b76eae497e98433ae075b00f01be10&end=c5c7d2b37780dac1092e75f12ab97dd56c30861d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 1.3%] | 4     |
| Regressions ❌ <br /> (secondary)  | 2.2% | [2.0%, 2.6%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 1.3%] | 4     |

* already triaged, believed to be noise.

Print a backtrace when query forcing fails. [#91742](https://github.com/rust-lang/rust/pull/91742) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c5c7d2b37780dac1092e75f12ab97dd56c30861d&end=f0bc76ac41a0a832c9ee621e31aaf1f515d3d6a5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.7%] | 65    |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 2.3%] | 14    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.7%] | 65    |

* The compiler team [anticipated fallout here](https://github.com/rust-lang/rust/pull/91742#issuecomment-1435790317)
* the [actual fallout](https://github.com/rust-lang/rust/pull/91742#issuecomment-1444980590) seems to roughly match.
* marked as triaged.

Rollup of 9 pull requests [#108488](https://github.com/rust-lang/rust/pull/108488) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43ee4d15bf201f72c36abd7f02961df87dead441&end=c4e0cd966062ca67daed20775f4e8a60c28e57df&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4% | [0.8%, 2.0%] | 2     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.4% | [0.8%, 2.0%] | 2     |

* two doc,full regressions: 2% on hyper, 0.76% on serde...
* not worth teasing out of rollup; marked as triaged

MIR-Validate StorageLive. [#108175](https://github.com/rust-lang/rust/pull/108175) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=49b9cc5139dd4d11ef78dc08c1f9170de5b1ca39&end=7d782b7ff4d57170e110211565209ecc5bbb3907&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.6%, 0.7%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.3%, 0.5%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.6%, 0.7%] | 3     |

* regressed helloworld check by 0.6% in three incremental scenarios.
* note though that these regressions did not show up in the timer run before the PR landed.
* marked as triaged.

#### Improvements

Rollup of 6 pull requests [#108357](https://github.com/rust-lang/rust/pull/108357) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fdbc4329cb781c7768ffa6d76c8fa2d032d3fe20&end=da439d98749e7c94f3ecf355fdd616253ee08359&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.8%  | [1.8%, 1.8%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -0.9%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.5%, -1.9%] | 6     |
| All ❌✅ (primary)                 | -1.0% | [-1.1%, -0.9%] | 2     |


Use `tcx.ty_error_with_guaranteed` in more places, rename variants [#108369](https://github.com/rust-lang/rust/pull/108369) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eb909d81464900597b91f3bbf2a6bef10006c9ff&end=07c993eba8b76eae497e98433ae075b00f01be10&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.2%, -1.0%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.5%, -2.0%] | 6     |
| All ❌✅ (primary)                 | -1.1% | [-1.2%, -1.0%] | 2     |


Emit the enum discriminant separately for the Encodable macro [#108440](https://github.com/rust-lang/rust/pull/108440) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d962ea57899d64dc8a57040142c6b498a57c8064&end=58136ffa92c81ec9e6ac1f91773254914da2ca01&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.0%, -0.3%] | 91    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.9%, -0.4%] | 22    |
| All ❌✅ (primary)                 | -0.6% | [-1.0%, -0.3%] | 91    |


rustdoc: reduce allocations when generating tooltips [#108098](https://github.com/rust-lang/rust/pull/108098) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd1f1fa0d10430885478276341e4afa2e2875adb&end=5157d938c49af1248a21e7ed2fbc5c6f71963276&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -5.1% | [-17.0%, -0.6%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-0.9%, -0.9%]  | 1     |
| All ❌✅ (primary)                 | -5.1% | [-17.0%, -0.6%] | 4     |


#### Mixed

Rollup of 8 pull requests [#108339](https://github.com/rust-lang/rust/pull/108339) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bd4a96a12d0bf6dc12edf20a45df3a33052c9d7d&end=3b4d6e080404560f63599deeb328dfa27fe081a6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.6%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.7%, 0.9%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-3.0%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.4% | [-3.0%, 0.6%]  | 12    |


* seems like a wash, in terms of mix of regressions and improvements. the one outlier was the 3% improvement to opt-full on cranelift-codegen.
* the primary regressions were to ripgrep opt-full (0.59%), image opt-full (0.51%), cranelift-codegen check-full (0.42%), and cranelift-codegen check-incr-full (0.27%)
* I do not think its worth trying to dissect the rollup at this point though. Marking as triaged.

diagnostics: if AssocFn has self argument, describe as method [#108324](https://github.com/rust-lang/rust/pull/108324) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da439d98749e7c94f3ecf355fdd616253ee08359&end=0978711950b77582e4f8f334f6e9848d48ab7790&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [1.0%, 1.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [2.0%, 2.6%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-2.3%, -2.3%] | 1     |
| All ❌✅ (primary)                 | 1.1%  | [1.0%, 1.2%]   | 2     |

* already triaged as noise.

Update cargo [#108330](https://github.com/rust-lang/rust/pull/108330) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0978711950b77582e4f8f334f6e9848d48ab7790&end=8b1dbf728add722d4db894b9b986ec24e1cdb0a1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.5%  | [2.5%, 2.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -0.9%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.5%, -1.9%] | 6     |
| All ❌✅ (primary)                 | -1.0% | [-1.1%, -0.9%] | 2     |

* already triaged as noise

Rollup of 7 pull requests [#108386](https://github.com/rust-lang/rust/pull/108386) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8b1dbf728add722d4db894b9b986ec24e1cdb0a1&end=eb909d81464900597b91f3bbf2a6bef10006c9ff&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.9%, 1.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.4%, 2.6%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.5% | [-2.5%, -2.5%] | 1     |
| All ❌✅ (primary)                 | 1.0%  | [0.9%, 1.1%]   | 2     |

* primary cranelift-codegen; secondary keccak, coercions, unused-warnings
* seems like the same cases that were already categorized as noise by nnethercote in several other cases
* marking as triaged.

Rollup of 7 pull requests [#108464](https://github.com/rust-lang/rust/pull/108464) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=34e6673a0473e90ef01a18eb575392c9e3859747&end=f37f9f6512cb6b295acb70938302704a80c29b2b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.6%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-0.9%, -0.6%] | 6     |

* already triaged

Add inlining attributes for query system functions [#108375](https://github.com/rust-lang/rust/pull/108375) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=70fd012439d75fd6ce561a6518b9b8fd399f455f&end=43ee4d15bf201f72c36abd7f02961df87dead441&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.7%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.1%, -0.2%] | 38    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 12    |
| All ❌✅ (primary)                 | -0.4% | [-1.1%, -0.2%] | 38    |

* wins clearly outweigh losses here.
* marking as triaged.

#### Untriaged Pull Requests

- [#108386 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/108386)
- [#108375 Add inlining attributes for query system functions](https://github.com/rust-lang/rust/pull/108375)
- [#108339 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/108339)
- [#108175 MIR-Validate StorageLive.](https://github.com/rust-lang/rust/pull/108175)
- [#108025 rustdoc: add more tooltips to intra-doc links](https://github.com/rust-lang/rust/pull/108025)
- [#107833 Factor query arena allocation out from query caches](https://github.com/rust-lang/rust/pull/107833)
- [#107783 rustdoc: simplify DOM for `.item-table`](https://github.com/rust-lang/rust/pull/107783)
- [#107765 rustc/rustdoc: Perform name resolver cleanups enabled by #94857](https://github.com/rust-lang/rust/pull/107765)
- [#107672 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/107672)
- [#107408 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/107408)
- [#107143 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/107143)
- [#107103 Use new solver in `evaluate_obligation` query (when new solver is enabled)](https://github.com/rust-lang/rust/pull/107103)
- [#107101 Filter param-env predicates for errors before calling `to_opt_poly_trait_pred`](https://github.com/rust-lang/rust/pull/107101)
- [#106757 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/106757)
- [#105657 Guard ProjectionTy creation against passing the wrong number of substs](https://github.com/rust-lang/rust/pull/105657)
- [#105472 Make encode_info_for_trait_item use queries instead of accessing the HIR](https://github.com/rust-lang/rust/pull/105472)
- [#105426 Catch panics/unwinding in destruction of TLS values](https://github.com/rust-lang/rust/pull/105426)
- [#105378 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/105378)
- [#105323 Perform SimplifyLocals before ConstProp.](https://github.com/rust-lang/rust/pull/105323)
- [#105147 Allow unsafe through inline const](https://github.com/rust-lang/rust/pull/105147)
- [#104566 couple of clippy::perf fixes](https://github.com/rust-lang/rust/pull/104566)
- [#104533 Clean up and harden various methods around trait substs](https://github.com/rust-lang/rust/pull/104533)
- [#104017 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/104017)
- [#103998 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/103998)
- [#103975 Some tracing and comment cleanups](https://github.com/rust-lang/rust/pull/103975)
- [#103934 std: sync "Dependencies of the `backtrace` crate" with `backtrace`](https://github.com/rust-lang/rust/pull/103934)
- [#103880 Use non-ascribed type as field's type in mir](https://github.com/rust-lang/rust/pull/103880)
- [#103841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/103841)
- [#103650 rustdoc: change `.src-line-numbers > span` to `.src-line-numbers > a`](https://github.com/rust-lang/rust/pull/103650)
- [#103562 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/103562)

#### Nags requiring follow up

TODO: Nags

