/*
 * Copyright (C) 2009-2017 Alistair Neil <info@dazzleships.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package lib;

/**
 *
 * @author Alistair Neil <info@dazzleships.net>
 */
public class TextResourceDialog extends javax.swing.JDialog {

    private String strUrl;

    /**
     * Creates new License Dialog
     *
     * @param parent
     * @param modal
     */
    public TextResourceDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        jTextArea.setCaretPosition(0);
        jButtonLaunchURL.setVisible(false);
    }

    /**
     * Set the browser url for unnoficial translation
     *
     * @param url
     */
    public void setButtonURL(String url) {
        strUrl = url;
        jButtonLaunchURL.setVisible(url != null);
    }

    /**
     * Get the license text
     *
     * @return Text
     */
    public String getText() {
        return jTextArea.getText();
    }

    /**
     * Set the license text
     *
     * @param text
     */
    public void setText(String text) {
        jTextArea.setText(text);
        jTextArea.setCaretPosition(0);
    }

    /**
     * Set the text on the Close button
     *
     * @param text
     */
    public void setCloseButtonText(String text) {
        jButtonClose.setText(text);
    }

    /**
     * Set the text on the Close button
     *
     * @param text
     */
    public void setURLButtonText(String text) {
        jButtonLaunchURL.setText(text);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea = new javax.swing.JTextArea();
        jButtonClose = new javax.swing.JButton();
        jButtonLaunchURL = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);

        jTextArea.setEditable(false);
        jTextArea.setColumns(40);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(20);
        jTextArea.setText("\n");
        jTextArea.setWrapStyleWord(true);
        jScrollPane1.setViewportView(jTextArea);

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jButtonLaunchURL.setText("URL Desc");
        jButtonLaunchURL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLaunchURLActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonLaunchURL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonClose)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonClose)
                    .addComponent(jButtonLaunchURL))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        dispose();
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonLaunchURLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLaunchURLActionPerformed
        Utilities.openFileExternally(strUrl);
    }//GEN-LAST:event_jButtonLaunchURLActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonLaunchURL;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea;
    // End of variables declaration//GEN-END:variables
}
