use lang:bs;
use lang:bs:macro;
use core:lang;
use core:asm;

class MapExpr extends ExprBlock {
	private ExprBlock loopBody;

	init(SrcPos pos, Block parent, Expr src, SStr varName) {
		init(pos, parent) {
			loopBody(pos, parent);
		}

		Var local(this, named{Int}, varName, Actuals());
		add(local);

		add(pattern(this) {
				Array<Int> original = ${src};
				Array<Int> out;
				for (Nat i = 0; i < original.count; i++) {
					${LocalVarAccess(pos, local.var)} = original[i];
					out << ${loopBody};
				}
				out;
			});
	}

	void setTransform(Expr expr) {
		loopBody.add(expectCastTo(expr, named{Int}, scope));
	}
}
