## TFSA-2021-150: Division by 0 in most convolution operators

### CVE Number
CVE-2021-37675

### Impact
Most implementations of convolution operators in TensorFlow are affected by a
division by 0 vulnerability where an attacker can trigger a denial of service
via a crash:

```python
import tensorflow as tf

tf.compat.v1.disable_v2_behavior()
tf.raw_ops.Conv2D(
  input = tf.constant([], shape=[0, 0, 0, 0], dtype=tf.float32),
  filter = tf.constant([], shape=[0, 0, 0, 0], dtype=tf.float32),
  strides = [1, 1, 1, 1],
  padding = "SAME")
```

The shape inference
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/framework/common_shape_fns.cc#L577)
is missing several validations before doing divisions and modulo operations.

### Patches
We have patched the issue in GitHub commit
[8a793b5d7f59e37ac7f3cd0954a750a2fe76bad4](https://github.com/tensorflow/tensorflow/commit/8a793b5d7f59e37ac7f3cd0954a750a2fe76bad4).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang of Baidu Security.
