/*
 * Copyright (c) 2024 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#import <utility>
#import <wtf/CompletionHandler.h>
#import <wtf/FastMalloc.h>
#import <wtf/Ref.h>
#include <wtf/RefCountedAndCanMakeWeakPtr.h>

struct WGPUXRViewImpl {
};

namespace WebGPU {

class CommandEncoder;
class Device;
class XRProjectionLayer;

class XRView : public RefCountedAndCanMakeWeakPtr<XRView>, public WGPUXRViewImpl {
    WTF_DEPRECATED_MAKE_FAST_ALLOCATED(XRView);
public:
    static Ref<XRView> create(Device& device)
    {
        return adoptRef(*new XRView(true, device));
    }
    static Ref<XRView> createInvalid(Device& device)
    {
        return adoptRef(*new XRView(device));
    }

    ~XRView();

    void setLabel(String&&);

    bool isValid() const { return true; }
    Device& device() { return m_device; }

private:
    XRView(bool, Device&);
    XRView(Device&);

    const Ref<Device> m_device;
};

} // namespace WebGPU
