/* table-lookup-test.c generated by valac 0.48.11, the Vala compiler
 * generated from table-lookup-test.vala, do not modify */

/* where-clause-test.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist-engine.h"
#include <glib-object.h>
#include "zeitgeist-internal.h"
#include <sqlite3.h>

#define TYPE_PUBLIC_ENGINE (public_engine_get_type ())
#define PUBLIC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUBLIC_ENGINE, PublicEngine))
#define PUBLIC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUBLIC_ENGINE, PublicEngineClass))
#define IS_PUBLIC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUBLIC_ENGINE))
#define IS_PUBLIC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUBLIC_ENGINE))
#define PUBLIC_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUBLIC_ENGINE, PublicEngineClass))

typedef struct _PublicEngine PublicEngine;
typedef struct _PublicEngineClass PublicEngineClass;
typedef struct _PublicEnginePrivate PublicEnginePrivate;
enum  {
	PUBLIC_ENGINE_0_PROPERTY,
	PUBLIC_ENGINE_NUM_PROPERTIES
};
static GParamSpec* public_engine_properties[PUBLIC_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublicEngine {
	ZeitgeistEngine parent_instance;
	PublicEnginePrivate * priv;
};

struct _PublicEngineClass {
	ZeitgeistEngineClass parent_class;
};

static gpointer public_engine_parent_class = NULL;

gint _vala_main (gchar** args,
                 gint args_length1);
void basic_test (void);
static void _basic_test_gtest_func (void);
void engine_test (void);
static void _engine_test_gtest_func (void);
void get_value_with_query_test (void);
static void _get_value_with_query_test_gtest_func (void);
GType public_engine_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PublicEngine, g_object_unref)
ZeitgeistSQLiteTableLookup* public_engine_get_actors_table_lookup (PublicEngine* self);
PublicEngine* public_engine_new (void);
PublicEngine* public_engine_construct (GType object_type);
static GType public_engine_get_type_once (void);

static void
_basic_test_gtest_func (void)
{
#line 39 "table-lookup-test.vala"
	basic_test ();
#line 86 "table-lookup-test.c"
}

static void
_engine_test_gtest_func (void)
{
#line 40 "table-lookup-test.vala"
	engine_test ();
#line 94 "table-lookup-test.c"
}

static void
_get_value_with_query_test_gtest_func (void)
{
#line 41 "table-lookup-test.vala"
	get_value_with_query_test ();
#line 102 "table-lookup-test.c"
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	gint result = 0;
#line 27 "table-lookup-test.vala"
	g_test_init ((gint*) (&args_length1), &args, NULL);
#line 30 "table-lookup-test.vala"
	g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);
#line 34 "table-lookup-test.vala"
	_vala_assert (g_setenv ("ZEITGEIST_DATA_PATH", "/tmp/zeitgeist-tests", TRUE), "Environment.set_variable(         \"ZEITGEIST_DATA_PATH\", \"/tmp/zeitgeist-tests\", true)");
#line 36 "table-lookup-test.vala"
	_vala_assert (g_setenv ("ZEITGEIST_DATABASE_PATH", ":memory:", TRUE), "Environment.set_variable(         \"ZEITGEIST_DATABASE_PATH\", \":memory:\", true)");
#line 39 "table-lookup-test.vala"
	g_test_add_func ("/WhereClause/basic", _basic_test_gtest_func);
#line 40 "table-lookup-test.vala"
	g_test_add_func ("/WhereClause/delete_hook", _engine_test_gtest_func);
#line 41 "table-lookup-test.vala"
	g_test_add_func ("/WhereClause/get_value_query", _get_value_with_query_test_gtest_func);
#line 43 "table-lookup-test.vala"
	result = g_test_run ();
#line 43 "table-lookup-test.vala"
	return result;
#line 128 "table-lookup-test.c"
}

int
main (int argc,
      char ** argv)
{
#line 25 "table-lookup-test.vala"
	return _vala_main (argv, argc);
#line 137 "table-lookup-test.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 50 "table-lookup-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 145 "table-lookup-test.c"
}

ZeitgeistSQLiteTableLookup*
public_engine_get_actors_table_lookup (PublicEngine* self)
{
	ZeitgeistSQLiteTableLookup* _tmp0_;
	ZeitgeistSQLiteTableLookup* _tmp1_;
	ZeitgeistSQLiteTableLookup* result = NULL;
#line 48 "table-lookup-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "table-lookup-test.vala"
	_tmp0_ = ((ZeitgeistDbReader*) self)->actors_table;
#line 50 "table-lookup-test.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 50 "table-lookup-test.vala"
	result = _tmp1_;
#line 50 "table-lookup-test.vala"
	return result;
#line 164 "table-lookup-test.c"
}

PublicEngine*
public_engine_construct (GType object_type)
{
	PublicEngine * self = NULL;
	GError* _inner_error0_ = NULL;
#line 46 "table-lookup-test.vala"
	self = (PublicEngine*) zeitgeist_engine_construct (object_type, &_inner_error0_);
#line 46 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 46 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 46 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 46 "table-lookup-test.vala"
		return NULL;
#line 182 "table-lookup-test.c"
	}
#line 46 "table-lookup-test.vala"
	return self;
#line 186 "table-lookup-test.c"
}

PublicEngine*
public_engine_new (void)
{
#line 46 "table-lookup-test.vala"
	return public_engine_construct (TYPE_PUBLIC_ENGINE);
#line 194 "table-lookup-test.c"
}

static void
public_engine_class_init (PublicEngineClass * klass,
                          gpointer klass_data)
{
#line 46 "table-lookup-test.vala"
	public_engine_parent_class = g_type_class_peek_parent (klass);
#line 203 "table-lookup-test.c"
}

static void
public_engine_instance_init (PublicEngine * self,
                             gpointer klass)
{
}

static GType
public_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PublicEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) public_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublicEngine), 0, (GInstanceInitFunc) public_engine_instance_init, NULL };
	GType public_engine_type_id;
	public_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_ENGINE, "PublicEngine", &g_define_type_info, 0);
	return public_engine_type_id;
}

GType
public_engine_get_type (void)
{
	static volatile gsize public_engine_type_id__volatile = 0;
	if (g_once_init_enter (&public_engine_type_id__volatile)) {
		GType public_engine_type_id;
		public_engine_type_id = public_engine_get_type_once ();
		g_once_init_leave (&public_engine_type_id__volatile, public_engine_type_id);
	}
	return public_engine_type_id__volatile;
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar* * errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result = 0;
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "sqlite3.vapi"
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
#line 36 "sqlite3.vapi"
	sqlite_errmsg = _tmp0_;
#line 36 "sqlite3.vapi"
	ec = _tmp1_;
#line 37 "sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 259 "table-lookup-test.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 38 "sqlite3.vapi"
		_tmp2_ = sqlite_errmsg;
#line 38 "sqlite3.vapi"
		_tmp3_ = g_strdup (_tmp2_);
#line 38 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "sqlite3.vapi"
		_vala_errmsg = _tmp3_;
#line 270 "table-lookup-test.c"
	} else {
#line 40 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 40 "sqlite3.vapi"
		_vala_errmsg = NULL;
#line 276 "table-lookup-test.c"
	}
#line 42 "sqlite3.vapi"
	_tmp4_ = sqlite_errmsg;
#line 42 "sqlite3.vapi"
	sqlite3_free ((void*) _tmp4_);
#line 43 "sqlite3.vapi"
	result = ec;
#line 43 "sqlite3.vapi"
	if (errmsg) {
#line 43 "sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 288 "table-lookup-test.c"
	} else {
#line 43 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 292 "table-lookup-test.c"
	}
#line 43 "sqlite3.vapi"
	return result;
#line 296 "table-lookup-test.c"
}

void
basic_test (void)
{
	ZeitgeistSQLiteDatabase* database = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	sqlite3* db = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteTableLookup* _tmp4_;
	gint id = 0;
	ZeitgeistSQLiteTableLookup* _tmp5_;
	gint _tmp6_ = 0;
	ZeitgeistSQLiteTableLookup* _tmp7_;
	gint _tmp8_ = 0;
	ZeitgeistSQLiteTableLookup* _tmp9_;
	gint rc = 0;
	sqlite3* _tmp10_;
	ZeitgeistSQLiteTableLookup* _tmp11_;
	gint _tmp12_ = 0;
	ZeitgeistSQLiteTableLookup* _tmp13_;
	gint _tmp14_ = 0;
	ZeitgeistSQLiteTableLookup* _tmp15_;
	GError* _inner_error0_ = NULL;
#line 56 "table-lookup-test.vala"
	_tmp0_ = zeitgeist_sq_lite_database_new (&_inner_error0_);
#line 56 "table-lookup-test.vala"
	database = _tmp0_;
#line 56 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 56 "table-lookup-test.vala"
		return;
#line 336 "table-lookup-test.c"
	}
#line 57 "table-lookup-test.vala"
	_tmp1_ = database;
#line 57 "table-lookup-test.vala"
	_tmp2_ = _tmp1_->database;
#line 57 "table-lookup-test.vala"
	db = _tmp2_;
#line 58 "table-lookup-test.vala"
	_tmp3_ = database;
#line 58 "table-lookup-test.vala"
	_tmp4_ = zeitgeist_sq_lite_table_lookup_new (_tmp3_, "actor", &_inner_error0_);
#line 58 "table-lookup-test.vala"
	table_lookup = _tmp4_;
#line 58 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 58 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 58 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 58 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 58 "table-lookup-test.vala"
		return;
#line 360 "table-lookup-test.c"
	}
#line 60 "table-lookup-test.vala"
	_tmp5_ = table_lookup;
#line 60 "table-lookup-test.vala"
	id = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp5_, "1st-actor", &_inner_error0_);
#line 60 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 60 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 60 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 60 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 60 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 60 "table-lookup-test.vala"
		return;
#line 378 "table-lookup-test.c"
	}
#line 61 "table-lookup-test.vala"
	_tmp7_ = table_lookup;
#line 61 "table-lookup-test.vala"
	_tmp6_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp7_, "2nd-actor", &_inner_error0_);
#line 61 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 61 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 61 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 61 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 61 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 61 "table-lookup-test.vala"
		return;
#line 396 "table-lookup-test.c"
	}
#line 61 "table-lookup-test.vala"
	g_assert_cmpint (_tmp6_, ==, id + 1);
#line 62 "table-lookup-test.vala"
	_tmp9_ = table_lookup;
#line 62 "table-lookup-test.vala"
	_tmp8_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp9_, "1st-actor", &_inner_error0_);
#line 62 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 62 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 62 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 62 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 62 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 62 "table-lookup-test.vala"
		return;
#line 416 "table-lookup-test.c"
	}
#line 62 "table-lookup-test.vala"
	g_assert_cmpint (_tmp8_, ==, id);
#line 64 "table-lookup-test.vala"
	_tmp10_ = db;
#line 64 "table-lookup-test.vala"
	rc = _sqlite3_exec (_tmp10_, "DELETE FROM actor WHERE value='1st-actor'", NULL, NULL, NULL);
#line 65 "table-lookup-test.vala"
	_vala_assert (rc == SQLITE_OK, "rc == Sqlite.OK");
#line 67 "table-lookup-test.vala"
	_tmp11_ = table_lookup;
#line 67 "table-lookup-test.vala"
	zeitgeist_sq_lite_table_lookup_remove (_tmp11_, 1);
#line 68 "table-lookup-test.vala"
	_tmp13_ = table_lookup;
#line 68 "table-lookup-test.vala"
	_tmp12_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp13_, "2nd-actor", &_inner_error0_);
#line 68 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 68 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 68 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 68 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 68 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 68 "table-lookup-test.vala"
		return;
#line 446 "table-lookup-test.c"
	}
#line 68 "table-lookup-test.vala"
	g_assert_cmpint (_tmp12_, ==, id + 1);
#line 69 "table-lookup-test.vala"
	_tmp15_ = table_lookup;
#line 69 "table-lookup-test.vala"
	_tmp14_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp15_, "1st-actor", &_inner_error0_);
#line 69 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 69 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 69 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 69 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 69 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 69 "table-lookup-test.vala"
		return;
#line 466 "table-lookup-test.c"
	}
#line 69 "table-lookup-test.vala"
	g_assert_cmpint (_tmp14_, ==, id + 2);
#line 54 "table-lookup-test.vala"
	_g_object_unref0 (table_lookup);
#line 54 "table-lookup-test.vala"
	_g_object_unref0 (database);
#line 474 "table-lookup-test.c"
}

void
get_value_with_query_test (void)
{
	ZeitgeistSQLiteDatabase* database = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	sqlite3* db = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteTableLookup* _tmp4_;
	gint rc = 0;
	sqlite3* _tmp5_;
	const gchar* _tmp6_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 74 "table-lookup-test.vala"
	_tmp0_ = zeitgeist_sq_lite_database_new (&_inner_error0_);
#line 74 "table-lookup-test.vala"
	database = _tmp0_;
#line 74 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 74 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 74 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 74 "table-lookup-test.vala"
		return;
#line 506 "table-lookup-test.c"
	}
#line 75 "table-lookup-test.vala"
	_tmp1_ = database;
#line 75 "table-lookup-test.vala"
	_tmp2_ = _tmp1_->database;
#line 75 "table-lookup-test.vala"
	db = _tmp2_;
#line 76 "table-lookup-test.vala"
	_tmp3_ = database;
#line 76 "table-lookup-test.vala"
	_tmp4_ = zeitgeist_sq_lite_table_lookup_new (_tmp3_, "actor", &_inner_error0_);
#line 76 "table-lookup-test.vala"
	table_lookup = _tmp4_;
#line 76 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 76 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 76 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 76 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 76 "table-lookup-test.vala"
		return;
#line 530 "table-lookup-test.c"
	}
#line 78 "table-lookup-test.vala"
	_tmp5_ = db;
#line 78 "table-lookup-test.vala"
	rc = _sqlite3_exec (_tmp5_, "INSERT INTO actor (id, value) VALUES (100, 'new-actor')", NULL, NULL, NULL);
#line 79 "table-lookup-test.vala"
	_vala_assert (rc == SQLITE_OK, "rc == Sqlite.OK");
#line 81 "table-lookup-test.vala"
	_tmp7_ = table_lookup;
#line 81 "table-lookup-test.vala"
	_tmp8_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp7_, 100, &_inner_error0_);
#line 81 "table-lookup-test.vala"
	_tmp6_ = _tmp8_;
#line 81 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 81 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 81 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 81 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 81 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 81 "table-lookup-test.vala"
		return;
#line 556 "table-lookup-test.c"
	}
#line 81 "table-lookup-test.vala"
	g_assert_cmpstr (_tmp6_, ==, "new-actor");
#line 72 "table-lookup-test.vala"
	_g_object_unref0 (table_lookup);
#line 72 "table-lookup-test.vala"
	_g_object_unref0 (database);
#line 564 "table-lookup-test.c"
}

void
engine_test (void)
{
	PublicEngine* engine = NULL;
	PublicEngine* _tmp0_;
	ZeitgeistSQLiteDatabase* database = NULL;
	PublicEngine* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	sqlite3* db = NULL;
	ZeitgeistSQLiteDatabase* _tmp5_;
	sqlite3* _tmp6_;
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	PublicEngine* _tmp7_;
	ZeitgeistSQLiteTableLookup* _tmp8_;
	gint _tmp9_ = 0;
	ZeitgeistSQLiteTableLookup* _tmp10_;
	gint rc = 0;
	sqlite3* _tmp11_;
	gint _tmp12_ = 0;
	ZeitgeistSQLiteTableLookup* _tmp13_;
	GError* _inner_error0_ = NULL;
#line 86 "table-lookup-test.vala"
	_tmp0_ = public_engine_new ();
#line 86 "table-lookup-test.vala"
	engine = _tmp0_;
#line 87 "table-lookup-test.vala"
	_tmp1_ = engine;
#line 87 "table-lookup-test.vala"
	_tmp2_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) _tmp1_);
#line 87 "table-lookup-test.vala"
	_tmp3_ = _tmp2_;
#line 87 "table-lookup-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 87 "table-lookup-test.vala"
	database = _tmp4_;
#line 88 "table-lookup-test.vala"
	_tmp5_ = database;
#line 88 "table-lookup-test.vala"
	_tmp6_ = _tmp5_->database;
#line 88 "table-lookup-test.vala"
	db = _tmp6_;
#line 89 "table-lookup-test.vala"
	_tmp7_ = engine;
#line 89 "table-lookup-test.vala"
	_tmp8_ = public_engine_get_actors_table_lookup (_tmp7_);
#line 89 "table-lookup-test.vala"
	table_lookup = _tmp8_;
#line 91 "table-lookup-test.vala"
	_tmp10_ = table_lookup;
#line 91 "table-lookup-test.vala"
	_tmp9_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp10_, "something", &_inner_error0_);
#line 91 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 91 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 91 "table-lookup-test.vala"
		_g_object_unref0 (engine);
#line 91 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 91 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 91 "table-lookup-test.vala"
		return;
#line 634 "table-lookup-test.c"
	}
#line 91 "table-lookup-test.vala"
	g_assert_cmpint (_tmp9_, ==, 1);
#line 95 "table-lookup-test.vala"
	_tmp11_ = db;
#line 95 "table-lookup-test.vala"
	rc = _sqlite3_exec (_tmp11_, "DELETE FROM actor WHERE value='something'", NULL, NULL, NULL);
#line 96 "table-lookup-test.vala"
	_vala_assert (rc == SQLITE_OK, "rc == Sqlite.OK");
#line 98 "table-lookup-test.vala"
	_tmp13_ = table_lookup;
#line 98 "table-lookup-test.vala"
	_tmp12_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp13_, "something", &_inner_error0_);
#line 98 "table-lookup-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 98 "table-lookup-test.vala"
		_g_object_unref0 (table_lookup);
#line 98 "table-lookup-test.vala"
		_g_object_unref0 (database);
#line 98 "table-lookup-test.vala"
		_g_object_unref0 (engine);
#line 98 "table-lookup-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 98 "table-lookup-test.vala"
		g_clear_error (&_inner_error0_);
#line 98 "table-lookup-test.vala"
		return;
#line 662 "table-lookup-test.c"
	}
#line 98 "table-lookup-test.vala"
	g_assert_cmpint (_tmp12_, ==, 2);
#line 84 "table-lookup-test.vala"
	_g_object_unref0 (table_lookup);
#line 84 "table-lookup-test.vala"
	_g_object_unref0 (database);
#line 84 "table-lookup-test.vala"
	_g_object_unref0 (engine);
#line 672 "table-lookup-test.c"
}

